/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.common.spread.common.variant;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.emr.common.spread.common.variant.ExprErr;
import kd.epm.emr.common.spread.common.variant.SyntaxErrorException;
import kd.epm.emr.common.spread.common.variant.Util;
import kd.epm.emr.common.spread.common.variant.VarBase;
import kd.epm.emr.common.spread.common.variant.Variant;

class VarFloat
extends VarBase {
    VarFloat() {
    }

    @Override
    protected void add(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        float leftval = ((Float)left.getValue()).floatValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.add(leftval, (float)((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.add(leftval, (float)rightval, result);
                    break;
                }
                case 9: {
                    Util.add((double)leftval, ((BigInteger)right.getValue()).doubleValue(), result);
                    break;
                }
                case 10: {
                    result.setObject(((BigDecimal)right.getValue()).add(new BigDecimal(Float.toString(leftval))), 10);
                    break;
                }
                case 11: {
                    result.setObject(new BigDecimal((String)right.getValue()).add(new BigDecimal(Float.toString(leftval))), 10);
                    break;
                }
                case 12: {
                    Util.add(leftval, (float)((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.add(leftval, right.floatValue(), result);
                    break;
                }
                case 15: {
                    left.add((Variant)right.getValue(), result);
                    break;
                }
                case 0: {
                    result.setVariant(left);
                    break;
                }
                default: {
                    ExprErr.goError(64L, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97", (String)"Variant_0", (String)"epm-emr-common", (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    protected void subtract(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        float leftval = ((Float)left.getValue()).floatValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.subtract(leftval, (float)((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.subtract(leftval, (float)rightval, result);
                    break;
                }
                case 9: {
                    Util.subtract((double)leftval, ((BigInteger)right.getValue()).doubleValue(), result);
                    break;
                }
                case 10: {
                    result.setObject(new BigDecimal(Float.toString(leftval)).subtract((BigDecimal)right.getValue()), 10);
                    break;
                }
                case 11: {
                    result.setObject(new BigDecimal(Float.toString(leftval)).subtract(new BigDecimal((String)right.getValue())), 10);
                    break;
                }
                case 12: {
                    Util.subtract(leftval, (float)((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.subtract(leftval, right.floatValue(), result);
                    break;
                }
                case 15: {
                    left.subtract((Variant)right.getValue(), result);
                    break;
                }
                case 0: {
                    result.setVariant(left);
                    break;
                }
                default: {
                    ExprErr.goError(64L, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97", (String)"Variant_0", (String)"epm-emr-common", (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    protected void multiply(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        float leftval = ((Float)left.getValue()).floatValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.multiply(leftval, (float)((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.multiply(leftval, (float)rightval, result);
                    break;
                }
                case 9: {
                    Util.multiply((double)leftval, ((BigInteger)right.getValue()).doubleValue(), result);
                    break;
                }
                case 10: {
                    result.setObject(new BigDecimal(Float.toString(leftval)).multiply((BigDecimal)right.getValue()), 10);
                    break;
                }
                case 11: {
                    result.setObject(new BigDecimal(Float.toString(leftval)).multiply(new BigDecimal((String)right.getValue())), 10);
                    break;
                }
                case 12: {
                    Util.multiply(leftval, (float)((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.multiply(leftval, right.floatValue(), result);
                    break;
                }
                case 15: {
                    left.multiply((Variant)right.getValue(), result);
                    break;
                }
                case 0: {
                    result.setVariant(left);
                    break;
                }
                default: {
                    ExprErr.goError(64L, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97", (String)"Variant_0", (String)"epm-emr-common", (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    protected void divide(Variant left, Variant right, Variant result) throws SyntaxErrorException {
    }

    @Override
    protected void mod(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        float leftval = ((Float)left.getValue()).floatValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.mod(leftval, (float)((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.mod(leftval, (float)rightval, result);
                    break;
                }
                case 9: {
                    Util.mod(leftval, right.floatValue(), result);
                    break;
                }
                case 10: {
                    Util.mod((double)leftval, right.doubleValue(), result);
                    break;
                }
                case 11: {
                    Variant vright = new Variant();
                    if (right.isNumeric(vright)) {
                        this.mod(left, vright, result);
                        break;
                    }
                    ExprErr.goError(64L, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97", (String)"Variant_0", (String)"epm-emr-common", (Object[])new Object[0]));
                    break;
                }
                case 12: {
                    Util.mod(leftval, (float)((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.mod(leftval, right.floatValue(), result);
                    break;
                }
                case 15: {
                    left.mod((Variant)right.getValue(), result);
                    break;
                }
                default: {
                    ExprErr.goError(64L, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97", (String)"Variant_0", (String)"epm-emr-common", (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    protected void and(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        float leftval = ((Float)left.getValue()).floatValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.and(leftval, (float)((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.and(leftval, (float)rightval, result);
                    break;
                }
                case 9: {
                    Util.and((double)leftval, ((BigInteger)right.getValue()).doubleValue(), result);
                    break;
                }
                case 10: {
                    result.setObject(BigInteger.valueOf((long)leftval).and(((BigDecimal)right.getValue()).toBigInteger()), 9);
                    break;
                }
                case 11: {
                    result.setObject(BigInteger.valueOf((long)leftval).and(new BigInteger((String)right.getValue())), 9);
                    break;
                }
                case 12: {
                    Util.and(leftval, (float)((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.and(leftval, right.floatValue(), result);
                    break;
                }
                case 15: {
                    left.and((Variant)right.getValue(), result);
                    break;
                }
                default: {
                    ExprErr.goError(64L, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97", (String)"Variant_0", (String)"epm-emr-common", (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    protected void or(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        float leftval = ((Float)left.getValue()).floatValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.or(leftval, (float)((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.or(leftval, (float)rightval, result);
                    break;
                }
                case 9: {
                    Util.or((double)leftval, ((BigInteger)right.getValue()).doubleValue(), result);
                    break;
                }
                case 10: {
                    result.setObject(BigInteger.valueOf((long)leftval).or(((BigDecimal)right.getValue()).toBigInteger()), 9);
                    break;
                }
                case 11: {
                    result.setObject(BigInteger.valueOf((long)leftval).or(new BigInteger((String)right.getValue())), 9);
                    break;
                }
                case 12: {
                    Util.or(leftval, (float)((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.or(leftval, right.floatValue(), result);
                    break;
                }
                case 15: {
                    left.or((Variant)right.getValue(), result);
                    break;
                }
                default: {
                    ExprErr.goError(64L, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97", (String)"Variant_0", (String)"epm-emr-common", (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    protected void xor(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        float leftval = ((Float)left.getValue()).floatValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.xor(leftval, (float)((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.xor(leftval, (float)rightval, result);
                    break;
                }
                case 9: {
                    Util.xor((double)leftval, ((BigInteger)right.getValue()).doubleValue(), result);
                    break;
                }
                case 10: {
                    result.setObject(BigInteger.valueOf((long)leftval).xor(((BigDecimal)right.getValue()).toBigInteger()), 9);
                    break;
                }
                case 11: {
                    result.setObject(BigInteger.valueOf((long)leftval).xor(new BigInteger((String)right.getValue())), 9);
                    break;
                }
                case 12: {
                    Util.xor(leftval, (float)((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.xor(leftval, right.floatValue(), result);
                    break;
                }
                case 15: {
                    left.xor((Variant)right.getValue(), result);
                    break;
                }
                default: {
                    ExprErr.goError(64L, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97", (String)"Variant_0", (String)"epm-emr-common", (Object[])new Object[0]));
                }
            }
        }
    }
}

