/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.common.spread.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.epm.emr.common.spread.domain.IDomain;
import kd.epm.emr.common.spread.model.IDimMember;
import kd.epm.emr.common.spread.model.IDimension;

public class Domain
implements IDomain,
Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private List<IDimension> dimensions = new ArrayList<IDimension>();
    @JsonIgnore
    private transient List<IDimMember> cachedMemberList;

    @Override
    public void addDimension(IDimension dim) {
        this.dimensions.add(dim);
    }

    @Override
    public boolean removeDimension(IDimension dim) {
        return this.dimensions.remove(dim);
    }

    @Override
    public void clear() {
        this.dimensions.clear();
        this.cachedMemberList = null;
    }

    @Override
    @JsonIgnore
    public Iterator<IDimension> getDimIterator() {
        return this.dimensions.iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.dimensions.isEmpty();
    }

    @JsonIgnore
    public int getDimSize() {
        return this.dimensions.size();
    }

    @Override
    public IDimension getDimension(IDimension dim) {
        Iterator<IDimension> it = this.getDimIterator();
        while (it.hasNext()) {
            IDimension tmp = it.next();
            if (!tmp.equals(dim)) continue;
            return tmp;
        }
        return null;
    }

    public boolean containsDimension(IDimension dim) {
        return this.getDimensions().contains(dim);
    }

    @Override
    public IDimension getDimension(int index) {
        return this.dimensions.get(index);
    }

    @Override
    public void replaceDimension(IDimension old, IDimension newDim) {
        if (old != null && old.equals(newDim) && old.getMembers().equals(newDim.getMembers())) {
            return;
        }
        int index = -1;
        if (old != null) {
            index = this.dimensions.indexOf(old);
        } else {
            this.dimensions.remove(old);
        }
        if (index != -1) {
            this.dimensions.remove(index);
            this.dimensions.add(index, newDim);
        } else {
            this.dimensions.add(newDim);
        }
    }

    public List<IDimension> getDimensions() {
        return this.dimensions;
    }

    @JsonIgnore
    public List<IDimMember> getAllMembers() {
        if (this.cachedMemberList == null || this.cachedMemberList.size() == 0) {
            this.cachedMemberList = new ArrayList<IDimMember>();
            for (IDimension dim : this.dimensions) {
                this.cachedMemberList.addAll(dim.getMembers());
            }
        }
        return this.cachedMemberList;
    }

    public void resetCachedMemberList() {
        this.cachedMemberList = null;
    }
}

