/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.common.spread.sheet;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kd.epm.emr.common.spread.sheet.Cell;
import kd.epm.emr.common.spread.sheet.ISheet;
import kd.epm.emr.common.spread.sheet.hander.SpanMergeHandler;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.common.util.RangeModel;

public abstract class AbstractSheet
implements ISheet {
    private static final long serialVersionUID = 1L;
    protected static final int DEFAULT_MAX_ROW = 1000;
    protected static final int DEFAULT_MAX_COL = 52;
    private List<List<Cell>> table = new ArrayList<List<Cell>>(16);
    private String sheetName = "defaultSheetName";
    private Map<String, Object> userObject;
    private Map<String, Object> defaultDataNodeStyle;
    private Map<String, Object> sheetDefaults;

    public AbstractSheet() {
    }

    public AbstractSheet(int rows, int cols) {
        for (int i = 0; i < rows; ++i) {
            this.table.add(new ArrayList(cols));
        }
    }

    public AbstractSheet(String sheetName) {
        this.sheetName = sheetName;
    }

    @Override
    public void putUserObject(String key, Object val) {
        if (this.userObject == null) {
            this.userObject = new HashMap<String, Object>(1);
        }
        this.userObject.put(key, val);
    }

    @Override
    public <T> T getUserObject(String key) {
        if (this.userObject == null) {
            return null;
        }
        return (T)this.userObject.get(key);
    }

    @Override
    public void setDefaultDataNodeStyle(Map<String, Object> defaultDataNodeStyle) {
        this.defaultDataNodeStyle = defaultDataNodeStyle;
    }

    @Override
    public Map<String, Object> getSheetDefaults() {
        return this.sheetDefaults;
    }

    @Override
    public void setSheetDefaults(Map<String, Object> sheetDefaults) {
        this.sheetDefaults = sheetDefaults;
    }

    @Override
    public void addRow() {
        this.table.add(this.extendSameColCountAtOneRow());
    }

    private List<Cell> extendSameColCountAtOneRow() {
        ArrayList<Cell> cols = new ArrayList<Cell>(this.getMaxColumnCount());
        if (this.getMaxColumnCount() > 0) {
            for (int i = 0; i < this.getMaxColumnCount(); ++i) {
                cols.add(this.createECell(false));
            }
        }
        return cols;
    }

    protected Cell createECell(boolean isCreated) {
        return isCreated ? new Cell() : null;
    }

    @Override
    public void addRows(int rowCount) {
        for (int i = 0; i < rowCount; ++i) {
            this.addRow();
        }
    }

    @Override
    public void addRange(int rowCount, int colCount) {
        this.addRows(rowCount);
        this.addColumns(colCount);
    }

    public Cell getECell(int row, int col) {
        this.ensureCapacity(row, col);
        Cell eCell = this.table.get(row).get(col);
        if (eCell == null) {
            eCell = this.createECell(true);
            this.table.get(row).set(col, eCell);
        }
        eCell.setRowAndCol(row, col);
        return eCell;
    }

    @Override
    public void setCell(int row, int col, Cell ecell) {
        this.ensureCapacity(row, col);
        this.table.get(row).set(col, ecell);
    }

    private void ensureCapacity(int row, int col) {
        int maxrow = this.getMaxRowCount();
        int maxcol = this.getMaxColumnCount();
        if (row > maxrow - 1) {
            this.autoGrowRows(row - maxrow + 1);
        }
        if (col > maxcol - 1) {
            this.autoGrowCols(col - maxcol + 1);
        }
    }

    private void autoGrowRows(int rowCount) {
        this.addRows(rowCount);
    }

    private void autoGrowCols(int colCount) {
        this.addColumns(colCount);
    }

    @Override
    public void insertRowToBottom(int i) {
        this.insertRow(i + 1);
    }

    @Override
    public void insertColumnToRight(int i) {
        this.insertColumn(i + 1);
    }

    @Override
    public void insertRow(int i) {
        if (i > this.getMaxRowCount()) {
            this.autoGrowRows(i - this.getMaxRowCount());
        }
        this.table.add(i, this.extendSameColCountAtOneRow());
    }

    @Override
    public void insertRow(int i, boolean copybefore) {
        if (!copybefore) {
            this.insertRow(i);
        } else {
            if (i > this.getMaxRowCount()) {
                this.autoGrowRows(i - this.getMaxRowCount());
            }
            if (i - 1 >= 0 && this.table.get(i - 1) != null) {
                List before = (List)ObjectSerialUtil.deSerializedBytes((String)ObjectSerialUtil.toByteSerialized(this.table.get(i - 1)));
                for (Cell cell : before) {
                    if (cell != null && cell.isFloatCell()) {
                        Object isQuickAddNew = cell.getUserObject("isQuickAddNew");
                        cell.setValue(null);
                        cell.clearAllUserObject();
                        if (isQuickAddNew != null) {
                            cell.setUserObject("isQuickAddNew", isQuickAddNew);
                        }
                    }
                    if (cell == null || cell.getUserObject("number") != null) continue;
                    cell.setValue(null);
                }
                this.table.add(i, before);
            } else {
                this.table.add(i, this.extendSameColCountAtOneRow());
            }
        }
    }

    @Override
    public void insertRangeRows(int fromColIdx, int toColIdx, int selcRowindex, int rowcount) {
        int r;
        for (r = 0; r < rowcount; ++r) {
            this.insertRow(r + selcRowindex);
        }
        this.ensureCapacity(selcRowindex, toColIdx + rowcount);
        for (r = rowcount - 1; r >= 0; --r) {
            this.moveRowUp(fromColIdx, toColIdx, selcRowindex + r, r);
        }
    }

    @Override
    public void delRangeRows(int fromColIdx, int toColIdx, int selcRowindex, int rowcount) {
        this.moveRowUpInRangeField(fromColIdx, toColIdx, selcRowindex, rowcount);
    }

    private void moveRowUpInRangeField(int fromColIdx, int toColIdx, int selcRowindex, int rowcount) {
        int c;
        List<Cell> targ;
        int from;
        int maxRowCount = this.getMaxRowCount();
        for (from = selcRowindex + rowcount; from < maxRowCount; ++from) {
            List<Cell> source = this.table.get(from);
            targ = this.table.get(from - rowcount);
            for (c = fromColIdx; c <= toColIdx; ++c) {
                targ.set(c, source.get(c));
            }
        }
        for (from = maxRowCount - rowcount; from < maxRowCount; ++from) {
            targ = this.table.get(from);
            for (c = fromColIdx; c <= toColIdx; ++c) {
                targ.set(c, this.createECell(false));
            }
        }
    }

    @Override
    public void delRangeCols(int fromRowIdx, int toRowIdx, int selcColindex, int colCount) {
        this.moveColLeftInRangeField(fromRowIdx, toRowIdx, selcColindex, colCount);
    }

    private void moveColLeftInRangeField(int fromRowIdx, int toRowIdx, int selcColindex, int colCount) {
        int maxColCount = this.getMaxColumnCount();
        for (int r = fromRowIdx; r <= toRowIdx; ++r) {
            List<Cell> targ = this.table.get(r);
            for (int c = selcColindex + colCount; c < maxColCount; ++c) {
                targ.set(c - colCount, targ.get(c));
            }
        }
        for (int from = maxColCount - colCount; from < maxColCount; ++from) {
            for (int r = fromRowIdx; r <= toRowIdx; ++r) {
                this.table.get(r).set(from, this.createECell(false));
            }
        }
    }

    @Override
    public void insertRangeCols(int fromRowIdx, int toRowIdx, int selcColindex, int colCount) {
        for (int c = 0; c < colCount; ++c) {
            this.insertColumn(c + selcColindex);
        }
        this.ensureCapacity(toRowIdx, selcColindex + colCount);
        this.moveColLeft(fromRowIdx, toRowIdx, selcColindex, colCount);
    }

    private void moveColLeft(int excludeFromRowIdx, int excludeToRowIdx, int selcColindex, int colCount) {
        List<Cell> currRow = null;
        int size = this.getMaxRowCount();
        for (int r = 0; r < size; ++r) {
            if (r >= excludeFromRowIdx && r <= excludeToRowIdx) continue;
            currRow = this.getRowInner(r);
            this.doMoveColLeft(currRow, selcColindex, colCount);
        }
    }

    private void doMoveColLeft(List<Cell> currRow, int selcColindex, int colCount) {
        Cell[] dataElements = currRow.toArray(new Cell[0]);
        int size = dataElements.length;
        System.arraycopy(dataElements, selcColindex + colCount, dataElements, selcColindex, this.getMaxColumnCount() - (selcColindex + colCount));
        for (int c = 0; c < colCount; ++c) {
            dataElements[--size] = this.createECell(false);
        }
        currRow.clear();
        currRow.addAll(Arrays.asList(dataElements));
    }

    private void moveRowUp(int excludeFromColIdx, int excludeToColIdx, int startIndex, int offset) {
        List<Cell> nextRow = null;
        int columSize = this.getMaxColumnCount();
        int size = this.table.size();
        for (int idx = startIndex; idx < size && idx != size - 1 - offset; ++idx) {
            this.ensureCapacity(idx + 1, this.getMaxColumnCount() - 1);
            List<Cell> currRow = this.table.get(idx);
            nextRow = this.table.get(idx + 1);
            this.doReplace(currRow, nextRow, 0, excludeFromColIdx - 1);
            this.doReplace(currRow, nextRow, excludeToColIdx + 1, columSize - 1);
        }
        if (nextRow == null) {
            return;
        }
        size = nextRow.size();
        for (int i = 0; i < size; ++i) {
            if (i >= excludeFromColIdx && i <= excludeToColIdx) continue;
            nextRow.set(i, this.createECell(false));
        }
    }

    private void doReplace(List<Cell> targ, List<Cell> src, int start, int end) {
        if (start > end) {
            return;
        }
        for (int i = start; i <= end; ++i) {
            targ.set(i, src.get(i));
        }
    }

    private List<Cell> getRowInner(int i) {
        return this.table.get(i);
    }

    @Override
    public void delRow(int i) {
        if (i < 0 || !this.ensureMaxRow(i)) {
            return;
        }
        this.table.remove(i);
    }

    @Override
    public void delColumn(int i) {
        if (i < 0 || !this.ensureMaxCol(i)) {
            return;
        }
        for (List<Cell> column : this.table) {
            column.remove(i);
        }
    }

    private boolean ensureMaxRow(int rowIndex) {
        return rowIndex < this.getMaxRowCount();
    }

    private boolean ensureMaxCol(int colIndex) {
        return colIndex < this.getMaxColumnCount();
    }

    @Deprecated
    public Iterator<Cell> iteratorCells() {
        ArrayList<Cell> ECells = new ArrayList<Cell>();
        int rowIdx = 0;
        int colIdx = 0;
        for (List<Cell> row : this.table) {
            colIdx = 0;
            for (Cell ECell : row) {
                if (ECell != null) {
                    ECell.setRowAndCol(rowIdx, colIdx);
                    ECells.add(ECell);
                }
                ++colIdx;
            }
            ++rowIdx;
        }
        return ECells.iterator();
    }

    @Override
    public void iteratorCells(Consumer<Cell> consumer) {
        int rowIdx = 0;
        int colIdx = 0;
        for (List<Cell> row : this.table) {
            colIdx = 0;
            for (Cell ECell : row) {
                if (ECell != null) {
                    ECell.setRowAndCol(rowIdx, colIdx);
                    consumer.accept(ECell);
                }
                ++colIdx;
            }
            ++rowIdx;
        }
    }

    @Override
    public void iteratorCellsByPredicateBreak(Predicate<Cell> predicate) {
        int rowIdx = 0;
        int colIdx = 0;
        block0: for (List<Cell> row : this.table) {
            colIdx = 0;
            for (Cell ECell : row) {
                if (ECell != null) {
                    ECell.setRowAndCol(rowIdx, colIdx);
                    if (predicate.test(ECell)) break block0;
                }
                ++colIdx;
            }
            ++rowIdx;
        }
    }

    @Override
    public void iteratorRowRangeCells(int fromRow, int endRow, Consumer<Cell> consumer) {
        endRow = Math.min(endRow, this.getMaxRowCount() - 1);
        int colIdx = 0;
        for (int r = fromRow; r <= endRow; ++r) {
            colIdx = 0;
            for (Cell ECell : this.table.get(r)) {
                if (ECell != null) {
                    ECell.setRowAndCol(r, colIdx);
                    consumer.accept(ECell);
                }
                ++colIdx;
            }
        }
    }

    @Override
    public void iteratorColRangeCells(int fromCol, int endCol, Consumer<Cell> consumer) {
        endCol = Math.min(endCol, this.getMaxColumnCount() - 1);
        int rowIdx = 0;
        for (List<Cell> row : this.table) {
            for (int c = fromCol; c <= endCol; ++c) {
                Cell ECell = row.get(c);
                if (ECell == null) continue;
                ECell.setRowAndCol(rowIdx, c);
                consumer.accept(ECell);
            }
            ++rowIdx;
        }
    }

    @Override
    public void iteratorRangeCells(int fromRow, int endRow, int fromCol, int endCol, Consumer<Cell> consumer) {
        this.iteratorRangeCells(fromRow, endRow, fromCol, endCol, false, consumer);
    }

    @Override
    public void iteratorRangeCells(int fromRow, int endRow, int fromCol, int endCol, boolean isCreateNew, Consumer<Cell> consumer) {
        if (!isCreateNew) {
            endRow = Math.min(endRow, this.getMaxRowCount() - 1);
            endCol = Math.min(endCol, this.getMaxColumnCount() - 1);
        }
        for (int r = fromRow; r <= endRow; ++r) {
            for (int c = fromCol; c <= endCol; ++c) {
                Cell ECell;
                if (isCreateNew) {
                    ECell = this.getECell(r, c);
                    consumer.accept(ECell);
                    continue;
                }
                ECell = this.table.get(r).get(c);
                if (ECell == null) continue;
                ECell.setRowAndCol(r, c);
                consumer.accept(ECell);
            }
        }
    }

    @Override
    public void iteratorRangeCells(RangeModel rangeModel, boolean isCreatNew, Consumer<Cell> consumer) {
        if (rangeModel != null) {
            this.iteratorRangeCells(rangeModel.getY_start(), rangeModel.getY_end(), rangeModel.getX_start(), rangeModel.getX_end(), isCreatNew, consumer);
        } else {
            this.iteratorCells(consumer);
        }
    }

    @Override
    public void iteratorRangeCells(RangeModel rangeModel, Consumer<Cell> consumer) {
        if (rangeModel != null) {
            this.iteratorRangeCells(rangeModel.getY_start(), rangeModel.getY_end(), rangeModel.getX_start(), rangeModel.getX_end(), false, consumer);
        } else {
            this.iteratorCells(consumer);
        }
    }

    @Override
    public void iteratorRangeCells(RangeModel rangeModel, boolean isCreatNew, boolean isReturnNull, Consumer<Cell> consumer) {
        if (rangeModel != null) {
            this.iteratorRangeCells(rangeModel.getY_start(), rangeModel.getY_end(), rangeModel.getX_start(), rangeModel.getX_end(), isCreatNew, isReturnNull, consumer);
        } else {
            this.iteratorCells(consumer);
        }
    }

    @Override
    public void iteratorRangeCells(int fromRow, int endRow, int fromCol, int endCol, boolean isCreateNew, boolean isReturnNull, Consumer<Cell> consumer) {
        if (!isCreateNew) {
            endRow = Math.min(endRow, this.getMaxRowCount() - 1);
            endCol = Math.min(endCol, this.getMaxColumnCount() - 1);
        }
        for (int r = fromRow; r <= endRow; ++r) {
            for (int c = fromCol; c <= endCol; ++c) {
                Cell cell;
                if (isCreateNew) {
                    cell = this.getCell(r, c);
                    consumer.accept(cell);
                    continue;
                }
                cell = this.table.get(r).get(c);
                if (cell != null) {
                    cell.setRowAndCol(r, c);
                    consumer.accept(cell);
                    continue;
                }
                if (!isReturnNull) continue;
                consumer.accept(cell);
            }
        }
    }

    @Override
    public List<Cell> getRow(int rowIndex) {
        ArrayList<Cell> ECells = new ArrayList<Cell>();
        this.iteratorRowRangeCells(rowIndex, rowIndex, ECell -> ECells.add((Cell)ECell));
        return ECells;
    }

    @Override
    public List<Cell> getCol(int colIndex) {
        ArrayList<Cell> ECells = new ArrayList<Cell>();
        this.iteratorColRangeCells(colIndex, colIndex, ECell -> ECells.add((Cell)ECell));
        return ECells;
    }

    private void shrinkRow() {
        boolean isAllNull;
        for (int i = this.table.size() - 1; i >= 1 && (isAllNull = this.table.get(i).stream().allMatch(ECell -> ECell == null)); --i) {
            this.table.remove(i);
        }
    }

    @Override
    public void insertColumn(int i) {
        if (i > this.getMaxColumnCount()) {
            this.autoGrowCols(i - this.getMaxColumnCount());
        }
        for (List<Cell> column : this.table) {
            column.add(i, this.createECell(false));
        }
    }

    @Override
    public void insertColumn(int i, boolean copybefore) {
        if (!copybefore) {
            this.insertColumn(i);
        } else {
            if (i > this.getMaxColumnCount()) {
                this.autoGrowCols(i - this.getMaxColumnCount());
            }
            for (List<Cell> column : this.table) {
                if (i - 1 >= 0 && column.get(i - 1) != null) {
                    Cell before = (Cell)ObjectSerialUtil.deSerializedBytes((String)ObjectSerialUtil.toByteSerialized((Object)column.get(i - 1)));
                    if (before != null && before.isFloatCell()) {
                        before.setValue(null);
                        before.getUserObject().clearAllUserObject();
                    }
                    column.add(i, before);
                    continue;
                }
                column.add(i, this.createECell(false));
            }
        }
    }

    @Override
    public void addColumn() {
        for (List<Cell> column : this.table) {
            column.add(this.createECell(false));
        }
    }

    @Override
    public void addColumns(int colCount) {
        for (List<Cell> row : this.table) {
            for (int i = 0; i < colCount; ++i) {
                row.add(this.createECell(false));
            }
        }
    }

    @Override
    public void clear() {
        this.table.clear();
    }

    @Override
    public int getMaxRowCount() {
        return this.table.size() > 0 ? this.table.size() : 0;
    }

    @Override
    public int getCountOnRow(int row) {
        return this.table.get(row).size();
    }

    @Override
    public int getMaxColumnCount() {
        return this.table.size() > 0 ? this.table.get(0).size() : 0;
    }

    @Override
    public String getSheetName() {
        return this.sheetName;
    }

    @Override
    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public static int getDefaultMaxRow() {
        return 1000;
    }

    public static int getDefaultMaxCol() {
        return 52;
    }

    @Override
    public List<List<Cell>> getTable() {
        return this.table;
    }

    public Map<String, Object> getUserObject() {
        return this.userObject;
    }

    public void getTableJSon(JsonGenerator jsonGenerator) throws IOException {
        SpanMergeHandler spanHandler = new SpanMergeHandler();
        jsonGenerator.writeObjectFieldStart("data");
        jsonGenerator.writeObjectFieldStart("dataTable");
        int r = -1;
        for (List<Cell> row : this.table) {
            jsonGenerator.writeObjectFieldStart(String.valueOf(++r));
            int c = -1;
            for (Cell cell : row) {
                ++c;
                if (cell == null) continue;
                jsonGenerator.writeObjectFieldStart(String.valueOf(c));
                cell.toJSon(jsonGenerator);
                spanHandler.findAndMergeSpan(cell, r, c);
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndObject();
        this.writeDefaultStyle(jsonGenerator);
        jsonGenerator.writeEndObject();
        if (!spanHandler.isEmpty()) {
            spanHandler.toJSon(jsonGenerator);
        }
    }

    private void writeDefaultStyle(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeObjectFieldStart("defaultDataNode");
        jsonGenerator.writeObjectFieldStart("style");
        if (this.defaultDataNodeStyle != null && this.defaultDataNodeStyle.get("font") != null) {
            jsonGenerator.writeStringField("font", String.valueOf(this.defaultDataNodeStyle.get("font")));
        } else {
            jsonGenerator.writeStringField("font", "13.3333px \"Microsoft YaHei\"");
        }
        String borderColor = "#4c4c4c";
        if (this.defaultDataNodeStyle != null && this.defaultDataNodeStyle.get("borderColor") != null) {
            borderColor = String.valueOf(this.defaultDataNodeStyle.get("borderColor"));
        }
        jsonGenerator.writeObjectFieldStart("borderLeft");
        jsonGenerator.writeStringField("color", borderColor);
        jsonGenerator.writeNumberField("style", 1);
        jsonGenerator.writeEndObject();
        jsonGenerator.writeObjectFieldStart("borderTop");
        jsonGenerator.writeStringField("color", borderColor);
        jsonGenerator.writeNumberField("style", 1);
        jsonGenerator.writeEndObject();
        jsonGenerator.writeObjectFieldStart("borderRight");
        jsonGenerator.writeStringField("color", borderColor);
        jsonGenerator.writeNumberField("style", 1);
        jsonGenerator.writeEndObject();
        jsonGenerator.writeObjectFieldStart("borderBottom");
        jsonGenerator.writeStringField("color", borderColor);
        jsonGenerator.writeNumberField("style", 1);
        jsonGenerator.writeEndObject();
        jsonGenerator.writeEndObject();
        jsonGenerator.writeEndObject();
    }

    @Override
    public void setCellToNULL(int row, int col) {
        if (row < this.getMaxRowCount() && col < this.getMaxColumnCount()) {
            this.table.get(row).set(col, null);
        }
    }

    @Override
    public void setRow(int row, List<Cell> rowlist) {
        if (this.getMaxRowCount() < row) {
            for (int i = this.getMaxRowCount(); i <= row; ++i) {
                this.getTable().add(new ArrayList());
            }
        }
        this.getTable().set(row, rowlist);
    }
}

