/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.common.spread.sheet;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import kd.bos.util.StringUtils;
import kd.epm.emr.common.spread.UserObjectConstant;
import kd.epm.emr.common.spread.common.variant.Util;
import kd.epm.emr.common.spread.common.variant.Variant;
import kd.epm.emr.common.spread.model.CellData;
import kd.epm.emr.common.spread.model.IDimMember;
import kd.epm.emr.common.spread.model.UserObject;
import kd.epm.emr.common.spread.sheet.hander.SpanInfo;
import kd.epm.epbs.common.constant.SystemSeparator;
import kd.epm.epbs.common.util.ExcelUtils;
import kd.epm.epbs.common.util.ICell;
import kd.epm.epbs.common.util.TypeConversionUtils;

public class Cell
implements Serializable,
ICell,
UserObjectConstant {
    private static final long serialVersionUID = 1L;
    private volatile CellData cellData;
    private String formula;
    private SpanInfo spanInfo;
    private UserObject userObject;
    private boolean isChangeVal = false;
    private transient int row = -1;
    private transient int col = -1;
    private volatile transient Object newValue;
    private boolean isFloatCell;

    public Cell() {
    }

    public Cell(int row, int col) {
        this.row = row;
        this.col = col;
    }

    public void setRowAndCol(int row, int col) {
        this.row = row;
        this.col = col;
    }

    public Cell(int row, int col, Object value) {
        this.row = row;
        this.col = col;
        this.setValue(value);
    }

    public void setRow(int row) {
        this.row = row;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public final boolean setValue(Object val) {
        Variant temp = Util.convert2Variant(val);
        if (Util.notEquals(val, this.getCellData().getData())) {
            this.isChangeVal = true;
            this.getCellData().setData(temp);
        }
        return this.isChangeVal;
    }

    public Object getValue() {
        return this.getCellData().getData().getValue();
    }

    public Variant getVariant() {
        return this.getCellData().getData();
    }

    public boolean isChangeVal() {
        return this.isChangeVal;
    }

    public void setChangeVal(boolean isChange) {
        this.isChangeVal = isChange;
    }

    public void setCellData(CellData cellData) {
        this.cellData = cellData;
    }

    public CellData getCellData() {
        if (this.cellData == null) {
            this.cellData = new CellData();
        }
        return this.cellData;
    }

    public Object getUserObject(String key) {
        return this.getUserObject().getUserObject(key);
    }

    public UserObject getUserObject() {
        if (this.userObject == null) {
            this.userObject = new UserObject(0);
        }
        return this.userObject;
    }

    public void setUserObject(String key, Object val) {
        this.getUserObject().setUserObject(key, val);
    }

    public void setUserObject(UserObject userObject) {
        this.userObject = userObject;
    }

    public void removeUserObject(String key) {
        if (this.userObject == null) {
            return;
        }
        this.getUserObject().remove(key);
    }

    public void clearAllUserObject() {
        this.userObject = null;
    }

    public <T> T getUserObject(String key, T defaultValue) {
        Object v = this.getUserObject(key);
        return (T)(v == null ? defaultValue : v);
    }

    public void addDim2UserObject(IDimMember member) {
        this.getUserObject().addDim2UserObject(member);
    }

    public void addDims2UserObject(List<IDimMember> members) {
        for (IDimMember m : members) {
            this.addDim2UserObject(m);
        }
    }

    public List<IDimMember> getMemberFromUserObject() {
        return this.getUserObject().getMemberFromUserObject();
    }

    public SpanInfo getSpanInfo() {
        return this.spanInfo;
    }

    public void setSpanInfo(SpanInfo spanInfo) {
        this.spanInfo = spanInfo;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public boolean hasFormula() {
        return this.formula == null || StringUtils.isNotEmpty((String)this.formula);
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public String getExcelAxis() {
        return ExcelUtils.xy2Pos((int)this.col, (int)this.row);
    }

    public String displayDimMsg() {
        return Cell.formatDimMsg(this.getMemberFromUserObject());
    }

    public static String formatDimMsg(List<IDimMember> members) {
        StringBuilder sb = new StringBuilder();
        if (members != null && !members.isEmpty()) {
            sb.append("[");
            for (IDimMember mem : members) {
                sb.append(mem.getDimension().getName()).append("!").append(mem.getName()).append(SystemSeparator.NAME_AND_NUMBER).append(mem.getNumber()).append(";");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("]");
        }
        return sb.toString();
    }

    public String valueToString() {
        Variant val = this.getCellData().getData();
        if (val == null) {
            return "";
        }
        if (val.isNumber()) {
            return val.toString();
        }
        if (val.isDate()) {
            return TypeConversionUtils.objToDate((Object)val).toString();
        }
        return val.toString();
    }

    public String toJSon(JsonGenerator jsonGenerator) throws IOException {
        if (this.getValue() != null) {
            jsonGenerator.writeObjectField("value", this.getValue());
        }
        jsonGenerator.writeBooleanField("locked", false);
        jsonGenerator.writeEndObject();
        return null;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public void setNewValue(Object newValue) {
        this.newValue = newValue;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"").add("value", this.cellData == null ? "null" : this.cellData.getData()).add("formula", (Object)this.formula).add("isChangeVal", this.isChangeVal).add("userObject", this.userObject == null ? "null" : this.userObject).toString();
    }

    public boolean isFloatCell() {
        return this.isFloatCell;
    }

    public void setFloatCell(boolean floatCell) {
        this.isFloatCell = floatCell;
    }

    public static Cell cloneECell(Cell eCell) {
        if (eCell != null) {
            Cell cloned = new Cell(eCell.getRow(), eCell.getCol(), eCell.getValue());
            cloned.getUserObject().putAll(eCell.getUserObject());
            cloned.setFloatCell(eCell.isFloatCell());
            return cloned;
        }
        return null;
    }
}

