/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.common.spread.sheet;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.epm.emr.common.spread.sheet.AbstractSheet;
import kd.epm.emr.common.spread.sheet.Cell;
import kd.epm.emr.common.spread.sheet.StyleCell;

public class Sheet
extends AbstractSheet {
    private volatile int realMaxRows = 0;
    private volatile int realMaxCols = 0;
    private int valueAreaRowStart = -1;
    private int valueAreaColStart = -1;
    private boolean isdatachanged = false;
    private boolean isStyleCell;
    private int dimRowStart = -1;
    private int dimColStart = -1;

    public Sheet() {
    }

    public Sheet(String sheetName) {
        super.setSheetName(sheetName);
    }

    public Sheet(String sheetName, int rows, int cols) {
        super(rows, cols);
        this.setSheetName(sheetName);
    }

    @Override
    public Cell getCell(int row, int col) {
        this.ensureRealMaxRowCol(row + 1, col + 1);
        return super.getECell(row, col);
    }

    @Override
    public Cell getCell(int row, int col, boolean isCreate) {
        return isCreate ? this.getCell(row, col) : this.getCellNotAdd(row, col);
    }

    @Override
    public Cell createECell(boolean isCreated) {
        if (this.isStyleCell) {
            return isCreated ? new StyleCell() : null;
        }
        return isCreated ? new Cell() : null;
    }

    @Override
    public Cell getCellNotAdd(int row, int col) {
        if (row < 0 || col < 0) {
            return null;
        }
        if (row >= super.getTable().size()) {
            return null;
        }
        List<Cell> cols = super.getTable().get(row);
        if (cols == null) {
            return null;
        }
        if (col >= cols.size()) {
            return null;
        }
        Cell cell = cols.get(col);
        if (cell != null) {
            cell.setRowAndCol(row, col);
        }
        return cell;
    }

    @Override
    public void getSpreadJson(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeObjectFieldStart(this.getSheetName());
        jsonGenerator.writeStringField("name", this.getSheetName());
        jsonGenerator.writeNumberField("rowCount", this.realMaxRows > 0 ? this.realMaxRows : Sheet.getDefaultMaxRow());
        jsonGenerator.writeNumberField("columnCount", this.realMaxCols > 0 ? this.realMaxCols : Sheet.getDefaultMaxCol());
        this.getTableJSon(jsonGenerator);
        if (this.getSheetDefaults() != null && !this.getSheetDefaults().isEmpty()) {
            jsonGenerator.writeObjectFieldStart("defaults");
            for (Map.Entry<String, Object> entry : this.getSheetDefaults().entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                jsonGenerator.writeStringField(entry.getKey(), (String)entry.getValue());
            }
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeBooleanField("isProtected", true);
        jsonGenerator.writeObjectFieldStart("protectionOptions");
        jsonGenerator.writeBooleanField("allowResizeRows", true);
        jsonGenerator.writeBooleanField("allowResizeColumns", true);
        jsonGenerator.writeBooleanField("allowInsertRows", true);
        jsonGenerator.writeBooleanField("allowInsertColumns", true);
        jsonGenerator.writeBooleanField("allowDeleteRows", true);
        jsonGenerator.writeBooleanField("allowDeleteColumns", true);
        jsonGenerator.writeBooleanField("allowFilter", true);
        jsonGenerator.writeEndObject();
        jsonGenerator.writeEndObject();
    }

    @Override
    public int getRealMaxRows() {
        return this.realMaxRows;
    }

    @Override
    public int getRealMaxCols() {
        return this.realMaxCols;
    }

    @Override
    public int getValueAreaRowStart() {
        return this.valueAreaRowStart;
    }

    @Override
    public void setValueAreaRowStart(int valueAreaRowStart) {
        this.valueAreaRowStart = valueAreaRowStart;
    }

    @Override
    public int getValueAreaColStart() {
        return this.valueAreaColStart;
    }

    @Override
    public void setValueAreaColStart(int valueAreaColStart) {
        this.valueAreaColStart = valueAreaColStart;
    }

    @Override
    public int getDimRowStart() {
        return this.dimRowStart;
    }

    @Override
    public void setDimRowStart(int dimRowStart) {
        this.dimRowStart = dimRowStart;
    }

    @Override
    public int getDimColStart() {
        return this.dimColStart;
    }

    @Override
    public void setDimColStart(int dimColStart) {
        this.dimColStart = dimColStart;
    }

    private void ensureRealMaxRowCol(Integer row, Integer col) {
        if (row != null && row > this.realMaxRows) {
            this.realMaxRows = row;
        }
        if (col != null && col > this.realMaxCols) {
            this.realMaxCols = col;
        }
    }

    @Override
    public List<Cell> packageIntoCells() {
        ArrayList<Cell> ECells = new ArrayList<Cell>();
        int r = -1;
        for (List<Cell> row : super.getTable()) {
            ++r;
            int c = -1;
            for (Cell ECell : row) {
                ++c;
                if (ECell == null || ECell.getValue() == null) continue;
                ECell.setRowAndCol(r, c);
                ECells.add(ECell);
            }
        }
        return ECells;
    }

    @Override
    public boolean isIsdatachanged() {
        return this.isdatachanged;
    }

    @Override
    public void setIsdatachanged(boolean isdatachanged) {
        this.isdatachanged = isdatachanged;
    }

    @Override
    public void setStyleCell(boolean styleCell) {
        this.isStyleCell = styleCell;
    }

    @Override
    public boolean isStyleCell() {
        return this.isStyleCell;
    }

    @Override
    public String getEmptySheetJson() {
        StringBuilder json = new StringBuilder();
        json.append("\"").append(this.getSheetName()).append("\":{");
        json.append("\"name\":\"").append(this.getSheetName()).append("\",");
        json.append("\"rowCount\":\"").append(1000).append("\",");
        json.append("\"columnCount\":\"").append(52).append("\",");
        json.append(this.getEmptyTableJson());
        json.append("}");
        return json.toString();
    }

    public String getEmptyTableJson() {
        StringBuilder json = new StringBuilder();
        json.append("\"data\": {").append("\"dataTable\": {");
        json.append("}}");
        return json.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toJsonWithRealRowCol() throws IOException {
        JsonGenerator jsonGenerator = null;
        boolean close = false;
        SegmentedStringWriter sw = null;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonFactory jsonFactory = objectMapper.getJsonFactory();
            sw = new SegmentedStringWriter(jsonFactory._getBufferRecycler());
            jsonGenerator = jsonFactory.createJsonGenerator((Writer)sw);
            jsonGenerator.writeStartObject();
            this.getSpreadJson(jsonGenerator);
            jsonGenerator.writeEndObject();
            if (jsonGenerator != null) {
                jsonGenerator.close();
                close = true;
            }
        }
        catch (Exception e) {
            close = false;
        }
        finally {
            if (!close && jsonGenerator != null) {
                jsonGenerator.close();
            }
        }
        return sw == null ? null : sw.getAndClear();
    }
}

