/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.common.spread.sheet;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import kd.epm.emr.common.spread.sheet.Cell;

public class StyleCell
extends Cell {
    private String backColor;
    private String foreColor;
    private int hAlign;
    private int vAlign;
    private String formatter;
    private String font;
    private boolean locked;
    private int textIndent;

    public StyleCell() {
    }

    public StyleCell(Cell cell) {
        this.setValue(cell.getValue());
        this.setFormula(cell.getFormula());
        this.setSpanInfo(cell.getSpanInfo());
        cell.getUserObject().forEach((k, v) -> this.setUserObject((String)k, v));
        cell.setRowAndCol(cell.getRow(), cell.getCol());
    }

    @Override
    public String toJSon(JsonGenerator jsonGenerator) throws IOException {
        if (this.getValue() != null) {
            jsonGenerator.writeObjectField("value", this.getValue());
        }
        jsonGenerator.writeObjectFieldStart("style");
        if (this.backColor != null) {
            jsonGenerator.writeStringField("backColor", this.backColor);
        }
        if (this.foreColor != null) {
            jsonGenerator.writeStringField("foreColor", this.foreColor);
        }
        if (this.hAlign != 0) {
            jsonGenerator.writeNumberField("hAlign", this.hAlign);
        }
        if (this.vAlign != 0) {
            jsonGenerator.writeNumberField("vAlign", this.vAlign);
        }
        if (this.formatter != null) {
            jsonGenerator.writeStringField("formatter", this.formatter);
        }
        if (this.font != null) {
            jsonGenerator.writeStringField("font", this.font);
        }
        jsonGenerator.writeBooleanField("locked", this.locked);
        if (this.textIndent > 0) {
            jsonGenerator.writeNumberField("textIndent", this.textIndent);
        }
        jsonGenerator.writeEndObject();
        return null;
    }

    public void setBackColor(String backColor) {
        this.backColor = backColor;
    }

    public void setForeColor(String foreColor) {
        this.foreColor = foreColor;
    }

    public void sethAlign(int hAlign) {
        this.hAlign = hAlign;
    }

    public void setvAlign(int vAlign) {
        this.vAlign = vAlign;
    }

    public void setFormatter(String formatter) {
        this.formatter = formatter;
    }

    public String getFormatter() {
        return this.formatter;
    }

    public String getFont() {
        return this.font;
    }

    public void setFont(String font) {
        this.font = font;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setTextIndent(int textIndent) {
        this.textIndent = textIndent;
    }

    public int getTextIndent() {
        return this.textIndent;
    }
}

