/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.common.spread.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.epm.epbs.common.util.GZIPUtils;

public class DataAndJsonTranslator {
    public static final String BASE64 = "base64";
    public static final String VERSION = "version";
    public static final String SHEETCOUNT = "sheetCount";
    public static final String SHEETS = "sheets";
    public static final String NAME = "name";
    public static final String INDEX = "index";
    public static final String ISSELECTED = "isSelected";
    public static final String ROWCOUNT = "rowCount";
    public static Integer DEFAULT_ROWCOUNT = 200;
    public static final String COLUMNCOUNT = "columnCount";
    public static Integer DEFAULT_COLUMNCOUNT = 52;
    public static final String ROWS = "rows";
    public static final String COLUMNS = "columns";
    public static final String SIZE = "size";
    public static final String ACTIVEROW = "activeRow";
    public static final String ACTIVECOL = "activeCol";
    public static final String FROZENROWCOUNT = "frozenRowCount";
    public static final String FROZENCOLCOUNT = "frozenColCount";
    public static final String ZOOMFACTOR = "zoomFactor";
    public static final String VISIBLE = "visible";
    public static final String LEFTCELLINDEX = "leftCellIndex";
    public static final String TOPCELLINDEX = "topCellIndex";
    public static final String SPANS = "spans";
    public static final String SELECTIONS = "selections";
    public static final String DEFAULTS = "defaults";
    public static final String COLHEADERROWHEIGHT = "colHeaderRowHeight";
    public static final String ROWHEADERCOLWIDTH = "rowHeaderColWidth";
    public static final String COLWIDTH = "colWidth";
    public static final String ROWHEIGHT = "rowHeight";
    public static final String ROW = "row";
    public static final String COL = "col";
    public static final String COLCOUNT = "colCount";
    public static final String DEFAULT_SHEET_NAME = "Sheet1";
    public static final String ROWOUTLINES = "rowOutlines";
    public static final String COLUMNOUTLINES = "columnOutlines";
    public static final String ITEMS = "items";
    public static final String DATA = "data";
    public static final String DATATABLE = "dataTable";
    public static final String DEFAULTDATANODE = "defaultDataNode";
    public static final String ROWDATAARRAY = "rowDataArray";
    public static final String COLUMNDATAARRAY = "columnDataArray";
    public static final String VALUE = "value";
    public static final String FORMULA = "formula";
    public static final String STYLE = "style";
    public static final String FONT = "font";
    public static final String LOCKED = "locked";
    public static final String BACKCOLOR = "backColor";
    public static final String FORECOLOR = "foreColor";
    public static final String HALIGN = "hAlign";
    public static final String VALIGN = "vAlign";
    public static final String FORMATTER = "formatter";
    public static final String BORDERLEFT = "borderLeft";
    public static final String BORDERTOP = "borderTop";
    public static final String BORDERRIGHT = "borderRight";
    public static final String BORDERBOTTOM = "borderBottom";
    public static final String TEXTINDENT = "textIndent";
    public static final String WORDWRAP = "wordWrap";
    public static final String TEXTDECORATION = "textDecoration";

    public static String dealBase64Str(String spreadJson) {
        if (spreadJson.startsWith(BASE64)) {
            return spreadJson.substring(6);
        }
        return spreadJson;
    }

    public static JSONObject getSelectedSheet(JSONObject object) {
        if (object == null) {
            return null;
        }
        JSONObject sheets = (JSONObject)object.get((Object)SHEETS);
        JSONObject selectedSheet = null;
        if (sheets != null) {
            for (Object sheet : sheets.values()) {
                selectedSheet = (JSONObject)sheet;
                if (!((JSONObject)sheet).getBoolean(ISSELECTED).booleanValue()) continue;
                return (JSONObject)sheet;
            }
        }
        return selectedSheet;
    }

    public static JSONObject getSelectedSheetDataTable(JSONObject object) {
        if (object == null) {
            return null;
        }
        return DataAndJsonTranslator.getDataTable(DataAndJsonTranslator.getSelectedSheet(object));
    }

    public static JSONObject getDataTable(JSONObject object) {
        if (object != null) {
            JSONObject data = (JSONObject)object.get((Object)DATA);
            return (JSONObject)data.get((Object)DATATABLE);
        }
        return null;
    }

    public static String uncompress(String spreadJson) {
        if (spreadJson != null) {
            try {
                return new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(DataAndJsonTranslator.dealBase64Str(spreadJson))));
            }
            catch (Exception e) {
                return spreadJson;
            }
        }
        return spreadJson;
    }

    public static JSONObject fromSpreadJson(String spreadJson) {
        if (spreadJson != null) {
            return JSON.parseObject((String)DataAndJsonTranslator.uncompress(spreadJson), (Feature[])new Feature[]{Feature.OrderedField});
        }
        return null;
    }

    public static String toSpreadJson(JSONObject object) {
        byte[] bb = Base64.getEncoder().encode(GZIPUtils.compress((String)object.toJSONString()));
        String bbs = new String(bb);
        return BASE64 + bbs;
    }

    public static List<Integer[]> getLockedCells(String spreadJson) {
        JSONObject dataTable = DataAndJsonTranslator.getSelectedSheetDataTable(DataAndJsonTranslator.fromSpreadJson(spreadJson));
        if (dataTable != null) {
            LinkedList<Integer[]> lockedRowCols = new LinkedList<Integer[]>();
            for (Map.Entry rowEntry : dataTable.entrySet()) {
                Integer r = Integer.valueOf(rowEntry.getKey() + "");
                JSONObject columns = (JSONObject)rowEntry.getValue();
                for (Map.Entry columnEntry : columns.entrySet()) {
                    Integer c = Integer.valueOf(columnEntry.getKey() + "");
                    JSONObject column = (JSONObject)columnEntry.getValue();
                    JSONObject style = column.getJSONObject(STYLE);
                    if (style == null || style.get((Object)LOCKED) == null || !Boolean.TRUE.equals(style.get((Object)LOCKED))) continue;
                    lockedRowCols.add(new Integer[]{r, c});
                }
            }
            return lockedRowCols;
        }
        return null;
    }

    public static String getEmptySpreadJson(int rowCount, int columnCount, int leftCellIndex, int topCellIndex) {
        return "{\"version\":\"10.0.1\",\"sheetCount\":1,\"sheets\":{\"Sheet1\":{\"name\":\"Sheet1\",\"rowCount\":\"" + rowCount + "\",\"columnCount\":\"" + columnCount + "\",\"leftCellIndex\":\"" + leftCellIndex + "\",\"topCellIndex\":\"" + topCellIndex + "\",\"data\": {\"dataTable\": {}}}}}";
    }
}

