/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.common.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.enums.ShowTypeEnum;
import kd.epm.epbs.common.tree.AbstractTreeBuilder;
import kd.epm.epbs.common.tree.DynamicTreeContext;
import kd.epm.epbs.common.tree.TreeBuilderUtils;
import org.apache.commons.collections4.CollectionUtils;

public class RuleCategoryTreeBuilder<T extends DynamicTreeContext>
extends AbstractTreeBuilder<T> {
    public static final String CUSTOM_NODE = "2003687597250984960";
    public static final String SYSTEM_NODE = "2005049113283930112";
    public static final String CALC_NODE = "2005063722162241536";
    public static final String ROOT_NODE = "0";

    public RuleCategoryTreeBuilder(T context) {
        this._cxt = context;
    }

    public TreeNode getRoot() {
        return new TreeNode("", ROOT_NODE, EntityMetadataCache.getDataEntityType((String)"emr_rule_list").getDisplayName().getLocaleValue());
    }

    protected TreeNode createTreeNode() {
        TreeNode root = this.getRoot();
        List<TreeNode> categories = this.queryCustomCategories();
        if (categories != null) {
            root.addChildren(categories);
        } else {
            root.setLeaf(true);
        }
        return root;
    }

    private List<TreeNode> queryCustomCategories() {
        LinkedHashMap map = new LinkedHashMap();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryCustomCategories", (String)"emr_rule_category", (String)"id,number,name,parent", (QFilter[])((DynamicTreeContext)this._cxt).getqFilters(), (String)"sequence,createtime");){
            ds.forEach(e -> {
                String parent = e.getString("parent");
                map.computeIfAbsent(parent, k -> new ArrayList()).add(this.newTreeNode((Row)e));
            });
        }
        new ArrayList(map.keySet()).forEach(parentId -> this.recursionTree((List)map.get(parentId), map));
        List rootCategory = (List)map.get(ROOT_NODE);
        if (CollectionUtils.isNotEmpty((Collection)rootCategory)) {
            return rootCategory;
        }
        return null;
    }

    protected TreeNode newTreeNode(Row row) {
        return new TreeNode(row.getString("parent"), row.getString("id"), TreeBuilderUtils.getShowText((ShowTypeEnum)((DynamicTreeContext)this._cxt).getShowTypeEnum(), (Row)row));
    }

    protected void recursionTree(List<TreeNode> treeNodes, Map<String, List<TreeNode>> map) {
        if (CollectionUtils.isEmpty(treeNodes)) {
            return;
        }
        treeNodes.forEach(e -> {
            List children = (List)map.remove(e.getId());
            if (children != null) {
                e.addChildren(children);
                e.setCheckable(this.isOnlyNoLeafCheck);
                this.recursionTree(children, map);
            } else {
                e.setLeaf(true);
                e.setCheckable(this.isOnlyLeafCheck);
            }
        });
    }
}

