/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.opplugin.dataimport;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICreateTimeProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.dataimport.FileResourceImportHelper;
import kd.epm.epbs.common.util.GZIPUtils;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.common.util.TXUtils;
import kd.epm.epbs.common.util.UserUtils;

public class FileResourceImportOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(FileResourceImportOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject dynamicObject = e.getDataEntities()[0];
        DynamicObjectCollection mainResources = dynamicObject.getDynamicObjectCollection("main_resources");
        DynamicObjectCollection refResources = dynamicObject.getDynamicObjectCollection("ref_resources");
        if (mainResources.isEmpty() && refResources.isEmpty()) {
            return;
        }
        StringBuilder opDescriotion = new StringBuilder();
        this.importData(mainResources, false, opDescriotion);
        this.importData(refResources, true, opDescriotion);
        OperationResult operationResult = this.getOperationResult();
        operationResult.setMessage(opDescriotion.toString());
    }

    private void importData(DynamicObjectCollection resources, boolean isref, StringBuilder opDescriotion) {
        String type = isref ? "ref_" : "main_";
        OperationResult operationResult = this.getOperationResult();
        for (int i = 0; i < resources.size(); ++i) {
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setEntityKey(type);
            operateErrorInfo.setRowIndex(i);
            operateErrorInfo.setLevel(ErrorLevel.Info);
            DynamicObject resource = (DynamicObject)resources.get(i);
            String importType = resource.getString(type + "importing_operation");
            if (!"UPDATE".equals(importType)) {
                operateErrorInfo.setErrorCode("OMITTED");
                operationResult.addErrorInfo(operateErrorInfo);
                continue;
            }
            String entityName = null;
            Object number = null;
            try {
                DynamicObject dynamicObject;
                String dataStr = GZIPUtils.unZipAndBase64((String)resource.getString(type + "res_data").trim());
                entityName = ((JSONObject)JSON.parseObject((String)dataStr, JSONObject.class)).getString("$entityname");
                DynamicObject importObj = (DynamicObject)ObjectSerialUtil.deSerializedToDynaObj((String)entityName, (String)dataStr);
                BasedataEntityType dataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)entityName);
                String numberProperty = dataEntityType.getNumberProperty();
                number = importObj.get(numberProperty);
                ICreateTimeProperty createTimeProperty = dataEntityType.getCreateTimeProperty();
                IDataEntityProperty createdByProperty = FileResourceImportHelper.getCreatedByProperty((BasedataEntityType)dataEntityType);
                ISimpleProperty primaryKey = dataEntityType.getPrimaryKey();
                String pkKey = primaryKey != null ? primaryKey.getName() : "id";
                HashSet<String> ignoreKeys = new HashSet<String>(Collections.singletonList(pkKey));
                if (createdByProperty != null) {
                    ignoreKeys.add(createdByProperty.getName());
                }
                if ((dynamicObject = FileResourceImportHelper.getLocalDynamicObject((String)entityName, (String)numberProperty, (Object)number, (DynamicObject)importObj)) == null) {
                    dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
                    DynamicObjectUtils.copy((DynamicObject)importObj, (DynamicObject)dynamicObject, ignoreKeys);
                    dynamicObject.set(pkKey, importObj.getPkValue());
                    if (createTimeProperty != null) {
                        dynamicObject.set(createTimeProperty.getName(), (Object)TimeServiceHelper.now());
                    }
                    if (createdByProperty != null) {
                        dynamicObject.set(createdByProperty.getName(), (Object)BusinessDataServiceHelper.loadSingle((Object)UserUtils.getUserId(), (String)"bos_user"));
                    }
                } else {
                    if (createTimeProperty != null) {
                        ignoreKeys.add(createTimeProperty.getName());
                    }
                    DynamicObjectUtils.copy((DynamicObject)importObj, (DynamicObject)dynamicObject, ignoreKeys);
                    if (createdByProperty != null) {
                        dynamicObject.set(createdByProperty.getName(), dynamicObject.get(createdByProperty.getName()));
                    }
                }
                DynamicObject finalDynamicObject = dynamicObject;
                TXUtils.requiresNew((String)"isc.updateTableModel", tx2 -> SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finalDynamicObject}));
                if (!isref) {
                    operationResult.addSuccessPkId(dynamicObject.getPkValue());
                }
                operateErrorInfo.setErrorCode("SUCCESS");
                opDescriotion.append(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u57fa\u7840\u8d44\u6599\uff1a%1$s\uff0c\u7f16\u7801\uff1a%2$s\uff0c\u5bfc\u5165\u6210\u529f\u3002", (String)"FileResourceImportOp_1", (String)"epm-epbs-opplugin", (Object[])new Object[0]), entityName, number));
            }
            catch (Exception e) {
                log.info(e.getMessage());
                opDescriotion.append(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u57fa\u7840\u8d44\u6599\uff1a%1$s\uff0c\u7f16\u7801\uff1a%2$s\uff0c\u5bfc\u5165\u5931\u8d25\uff1a%3$s\u3002", (String)"FileResourceImportOp_2", (String)"epm-epbs-opplugin", (Object[])new Object[0]), entityName, number, e.getMessage()));
                operateErrorInfo.setErrorCode("FAILED");
                operateErrorInfo.setMessage(e.getMessage());
            }
            operationResult.addErrorInfo(operateErrorInfo);
        }
    }
}

