/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.opplugin.datasource;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.ds.DatasourceModel;
import kd.epm.epbs.common.util.OlapManagerHelper;

public class DataSourceValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] ed = this.getDataEntities();
        DynamicObject dot = ed[0].getDataEntity();
        String dataconnect = dot.getString("dataconnect");
        String serveaddress = dot.getString("serveraddress");
        String username = dot.getString("username");
        String password = dot.getString("password");
        String number = dot.getString("number");
        String name = dot.getString("name");
        if (StringUtils.isEmpty((String)number)) {
            this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u7f16\u7801\u672a\u586b\u5199\u3002", (String)"DataSourceValidator_1", (String)"epm-epbs-opplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((String)name)) {
            this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u540d\u79f0\u672a\u586b\u5199\u3002", (String)"DataSourceValidator_2", (String)"epm-epbs-opplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((String)serveaddress)) {
            this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u670d\u52a1\u5668\u5730\u5740\u672a\u586b\u5199\u3002", (String)"DataSourceValidator_3", (String)"epm-epbs-opplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        QFilter qFilter1 = new QFilter("id", "!=", (Object)dot.getLong("id"));
        boolean exists = QueryServiceHelper.exists((String)"epbs_datasource", (QFilter[])new QFilter[]{qFilter, qFilter1});
        if (exists) {
            this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d\u3002", (String)"DataSourceValidator_4", (String)"epm-epbs-opplugin", (Object[])new Object[0]));
            return;
        }
        password = EncrypterFactory.getAesEncrypter().encrypt(password);
        boolean isOnline = OlapManagerHelper.testIsOnline((DatasourceModel)new DatasourceModel(dataconnect, username, password));
        if (!isOnline) {
            this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u8fde\u63a5\u5931\u8d25\u3002", (String)"DataSourceValidator_5", (String)"epm-epbs-opplugin", (Object[])new Object[0]));
        }
    }
}

