/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.opplugin.model.dimension;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.OperationResultUtil;
import kd.epm.epbs.opplugin.model.dimension.validator.DimensionDeleteValidator;

public class DimensionDeleteOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new DimensionDeleteValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        List ids;
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities != null && dataEntities.length > 0 && (ids = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList())).size() > 0) {
            for (DynamicObject obj : dataEntities) {
                ids.add(obj.getLong("id"));
            }
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.billEntityType.getName(), (String)"model", (QFilter[])new QFilter("id", "in", ids).toArray());
            if (!ids.isEmpty() && !dynamicObjects.isEmpty()) {
                long modelId = ((DynamicObject)dynamicObjects.get(0)).getLong("model");
                EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
                QFilter filter = new QFilter("dimension", "in", ids);
                List idList = QueryServiceHelper.query((String)modelCache.getMetaDataEntity("epbs_struct_view"), (String)"id", (QFilter[])new QFilter[]{filter}).stream().map(c -> c.getLong("id")).collect(Collectors.toList());
                if (idList != null && idList.size() > 0) {
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("valid", "0");
                    OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)modelCache.getMetaDataEntity("epbs_struct_view"), (Object[])idList.toArray(), (OperateOption)option);
                    if (!operationResult.isSuccess()) {
                        OperationResultUtil.throwOperationResult((OperationResult)operationResult);
                    }
                }
                filter = new QFilter("id", "in", ids);
                DeleteServiceHelper.delete((String)modelCache.getMetaDataEntity("epbs_dimension"), (QFilter[])filter.toArray());
                EpbsModelCacheHelper.invalidateModelKeyById((Long)modelId);
            }
        }
    }
}

