/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.opplugin.model.member;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.model.bizmodel.BizModelInitHelper;
import kd.epm.epbs.common.model.bean.BizModelBean;
import kd.epm.epbs.common.model.bean.DimensionBean;
import kd.epm.epbs.common.model.cache.DimTypeCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.opplugin.model.member.validator.MemberDeleteValidator;

public class MemberDeleteOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new MemberDeleteValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities != null && dataEntities.length > 0) {
            EpbsModelCache modelCache;
            Set pks = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("id", "in", pks);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.billEntityType.getName(), (String)"id,model,dimension,dimension.dtypeid,view,longnumber,parent", (QFilter[])qFilter.toArray());
            String baseMemberModel = null;
            ArrayList allMembers = new ArrayList(10);
            ArrayList<Long> parentIds = new ArrayList<Long>(dynamicObjects.size());
            long modelId = 0L;
            long dimensionId = 0L;
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (baseMemberModel == null) {
                    baseMemberModel = DimTypeCacheHelper.get().getDimTypeById(dynamicObject.getLong("dimension.dtypeid")).getBaseMemberModel();
                }
                modelId = dynamicObject.getLong("model");
                long viewId = dynamicObject.getLong("view");
                dimensionId = dynamicObject.getLong("dimension");
                parentIds.add(dynamicObject.getLong("parent"));
                String longNumber = dynamicObject.getString("longnumber");
                DynamicObjectCollection childWithSelf = this.getChildWithSelf(viewId, dynamicObject.getLong("id"), longNumber);
                allMembers.addAll(childWithSelf);
            }
            HashSet<String> treeMemberNumbers = new HashSet<String>(allMembers.size());
            if (!allMembers.isEmpty()) {
                HashSet<Long> baseMemberIds = new HashSet<Long>(allMembers.size());
                HashSet<Long> treeMemberIds = new HashSet<Long>(allMembers.size());
                for (DynamicObject memberDy : allMembers) {
                    treeMemberNumbers.add(memberDy.getString("number"));
                    baseMemberIds.add(memberDy.getLong("member"));
                    treeMemberIds.add(memberDy.getLong("id"));
                }
                DeleteServiceHelper.delete((IDataEntityType)this.billEntityType, (Object[])treeMemberIds.toArray(new Long[0]));
                DynamicObjectCollection baseMembers = QueryServiceHelper.query((String)this.billEntityType.getName(), (String)"member", (QFilter[])new QFilter("member", "in", baseMemberIds).toArray());
                baseMemberIds.removeAll(baseMembers.stream().map(o -> o.getLong("member")).collect(Collectors.toSet()));
                if (!baseMemberIds.isEmpty() && baseMemberModel != null) {
                    DeleteServiceHelper.delete((String)baseMemberModel, (QFilter[])new QFilter("id", "in", baseMemberIds).toArray());
                    modelCache = EpbsModelCacheHelper.get((long)modelId);
                    DeleteServiceHelper.delete((String)modelCache.getMetaDataEntity("epbs_membpropval"), (QFilter[])new QFilter("memberid", "in", baseMemberIds).toArray());
                }
            }
            EpbsModelCache parents = BusinessDataServiceHelper.load((String)this.billEntityType.getName(), (String)"id,isleaf", (QFilter[])new QFilter("id", "in", parentIds).toArray());
            DynamicObjectCollection childs = QueryServiceHelper.query((String)this.billEntityType.getName(), (String)"parent", (QFilter[])new QFilter("parent", "in", parentIds).toArray());
            Set parentSet = childs.stream().map(o -> o.getLong("parent")).collect(Collectors.toSet());
            for (DynamicObject parent : parents) {
                long id = parent.getLong("id");
                if (parentSet.contains(id)) continue;
                parent.set("isleaf", (Object)true);
            }
            SaveServiceHelper.save((DynamicObject[])parents);
            EpbsMemberCacheHelper.invalidate((long)dimensionId);
            modelCache = EpbsModelCacheHelper.get((long)modelId);
            Map bizModelMap = modelCache.getBizModelMap();
            for (Map.Entry bizModelBeanEntry : bizModelMap.entrySet()) {
                BizModelBean bizModelBean = (BizModelBean)bizModelBeanEntry.getValue();
                Map dimMap = bizModelBean.getDimMap();
                if (!dimMap.containsKey(dimensionId)) continue;
                DimensionBean dimension = modelCache.getDimensionById(dimensionId);
                BizModelInitHelper.batchDropDimensionMembers((long)modelId, (long)bizModelBean.getId(), (String)dimension.getNumber(), treeMemberNumbers);
            }
        }
    }

    public DynamicObjectCollection getChildWithSelf(long viewId, long memberId, String longNumber) {
        QFilter qFilter = new QFilter("view", "=", (Object)viewId).and("longnumber", "like", (Object)(longNumber + "!%")).or("id", "=", (Object)memberId);
        return QueryServiceHelper.query((String)this.billEntityType.getName(), (String)"id,member,number", (QFilter[])qFilter.toArray());
    }
}

