/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.opplugin.model.member;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.opplugin.model.member.validator.MemberEnableValidator;

public class MemberEnableOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new MemberEnableValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Long> dimensionIds = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            int i;
            Object id = dataEntity.get("id");
            DynamicObject member = QueryServiceHelper.queryOne((String)this.billEntityType.getName(), (String)"model,dimension,view,view.parent,longnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
            long modelId = member.getLong("model");
            long dimensionId = member.getLong("dimension");
            long viewId = member.getLong("view");
            dimensionIds.add(member.getLong("dimension"));
            long viewGpId = member.getLong("view.parent");
            String longNumber = member.getString("longnumber");
            EpbsMemberCache epbsMemberCache = EpbsMemberCacheHelper.get((long)modelId, (long)dimensionId);
            List allChildIncludeSelf = epbsMemberCache.getAllChildIncludeSelf(((Long)id).longValue());
            if (allChildIncludeSelf.size() > 60000) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u4e00\u6b21\u7981\u752860000\u4e2a\u4ee5\u4e0a\u6210\u5458\u3002", (String)"MemberEnableOp_1", (String)"epm-epbs-opplugin", (Object[])new Object[0]));
            }
            boolean enable = "enable".equals(e.getOperationKey());
            QFilter qFilter = !enable ? new QFilter("view", "=", (Object)viewId).and("longnumber", "like", (Object)(longNumber + "!%")).or("id", "=", id) : new QFilter("id", "=", id);
            DynamicObject[] allMembers = BusinessDataServiceHelper.load((String)this.billEntityType.getName(), (String)"id,enable", (QFilter[])qFilter.toArray());
            Set childWithSelfIds = Arrays.stream(allMembers).map(o -> o.getLong("id")).collect(Collectors.toSet());
            QFilter qFilter1 = new QFilter("viewgp", "=", (Object)viewGpId).and("refmember", "in", childWithSelfIds);
            DynamicObject[] refMembers = BusinessDataServiceHelper.load((String)this.billEntityType.getName(), (String)"id,enable", (QFilter[])qFilter1.toArray());
            DynamicObject[] saveObjs = new DynamicObject[allMembers.length + refMembers.length];
            for (i = 0; i < allMembers.length; ++i) {
                allMembers[i].set("enable", (Object)(enable ? "1" : "0"));
                saveObjs[i] = allMembers[i];
            }
            for (i = 0; i < refMembers.length; ++i) {
                refMembers[i].set("enable", (Object)(enable ? "1" : "0"));
                saveObjs[allMembers.length + i] = refMembers[i];
            }
            SaveServiceHelper.save((DynamicObject[])saveObjs);
        }
        for (Long dimensionId : dimensionIds) {
            EpbsMemberCacheHelper.invalidate((long)dimensionId);
        }
    }
}

