/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.opplugin.model.member;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.model.bizmodel.BizModelInitHelper;
import kd.epm.epbs.business.model.member.MemberDao;
import kd.epm.epbs.common.enums.DataTypeEnum;
import kd.epm.epbs.common.enums.model.AggoprtEnum;
import kd.epm.epbs.common.enums.model.MemberSourceTypeEnum;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.util.DynamicObjectUtils;
import kd.epm.epbs.common.util.GlobalIdUtil;
import kd.epm.epbs.common.util.UserUtils;
import kd.epm.epbs.opplugin.model.member.validator.MemberSaveValidator;

public class MemberSaveOp
extends AbstractOperationServicePlugIn {
    private final String[] MEMBER_FIELDS = new String[]{"dimension", "number", "shownumber", "name", "shortname", "description", "sourcetype", "datatype"};

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new MemberSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dynamicObjects = e.getDataEntities();
        if (dynamicObjects != null) {
            DynamicObject[] members = new DynamicObject[dynamicObjects.length];
            ArrayList<DynamicObject> parents = new ArrayList<DynamicObject>(dynamicObjects.length);
            HashMap<Long, Integer> dseqMap = new HashMap<Long, Integer>(16);
            HashMap<Long, DynamicObject> viewMap = new HashMap<Long, DynamicObject>(16);
            for (int i = 0; i < dynamicObjects.length; ++i) {
                boolean isNew;
                DynamicObject view;
                DynamicObject dynamicObject = dynamicObjects[i];
                String number = dynamicObject.getString("number");
                String showNumber = dynamicObject.getString("shownumber");
                if (StringUtils.isEmpty((String)showNumber)) {
                    showNumber = number;
                    dynamicObject.set("shownumber", (Object)showNumber);
                }
                if ((view = dynamicObject.getDynamicObject("view")) == null) {
                    throw new KDBizException("view is null");
                }
                long viewId = view.getLong("id");
                boolean bl = isNew = dynamicObject.get("id") == null || !QueryServiceHelper.exists((String)this.billEntityType.getName(), (Object)dynamicObject.get("id"));
                if (isNew) {
                    Object parentObj = dynamicObject.get("parent");
                    if (parentObj != null && !Objects.equals(parentObj, 0L)) {
                        Object pkValue = parentObj instanceof Long ? parentObj : ((DynamicObject)parentObj).getPkValue();
                        DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)this.billEntityType.getName(), (String)"level,isleaf");
                        parent.set("isleaf", (Object)false);
                        parents.add(parent);
                        dynamicObject.set("level", (Object)(parent.getInt("level") + 1));
                        String longnumber = parent.getString("longnumber") + "!" + dynamicObject.getString("number");
                        if (longnumber.length() > 2000) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u957f\u7f16\u7801\u957f\u5ea6\u8d85\u8fc72000\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5\u5c42\u7ea7\u662f\u5426\u8fc7\u591a\u3002", (String)"MemberSaveOp_1", (String)"epm-epbs-opplugin", (Object[])new Object[0]));
                        }
                        dynamicObject.set("longnumber", (Object)longnumber);
                    } else {
                        dynamicObject.set("longnumber", (Object)dynamicObject.getString("number"));
                        dynamicObject.set("level", (Object)1);
                        dynamicObject.set("dseq", (Object)0);
                    }
                    int nextSeq = dseqMap.computeIfAbsent(viewId, k -> new MemberDao(this.billEntityType.getName()).getMaxSeq(Long.valueOf(viewId))) + 1;
                    dseqMap.put(viewId, nextSeq);
                    dynamicObject.set("dseq", (Object)nextSeq);
                    dynamicObject.set("creator", (Object)UserUtils.getUserId());
                    String viewEntity = view.getDynamicObjectType().getName();
                    view = viewMap.computeIfAbsent(viewId, k -> QueryServiceHelper.queryOne((String)viewEntity, (String)"parent,dimension,model", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)viewId)}));
                    dynamicObject.set("viewgp", (Object)view.getLong("parent"));
                    dynamicObject.set("dimension", (Object)view.getLong("dimension"));
                    dynamicObject.set("model", (Object)view.getLong("model"));
                    if (dynamicObject.get("datatype") == null) {
                        dynamicObject.set("datatype", (Object)DataTypeEnum.DEFAULT.getCode());
                    }
                    if (dynamicObject.get("reftype") == null) {
                        dynamicObject.set("reftype", (Object)"0");
                    }
                    QFilter qFilter = new QFilter("viewgp", "=", (Object)dynamicObject.getLong("viewgp.id"));
                    qFilter.and("number", "=", (Object)dynamicObject.getString("number")).and("reftype", "=", (Object)"0");
                    DynamicObject treeMember = BusinessDataServiceHelper.loadSingle((String)this.billEntityType.getName(), (String)"id,member", (QFilter[])qFilter.toArray());
                    if (treeMember != null) {
                        dynamicObject.set("refmember", treeMember.get("id"));
                        dynamicObject.set("member", treeMember.get("member"));
                    }
                }
                DynamicObject baseMember = dynamicObject.getDynamicObject("member");
                BasedataProp memberProperty = (BasedataProp)this.billEntityType.getProperty("member");
                if (baseMember == null) {
                    baseMember = DynamicObjectUtils.newDynamicObject((String)memberProperty.getBaseEntityId());
                    long memberId = GlobalIdUtil.genGlobalLongId();
                    baseMember.set("id", (Object)memberId);
                    dynamicObject.set("member", (Object)baseMember);
                } else {
                    baseMember = BusinessDataServiceHelper.loadSingle((Object)baseMember.getPkValue(), (String)memberProperty.getBaseEntityId());
                }
                for (String memberField : this.MEMBER_FIELDS) {
                    baseMember.set(memberField, dynamicObject.get(memberField));
                }
                if (dynamicObject.get("enable") == null) {
                    dynamicObject.set("enable", (Object)"1");
                }
                members[i] = baseMember;
            }
            SaveServiceHelper.save((DynamicObject[])parents.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])members);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dynamicObjects = e.getDataEntities();
        if (dynamicObjects != null) {
            HashSet<Long> dimensionIds = new HashSet<Long>(dynamicObjects.length);
            long modelId = 0L;
            for (DynamicObject dynamicObject : dynamicObjects) {
                dimensionIds.add(dynamicObject.getLong("dimension_id"));
                modelId = dynamicObject.getLong("model_id");
            }
            for (Long dimensionId : dimensionIds) {
                EpbsMemberCacheHelper.invalidate((long)dimensionId);
                BizModelInitHelper.updateOLAPBase((long)modelId, (long)dimensionId);
            }
        }
    }

    public static DynamicObject newMember(DynamicObject viewObj, String number, ILocaleString name, Long parent, String memberTreemodel) {
        DynamicObject memberTree = DynamicObjectUtils.newDynamicObject((String)memberTreemodel);
        memberTree.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        memberTree.set("number", (Object)number);
        memberTree.set("shownumber", (Object)number);
        memberTree.set("aggoprt", (Object)AggoprtEnum.ADD.getValue());
        memberTree.set("name", (Object)name);
        memberTree.set("shortname", (Object)name);
        memberTree.set("sourcetype", (Object)MemberSourceTypeEnum.PRESET.getValue());
        memberTree.set("view", (Object)viewObj);
        memberTree.set("viewgp", viewObj.get("parent"));
        memberTree.set("dimension", viewObj.get("dimension"));
        memberTree.set("model", viewObj.get("model"));
        memberTree.set("parent", (Object)parent);
        return memberTree;
    }

    public static DynamicObject newMemberCustomAggoprt(AggoprtEnum aggoprtEnum, DynamicObject viewObj, String number, ILocaleString name, Long parent, String memberTreemodel) {
        DynamicObject memberTree = MemberSaveOp.newMember(viewObj, number, name, parent, memberTreemodel);
        memberTree.set("aggoprt", (Object)aggoprtEnum.getValue());
        return memberTree;
    }
}

