/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.opplugin.model.member.validator;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.model.memberref.MemberRefHelper;
import kd.epm.epbs.business.model.memberref.MemberRefResult;
import kd.epm.epbs.common.enums.model.MemberSourceTypeEnum;
import kd.epm.epbs.common.model.bean.BaseBean;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;

public class MemberDeleteValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        if (extendedDataEntities != null) {
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                long dimensionId;
                DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                String validPreset = this.getOption().getVariableValue("validPreset", "1");
                Object pkValue = dataEntity.getPkValue();
                DynamicObject memberDy = QueryServiceHelper.queryOne((String)this.getEntityKey(), (String)"member.sourcetype,model,dimension", (QFilter[])new QFilter[]{new QFilter("id", "=", dataEntity.getPkValue())});
                if ("1".equals(validPreset) && MemberSourceTypeEnum.PRESET.getValue().equals(memberDy.getString("member.sourcetype"))) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u9884\u7f6e\u6210\u5458\u3002", (String)"MemberDeleteValidator_1", (String)"epm-epbs-opplugin", (Object[])new Object[0]));
                    continue;
                }
                long modelId = memberDy.getLong("model");
                EpbsMemberCache epbsMemberCache = EpbsMemberCacheHelper.get((long)modelId, (long)(dimensionId = memberDy.getLong("dimension")));
                List allChildIncludeSelf = epbsMemberCache.getAllChildIncludeSelf(((Long)pkValue).longValue());
                if (allChildIncludeSelf.size() > 60000) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u4e00\u6b21\u5220\u966460000\u4e2a\u4ee5\u4e0a\u6210\u5458\u3002", (String)"MemberDeleteValidator_3", (String)"epm-epbs-opplugin", (Object[])new Object[0]));
                }
                List allChildIdIncludeSelf = allChildIncludeSelf.stream().map(BaseBean::getId).collect(Collectors.toList());
                MemberRefResult memberRefResult = MemberRefHelper.getInstance((long)modelId, (long)dimensionId).hasRef(allChildIdIncludeSelf);
                if (!memberRefResult.isHasRef()) continue;
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%s\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"MemberDeleteValidator_2", (String)"epm-epbs-opplugin", (Object[])new Object[0]), memberRefResult.getMsg()));
            }
        }
    }
}

