/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.opplugin.model.member.validator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.model.view.valid.MemberSaveValidUtil;
import kd.epm.epbs.common.enums.model.MemberSourceTypeEnum;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.opplugin.model.member.validator.BaseMemberEditValidator;
import kd.epm.epbs.opplugin.model.member.validator.MemberAddNewValidator;

public class MemberSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        String ignoreValidPreset = this.getOption().getVariableValue("validPreset", "1");
        if (extendedDataEntities != null) {
            DynamicObject dataEntity = extendedDataEntities[0].getDataEntity();
            long modelId = dataEntity.getLong("model_id");
            long dimensionId = dataEntity.getLong("dimension_id");
            String appPkId = AppMetadataCache.getAppInfo((String)this.validateContext.getBillEntityType().getAppId()).getId();
            String permCheckMsg = new BaseMemberEditValidator().checkPermission(modelId, appPkId);
            List ids = Arrays.stream(extendedDataEntities).filter(o -> IDUtils.isNotNull((long)o.getDataEntity().getLong("id"))).map(o -> o.getDataEntity().getLong("id")).collect(Collectors.toList());
            DynamicObjectCollection existsMemberDys = QueryServiceHelper.query((String)this.getEntityKey(), (String)"id,number,name,view", (QFilter[])new QFilter("id", "in", ids).toArray());
            HashMap<Long, DynamicObject> existsMemberMap = new HashMap<Long, DynamicObject>(existsMemberDys.size());
            for (DynamicObject existsMember : existsMemberDys) {
                long id = existsMember.getLong("id");
                existsMemberMap.put(id, existsMember);
            }
            EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                Map memberMap;
                boolean isNew;
                String number;
                String msg;
                dataEntity = extendedDataEntity.getDataEntity();
                if (permCheckMsg != null) {
                    this.addErrorMessage(extendedDataEntity, permCheckMsg);
                }
                if ((msg = MemberSaveValidUtil.checkBaseNumber((String)(number = dataEntity.getString("number")))) != null) {
                    this.addErrorMessage(extendedDataEntity, msg);
                    continue;
                }
                boolean isPreset = MemberSourceTypeEnum.PRESET.getValue().equals(dataEntity.getString("sourcetype"));
                msg = this.checkRetain(number, isPreset);
                if (msg != null) {
                    this.addErrorMessage(extendedDataEntity, msg);
                    continue;
                }
                String showNumber = dataEntity.getString("shownumber");
                if (StringUtils.isEmpty((String)showNumber)) {
                    showNumber = number;
                }
                if ((msg = this.checkRetain(showNumber, isPreset)) != null) {
                    this.addErrorMessage(extendedDataEntity, msg);
                    continue;
                }
                boolean bl = isNew = dataEntity.get("id") == null || !existsMemberMap.containsKey(dataEntity.getLong("id"));
                if (!isNew) continue;
                EpbsMemberCache memberCache = EpbsMemberCacheHelper.get((long)modelId, (long)dimensionId);
                if (!isPreset && (memberMap = memberCache.getMemberMap()).values().stream().anyMatch(o -> o.getNumber().equalsIgnoreCase(number))) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u7f16\u7801(\u4e0d\u533a\u5206\u5927\u5c0f\u5199)\u4e3a%s\u7684\u6210\u5458\u3002", (String)"MemberSaveValidator_1", (String)"epm-epbs-opplugin", (Object[])new Object[0]), number));
                    continue;
                }
                MemberAddNewValidator memberAddNewValidator = new MemberAddNewValidator();
                Object parent = dataEntity.get("parent");
                if (parent instanceof DynamicObject) {
                    parent = ((DynamicObject)parent).get("id");
                }
                if ((msg = memberAddNewValidator.check(modelCache, memberCache, (Long)parent, "1".equals(ignoreValidPreset))) == null) continue;
                this.addErrorMessage(extendedDataEntity, msg);
            }
        }
    }

    private String checkRetain(String number, boolean isPreset) {
        if (!isPreset) {
            return MemberSaveValidUtil.checkNumber((String)number);
        }
        return null;
    }
}

