/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.opplugin.model.prop.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.model.memberref.MemberRefHelper;
import kd.epm.epbs.business.model.memberref.MemberRefResult;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;

public class PropertyDeleteValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        if (extendedDataEntities != null) {
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                this.validate(extendedDataEntity);
            }
        }
    }

    private void validate(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)dataEntity.getDynamicObjectType().getName(), (String)"model,dimension,propvalues", (QFilter[])new QFilter("id", "=", dataEntity.getPkValue()).toArray());
        long modelId = dynamicObject.getLong("model_id");
        long dimensionId = dynamicObject.getLong("dimension_id");
        DynamicObjectCollection propValues = dynamicObject.getDynamicObjectCollection("propvalues");
        ArrayList<Long> propValueIds = new ArrayList<Long>(propValues.size());
        for (DynamicObject object : propValues) {
            propValueIds.add(object.getLong("id"));
        }
        MemberRefHelper memberRefHelper = MemberRefHelper.getInstance((long)modelId, (long)dimensionId);
        memberRefHelper.setPropValue(true);
        MemberRefResult memberRefResult = memberRefHelper.hasRef(propValueIds);
        String name = dataEntity.getString("number") + " " + dataEntity.getString("name");
        if (memberRefResult.isHasRef()) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%1$s %2$s\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PropertyDeleteValidator_3", (String)"epm-epbs-opplugin", (Object[])new Object[0]), name, memberRefResult.getMsg()));
            return;
        }
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
        QFilter qFilter = new QFilter("propertydefined", "=", dataEntity.getPkValue());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)modelCache.getMetaDataEntity("epbs_membpropval"), (String)"memberid", (QFilter[])qFilter.toArray());
        if (!dynamicObjects.isEmpty()) {
            List memberIds = dynamicObjects.stream().map(o -> o.getLong("memberid")).collect(Collectors.toList());
            EpbsMemberCache epbsMemberCache = EpbsMemberCacheHelper.get((long)modelId, (long)dimensionId);
            List members = epbsMemberCache.getMembersByBaseMemberIds(memberIds, null);
            Set memberSet = members.stream().map(o -> o.getNumber() + " " + o.getNameString()).collect(Collectors.toSet());
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u7ecf\u88ab\u6210\u5458\u201c%2$s\u201d\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PropertyDeleteValidator_2", (String)"epm-epbs-opplugin", (Object[])new Object[0]), name, String.join((CharSequence)",", memberSet)));
        }
    }
}

