/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.opplugin.model.prop.validator;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.enums.model.PropTypeEnum;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.opplugin.model.BaseSaveValidator;

public class PropertySaveValidator
extends BaseSaveValidator {
    @Override
    public void validate() {
        super.validate();
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        if (extendedDataEntities != null) {
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                boolean isNew;
                DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                String number = dataEntity.getString("number");
                Object pk = dataEntity.get("id");
                boolean bl = isNew = pk == null || !QueryServiceHelper.exists((String)this.getEntityKey(), (Object)pk);
                if (isNew) {
                    QFilter numberFilter = new QFilter("number", "=", (Object)number);
                    if (!QueryServiceHelper.exists((String)this.getEntityKey(), (QFilter[])new QFilter[]{numberFilter, new QFilter("dimension", "=", (Object)dataEntity.getLong("dimension.id"))})) continue;
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5185\u5df2\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u5c5e\u6027\u3002", (String)"PropertySaveValidator_1", (String)"epm-epbs-opplugin", (Object[])new Object[0]), number));
                    continue;
                }
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)this.getEntityKey(), (String)"datatype,timetype,model,refdimension,propvalues,propvalues.sourcename");
                EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)dynamicObject.getLong("model_id"));
                String datatype = dynamicObject.getString("datatype");
                PropTypeEnum propTypeEnum = PropTypeEnum.getPropTypeEnum((String)datatype);
                if (!Objects.equals(dataEntity.getString("datatype"), datatype)) {
                    if (!this.existsMemberPropValRef(modelCache, pk)) continue;
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%s\u5df2\u7ecf\u88ab\u6210\u5458\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5c5e\u6027\u7c7b\u522b\u3002", (String)"PropertySaveValidator_2", (String)"epm-epbs-opplugin", (Object[])new Object[0]), dataEntity.getString("name")));
                    continue;
                }
                if (PropTypeEnum.DIMENSION == propTypeEnum && !Objects.equals(dataEntity.get("refdimension"), dynamicObject.get("refdimension")) && this.existsMemberPropValRef(modelCache, pk)) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%s\u5df2\u7ecf\u88ab\u6210\u5458\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u7ef4\u5ea6\u3002", (String)"PropertySaveValidator_4", (String)"epm-epbs-opplugin", (Object[])new Object[0]), dataEntity.getString("name")));
                }
                if (PropTypeEnum.TIME == propTypeEnum && !Objects.equals(dataEntity.getString("timetype"), dynamicObject.getString("timetype")) && this.existsMemberPropValRef(modelCache, pk)) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%s\u5df2\u7ecf\u88ab\u6210\u5458\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u65f6\u95f4\u7c7b\u578b\u3002", (String)"PropertySaveValidator_3", (String)"epm-epbs-opplugin", (Object[])new Object[0]), dataEntity.getString("name")));
                }
                if (!propTypeEnum.isHasPropValue()) continue;
                Set ids = dataEntity.getDynamicObjectCollection("propvalues").stream().map(o -> o.getString("id")).collect(Collectors.toSet());
                Map<String, String> dbMap = dynamicObject.getDynamicObjectCollection("propvalues").stream().collect(Collectors.toMap(o -> o.getString("id"), o -> o.getLocaleString("sourcename").toString(), (o1, o2) -> o2));
                Set<String> dbIds = dbMap.keySet();
                dbIds.removeAll(ids);
                if (dbIds.isEmpty()) continue;
                QFilter qFilter = new QFilter("propertydefined", "=", pk).and("propval", "in", dbIds);
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)modelCache.getMetaDataEntity("epbs_membpropval"), (String)"propval", (QFilter[])qFilter.toArray());
                List names = dynamicObjects.stream().map(o -> (String)dbMap.get(o.getString("propval"))).collect(Collectors.toList());
                if (names.isEmpty()) continue;
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%s\u5df2\u7ecf\u88ab\u6210\u5458\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PropertySaveValidator_5", (String)"epm-epbs-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", names)));
            }
        }
    }

    private boolean existsMemberPropValRef(EpbsModelCache modelCache, Object pkId) {
        return QueryServiceHelper.exists((String)modelCache.getMetaDataEntity("epbs_membpropval"), (QFilter[])new QFilter("propertydefined", "=", pkId).toArray());
    }
}

