/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.opplugin.model.view;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.enums.model.MonthPeriodMemberEnum;
import kd.epm.epbs.common.enums.model.PeriodTypeEnum;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.cache.DimTypeCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.DateBean;
import kd.epm.epbs.common.util.OperationResultUtil;
import kd.epm.epbs.opplugin.model.member.MemberSaveOp;
import kd.epm.epbs.opplugin.model.view.ViewSaveOP;

public class PeriodViewSaveOP
extends ViewSaveOP {
    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
    }

    @Override
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dynamicObjects = e.getDataEntities();
        if (dynamicObjects != null) {
            HashSet<Long> modelSet = new HashSet<Long>(16);
            ArrayList<DynamicObject> hySaves = new ArrayList<DynamicObject>(dynamicObjects.length);
            ArrayList<DynamicObject> qSaves = new ArrayList<DynamicObject>(dynamicObjects.length);
            ArrayList<DynamicObject> mSaves = new ArrayList<DynamicObject>(dynamicObjects.length);
            for (DynamicObject viewObj : dynamicObjects) {
                if (viewObj.getBoolean("isgroup")) continue;
                long modelId = viewObj.getLong("model_id");
                modelSet.add(modelId);
                long dimensionId = viewObj.getLong("dimension_id");
                long viewId = viewObj.getLong("id");
                EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
                DynamicObject dimension = QueryServiceHelper.queryOne((String)modelCache.getMetaDataEntity("epbs_dimension"), (String)"dtypeid", (QFilter[])new QFilter("id", "=", (Object)dimensionId).toArray());
                DimTypeBean dimTypeBean = DimTypeCacheHelper.get().getDimTypeById(dimension.getLong("dtypeid"));
                String memberTreeModel = dimTypeBean.getMemberTreemodel();
                if (QueryServiceHelper.exists((String)memberTreeModel, (QFilter[])new QFilter("view", "=", (Object)viewId).and("level", ">", (Object)1).toArray())) {
                    return;
                }
                String periodType = viewObj.getString("periodtype");
                boolean isCreHalf = viewObj.getBoolean("iscrehalf");
                boolean isCreQuarter = viewObj.getBoolean("iscrequarter");
                DynamicObject root = QueryServiceHelper.queryOne((String)memberTreeModel, (String)"id", (QFilter[])new QFilter("view", "=", (Object)viewId).and("level", "=", (Object)1).toArray());
                if (PeriodTypeEnum.MONTH.getValue().equals(periodType) || PeriodTypeEnum.QUARTER.getValue().equals(periodType) || PeriodTypeEnum.HALF_YEAR.getValue().equals(periodType)) {
                    long rootId;
                    long hy1Id = rootId = root.getLong("id");
                    long hy2Id = rootId;
                    long q1Id = rootId;
                    long q2Id = rootId;
                    long q3Id = rootId;
                    long q4Id = rootId;
                    if (isCreHalf) {
                        DynamicObject hy1 = this.setPeriodMember(MonthPeriodMemberEnum.HY1, rootId, memberTreeModel, viewObj);
                        hySaves.add(hy1);
                        q1Id = hy1Id = hy1.getLong("id");
                        q2Id = hy1Id;
                        DynamicObject hy2 = this.setPeriodMember(MonthPeriodMemberEnum.HY2, rootId, memberTreeModel, viewObj);
                        hySaves.add(hy2);
                        q3Id = hy2Id = hy2.getLong("id");
                        q4Id = hy2Id;
                    }
                    if (isCreQuarter && (PeriodTypeEnum.MONTH.getValue().equals(periodType) || PeriodTypeEnum.QUARTER.getValue().equals(periodType))) {
                        DynamicObject q1 = this.setPeriodMember(MonthPeriodMemberEnum.Q1, hy1Id, memberTreeModel, viewObj);
                        qSaves.add(q1);
                        q1Id = q1.getLong("id");
                        DynamicObject q2 = this.setPeriodMember(MonthPeriodMemberEnum.Q2, hy1Id, memberTreeModel, viewObj);
                        qSaves.add(q2);
                        q2Id = q2.getLong("id");
                        DynamicObject q3 = this.setPeriodMember(MonthPeriodMemberEnum.Q3, hy2Id, memberTreeModel, viewObj);
                        qSaves.add(q3);
                        q3Id = q3.getLong("id");
                        DynamicObject q4 = this.setPeriodMember(MonthPeriodMemberEnum.Q4, hy2Id, memberTreeModel, viewObj);
                        qSaves.add(q4);
                        q4Id = q4.getLong("id");
                    }
                    if (PeriodTypeEnum.MONTH.getValue().equals(periodType)) {
                        DynamicObject month1 = this.setPeriodMember(MonthPeriodMemberEnum.M01, q1Id, memberTreeModel, viewObj);
                        mSaves.add(month1);
                        DynamicObject month2 = this.setPeriodMember(MonthPeriodMemberEnum.M02, q1Id, memberTreeModel, viewObj);
                        mSaves.add(month2);
                        DynamicObject month3 = this.setPeriodMember(MonthPeriodMemberEnum.M03, q1Id, memberTreeModel, viewObj);
                        mSaves.add(month3);
                        DynamicObject month4 = this.setPeriodMember(MonthPeriodMemberEnum.M04, q2Id, memberTreeModel, viewObj);
                        mSaves.add(month4);
                        DynamicObject month5 = this.setPeriodMember(MonthPeriodMemberEnum.M05, q2Id, memberTreeModel, viewObj);
                        mSaves.add(month5);
                        DynamicObject month6 = this.setPeriodMember(MonthPeriodMemberEnum.M06, q2Id, memberTreeModel, viewObj);
                        mSaves.add(month6);
                        DynamicObject month7 = this.setPeriodMember(MonthPeriodMemberEnum.M07, q3Id, memberTreeModel, viewObj);
                        mSaves.add(month7);
                        DynamicObject month8 = this.setPeriodMember(MonthPeriodMemberEnum.M08, q3Id, memberTreeModel, viewObj);
                        mSaves.add(month8);
                        DynamicObject month9 = this.setPeriodMember(MonthPeriodMemberEnum.M09, q3Id, memberTreeModel, viewObj);
                        mSaves.add(month9);
                        DynamicObject month10 = this.setPeriodMember(MonthPeriodMemberEnum.M10, q4Id, memberTreeModel, viewObj);
                        mSaves.add(month10);
                        DynamicObject month11 = this.setPeriodMember(MonthPeriodMemberEnum.M11, q4Id, memberTreeModel, viewObj);
                        mSaves.add(month11);
                        DynamicObject month12 = this.setPeriodMember(MonthPeriodMemberEnum.M12, q4Id, memberTreeModel, viewObj);
                        mSaves.add(month12);
                    }
                }
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                option.setVariableValue("validPreset", "0");
                if (!hySaves.isEmpty()) {
                    OperationResultUtil.executeOperate((String)"save", (String)memberTreeModel, (DynamicObject[])hySaves.toArray(new DynamicObject[0]), (OperateOption)option);
                }
                if (!qSaves.isEmpty()) {
                    OperationResultUtil.executeOperate((String)"save", (String)memberTreeModel, (DynamicObject[])qSaves.toArray(new DynamicObject[0]), (OperateOption)option);
                }
                if (mSaves.isEmpty()) continue;
                OperationResultUtil.executeOperate((String)"save", (String)memberTreeModel, (DynamicObject[])mSaves.toArray(new DynamicObject[0]), (OperateOption)option);
            }
            for (Long modelId : modelSet) {
                EpbsModelCacheHelper.invalidateModelKeyById((Long)modelId);
            }
        }
    }

    private DynamicObject setPeriodMember(MonthPeriodMemberEnum memberEnum, Long parent, String memberTreeModel, DynamicObject viewObj) {
        DynamicObject member = MemberSaveOp.newMember(viewObj, memberEnum.getNumber(), (ILocaleString)memberEnum.getBridge().getLocaleString(), parent, memberTreeModel);
        boolean isDefault = viewObj.getBoolean("isdefault");
        String viewNumber = viewObj.getString("number");
        if (!isDefault) {
            member.set("number", (Object)(viewNumber + member.getString("number")));
            member.set("shownumber", (Object)(viewNumber + member.getString("shownumber")));
        }
        int startYear = viewObj.getInt("startyear");
        int startMonth = viewObj.getInt("startmonth");
        int startDay = viewObj.getInt("startday");
        DateBean startDayBean = memberEnum.getStartDay(startYear, startMonth, startDay);
        DateBean endDayBean = memberEnum.getEndDay(startYear, startMonth, startDay);
        member.set("startyear", (Object)startDayBean.getYear());
        member.set("startmonth", (Object)startDayBean.getMonth());
        member.set("startday", (Object)startDayBean.getDay());
        member.set("endyear", (Object)endDayBean.getYear());
        member.set("endmonth", (Object)endDayBean.getMonth());
        member.set("endday", (Object)endDayBean.getDay());
        return member;
    }
}

