/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.opplugin.model.view;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.cache.DimTypeCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.OperationResultUtil;
import kd.epm.epbs.opplugin.model.view.validator.ViewDeleteValidator;

public class ViewDeleteOP
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ViewDeleteValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Long> dimensionIds = new ArrayList<Long>(dataEntities.length);
        HashSet<Long> modelSet = new HashSet<Long>(16);
        for (DynamicObject viewObj : dataEntities) {
            long viewId = viewObj.getLong("id");
            DynamicObject view = QueryServiceHelper.queryOne((String)viewObj.getDataEntityType().getName(), (String)"model,dimension,dimension.dtypeid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)viewId)});
            modelSet.add(view.getLong("model"));
            dimensionIds.add(view.getLong("dimension"));
            DimTypeBean dimTypeBean = DimTypeCacheHelper.get().getDimTypeById(view.getLong("dimension.dtypeid"));
            String memberTreeModel = dimTypeBean.getMemberTreemodel();
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)memberTreeModel, (String)"id", (QFilter[])new QFilter("view", "=", (Object)viewId).and("level", "=", (Object)1).toArray());
            OperateOption option = OperateOption.create();
            option.setVariableValue("validPreset", "0");
            option.setVariableValue("ishasright", String.valueOf(true));
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)memberTreeModel, (DynamicObject[])dynamicObjects, (OperateOption)option);
            if (operationResult.isSuccess()) continue;
            OperationResultUtil.throwOperationResult((OperationResult)operationResult);
        }
        for (Long modelId : modelSet) {
            EpbsModelCacheHelper.invalidateModelKeyById((Long)modelId);
        }
        if (dataEntities.length > 0) {
            IDataEntityType dataEntityType = dataEntities[0].getDataEntityType();
            DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])e.getDataEntities());
        }
        for (Long dimensionId : dimensionIds) {
            EpbsMemberCacheHelper.invalidate((long)dimensionId);
        }
    }
}

