/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.opplugin.model.view;

import java.util.HashSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.epm.epbs.common.enums.model.AggoprtEnum;
import kd.epm.epbs.common.enums.model.DimTypeEnum;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.cache.DimTypeCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.CommonServiceHelper;
import kd.epm.epbs.common.util.OperationResultUtil;
import kd.epm.epbs.opplugin.model.member.MemberSaveOp;
import kd.epm.epbs.opplugin.model.member.preset.MemberPresetFactory;
import kd.epm.epbs.opplugin.model.view.validator.ViewSaveValidator;

public class ViewSaveOP
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ViewSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dynamicObjects;
        super.beginOperationTransaction(e);
        for (DynamicObject viewObj : dynamicObjects = e.getDataEntities()) {
            DynamicObject dimension = viewObj.getDynamicObject("dimension");
            DynamicObject model = viewObj.getDynamicObject("model");
            if (model != null) continue;
            dimension = BusinessDataServiceHelper.loadSingle((Object)dimension.getPkValue(), (String)dimension.getDataEntityType().getName(), (String)"model");
            viewObj.set("model", dimension.get("model"));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dynamicObjects = e.getDataEntities();
        if (dynamicObjects != null) {
            HashSet<Long> modelSet = new HashSet<Long>(16);
            for (DynamicObject viewObj : dynamicObjects) {
                long modelId = viewObj.getLong("model_id");
                modelSet.add(modelId);
                if (viewObj.getBoolean("isGroup")) continue;
                DynamicObject dimension = viewObj.getDynamicObject("dimension");
                dimension = BusinessDataServiceHelper.loadSingleFromCache((Object)dimension.getPkValue(), (String)dimension.getDataEntityType().getName());
                viewObj.set("dimension", (Object)dimension);
                DimTypeBean dimTypeBean = DimTypeCacheHelper.get().getDimTypeById(dimension.getLong("dtypeid.id"));
                String memberTreeModel = dimTypeBean.getMemberTreemodel();
                if (QueryServiceHelper.exists((String)memberTreeModel, (QFilter[])new QFilter[]{new QFilter("view", "=", viewObj.get("id"))})) continue;
                ILocaleString name = dimension.getLocaleString("name");
                DynamicObject rootMember = MemberSaveOp.newMember(viewObj, viewObj.getString("number"), name, 0L, memberTreeModel);
                rootMember.set("aggoprt", (Object)AggoprtEnum.SKIP.getValue());
                if (DimTypeEnum.Period.getValue().equals(dimTypeBean.getType())) {
                    rootMember.set("name", (Object)ResManager.getLocaleString((String)"\u5e74", (String)"ViewSaveOP_1", (String)"epm-epbs-opplugin"));
                    rootMember.set("startyear", (Object)viewObj.getString("startyear"));
                    rootMember.set("startmonth", (Object)viewObj.getString("startmonth"));
                    rootMember.set("startday", (Object)viewObj.getString("startday"));
                    rootMember.set("endyear", (Object)viewObj.getString("endyear"));
                    rootMember.set("endmonth", (Object)viewObj.getString("endmonth"));
                    rootMember.set("endday", (Object)viewObj.getString("endday"));
                }
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                option.setVariableValue("validPreset", "0");
                try {
                    OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)memberTreeModel, (DynamicObject[])new DynamicObject[]{rootMember}, (OperateOption)option);
                    if (!operationResult.isSuccess()) {
                        OperationResultUtil.throwOperationResult((OperationResult)operationResult);
                    }
                }
                catch (Exception ex) {
                    throw new KDBizException(CommonServiceHelper.getStackTraceStr((Throwable)ex));
                }
                MemberPresetFactory.doCreatePreset(viewObj, dimTypeBean, rootMember, option, this.operationResult);
            }
            for (Long modelId : modelSet) {
                EpbsModelCacheHelper.invalidateModelKeyById((Long)modelId);
            }
        }
    }
}

