/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.opplugin.importscheme;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epdm.business.importscheme.EPDMImportSchemeHelper;

public class EPDMImportSchemeEnableOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] entities = this.getDataEntities();
                String fieldName = "entryentity.fieldname";
                String staticValue = "entryentity.value";
                String colName = "entryentity.colname";
                String candidateKey = "entryentity.iscandidatekey";
                String required = "entryentity.isrequired";
                String defaultValue = "entryentity.defaultvalue";
                for (ExtendedDataEntity entity : entities) {
                    Object billPkId = entity.getBillPkId();
                    Object billNumber = entity.getValue("number");
                    String properties = String.join((CharSequence)",", "datamodel", "sheet", "attachment", "startcol", fieldName, staticValue, colName, candidateKey, required, defaultValue);
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billPkId, (String)entity.getDataEntity().getDynamicObjectType().getName(), (String)properties);
                    this.dataModelCheck(entity, billNumber, dynamicObject);
                    this.attachmentCheck(entity, billNumber, dynamicObject);
                    this.entityCheck(entity, billNumber, dynamicObject);
                }
            }

            private void attachmentCheck(ExtendedDataEntity entity, Object billNumber, DynamicObject dynamicObject) {
                String sheet = dynamicObject.getString("sheet");
                DynamicObjectCollection attDynCollection = dynamicObject.getDynamicObjectCollection("attachment");
                if (attDynCollection.isEmpty()) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EPDMImportSchemeEnableOp_1", (String)"epm-epbs-opplugin", (Object[])new Object[0]), billNumber));
                } else {
                    DynamicObject firstAttDyn = (DynamicObject)attDynCollection.get(0);
                    String startCol = dynamicObject.getString("startcol");
                    DynamicObject att = firstAttDyn.getDynamicObject("fbasedataid");
                    String type = att.getString("type");
                    if ("xls".equals(type) || "xlsx".equals(type)) {
                        if (StringUtils.isEmpty((String)sheet)) {
                            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u9644\u4ef6\u4e3aexcel\u8868\u65f6\uff0c\u6570\u636e\u6240\u5728\u9875\u7b7e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EPDMImportSchemeEnableOp_2", (String)"epm-epbs-opplugin", (Object[])new Object[0]), billNumber));
                        }
                        for (int i = 0; i < startCol.length(); ++i) {
                            char c = startCol.charAt(i);
                            if (c >= 'A' && c <= 'Z') continue;
                            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u9644\u4ef6\u4e3aexcel\u8868\u65f6\uff0c\u6570\u636e\u8d77\u59cb\u5217\u5e94\u53ea\u542b\u5927\u5199\u5b57\u6bcd\u3002", (String)"EPDMImportSchemeEnableOp_3", (String)"epm-epbs-opplugin", (Object[])new Object[0]), billNumber));
                            break;
                        }
                    } else {
                        for (int i = 0; i < startCol.length(); ++i) {
                            char c = startCol.charAt(i);
                            if (c >= '0' && c <= '9') continue;
                            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u9644\u4ef6\u4e0d\u4e3aexcel\u8868\u65f6\uff0c\u6570\u636e\u8d77\u59cb\u5217\u5e94\u4e3a\u6570\u5b57\u3002", (String)"EPDMImportSchemeEnableOp_4", (String)"epm-epbs-opplugin", (Object[])new Object[0]), billNumber));
                            break;
                        }
                    }
                }
            }

            private void dataModelCheck(ExtendedDataEntity entity, Object billNumber, DynamicObject dynamicObject) {
                DynamicObject dataModel = dynamicObject.getDynamicObject("datamodel");
                if (dataModel == null) {
                    return;
                }
                String modelNumber = dataModel.getString("number");
                String[] split = modelNumber.split("@");
                String source = "EPM.EPDM";
                if (split.length > 1 && !"epm".equalsIgnoreCase(source = split[1]) && !"EPM.EPDM".equalsIgnoreCase(source)) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u6570\u636e\u6a21\u578b\u5173\u8054\u8868\u8981\u6c42\u4e3a\u672c\u5e94\u7528\u7269\u7406\u8868\u3002", (String)"EPDMImportSchemeEnableOp_5", (String)"epm-epbs-opplugin", (Object[])new Object[0]), billNumber));
                    return;
                }
                DBRoute route = new DBRoute(source);
                if (!DB.exitsTable((DBRoute)route, (String)split[0])) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u6570\u636e\u6a21\u578b\u5173\u8054\u8868\u8981\u6c42\u4e3a\u672c\u5e94\u7528\u7269\u7406\u8868\u3002", (String)"EPDMImportSchemeEnableOp_5", (String)"epm-epbs-opplugin", (Object[])new Object[0]), billNumber));
                }
            }

            private void entityCheck(ExtendedDataEntity entity, Object billNumber, DynamicObject dynamicObject) {
                DynamicObjectCollection entries = dynamicObject.getDynamicObjectCollection("entryentity");
                if (entries.isEmpty()) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5217\u6620\u5c04\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EPDMImportSchemeEnableOp_6", (String)"epm-epbs-opplugin", (Object[])new Object[0]), billNumber));
                } else {
                    DynamicObject dataModel = dynamicObject.getDynamicObject("datamodel");
                    if (dataModel == null) {
                        return;
                    }
                    long pkValue = dataModel.getLong("id");
                    String modelNumber = dataModel.getString("number");
                    Map fieldValueFuncMap = EPDMImportSchemeHelper.getFieldValueFuncMap((long)pkValue, (String)modelNumber);
                    ArrayList<String> candidateKeys = new ArrayList<String>(4);
                    for (DynamicObject entry : entries) {
                        String defaultValue;
                        boolean required;
                        String value = entry.getString("value");
                        String col = entry.getString("colname");
                        String fieldName = entry.getString("fieldname");
                        boolean isCandidateKey = entry.getBoolean("iscandidatekey");
                        if (isCandidateKey) {
                            candidateKeys.add(fieldName);
                        }
                        if (isCandidateKey && StringUtils.isEmpty((String)col)) {
                            candidateKeys.add(fieldName);
                            String bothNullTip = ResManager.loadKDString((String)"%1$s\uff1a %2$s\u4f5c\u4e3a\u5019\u9009\u952e\u6a21\u677f\u5217\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EPDMImportSchemeEnableOp_7", (String)"epm-epbs-opplugin", (Object[])new Object[0]);
                            this.addErrorMessage(entity, String.format(bothNullTip, billNumber, fieldName));
                        }
                        if ((required = entry.getBoolean("isrequired")) && StringUtils.isEmpty((String)value) && StringUtils.isEmpty((String)col)) {
                            String bothNullTip = ResManager.loadKDString((String)"%1$s\uff1a \u5fc5\u5f55\u5b57\u6bb5%2$s\u76f4\u63a5\u8d4b\u503c\u548c\u6a21\u677f\u5217\u540d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"EPDMImportSchemeEnableOp_8", (String)"epm-epbs-opplugin", (Object[])new Object[0]);
                            this.addErrorMessage(entity, String.format(bothNullTip, billNumber, fieldName));
                        }
                        String staticValue = entry.getString("value");
                        Function<String, Object> valueConversion = fieldValueFuncMap.getOrDefault(fieldName.toUpperCase(Locale.ROOT), s -> null);
                        if (StringUtils.isNotEmpty((String)staticValue) && this.getValue(valueConversion, staticValue) == null) {
                            String bothNullTip = ResManager.loadKDString((String)"%1$s\uff1a \u5b57\u6bb5%2$s\u76f4\u63a5\u8d4b\u503c%3$s\u4e0d\u6ee1\u8db3\u5b57\u6bb5\u7c7b\u578b\u3002", (String)"EPDMImportSchemeEnableOp_9", (String)"epm-epbs-opplugin", (Object[])new Object[0]);
                            this.addErrorMessage(entity, String.format(bothNullTip, billNumber, fieldName, staticValue));
                        }
                        if (!StringUtils.isNotEmpty((String)(defaultValue = entry.getString("defaultvalue"))) || this.getValue(valueConversion, defaultValue) != null) continue;
                        String bothNullTip = ResManager.loadKDString((String)"%1$s\uff1a \u5b57\u6bb5%2$s\u9ed8\u8ba4\u503c%3$s\u4e0d\u6ee1\u8db3\u5b57\u6bb5\u7c7b\u578b\u3002", (String)"EPDMImportSchemeEnableOp_10", (String)"epm-epbs-opplugin", (Object[])new Object[0]);
                        this.addErrorMessage(entity, String.format(bothNullTip, billNumber, fieldName, defaultValue));
                    }
                    if (candidateKeys.isEmpty()) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5217\u6620\u5c04\u81f3\u5c11\u8bbe\u7f6e\u4e00\u4e2a\u5019\u9009\u952e\u3002", (String)"EPDMImportSchemeEnableOp_11", (String)"epm-epbs-opplugin", (Object[])new Object[0]), billNumber));
                    }
                }
            }

            private Object getValue(Function<String, Object> valueConversion, String valueStr) {
                try {
                    return valueConversion.apply(valueStr);
                }
                catch (Exception ex) {
                    return null;
                }
            }
        });
    }
}

