/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin;

import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.form.FormView;
import kd.epm.epbs.business.bd.model.ModelF7ParamContext;
import kd.epm.epbs.business.bd.model.ModelListHelper;
import kd.epm.epbs.business.userSelect.UserQuerySelectHelper;
import kd.epm.epbs.common.annotation.AppMark;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.model.IMetaDataEntity;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.formplugin.EpbsBaseFunction;
import kd.epm.epbs.formplugin.IModelId;
import kd.epm.epbs.formplugin.IOperationLog;
import kd.epm.epbs.formplugin.IPermItemCheckListener;
import kd.epm.epbs.formplugin.permission.admin.ModelAdminAssignHelper;

public class AbstractBaseListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener,
IOperationLog,
IMetaDataEntity,
EpbsBaseFunction,
IPermItemCheckListener,
IModelId {
    private EpbsModelCache modelCache;

    @Override
    public AbstractFormPlugin getPlugin() {
        return this;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (this.getView().getClass().equals(FormView.class)) {
            this.addItemClickListeners(new String[]{"toolbarap"});
        }
        this.addBasedataListener(this.getModelSign());
    }

    public void addBasedataListener(String ... keys) {
        this.addF7SelectListener(this, keys);
    }

    @AppMark
    public void addF7SelectListener(BeforeF7SelectListener listener, String ... keys) {
        if (keys == null) {
            return;
        }
        for (String ckey : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(ckey);
            if (basedataEdit == null) continue;
            basedataEdit.addBeforeF7SelectListener(listener);
        }
    }

    @Override
    public long getModelId() {
        return this.getModelId(this.getView(), this.getModelSign());
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        if (Objects.equals(this.getModelSign(), name)) {
            ModelListHelper.handleModelShowParam((ListShowParameter)((ListShowParameter)event.getFormShowParameter()), (ModelF7ParamContext)this.getModelF7Param());
        }
    }

    protected ModelF7ParamContext getModelF7Param() {
        return ModelListHelper.createModelF7Ctx((IFormView)this.getView());
    }

    @Override
    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }

    @Override
    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    @Override
    public void writeLog(IOperationTypeInfo opName, MultiLangEnumBridge opDescriotion) {
        OperationLogUtil.writeLog((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (IOperationTypeInfo)opName, (MultiLangEnumBridge)opDescriotion, (Long)this.getModelId());
    }

    @Override
    public void writeLog(String entityNumber, String baseEntity, IOperationTypeInfo opName, Object[] primaryKeyValues) {
        MultiLangEnumBridge opDescriotion = null;
        if (primaryKeyValues != null) {
            List numbers = this.getEntityDataNumber(baseEntity, primaryKeyValues);
            opDescriotion = this.getOpDescriotionByNumber(numbers);
        }
        OperationLogUtil.writeLog((String)this.getBizAppId(), (String)entityNumber, (IOperationTypeInfo)opName, (MultiLangEnumBridge)opDescriotion, (Long)this.getModelId());
    }

    @Override
    public void writeLog(String entityNumber, IOperationTypeInfo opName, Object[] primaryKeyValues) {
        this.writeLog(entityNumber, entityNumber, opName, primaryKeyValues);
    }

    public boolean validateModelAdmin(PreOpenFormEventArgs e) {
        return ModelAdminAssignHelper.validateModelAdmin(e);
    }

    public void setDefaultModel() {
        Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
        if (IDUtils.isNull((Long)modelId)) {
            modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        }
        if (IDUtils.isNull((Long)modelId)) {
            // empty if block
        }
        if (IDUtils.isNull((Long)modelId)) {
            modelId = UserQuerySelectHelper.getRandomModelId((ModelF7ParamContext)this.getModelF7Param());
        }
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4efb\u4f55\u4f53\u7cfb\uff0c\u8bf7\u5148\u65b0\u589e\u4f53\u7cfb\u3002", (String)"AbstractBaseListPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        } else {
            this.getModel().setValue("model", (Object)modelId);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String entityId = this.getView().getEntityId();
    }

    public BillList getBillList() {
        BillList billList = (BillList)this.getControl("billlistap");
        return billList;
    }

    public ListSelectedRowCollection getSelectedRows() {
        ListSelectedRowCollection selectedRows = this.getBillList().getSelectedRows();
        return selectedRows;
    }

    public List<Long> getSelectedIds() {
        return this.getSelectedRows().stream().map(e -> (Long)e.getPrimaryKeyValue()).collect(Collectors.toList());
    }

    public boolean isSelectedRows(String msg) {
        if (this.getSelectedRows().isEmpty()) {
            this.getView().showTipNotification(msg);
            return false;
        }
        return true;
    }

    public boolean isSelectedOneRow(String msg) {
        ListSelectedRowCollection rows = this.getSelectedRows();
        if (!rows.isEmpty() && rows.size() > 1) {
            this.getView().showTipNotification(msg);
            return false;
        }
        return true;
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        try {
            this.checkOperationPerm(key);
        }
        catch (KDBizException e) {
            evt.setCancel(true);
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        try {
            this.checkOperationPerm(itemKey);
        }
        catch (KDBizException e) {
            evt.setCancel(true);
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    public <T> T getModelValue(String property) {
        return (T)this.getModel().getValue(property);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.licenseCheck(e);
    }

    public EpbsModelCache getModelCache() {
        if (this.modelCache == null) {
            this.modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
        }
        return this.modelCache;
    }
}

