/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin;

import java.lang.reflect.ParameterizedType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListShowParameter;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.licence.LicenceControl;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.formplugin.pageinteraction.DynamicPage;

public interface EpbsBaseFunction {
    public static final String MODEL = "model";

    public AbstractFormPlugin getPlugin();

    default public String getModelSign() {
        return MODEL;
    }

    default public <T> T getFormCustomParam(String key) {
        return (T)this.getPlugin().getView().getFormShowParameter().getCustomParam(key);
    }

    default public <T> T deSerializedBytes(String serial) {
        return (T)(serial == null ? null : ObjectSerialUtil.deSerializedBytes((String)serial));
    }

    default public String toByteSerialized(Object t) {
        return ObjectSerialUtil.toByteSerialized((Object)t);
    }

    default public Class getClazz(int index) {
        ParameterizedType superClass = (ParameterizedType)this.getClass().getGenericSuperclass();
        return (Class)superClass.getActualTypeArguments()[index];
    }

    default public Object getValue(String sign) {
        if (this instanceof DynamicPage) {
            return ((DynamicPage)((Object)this)).getDynamicValue(sign);
        }
        return this.getPlugin().getView().getModel().getValue(sign);
    }

    default public void setValue(String sign, Object value) {
        this.setValue(sign, value, true);
    }

    default public void setValue(String sign, Object value, boolean cachePage) {
        this.getPlugin().getView().getModel().setValue(sign, value);
        if (this instanceof DynamicPage) {
            ((DynamicPage)((Object)this)).setDynamicValue(sign, value, cachePage);
        }
    }

    default public boolean isTrueFlagInCache(String key) {
        String str = this.getPlugin().getPageCache().get(key);
        return !StringUtils.isEmpty((String)str) && Boolean.parseBoolean(str);
    }

    default public void cacheTrueOrFalseFlag(String key, boolean b) {
        this.getPlugin().getPageCache().put(key, Boolean.toString(b));
    }

    default public String getFormId(PreOpenFormEventArgs e) {
        String formId = ((FormShowParameter)e.getSource()).getFormId();
        if (e.getFormShowParameter() instanceof ListShowParameter && formId.startsWith("bos_")) {
            formId = ((ListShowParameter)e.getFormShowParameter()).getBillFormId();
        }
        return formId;
    }

    default public void licenseCheck(PreOpenFormEventArgs e) {
        String appId = e.getFormShowParameter().getAppId();
        String formId = this.getFormId(e);
        LicenseCheckResult re = LicenceControl.getInstance((String)appId).check(appId, formId);
        if (re != null && !re.getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(re.getMsg());
            LicenceControl.setCancelFormShowParameter((PreOpenFormEventArgs)e, (LicenseCheckResult)re);
        }
    }
}

