/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.bd.commontype;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.bd.commontype.CommonTypeHelper;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.util.AppUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;

public class CommonTypeEditPlugin
extends AbstractFormPlugin {
    private OperationStatus status;

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ComboEdit comboEdit = (ComboEdit)this.getControl("appnum");
        ArrayList apps = Lists.newArrayList();
        for (AppTypeEnum appType : AppUtils.getAppTypesCache()) {
            apps.add(new ComboItem(new LocaleString(appType.getDesc()), appType.getAppNum()));
        }
        comboEdit.setComboItems((List)apps);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        this.status = this.getView().getFormShowParameter().getStatus();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean isSuccess = e.getOperationResult().getValidateResult().isSuccess();
        if (e.getSource() instanceof Save && isSuccess && OperationStatus.ADDNEW == this.status) {
            DynamicObject entity = this.getModel().getDataEntity();
            QFilter filter = CommonTypeHelper.getCommonQfilter((String)entity.getString("category"), (String)entity.getString("appnum"));
            DynamicObjectCollection list = QueryServiceHelper.query((String)entity.getDataEntityType().getName(), (String)"id,sequence", (QFilter[])filter.toArray(), (String)"sequence desc", (int)1);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                long sequence = ((DynamicObject)list.get(0)).getLong("sequence");
                if (((DynamicObject)list.get(0)).getLong("id") != entity.getLong("id")) {
                    DynamicObject saveEntity = BusinessDataServiceHelper.loadSingle((Object)entity.getLong("id"), (String)entity.getDataEntityType().getName());
                    saveEntity.set("sequence", (Object)(sequence + 1L));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveEntity});
                }
            }
        }
    }
}

