/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.bd.commontype;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.util.AppUtils;

public class CommonTypeListPlugin
extends AbstractListPlugin {
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public void setListFields(List<ListField> listFields) {
                ListField listField = listFields.stream().filter(e -> Objects.equals("appnum", e.getKey())).findFirst().orElseGet(() -> null);
                if (null != listField) {
                    try {
                        ComboProp comboProp = (ComboProp)listField.getSrcFieldProp().clone();
                        comboProp.getComboItems().clear();
                        for (AppTypeEnum appType : AppUtils.getAppTypesCache()) {
                            comboProp.getComboItems().add(new ValueMapItem(null, appType.getAppNum(), new LocaleString(appType.getDesc())));
                        }
                        listField.setSrcFieldProp((IDataEntityProperty)comboProp);
                    }
                    catch (CloneNotSupportedException e2) {
                        throw new KDBizException((Throwable)e2, new ErrorCode("", e2.getMessage()), new Object[0]);
                    }
                }
                super.setListFields(listFields);
            }
        });
    }
}

