/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.bd.manage;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.epm.epbs.business.bd.manage.ManageHelper;
import kd.epm.epbs.business.bd.manage.ModelEntryGrid;
import kd.epm.epbs.business.bd.manage.task.dto.DivisionBaseDataInput;
import kd.epm.epbs.business.bd.manage.task.dto.DivisionBaseDataResult;
import kd.epm.epbs.business.bd.manage.task.dto.DivisionBaseDataTaskInput;
import kd.epm.epbs.business.bd.manage.task.dto.DivisionBaseDataTaskResult;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.common.util.OperationMsgUtil;

public class ManagImportPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String BTN_IMPORT = "btn_import";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_IMPORT});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachment");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void afterUpload(UploadEvent evt) {
        ArrayList urls = new ArrayList(10);
        Collections.addAll(urls, evt.getUrls());
        LinkedHashMap url1map = (LinkedHashMap)evt.getUrls()[0];
        String url = url1map.get("url").toString();
        String filename = url1map.get("name").toString();
        Long pkId = System.currentTimeMillis();
        String fbilltype = "epbs_basedata_excell";
        String urlstr = AttachmentServiceHelper.saveTempToFileService((String)url, (String)"epbs", (String)fbilltype, (Object)pkId, (String)filename);
        this.getPageCache().put("urls", urlstr);
        this.getPageCache().put("filename", filename);
    }

    public void afterRemove(UploadEvent evt) {
        this.getPageCache().put("urls", null);
    }

    public void click(EventObject evt) {
        String eventKey = ((Control)evt.getSource()).getKey();
        if (BTN_IMPORT.equalsIgnoreCase(eventKey)) {
            this.importData();
        }
    }

    private void importData() {
        String url = this.getPageCache().get("urls");
        if (StringUtils.isBlank((CharSequence)url)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"ManagImportPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        Object entryGridModel = this.getFormCustomParam("entryGridModel");
        ModelEntryGrid modelEntryGrid = (ModelEntryGrid)SerializationUtils.fromJsonString((String)entryGridModel.toString(), ModelEntryGrid.class);
        DivisionBaseDataInput divisionBaseDataInput = new DivisionBaseDataInput();
        divisionBaseDataInput.setType("import");
        divisionBaseDataInput.setModelEntryGrid(modelEntryGrid);
        divisionBaseDataInput.setUrl(url);
        divisionBaseDataInput.setFileName(this.getPageCache().get("filename"));
        DivisionBaseDataTaskInput input = new DivisionBaseDataTaskInput();
        input.setInput(divisionBaseDataInput);
        this.dispatchImport(input);
    }

    private void dispatchImport(DivisionBaseDataTaskInput input) {
        String className = "kd.epm.epbs.business.bd.manage.task.BaseDataDivisionTask";
        String jobName = ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5bfc\u5165\u8fdb\u5ea6", (String)"ManagImportPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]);
        ManageHelper.handleDysData((IFormPlugin)this, (IFormView)this.getView(), (String)JSON.toJSONString((Object)input), (String)className, (String)jobName, (String)"taskcloseback");
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "taskcloseback": {
                this.taskCallBack(evt.getReturnData());
                break;
            }
            case "importResultClose": {
                String taskResultStr = this.getView().getPageCache().get("divisionBaseDataTaskResult");
                if (StringUtils.isNotBlank((CharSequence)taskResultStr)) {
                    DivisionBaseDataTaskResult divisionBaseDataTaskResult = (DivisionBaseDataTaskResult)SerializationUtils.fromJsonString((String)taskResultStr, DivisionBaseDataTaskResult.class);
                    DivisionBaseDataResult result = divisionBaseDataTaskResult.getResult();
                    int failCount = result.getFailCount();
                    if (failCount != 0) break;
                    this.getView().close();
                    break;
                }
                this.getView().close();
                break;
            }
        }
    }

    private void taskCallBack(Object returnData) {
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map) {
            DivisionBaseDataTaskResult divisionBaseDataTaskResult = ManageHelper.taskCallBack((Object)returnData);
            if (divisionBaseDataTaskResult == null) {
                return;
            }
            Object entryGridModel = this.getFormCustomParam("entryGridModel");
            ModelEntryGrid modelEntryGrid = (ModelEntryGrid)SerializationUtils.fromJsonString((String)entryGridModel.toString(), ModelEntryGrid.class);
            if (!divisionBaseDataTaskResult.getSuccess().booleanValue()) {
                this.getView().showTipNotification(divisionBaseDataTaskResult.getMessage());
                OperationLogUtil.writeLog((String)this.getBizAppId(), (String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.IMPORT, (MultiLangEnumBridge)OperationMsgUtil.getImportFailWithNumber((String)modelEntryGrid.getNumber()));
            } else {
                OperationLogUtil.writeLog((String)this.getBizAppId(), (String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.IMPORT, (MultiLangEnumBridge)OperationMsgUtil.getImportSucWithNumber((String)modelEntryGrid.getNumber()));
                this.openBaseDataImportResult(divisionBaseDataTaskResult);
            }
        }
    }

    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    public Object getFormCustomParam(String key) {
        return this.getView().getFormShowParameter().getCustomParam(key);
    }

    public void openBaseDataImportResult(DivisionBaseDataTaskResult divisionBaseDataTaskResult) {
        String taskResultStr = SerializationUtils.toJsonString((Object)divisionBaseDataTaskResult);
        this.getView().getPageCache().put("divisionBaseDataTaskResult", taskResultStr);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epbs_basedataimportresult");
        showParameter.setCustomParam("divisionBaseDataTaskResult", (Object)taskResultStr);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "importResultClose");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }
}

