/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.bd.manage;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.epbs.common.util.NumberRuleUtils;

public class ManageCatalogPlugin
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Object objParent = map.get("parent");
        if (!"0".equals(objParent)) {
            this.getModel().setValue("parent", objParent);
        }
        this.getPageCache().put("isSave", "1");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.EDIT)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        if ("save".equals(opType)) {
            IDataModel dataModel = this.getModel();
            String number = (String)dataModel.getValue("number");
            if (!NumberRuleUtils.checkNumberV2((String)number)) {
                this.getView().showTipNotification(NumberRuleUtils.getMessageV2(), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
            QFilter filter = new QFilter("number", "=", (Object)String.valueOf(number));
            boolean existRepeatNumber = QueryServiceHelper.exists((String)"epbs_basedatacatalog", (QFilter[])new QFilter[]{filter});
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (status.equals((Object)OperationStatus.ADDNEW) && existRepeatNumber) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201d%s\u201c\u7f16\u7801\u91cd\u590d\u3002", (String)"ManageObjectPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]), number));
                args.setCancel(true);
                return;
            }
            DynamicObject parent = (DynamicObject)dataModel.getValue("parent");
            dataModel.setValue("longname", (Object)(parent.getString("longname") + "." + parent.getString("id")));
            if (status.equals((Object)OperationStatus.ADDNEW)) {
                this.getView().getModel().setValue("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
                this.getView().getModel().setValue("createtime", (Object)TimeServiceHelper.now());
                this.getView().getModel().setValue("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
                this.getView().getModel().setValue("modifytime", (Object)TimeServiceHelper.now());
            } else {
                this.getView().getModel().setValue("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
                this.getView().getModel().setValue("modifytime", (Object)TimeServiceHelper.now());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean issuccess = e.getOperationResult().getValidateResult().isSuccess();
        List ids = e.getOperationResult().getSuccessPkIds();
        if (e.getSource() instanceof Save && issuccess) {
            this.getView().returnDataToParent((Object)ids);
            this.getView().close();
        }
    }
}

