/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.bd.manage;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.epm.epbs.business.bd.manage.CopyFormResult;
import kd.epm.epbs.business.bd.manage.EntityMetadata;
import kd.epm.epbs.business.bd.manage.ManageCopyHepler;
import kd.epm.epbs.business.bd.manage.ManageHelper;
import kd.epm.epbs.business.bd.manage.ManageImportHelper;
import kd.epm.epbs.business.bd.manage.ManageTreeHelper;
import kd.epm.epbs.business.bd.manage.ModelCustomSelectField;
import kd.epm.epbs.business.bd.manage.ModelEntryGrid;
import kd.epm.epbs.business.bd.manage.ModelEntryGridChange;
import kd.epm.epbs.business.bd.manage.task.dto.DivisionBaseDataInput;
import kd.epm.epbs.business.bd.manage.task.dto.DivisionBaseDataTaskInput;
import kd.epm.epbs.business.bd.manage.task.dto.DivisionBaseDataTaskResult;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.enums.BaseDataTypeEnum;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.model.IMetaDataEntity;
import kd.epm.epbs.common.util.DateTimeUtils;
import kd.epm.epbs.common.util.GlobalIdUtil;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.common.util.OperationMsgUtil;
import kd.epm.epbs.common.util.OperationResultUtil;
import kd.epm.epbs.common.util.QFBuilder;
import kd.epm.epbs.common.util.TXUtils;
import kd.epm.epbs.formplugin.bd.manage.ManageBaseListPlugin;
import kd.epm.epbs.formplugin.bd.manage.ManageEntryGridControl;
import org.apache.commons.collections.CollectionUtils;

public class ManageListPlugin
extends ManageBaseListPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener,
IMetaDataEntity {
    public static String[] columnWidths = new String[]{"20", "20", "20", "20", "20", "20", "20", "30", "20", "20", "20"};

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"entryentity"});
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addSetFilterListener(evt -> {
            QFilter qFilter = this.getQFilter(this.getCurrentNodeId());
            evt.getQFilters().add(qFilter);
        });
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnaddcatalog", "btnedit", "btndel", "btnadd", "searchbefore", "searchnext", "labelup", "imageapup", "labeldown", "imageapdown", "barup", "barreset", "barsearchdata"});
        this.addItemClickListeners(new String[]{"toolbarap", "operationtoor"});
        final TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        tree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                ManageListPlugin.this.getPageCache().put("focusnodeid", evt.getNodeId().toString());
                ManageListPlugin.this.setFilterflexpanelapVisible("barup");
                ManageListPlugin.this.clearFilter();
                ManageListPlugin.this.treeOnClick(tree);
            }
        });
        Search se = (Search)this.getControl("searchap");
        se.addEnterListener(evt -> this.searchap(evt));
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"baritemsave", "barimport", "entryentity", "filterflexpanelap", "labelup", "imageapup", "labeldown", "imageapdown", "buttonpanel"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"btnadd", "btnedit", "baritemaddsub"});
        ManageTreeHelper.addCatalogRoot();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object basedataId = formShowParameter.getCustomParam("basedataId");
        if (ObjectUtils.isEmpty((Object)basedataId)) {
            this.initTree(null);
        } else {
            this.initTree(basedataId.toString());
            this.treeOnCommonClick(basedataId.toString());
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        if (StringUtils.equals((CharSequence)e.getKey(), (CharSequence)"entryentity")) {
            ModelEntryGrid entryGridModel;
            ManageEntryGridControl entryGrid = new ManageEntryGridControl();
            entryGrid.setView(this.getView());
            entryGrid.setKey("entryentity");
            entryGrid.setEntryKey("entryentity");
            entryGrid.setPlugin(this);
            entryGrid.entryGridModel = entryGridModel = this.getEntryGridModel();
            Control oldGrid = e.getControl();
            if (oldGrid == null) {
                oldGrid = ManageHelper.findControl((String)"entryentity", (AbstractFormPlugin)this);
            }
            if (oldGrid instanceof EntryGrid) {
                entryGrid.getItems().addAll(((EntryGrid)oldGrid).getItems());
            }
            e.setControl((Control)entryGrid);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase()) {
            case "barreset": {
                this.clearFilter();
                this.searchData(false);
                break;
            }
            case "barsearchdata": {
                this.searchData(true);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "barupdate": {
                this.updateData();
                break;
            }
            case "btn_enable": {
                this.setStatus(true);
                break;
            }
            case "btn_disable": {
                this.setStatus(false);
                break;
            }
            case "baritemdel": 
            case "custom_del": {
                this.actionDelete();
                break;
            }
            case "baritemrefresh": {
                this.refrush();
                break;
            }
            case "baritemaddsub": 
            case "custom_add": {
                this.addDataByType();
                break;
            }
            case "baritemsave": {
                this.saveBasicData();
                break;
            }
            case "btn_export": {
                this.exportData();
                break;
            }
            case "barimport": {
                this.openBaseDataImport();
                break;
            }
            case "barcopy": {
                this.actionCopy();
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String appPkId = AppMetadataCache.getAppInfo((String)this.getView().getFormShowParameter().getAppId()).getId();
        boolean permission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appPkId, (String)this.getMetaDataEntity(this.getView(), "epbs_basedatalist"), (String)"4AT3/5NE9YB9");
        if (!permission) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u57fa\u7840\u8d44\u6599\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ManageListPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.deleteSurplus();
        BillList list = (BillList)hyperLinkClickEvent.getSource();
        Object pkId = list.getFocusRowPkId();
        this.showFormObject(pkId.toString(), false, false, "");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        Object backData = closedCallBackEvent.getReturnData();
        switch (key) {
            case "add_catalog_closecallback": {
                if (backData == null) break;
                String newID = backData instanceof List && !((List)backData).isEmpty() ? IDUtils.toString(((List)backData).get(0)) : String.valueOf(backData);
                this.initTree(newID);
                this.treeOnCommonClick(newID);
                break;
            }
            case "add_object_closecallback": {
                if (backData != null) {
                    String newID = backData instanceof List && !((List)backData).isEmpty() ? IDUtils.toString(((List)backData).get(0)) : String.valueOf(backData);
                    this.initTree(newID);
                    this.treeOnCommonClick(newID);
                    break;
                }
                this.initTree(this.getCurrentNodeId());
                this.treeOnCommonClick(this.getCurrentNodeId());
                break;
            }
            case "task_export_close_back": {
                DivisionBaseDataTaskResult divisionBaseDataTaskResult = ManageHelper.taskCallBack((Object)backData);
                if (divisionBaseDataTaskResult == null) {
                    return;
                }
                if (!divisionBaseDataTaskResult.getSuccess().booleanValue()) {
                    this.getView().showTipNotification(divisionBaseDataTaskResult.getMessage());
                    break;
                }
                String url = divisionBaseDataTaskResult.getResult().getUrl();
                String currentNodeId = this.getCurrentNodeId();
                TreeNode node = ManageTreeHelper.getSelectedNode((String)currentNodeId, (AbstractFormPlugin)this);
                Map dataMap = (Map)node.getData();
                if (StringUtils.isNotEmpty((CharSequence)url)) {
                    if (dataMap.size() > 0) {
                        OperationLogUtil.writeLog((String)this.getBizAppId(), (String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.EXPORT, (MultiLangEnumBridge)OperationMsgUtil.getExportSucWithNumber((String)((String)dataMap.get("dataset_number"))));
                    }
                    this.getClientViewProxy().addAction("download", (Object)url);
                    break;
                }
                if (dataMap.size() <= 0) break;
                OperationLogUtil.writeLog((String)this.getBizAppId(), (String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.EXPORT, (MultiLangEnumBridge)OperationMsgUtil.getExportFailWithNumber((String)((String)dataMap.get("dataset_number"))));
                break;
            }
            case "form_import_close": {
                this.refreshEntry(0, true);
                break;
            }
            case "epbs_basedataobject_copy": {
                if (backData == null) break;
                CopyFormResult copyFormResult = (CopyFormResult)SerializationUtils.fromJsonString((String)backData.toString(), CopyFormResult.class);
                Long newId = ManageCopyHepler.actionCopy((Object)copyFormResult.getSoucreId(), (Object)copyFormResult.getNewName(), (String)copyFormResult.getNewNumber(), (long)copyFormResult.getNewId());
                String caption = ResManager.loadKDString((String)"\u590d\u5236\u57fa\u7840\u8d44\u6599\u5b9e\u4f53", (String)"ManageListPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]);
                this.showFormObject(Long.toString(newId), false, true, caption);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (MessageBoxResult.Yes == evt.getResult()) {
            switch (evt.getCallBackId()) {
                case "delete_catalog": {
                    this.deleteCatalog(this.getCurrentNodeId());
                    break;
                }
                case "delete_object": {
                    this.deleteObject(this.getCurrentNodeId());
                    break;
                }
                case "callbackid_del_confirm": {
                    this.actionDeleteResult();
                    break;
                }
                case "callbackid_del_basicdata_confirm": {
                    this.actionDeleteBasicDataResult();
                    break;
                }
                case "callbackid_copyval": {
                    this.openCopyFormPage();
                    break;
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        DynamicObject dataEntity = changeData.getDataEntity();
        String propertyName = e.getProperty().getName();
        if (dataEntity != null && "entryentity".equals(name = dataEntity.getDataEntityType().getName())) {
            this.cacheEntryentityChangeData(changeData, propertyName);
        }
    }

    @Override
    public IClientViewProxy getClientViewProxy() {
        return (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
    }

    private void cacheEntryentityChangeData(ChangeData changeData, String propertyName) {
        DynamicObject dataEntity = changeData.getDataEntity();
        String oldValue = changeData.getOldValue() == null ? "" : changeData.getOldValue().toString();
        String newValue = changeData.getNewValue() == null ? "" : changeData.getNewValue().toString();
        ObjectMapper objectMapper = new ObjectMapper();
        if (!newValue.equals(oldValue)) {
            long id = dataEntity.getLong("id");
            long sourceid = dataEntity.getLong("sourceid");
            long catalogid = dataEntity.getLong("catalogid");
            if (id == 0L) {
                id = sourceid;
            }
            int rowIndex = changeData.getRowIndex();
            String changeStr = this.getPageCache().get("entryentity_change_cache");
            List<Object> list = new ArrayList();
            if (StringUtils.isNotEmpty((CharSequence)changeStr)) {
                List strList = (List)SerializationUtils.fromJsonString((String)changeStr, List.class);
                list = strList.stream().map(c -> (ModelEntryGridChange)objectMapper.convertValue(c, ModelEntryGridChange.class)).collect(Collectors.toList());
            }
            ManageHelper.setCacheEntryentityChangeData(list, (long)id, (String)newValue, (long)sourceid, (long)catalogid, (String)propertyName, (int)rowIndex);
            this.getPageCache().put("entryentity_change_cache", SerializationUtils.toJsonString(list));
        }
    }

    private void searchap(SearchEnterEvent evt) {
        String text = evt.getText().trim().toLowerCase();
        TreeNode root = ManageTreeHelper.getCacheLefTreeRoot((AbstractFormPlugin)this);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        this.leftSearch(treeView, root, text);
    }

    private void deleteCatalog(String nodeId) {
        TreeNode currentNode = ManageTreeHelper.getSelectedNode((String)nodeId, (AbstractFormPlugin)this);
        if (currentNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8282\u70b9\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"ManageListPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        String parentId = currentNode.getParentid();
        if (!"0".equals(parentId) && !"".equals(parentId)) {
            List childNodeIds = ManageTreeHelper.getNodeAllChildId((String)nodeId);
            if (!childNodeIds.isEmpty()) {
                QFBuilder qb = new QFBuilder("catalog", "in", (Object)childNodeIds);
                if (QueryServiceHelper.exists((String)"epbs_basedataobject", (QFilter[])qb.toArrays())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u6216\u4e0b\u7ea7\u5b50\u8282\u70b9\u5b58\u5728\u57fa\u7840\u8d44\u6599\u5b9e\u4f53\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"ManageListPlugin_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                qb = new QFBuilder("id", "in", (Object)childNodeIds);
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"epbs_basedatacatalog", (String)"number", (QFilter[])qb.toArrays());
                DeleteServiceHelper.delete((String)"epbs_basedatacatalog", (QFilter[])qb.toArrays());
                if (dynamicObjects != null && dynamicObjects.size() > 0) {
                    for (int i = 0; i < dynamicObjects.size(); ++i) {
                        DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
                        OperationLogUtil.writeLog((String)this.getBizAppId(), (String)"epbs_basedatacatalog", (IOperationTypeInfo)OperationTypeEnum.DELETE, (MultiLangEnumBridge)OperationMsgUtil.getDeleteSucWithNumber((String)dynamicObject.getString("number")));
                    }
                }
                this.initTree(null);
                this.refrush();
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u5220\u9664\u6839\u8282\u70b9\u3002", (String)"ManageListPlugin_10", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
    }

    private void deleteObject(String nodeId) {
        TreeNode currentNode = ManageTreeHelper.getSelectedNode((String)nodeId, (AbstractFormPlugin)this);
        if (currentNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8282\u70b9\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"ManageListPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        long id = Long.parseLong(currentNode.getId());
        QFBuilder qb = new QFBuilder("id", "=", (Object)id);
        DeleteServiceHelper.delete((String)"epbs_basedataobject", (QFilter[])qb.toArrays());
        this.refrush();
    }

    protected void treeOnClick(TreeView tree) {
        String nodeId = tree.getTreeState().getFocusNodeId();
        this.treeOnCommonClick(nodeId);
    }

    protected void treeOnCommonClick(String nodeId) {
        TreeNode treeNode;
        Map dataMap;
        String type;
        this.getPageCache().remove("entryentity_change_cache");
        this.getPageCache().remove("search_filter_cache");
        IFormView view = this.getView();
        view.setEnable(Boolean.TRUE, new String[]{"btnaddcatalog", "btnadd", "btnedit", "btndel"});
        if (nodeId != null && !"0".equals(nodeId) && !StringUtils.isEmpty((CharSequence)(type = (String)(dataMap = (Map)(treeNode = ManageTreeHelper.getSelectedNode((String)nodeId, (AbstractFormPlugin)this)).getData()).get("type")))) {
            if ("dataset".equals(type)) {
                this.setVisibleBasicDataObject(this.getObjectType((String)dataMap.get("id")));
                this.refreshEntry(0, true);
            } else {
                if ("catalog".equals(type)) {
                    view.setEnable(Boolean.TRUE, new String[]{"btnaddcatalog", "btnadd", "btnedit", "btndel", "baritemaddsub"});
                } else {
                    view.setEnable(Boolean.TRUE, new String[]{"btnaddcatalog"});
                    view.setEnable(Boolean.FALSE, new String[]{"btnadd", "btnedit", "baritemaddsub"});
                }
                view.setVisible(Boolean.FALSE, new String[]{"baritemsave", "barimport", "entryentity", "labeldown", "imageapdown", "labelup", "imageapup", "buttonpanel"});
                view.setVisible(Boolean.TRUE, new String[]{"btn_enable", "billlistap", "baritemdel", "barcopy", "baritemaddsub", "barupdate"});
                this.refreshBillList();
            }
        }
    }

    protected void refreshEntry(int pageRow, boolean flag) {
        TreeNode node;
        Map dataMap;
        String type;
        this.getPageCache().remove("entryentity_change_cache");
        String nodeId = this.getCurrentNodeId();
        if (nodeId != null && !StringUtils.isEmpty((CharSequence)(type = (String)(dataMap = (Map)(node = ManageTreeHelper.getSelectedNode((String)nodeId, (AbstractFormPlugin)this)).getData()).get("type"))) && "dataset".equals(type)) {
            this.loadEntryentity((String)dataMap.get("id"), (String)dataMap.get("parentid"), (String)dataMap.get("name"), pageRow, flag);
            String pagerowCacheStr = this.getPageCache().get("pagerow_cache");
            if (!StringUtils.isBlank((CharSequence)pagerowCacheStr)) {
                ManageEntryGridControl grid = (ManageEntryGridControl)this.getView().getControl("entryentity");
                grid.setPageRows(Integer.parseInt(pagerowCacheStr));
            }
        }
    }

    protected void loadEntryentity(String objectId, String catalogId, String name, int pageRow, boolean flag) {
        this.getPageCache().remove("entry_grid_model");
        ManageEntryGridControl grid = (ManageEntryGridControl)this.getView().getControl("entryentity");
        grid.setPlugin(this);
        ModelEntryGrid entryGridModel = this.createEntryGridModel(objectId, catalogId, grid, name);
        DynamicObject billObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        rows.clear();
        this.createDocumentBody(entryGridModel, grid, pageRow, flag);
    }

    private boolean createDocumentBody(ModelEntryGrid entryGridModel, ManageEntryGridControl grid, int pageRowData, boolean flag) {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        rows.clear();
        String entityName = entryGridModel.getEntityName();
        try {
            if (!StringUtils.isBlank((CharSequence)entityName)) {
                QueryServiceHelper.exists((String)entityName, null);
            }
        }
        catch (Throwable ex) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u201d%s\u201c\u5185\u5bb9\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ManageListPlugin_11", (String)"epm-epbs-formplugin", (Object[])new Object[0]), entityName));
            return false;
        }
        int pageRow = grid.getPageRow();
        int rowCount = ManageHelper.setTotal((ModelEntryGrid)entryGridModel);
        if (pageRowData != 0) {
            pageRow = pageRowData;
            this.getPageCache().remove("pagerow_cache");
            this.getPageCache().put("pagerow_cache", String.valueOf(pageRow));
        } else {
            String pagerowCacheStr = this.getPageCache().get("pagerow_cache");
            if (StringUtils.isBlank((CharSequence)pagerowCacheStr)) {
                this.getPageCache().put("pagerow_cache", String.valueOf(pageRow));
            } else {
                pageRow = Integer.parseInt(pagerowCacheStr);
                this.getPageCache().put("pagerow_cache", String.valueOf(pageRow));
            }
        }
        ManageHelper.createBasicData((ModelEntryGrid)entryGridModel, (DynamicObjectCollection)rows, (int)0, (int)pageRow, (AbstractListPlugin)this);
        billObj.getDataEntityState().setEntryRowCount("entryentity", rowCount);
        billObj.getDataEntityState().setEntryPageSize("entryentity", pageRow);
        billObj.getDataEntityState().setEntryStartRowIndex("entryentity", 0);
        if (flag) {
            this.getView().updateView();
        }
        return true;
    }

    private ModelEntryGrid createEntryGridModel(String objectId, String catalogId, ManageEntryGridControl grid, String name) {
        this.getPageCache().remove("filterrule_cache");
        String seletFileds = "id,name,type,valuesource,assistanttype,filterrule,strategy,orgfield,entryentity.sourcenumber,entryentity.zname,entryentity.znumber,entryentity.conversion,centryentity.id,centryentity.cnumber,centryentity.cnumber,centryentity.cname,centryentity.mustinput,centryentity.islocked,centryentity.isprimarykey";
        ModelEntryGrid entryGridModel = new ModelEntryGrid();
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"epbs_basedataobject", (String)seletFileds, (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(objectId)).toArray());
        if (dys == null || dys.length == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u57fa\u7840\u8d44\u6599\u5b9e\u4f53\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"ManageListPlugin_12", (String)"epm-epbs-formplugin", (Object[])new Object[0]), name));
        }
        entryGridModel.setObjectId(Long.valueOf(Long.parseLong(objectId)));
        entryGridModel.setName(name);
        for (DynamicObject dy : dys) {
            String type = dy.getString("type");
            if (BaseDataTypeEnum.DATABASE.getCode().equals(type) || BaseDataTypeEnum.ASSISTANTDATA.getCode().equals(type)) {
                this.createDatabaseGridModel(dy, grid, entryGridModel, type);
            } else if (!BaseDataTypeEnum.MODEL.getCode().equals(type) && BaseDataTypeEnum.CUSTOM.getCode().equals(type)) {
                List fieldEdits = grid.getFieldEdits().stream().filter(c -> c.getKey().startsWith("a")).collect(Collectors.toList());
                for (int i = 0; i < fieldEdits.size(); ++i) {
                    FieldEdit fieldEdit = (FieldEdit)fieldEdits.get(i);
                    fieldEdit.setVisible("a" + i, false);
                }
            }
            this.createCustomSelectFields(objectId, dy, grid, entryGridModel);
        }
        entryGridModel.setCatalogId(Long.valueOf(Long.parseLong(catalogId)));
        entryGridModel.setChangeCacheName("entryentity_change_cache");
        this.getPageCache().put("entry_grid_model", SerializationUtils.toJsonString((Object)entryGridModel));
        return entryGridModel;
    }

    private void createCustomSelectFields(String objectId, DynamicObject dy, ManageEntryGridControl grid, ModelEntryGrid entryGridModel) {
        ManageHelper.createCustomSelectFields((String)objectId, (DynamicObject)dy, (EntryGrid)grid, (ModelEntryGrid)entryGridModel);
        this.getView().updateView("entryentity");
    }

    private void createDatabaseGridModel(DynamicObject dy, ManageEntryGridControl grid, ModelEntryGrid entryGridModel, String type) {
        String entityName;
        String number = dy.getString("assistanttype.number");
        if (BaseDataTypeEnum.DATABASE.getCode().equals(type)) {
            entityName = dy.getString("valuesource.id");
        } else {
            entityName = "bos_assistantdata_detail";
            entryGridModel.setNumber(number);
        }
        entryGridModel.setEntityName(entityName);
        DynamicObjectCollection entryEntity = (DynamicObjectCollection)dy.get("entryentity");
        String selectFields = ManageHelper.getSelectFields((EntryGrid)grid, (DynamicObjectCollection)entryEntity, (ModelEntryGrid)entryGridModel);
        entryGridModel.setSelectFields(selectFields);
        String filterrule = dy.getString("filterrule");
        entryGridModel.setStrategy(dy.getString("strategy"));
        entryGridModel.setOrgfield(dy.getLong("orgfield.id"));
        this.getPageCache().put("filterrule_cache", filterrule);
        String searchFilterStr = this.getPageCache().get("search_filter_cache");
        ManageHelper.getFilterRule((ModelEntryGrid)entryGridModel, (String)filterrule, (String)searchFilterStr, (String)entityName, (String)number);
        entryGridModel.setConversionMap(ManageHelper.getConversionMapData((DynamicObjectCollection)entryEntity, (String)entityName));
    }

    private void setStatus(boolean status) {
        DynamicObject[] tempObjs = this.getSelectedTempDynaObjs(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"ManageListPlugin_13", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        if (tempObjs != null) {
            for (DynamicObject tempObj : tempObjs) {
                tempObj.set("enable", (Object)(status ? "1" : "2"));
            }
            SaveServiceHelper.save((DynamicObject[])tempObjs);
            if (status) {
                for (DynamicObject tempObj : tempObjs) {
                    OperationLogUtil.writeLog((String)this.getBizAppId(), (String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.ENABLE, (MultiLangEnumBridge)OperationMsgUtil.getEnableSucWithNumber((String)tempObj.getString("number")));
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"ManageListPlugin_16", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            } else {
                for (DynamicObject tempObj : tempObjs) {
                    OperationLogUtil.writeLog((String)this.getBizAppId(), (String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.DISABLE, (MultiLangEnumBridge)OperationMsgUtil.getDisableSucWithNumber((String)tempObj.getString("number")));
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"ManageListPlugin_19", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
            this.refreshBillList();
        }
    }

    public void refrush() {
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u5237\u65b0\u4e2d...", (String)"ManageListPlugin_46", (String)"epm-epbs-formplugin", (Object[])new Object[0])));
        try {
            this.deleteSurplus();
            String focusNodeId = this.getCurrentNodeId();
            this.initTree(focusNodeId);
            this.refreshBillList();
            this.refreshEntry(0, true);
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private void actionDelete() {
        TreeNode treeNode;
        Map dataMap;
        String type;
        String nodeId = this.getCurrentNodeId();
        if (!StringUtils.isBlank((CharSequence)nodeId) && !StringUtils.isEmpty((CharSequence)(type = (String)(dataMap = (Map)(treeNode = ManageTreeHelper.getSelectedNode((String)nodeId, (AbstractFormPlugin)this)).getData()).get("type")))) {
            if ("dataset".equals(type)) {
                ManageEntryGridControl grid = (ManageEntryGridControl)this.getView().getControl("entryentity");
                int[] selectRows = grid.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"ManageListPlugin_20", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%s\u6761\u8bb0\u5f55\u540e\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"ManageListPlugin_21", (String)"epm-epbs-formplugin", (Object[])new Object[0]), selectRows.length), MessageBoxOptions.YesNo, new ConfirmCallBackListener("callbackid_del_basicdata_confirm", (IFormPlugin)this));
            } else {
                BillList billList = (BillList)this.getView().getControl("billlistap");
                Object[] selectedIds = billList.getSelectedRows().getPrimaryKeyValues();
                if (selectedIds == null || selectedIds.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"ManageListPlugin_20", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%s\u6761\u8bb0\u5f55\u540e\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"ManageListPlugin_21", (String)"epm-epbs-formplugin", (Object[])new Object[0]), selectedIds.length), MessageBoxOptions.YesNo, new ConfirmCallBackListener("callbackid_del_confirm", (IFormPlugin)this));
            }
        }
    }

    private void actionDeleteBasicDataResult() {
        String nodeId;
        TreeNode node;
        Map dataMap;
        String msg = "";
        ManageEntryGridControl grid = (ManageEntryGridControl)this.getView().getControl("entryentity");
        int[] selectRows = grid.getSelectRows();
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)selectRows.length);
        for (int i = 0; i < selectRows.length; ++i) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", selectRows[i]);
            if (entryRowEntity == null) continue;
            ids.add(entryRowEntity.getLong("id"));
        }
        if (selectRows.length > 0) {
            this.getModel().deleteEntryRows("entryentity", selectRows);
        }
        if (ids.size() > 0) {
            TXUtils.required(txhandle -> {
                QFilter filter = new QFilter("id", "in", (Object)ids);
                DeleteServiceHelper.delete((String)"epbs_basedata", (QFilter[])filter.toArray());
            });
            msg = String.format(ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664%s\u6761\u6570\u636e\u3002", (String)"ManageListPlugin_22", (String)"epm-epbs-formplugin", (Object[])new Object[0]), ids.size());
            this.getView().showSuccessNotification(msg);
        }
        if ((dataMap = (Map)(node = ManageTreeHelper.getSelectedNode((String)(nodeId = this.getCurrentNodeId()), (AbstractFormPlugin)this)).getData()).size() > 0) {
            OperationLogUtil.writeLog((String)this.getBizAppId(), (String)"epbs_basedata", (IOperationTypeInfo)OperationTypeEnum.DELETE, (MultiLangEnumBridge)OperationMsgUtil.getDeleteSucWithNumber((String)((String)dataMap.get("dataset_number"))));
        }
        this.deleteSurplus();
        this.refreshEntry(0, true);
    }

    private void actionDeleteResult() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        Object[] ids = billList.getSelectedRows().getPrimaryKeyValues();
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"epbs_basedataobject", (String)"number", (QFilter[])new QFilter[]{qFilter});
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"epbs_basedataobject", (Object[])ids, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            if (dynamicObjects != null && dynamicObjects.size() > 0) {
                for (int i = 0; i < dynamicObjects.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
                    OperationLogUtil.writeLog((String)this.getBizAppId(), (String)"epbs_basedataobject", (IOperationTypeInfo)OperationTypeEnum.DELETE, (MultiLangEnumBridge)OperationMsgUtil.getDeleteSucWithNumber((String)dynamicObject.getString("number")));
                }
            }
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664%s\u6761\u6570\u636e\u3002", (String)"ManageListPlugin_22", (String)"epm-epbs-formplugin", (Object[])new Object[0]), ids.length));
        } else {
            ValidateResultCollection validateResult = operationResult.getValidateResult();
            List validateErrors = validateResult.getValidateErrors();
            if (validateErrors != null && validateErrors.size() > 0) {
                OperationLogUtil.writeLog((String)this.getBizAppId(), (String)"epbs_basedataobject", (IOperationTypeInfo)OperationTypeEnum.DELETE, (MultiLangEnumBridge)OperationMsgUtil.getFailStatus());
            }
            OperationResultUtil.showOperationResult((IFormView)this.getView(), (OperationResult)operationResult);
        }
        this.refrush();
    }

    @Override
    public String getObjectType(String id) {
        String type = "";
        QFilter nqFilter = new QFilter("id", "=", (Object)Long.parseLong(id));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epbs_basedataobject", (String)"type", (QFilter[])new QFilter[]{nqFilter});
        if (dynamicObject != null) {
            type = dynamicObject.getString("type");
        }
        return type;
    }

    @Override
    public void setVisibleBasicDataObject(String type) {
        if (BaseDataTypeEnum.CUSTOM.getCode().equals(type)) {
            this.deleteSurplus();
            this.getView().setVisible(Boolean.TRUE, new String[]{"baritemsave", "barimport", "entryentity", "buttonpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_enable", "billlistap", "barcopy", "labeldown", "imageapdown", "labelup", "imageapup", "baritemaddsub", "baritemdel"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"baritemaddsub"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"baritemsave", "barimport", "entryentity", "labeldown", "imageapdown"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"baritemaddsub", "baritemdel", "btn_enable", "billlistap", "barcopy", "labelup", "imageapup", "buttonpanel"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"barupdate"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"btnaddcatalog", "btnadd", "btnedit", "btndel"});
    }

    private void addDataByType() {
        String type;
        String nodeId = this.getCurrentNodeId();
        TreeNode currentNode = ManageTreeHelper.getSelectedNode((String)nodeId, (AbstractFormPlugin)this);
        Map dataMap = (Map)currentNode.getData();
        if (dataMap != null && dataMap.size() > 0 && !StringUtils.isEmpty((CharSequence)(type = (String)dataMap.get("type")))) {
            if ("catalog".equals(type)) {
                this.showFormObject(nodeId, true, false, "");
            } else {
                this.addBasicData();
            }
        }
    }

    private void addBasicData() {
        String nodeId = this.getCurrentNodeId();
        long[] longs = DBServiceHelper.genLongIds((String)"epbs_basedata", (int)1);
        DynamicObject dataSet = BusinessDataServiceHelper.newDynamicObject((String)"epbs_basedata");
        dataSet.set("id", (Object)longs[0]);
        if (nodeId != null) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
            int pageRow = entryGrid.getPageRow();
            DynamicObject billObj = this.getModel().getDataEntity(true);
            Integer entryRowCount = billObj.getDataEntityState().getEntryRowCount("entryentity");
            int remainder = entryRowCount % pageRow;
            int i = entryRowCount / pageRow;
            if (remainder != 0) {
                ++i;
            }
            int sourceSize = this.getModel().getEntryEntity("entryentity") == null ? 0 : this.getModel().getEntryEntity("entryentity").size();
            String changeStr = this.getPageCache().get("entryentity_change_cache");
            if (StringUtils.isNotEmpty((CharSequence)changeStr) && sourceSize * i + 1 > i * pageRow) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u53d1\u751f\u53d8\u5316,\u8bf7\u5148\u8fdb\u884c\u4fdd\u5b58\u3002", (String)"ManageListPlugin_24", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            if (sourceSize == pageRow && i == dynamicObjects.getPageIndex() && entryRowCount != i * pageRow) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5f53\u524d\u9875\u6570\u636e\u3002", (String)"ManageListPlugin_25", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            if (entryRowCount == i * pageRow) {
                ArrayList dataSets = Lists.newArrayListWithExpectedSize((int)1);
                TreeNode node = ManageTreeHelper.getSelectedNode((String)nodeId, (AbstractFormPlugin)this);
                Map dataMap = (Map)node.getData();
                dataSet.set("objectid", (Object)Long.parseLong((String)dataMap.get("id")));
                dataSet.set("catalogid", (Object)Long.parseLong((String)dataMap.get("parentid")));
                dataSet.set("type", (Object)"1");
                dataSet.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
                dataSet.set("createtime", (Object)TimeServiceHelper.now());
                dataSet.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
                dataSet.set("modifytime", (Object)TimeServiceHelper.now());
                dataSets.add(dataSet);
                SaveServiceHelper.save((DynamicObject[])dataSets.toArray(new DynamicObject[0]));
                this.refreshEntry(pageRow, false);
                entryGrid.setPageIndex(i + 1);
            } else {
                if (sourceSize == pageRow) {
                    entryGrid.setPageIndex(i);
                    sourceSize = entryRowCount % pageRow;
                }
                this.getModel().batchCreateNewEntryRow("entryentity", 1);
                dynamicObjects = this.getModel().getEntryEntity("entryentity");
                DynamicObject entry = (DynamicObject)dynamicObjects.get(sourceSize);
                TreeNode node = ManageTreeHelper.getSelectedNode((String)nodeId, (AbstractFormPlugin)this);
                Map dataMap = (Map)node.getData();
                entry.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                entry.set("objectid", (Object)Long.parseLong((String)dataMap.get("id")));
                entry.set("catalogid", (Object)Long.parseLong((String)dataMap.get("parentid")));
            }
        }
    }

    private void saveBasicData() {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        List insertRows = rows.getInsertRows();
        if (insertRows == null || insertRows.size() == 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u65e0\u53d8\u5316\u3002", (String)"ManageListPlugin_26", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        ModelCustomSelectField customSelectFieldModel = this.getCustomSelectFieldModel();
        if (customSelectFieldModel != null) {
            List showField = customSelectFieldModel.getShowField();
            List actualField = customSelectFieldModel.getActualField();
            if (CollectionUtils.isNotEmpty((Collection)showField) && CollectionUtils.isNotEmpty((Collection)actualField) && showField.size() == actualField.size()) {
                ArrayList dataSets = Lists.newArrayListWithExpectedSize((int)insertRows.size());
                boolean saveBasicData = this.getSaveBasicData(insertRows, showField, actualField, dataSets);
                if (!saveBasicData) {
                    return;
                }
                SaveServiceHelper.save((DynamicObject[])dataSets.toArray(new DynamicObject[0]));
                this.getPageCache().remove("entryentity_change_cache");
                this.deleteSurplus();
                String nodeId = this.getCurrentNodeId();
                TreeNode node = ManageTreeHelper.getSelectedNode((String)nodeId, (AbstractFormPlugin)this);
                Map dataMap = (Map)node.getData();
                if (dataSets.size() > 0) {
                    if (dataMap.size() > 0) {
                        OperationLogUtil.writeLog((String)this.getBizAppId(), (String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.SAVE, (MultiLangEnumBridge)OperationMsgUtil.getSaveSucTipWithNumber((String)((String)dataMap.get("dataset_number"))));
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ManageListPlugin_29", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u65e0\u53d8\u5316\u3002", (String)"ManageListPlugin_26", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                }
                this.refreshEntry(0, true);
            } else {
                OperationLogUtil.writeLog((String)this.getBizAppId(), (String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.SAVE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u65b0\u589e\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5c55\u793a\u5b57\u6bb5%1$s\uff0c\u5b9e\u9645\u5b57\u6bb5%2$s\u3002", "ManageListPlugin_30", "epm-epbs-formplugin", new Object[]{showField, actualField}));
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"ManageListPlugin_31", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean getSaveBasicData(List<DynamicObject> rows, List showField, List actualField, List<DynamicObject> dataSets) {
        if (rows == null || rows.size() == 0) {
            return false;
        }
        boolean flag = this.checkBasicData(rows, showField, actualField);
        if (flag) {
            String changeStr = this.getPageCache().get("entryentity_change_cache");
            ManageHelper.createSaveBasicData((String)changeStr, rows, (List)showField, (List)actualField, dataSets);
        }
        return flag;
    }

    private boolean checkBasicData(List<DynamicObject> update, List showField, List actualField) {
        boolean flag = true;
        ModelEntryGrid entryGridModel = this.getEntryGridModel();
        List mustinputList = entryGridModel.getMustinputList();
        String customSelectFields = entryGridModel.getCustomSelectFields();
        List isprimarykeyList = entryGridModel.getIsprimarykeyList();
        if (StringUtils.isBlank((CharSequence)customSelectFields)) {
            return true;
        }
        HashSet pkSet = Sets.newHashSetWithExpectedSize((int)update.size());
        String[] split = customSelectFields.split(",");
        for (int i = 0; i < update.size(); ++i) {
            DynamicObject dynamicObject = update.get(i);
            for (int s = 0; s < split.length; ++s) {
                String field = "b" + s;
                String fieldData = dynamicObject.getString(field);
                String type = dynamicObject.getString("type");
                if (mustinputList.contains(field) && StringUtils.isBlank((CharSequence)fieldData)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"ManageListPlugin_32", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (!isprimarykeyList.contains(field)) continue;
                if (!pkSet.add(fieldData)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e3b\u952e\u5b57\u6bb5\u503c\"%s\"\u4e0d\u80fd\u91cd\u590d\u3002", (String)"ManageListPlugin_33", (String)"epm-epbs-formplugin", (Object[])new Object[0]), fieldData));
                    return false;
                }
                String selectFiles = (String)actualField.get(showField.indexOf(field));
                if (!StringUtils.isNotEmpty((CharSequence)selectFiles) || !"1".equals(type)) continue;
                QFilter filter = new QFilter(selectFiles, "=", (Object)String.valueOf(fieldData));
                filter.and(new QFilter("objectid", "=", (Object)dynamicObject.getLong("objectid")));
                boolean existRepeatNumber = QueryServiceHelper.exists((String)"epbs_basedata", (QFilter[])new QFilter[]{filter});
                if (!existRepeatNumber) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e3b\u952e\u5b57\u6bb5\u503c\"%s\"\u4e0d\u80fd\u91cd\u590d\u3002", (String)"ManageListPlugin_33", (String)"epm-epbs-formplugin", (Object[])new Object[0]), fieldData));
                return false;
            }
        }
        return flag;
    }

    private ModelCustomSelectField getCustomSelectFieldModel() {
        ModelCustomSelectField customSelectFieldModel = new ModelCustomSelectField();
        String nodeId = this.getCurrentNodeId();
        if (nodeId != null) {
            TreeNode node = ManageTreeHelper.getSelectedNode((String)nodeId, (AbstractFormPlugin)this);
            Map dataMap = (Map)node.getData();
            String objectId = (String)dataMap.get("id");
            String name = (String)dataMap.get("name");
            customSelectFieldModel = ManageHelper.getCustomSelectFieldModel((String)objectId, (String)name);
        }
        return customSelectFieldModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportData() {
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u5bfc\u51fa\u4e2d...", (String)"ManageListPlugin_34", (String)"epm-epbs-formplugin", (Object[])new Object[0])));
        try {
            TreeNode node;
            Map dataMap;
            String type;
            String nodeId = this.getCurrentNodeId();
            if (nodeId != null && !StringUtils.isEmpty((CharSequence)(type = (String)(dataMap = (Map)(node = ManageTreeHelper.getSelectedNode((String)nodeId, (AbstractFormPlugin)this)).getData()).get("type")))) {
                if ("dataset".equals(type)) {
                    this.handleDysData();
                } else {
                    this.exportDataObject(nodeId);
                }
            }
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private void exportDataObject(String nodeId) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        QFilter qFilter = this.getQFilter(nodeId);
        if (selectedRows.size() > 0) {
            Set collect = selectedRows.stream().map(c -> c.getPrimaryKeyValue()).collect(Collectors.toSet());
            qFilter.and(new QFilter("id", "in", collect));
        }
        List listFields = billList.getListFields();
        ArrayList headerList = Lists.newArrayListWithExpectedSize((int)listFields.size());
        ArrayList showHeadList = Lists.newArrayListWithExpectedSize((int)listFields.size());
        HashMap conversionMap = new HashMap();
        EntityMetadata metadata = new EntityMetadata("epbs_basedataobject");
        listFields.stream().forEach(c -> {
            String fieldName = c.getFieldName();
            HashMap map = ManageHelper.createConversionMap((String)fieldName, (EntityMetadata)metadata);
            if (map != null && map.size() > 0) {
                conversionMap.put(fieldName, map);
            }
            headerList.add(fieldName);
            if ("valuesource.name".equals(fieldName)) {
                showHeadList.add(ResManager.loadKDString((String)"\u6e90\u5bf9\u8c61\u540d\u79f0", (String)"ManageListPlugin_35", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            } else if ("valuesource.number".equals(fieldName)) {
                showHeadList.add(ResManager.loadKDString((String)"\u6e90\u5bf9\u8c61\u7f16\u7801", (String)"ManageListPlugin_36", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            } else {
                LocaleString displayName = c.getSrcFieldProp().getDisplayName();
                showHeadList.add(displayName.getLocaleValue());
            }
        });
        String selectField = String.join((CharSequence)",", headerList);
        DynamicObjectCollection exportData = QueryServiceHelper.query((String)"epbs_basedataobject", (String)selectField, (QFilter[])qFilter.toArray(), (String)"number");
        String time = DateTimeUtils.format((Date)TimeServiceHelper.now(), (String)"MMddhhmmss");
        String fileName = String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5b9e\u4f53_%s", (String)"ManageListPlugin_37", (String)"epm-epbs-formplugin", (Object[])new Object[0]), time);
        String url = ManageImportHelper.handleExportData((DynamicObjectCollection)exportData, (List)headerList, (List)showHeadList, Arrays.asList(columnWidths), conversionMap, (String)fileName);
        TreeNode node = ManageTreeHelper.getSelectedNode((String)nodeId, (AbstractFormPlugin)this);
        Map dataMap = (Map)node.getData();
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            if (dataMap.size() > 0) {
                OperationLogUtil.writeLog((String)this.getBizAppId(), (String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.EXPORT, (MultiLangEnumBridge)OperationMsgUtil.getExportSucWithNumber((String)((String)dataMap.get("dataset_number"))));
            }
            this.getClientViewProxy().addAction("download", (Object)url);
        } else if (dataMap.size() > 0) {
            OperationLogUtil.writeLog((String)this.getBizAppId(), (String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.EXPORT, (MultiLangEnumBridge)OperationMsgUtil.getExportFailWithNumber((String)((String)dataMap.get("dataset_number"))));
        }
    }

    public void handleDysData() {
        ModelEntryGrid entryGridModel = this.getEntryGridModel();
        String entityName = entryGridModel.getEntityName();
        QFilter filter = null;
        if (!StringUtils.isBlank((CharSequence)entryGridModel.getFilterStr())) {
            filter = QFilter.fromSerializedString((String)entryGridModel.getFilterStr());
        }
        ManageEntryGridControl grid = (ManageEntryGridControl)this.getView().getControl("entryentity");
        int[] selectRows = grid.getSelectRows();
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)selectRows.length);
        if (selectRows.length > 0) {
            for (int i = 0; i < selectRows.length; ++i) {
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", selectRows[i]);
                if (!StringUtils.isBlank((CharSequence)entityName)) {
                    ids.add(entryRowEntity.getLong("sourceid"));
                    continue;
                }
                ids.add(entryRowEntity.getLong("id"));
            }
            if (ids.size() > 0) {
                QFilter idFilter = new QFilter("id", "in", (Object)ids);
                if (filter == null) {
                    filter = idFilter;
                } else {
                    filter.and(idFilter);
                }
            }
        }
        entryGridModel.setFilterStr(filter == null ? "" : filter.toSerializedString());
        String currentNodeId = this.getCurrentNodeId();
        TreeNode currentNode = ManageTreeHelper.getSelectedNode((String)currentNodeId, (AbstractFormPlugin)this);
        Map dataMap = (Map)currentNode.getData();
        String name = (String)dataMap.get("name");
        String time = DateTimeUtils.format((Date)TimeServiceHelper.now(), (String)"MMddhhmmss");
        String fileName = String.format(ResManager.loadKDString((String)"%1$s\u57fa\u7840\u8d44\u6599_%2$s", (String)"ManageListPlugin_38", (String)"epm-epbs-formplugin", (Object[])new Object[0]), name, time);
        DivisionBaseDataInput divisionBaseDataInput = new DivisionBaseDataInput();
        divisionBaseDataInput.setId(currentNodeId);
        divisionBaseDataInput.setFileName(fileName);
        divisionBaseDataInput.setType("export");
        divisionBaseDataInput.setModelEntryGrid(entryGridModel);
        DivisionBaseDataTaskInput input = new DivisionBaseDataTaskInput();
        input.setInput(divisionBaseDataInput);
        String jobName = ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5bfc\u51fa\u8fdb\u5ea6", (String)"ManageListPlugin_39", (String)"epm-epbs-formplugin", (Object[])new Object[0]);
        String className = "kd.epm.epbs.business.bd.manage.task.BaseDataDivisionTask";
        ManageHelper.handleDysData((IFormPlugin)this, (IFormView)this.getView(), (String)JSON.toJSONString((Object)input), (String)className, (String)jobName, (String)"task_export_close_back");
    }

    public void openBaseDataImport() {
        ModelEntryGrid entryGridModel = this.getEntryGridModel();
        String nodeId = this.getCurrentNodeId();
        if (nodeId != null) {
            TreeNode node = ManageTreeHelper.getSelectedNode((String)nodeId, (AbstractFormPlugin)this);
            Map dataMap = (Map)node.getData();
            String number = (String)dataMap.get("dataset_number");
            entryGridModel.setNumber(number);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epbs_basedataimport");
        showParameter.setCustomParam("entryGridModel", (Object)SerializationUtils.toJsonString((Object)entryGridModel));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "form_import_close");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void actionCopy() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        Object[] selectedIds = billList.getSelectedRows().getPrimaryKeyValues();
        if (selectedIds == null || selectedIds.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8981\u590d\u5236\u7684\u6570\u636e\u3002", (String)"ManageListPlugin_40", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billList.getSelectedRows().get(0).getPrimaryKeyValue(), (String)"epbs_basedataobject");
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"ManageListPlugin_41", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        String newNumber = dynamicObject.getString("number").concat("_copy");
        String newName = dynamicObject.getString("name").concat("_copy");
        QFilter qf = new QFilter("number", "=", (Object)newNumber);
        if (newNumber.length() > 50 || newName.length() > 50) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u590d\u5236\u751f\u6210\u7684\u53d8\u91cf\u7f16\u7801\u6216\u540d\u79f0\u8d85\u8fc7\u5236\u5b9a\u957f\u5ea6\u65e0\u6cd5\u4fdd\u5b58\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ManageListPlugin_42", (String)"epm-epbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("callbackid_copyval", (IFormPlugin)this));
        } else if (QueryServiceHelper.exists((String)"epbs_basedataobject", (QFilter[])qf.toArray())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u590d\u5236\u751f\u6210\u7684\u53d8\u91cf\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ManageListPlugin_43", (String)"epm-epbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("callbackid_copyval", (IFormPlugin)this));
        } else {
            Long newId = ManageCopyHepler.actionCopy((Object)selectedIds[0], (Object)"", (String)"", (long)GlobalIdUtil.genGlobalLongId());
            String caption = ResManager.loadKDString((String)"\u590d\u5236\u57fa\u7840\u8d44\u6599\u5b9e\u4f53", (String)"ManageListPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]);
            this.showFormObject(Long.toString(newId), false, true, caption);
        }
    }

    private void openCopyFormPage() {
        BillList billList = (BillList)this.getControl("billlistap");
        if (billList.getSelectedRows() == null || billList.getSelectedRows().size() != 1) {
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billList.getSelectedRows().get(0).getPrimaryKeyValue(), (String)"epbs_basedataobject");
        if (dynamicObject == null) {
            return;
        }
        Long oldValId = dynamicObject.getLong("id");
        String title = ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5b9e\u4f53\u590d\u5236", (String)"ManageListPlugin_44", (String)"epm-epbs-formplugin", (Object[])new Object[0]);
        ManageCopyHepler.openWindow((IFormView)this.getView(), (IFormPlugin)this, (Long)oldValId, (String)title);
    }

    public void searchData(boolean flag) {
        this.getPageCache().remove("search_filter_cache");
        QFilter qfilter = this.getFlexQfilter();
        if (qfilter != null) {
            this.getPageCache().put("search_filter_cache", qfilter.toSerializedString());
        }
        if (flag) {
            this.setFilterflexpanelapVisible("barup");
        }
        this.refreshEntry(0, true);
    }

    private void clearFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        filterGrid.SetValue(new FilterCondition());
    }

    public void initTree(String newId) {
        this.clearFilter();
        ManageTreeHelper dataSetobj = new ManageTreeHelper();
        dataSetobj.setCache_focusnodeid("focusnodeid");
        dataSetobj.setCache_headnodeid("headnodeid");
        dataSetobj.setTreeViewctrlName("treeviewap");
        dataSetobj.initTree(newId, (AbstractFormPlugin)this);
    }

    public void updateData() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        Object[] selectedIds = billList.getSelectedRows().getPrimaryKeyValues();
        if (selectedIds == null || selectedIds.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"ManageListPlugin_45", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showFormObject(selectedIds[0] + "", false, false, "");
    }
}

