/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.bd.manage;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.GetFilterFieldsParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.flex.FlexBDValueCondition;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.bd.manage.EntityMetadata;
import kd.epm.epbs.business.bd.manage.ManageHelper;
import kd.epm.epbs.business.bd.manage.ModelEntryGrid;
import kd.epm.epbs.common.enums.BaseDataTypeEnum;
import kd.epm.epbs.common.util.NumberRuleUtils;
import kd.epm.epbs.common.util.QFBuilder;
import kd.epm.epbs.formplugin.bd.manage.ManagePreEntryGridControl;
import kd.epm.epbs.formplugin.bd.manage.ManageRefPropsPlugin;
import org.apache.commons.collections.CollectionUtils;

public class ManageObjectPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(ManageObjectPlugin.class);
    private static final String TOOLBARAP = "toolbarap";
    private static final String ASSISTANTTYPE = "assistanttype";
    private static final String CATALOG = "catalog";
    private static final String VALUESOURCE = "valuesource";
    private static final String STRATEGY = "strategy";
    private static final String ADVCONTOOLBARAP = "advcontoolbarap";
    private static final String CADVCONTOOLBARAP = "cadvcontoolbarap";
    private static final String ENTRYENTITY = "entryentity";
    private static final String TYPE = "type";
    private static final String ZNUMBER = "znumber";
    private static final String ZNAME = "zname";
    private static final String CNUMBER = "cnumber";
    private static final String CNAME = "cname";
    private static final String SOURCE = "source";
    private static final String SOURCEFIELD = "sourcefield";
    private static final String PROPERTYEDIT = "propertyEdit";
    private static final String TABAP = "tabap";
    private static final String FIELDTAG = "fieldtag";
    private static final String FILTERTAG = "filtertag";
    private static final String PREVIEWTAG = "previewtag";
    private static final String EDIT = "edit";
    private static final String MOVEUP = "moveup";
    private static final String MOVEDOWN = "movedown";
    private static final String PENTRYENTITY = "pentryentity";
    private static final String FILTERGRIDAP = "filtergridap";
    private static final String FILTERRULE = "filterrule";
    private static final String HYPERLINKAP = "hyperlinkap";
    private static final String SOURCENUMBER = "sourcenumber";
    private static final String HYPERLINKAPFLEX = "hyperlinkapflex";
    private static final String ENTRYENTITY_MAP_CACHE = "entryentity_map_cache";
    private static final String ENTRYGRIDMODEL = "entry_grid_model";
    private static final String FIELD_FILTER_CACHE = "field_filter_cache";
    private static final String FLAG_CACHE = "flag_cache";
    private static final String CENTRYENTITY = "centryentity";
    private static final String CHECKFLEXPANELAP = "checkflexpanelap";
    private static final String OBJECT_CLOSE_CACHE = "object_close_cache";
    private static final String BAR_CLOSE = "bar_close";
    private static final String PAGEROW_CACHE = "pagerow_cache";
    private static final String ISPRIMARYKEY = "isprimarykey";
    private static final String PRIMARYKEY_CACHE = "primarykey_cache";
    private static final String ISPRIMARYKEY_CACHE = "isprimarykey_cache";
    private static final String ADDCUSTOM = "addcustom";
    private static final String DELCUSTOM = "delcustom";
    private static final String CALLBACKID_DELETE_CONFIRM = "callbackid_delete_confirm";
    private static final String CONVERSION = "conversion";
    private static final String DELCUSTOM_CACHE = "delCustom_cache";
    private static final String ISSAVE_CACHE = "issave_cache";
    private static final String SETTYPE_CACHE = "settype_cache";
    private static final String SETSOURCE_CACHE = "setsource_cache";
    private static final String CATALOG_CACHE = "catalog_cache";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{PENTRYENTITY});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARAP});
        BasedataEdit fieldDimensionsourceEdit = (BasedataEdit)this.getView().getControl(VALUESOURCE);
        fieldDimensionsourceEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{ADVCONTOOLBARAP, CADVCONTOOLBARAP});
        this.addClickListeners(new String[]{HYPERLINKAP});
        Tab tab = (Tab)this.getControl(TABAP);
        tab.addTabSelectListener(evt -> {
            String key = evt.getTabKey();
            if (FIELDTAG.equalsIgnoreCase(key)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{EDIT, MOVEUP, MOVEDOWN});
            } else if (FILTERTAG.equalsIgnoreCase(key)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{EDIT, MOVEUP, MOVEDOWN});
            } else if (PREVIEWTAG.equalsIgnoreCase(key)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{EDIT, MOVEUP, MOVEDOWN});
                this.previewtagEvent();
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Object catalog = map.get(CATALOG);
        if (!StringUtils.isBlank(catalog)) {
            this.getModel().setValue(CATALOG, catalog);
            this.getPageCache().put(CATALOG_CACHE, catalog.toString());
        }
        FieldEdit edit = (FieldEdit)this.getControl(VALUESOURCE);
        edit.setMustInput(true);
        FieldEdit edit2 = (FieldEdit)this.getControl(ASSISTANTTYPE);
        edit2.setMustInput(false);
        this.getView().setVisible(Boolean.FALSE, new String[]{PENTRYENTITY, FILTERGRIDAP});
        this.lockCtrls();
        this.setIsPrimaryKeyVisible(false);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String customVaule = evt.getCustomVaule();
        List<Object> returnList = new ArrayList();
        if (!StringUtils.isBlank((CharSequence)customVaule)) {
            returnList = Arrays.asList(customVaule.split(","));
        }
        if (MessageBoxResult.Yes == evt.getResult()) {
            switch (evt.getCallBackId()) {
                case "callbackid_delete_confirm": {
                    this.delete();
                    break;
                }
                case "type_load": {
                    this.getPageCache().remove(SETTYPE_CACHE);
                    if (returnList == null || returnList.size() != 3) break;
                    Object newValue = "".equals(returnList.get(2)) ? null : returnList.get(2);
                    this.basicDataTypeChange(newValue);
                    break;
                }
                case "source_load": {
                    this.getPageCache().remove(SETSOURCE_CACHE);
                    if (returnList == null || returnList.size() != 3) break;
                    Object newValue = "".equals(returnList.get(2)) ? null : returnList.get(2);
                    this.basicDataSourceChanged(newValue == null ? "" : newValue.toString());
                }
            }
        } else {
            switch (evt.getCallBackId()) {
                case "type_load": {
                    if (returnList == null || returnList.size() < 2) break;
                    this.getPageCache().put(SETTYPE_CACHE, "1");
                    this.getView().getModel().setValue(returnList.get(0).toString(), "".equals(returnList.get(1)) ? null : returnList.get(1));
                    break;
                }
                case "source_load": {
                    if (returnList == null || returnList.size() < 2) break;
                    this.getPageCache().put(SETSOURCE_CACHE, "1");
                    this.getView().getModel().setValue(returnList.get(0).toString(), "".equals(returnList.get(1)) ? null : returnList.get(1));
                    break;
                }
            }
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        if (StringUtils.equals((CharSequence)e.getKey(), (CharSequence)PENTRYENTITY)) {
            ManagePreEntryGridControl entryGrid = new ManagePreEntryGridControl();
            entryGrid.setView(this.getView());
            entryGrid.setKey(PENTRYENTITY);
            entryGrid.setEntryKey(PENTRYENTITY);
            String entryGridModelStr = this.getPageCache().get(ENTRYGRIDMODEL);
            ModelEntryGrid entryGridModel = new ModelEntryGrid();
            if (StringUtils.isNotEmpty((CharSequence)entryGridModelStr)) {
                JSONObject jsonObject = JSONObject.parseObject((String)entryGridModelStr);
                jsonObject.remove((Object)"filters");
                entryGridModel = (ModelEntryGrid)SerializationUtils.fromJsonString((String)jsonObject.toJSONString(), ModelEntryGrid.class);
                entryGridModel.setFilterStr(this.getFilters());
            }
            entryGrid.entryGridModel = entryGridModel;
            Control oldGrid = e.getControl();
            if (oldGrid == null) {
                oldGrid = ManageHelper.findControl((String)PENTRYENTITY, (AbstractFormPlugin)this);
            }
            if (oldGrid instanceof EntryGrid) {
                entryGrid.getItems().addAll(((EntryGrid)oldGrid).getItems());
            }
            e.setControl((Control)entryGrid);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        DynamicObjectCollection mzs = this.getModel().getEntryEntity(ENTRYENTITY);
        switch (propertyName) {
            case "type": {
                String returnData = String.join((CharSequence)",", Arrays.asList(propertyName, oldValue == null ? "" : oldValue.toString(), newValue == null ? "" : newValue.toString()));
                String setTypeCacheStr = this.getPageCache().get(SETTYPE_CACHE);
                if (StringUtils.isBlank((CharSequence)setTypeCacheStr)) {
                    if (mzs.size() > 0) {
                        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("type_load", (IFormPlugin)this);
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u7c7b\u578b\u65f6\u9009\u5165\u5b57\u6bb5\u5c06\u4f1a\u88ab\u8986\u76d6\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"ManageObjectPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks, (Map)null, returnData);
                    } else {
                        this.basicDataTypeChange(newValue);
                    }
                }
                this.getPageCache().remove(SETTYPE_CACHE);
                break;
            }
            case "valuesource": 
            case "assistanttype": {
                DynamicObject dynamicObject = (DynamicObject)newValue;
                String newData = dynamicObject == null ? "" : (String)dynamicObject.getPkValue();
                DynamicObject oldDynamicObject = (DynamicObject)oldValue;
                String oldData = oldDynamicObject == null ? "" : (String)oldDynamicObject.getPkValue();
                String sourceReturnData = String.join((CharSequence)",", Arrays.asList(propertyName, oldData, newData));
                String setSourceCacheStr = this.getPageCache().get(SETSOURCE_CACHE);
                if (StringUtils.isBlank((CharSequence)setSourceCacheStr)) {
                    if (mzs.size() > 0 && !"".equals(newData)) {
                        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("source_load", (IFormPlugin)this);
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u503c\u6765\u6e90\u65f6\u9009\u5165\u5b57\u6bb5\u5c06\u4f1a\u88ab\u8986\u76d6\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"ManageObjectPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks, (Map)null, sourceReturnData);
                    } else {
                        this.basicDataSourceChanged(newData);
                    }
                }
                this.getPageCache().remove(SETSOURCE_CACHE);
                break;
            }
            case "isprimarykey": {
                this.changeOtherIsprimarykey(e.getChangeSet()[0]);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryEntity;
        super.beforeDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        if ("save".equals(opType)) {
            boolean b;
            IDataModel dataModel = this.getModel();
            String number = (String)dataModel.getValue("number");
            if (!NumberRuleUtils.checkNumberV2((String)number)) {
                this.getView().showTipNotification(NumberRuleUtils.getMessageV2());
                args.setCancel(true);
                return;
            }
            QFilter filter = new QFilter("number", "=", (Object)String.valueOf(number));
            boolean existRepeatNumber = QueryServiceHelper.exists((String)"epbs_basedataobject", (QFilter[])new QFilter[]{filter});
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (status.equals((Object)OperationStatus.ADDNEW) && existRepeatNumber) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201d%s\u201c\u7f16\u7801\u91cd\u590d\u3002", (String)"ManageObjectPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]), number));
                args.setCancel(true);
                return;
            }
            String type = (String)this.getModel().getValue(TYPE);
            if (BaseDataTypeEnum.DATABASE.getCode().equals(type) || BaseDataTypeEnum.ASSISTANTDATA.getCode().equals(type)) {
                b = this.preSaveEntityCheck(type);
                if (!b) {
                    args.setCancel(true);
                    return;
                }
                this.preSaveFilterCheck();
                String entryName = (String)this.getModel().getValue("valuesource_id");
                try {
                    QueryServiceHelper.exists((String)entryName, null);
                }
                catch (Throwable ex) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u201d%s\u201c\u5185\u5bb9\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ManageObjectPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]), entryName));
                    args.setCancel(true);
                    return;
                }
            }
            if (!(b = this.preSaveDatabase(CENTRYENTITY, type))) {
                args.setCancel(true);
                return;
            }
            if (status.equals((Object)OperationStatus.ADDNEW)) {
                this.getView().getModel().setValue("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
                this.getView().getModel().setValue("createtime", (Object)TimeServiceHelper.now());
                this.getView().getModel().setValue("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
                this.getView().getModel().setValue("modifytime", (Object)TimeServiceHelper.now());
            } else {
                this.getView().getModel().setValue("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
                this.getView().getModel().setValue("modifytime", (Object)TimeServiceHelper.now());
            }
            this.getView().getModel().setValue("mtype", (Object)"1");
            String catalogStr = this.getPageCache().get(CATALOG_CACHE);
            if (!StringUtils.isBlank((CharSequence)catalogStr)) {
                this.getView().getModel().setValue(CATALOG, (Object)Long.parseLong(catalogStr));
            }
        } else if (args.getSource() instanceof NewEntry && (entryEntity = this.getModel().getEntryEntity(CENTRYENTITY)).size() >= 30) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5b57\u6bb5\u4e0d\u80fd\u5927\u4e8e30,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ManageObjectPlugin_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        this.getPageCache().put(ISSAVE_CACHE, "T");
        if (e.getSource() instanceof Save && e.getOperationResult().getValidateResult().isSuccess()) {
            List ids = e.getOperationResult().getSuccessPkIds();
            this.getPageCache().put(OBJECT_CLOSE_CACHE, SerializationUtils.toJsonString((Object)ids));
            this.getView().returnDataToParent((Object)ids);
            this.maintainRelationships(ids);
            this.setCtrlPreview(true);
            DynamicObject billObj = this.getModel().getDataEntity(true);
            DynamicObjectCollection rows = billObj.getDynamicObjectCollection(PENTRYENTITY);
            rows.clear();
        }
        if (e.getSource() instanceof SaveAndNew && e.getOperationResult().getValidateResult().isSuccess()) {
            String catalogStr = this.getPageCache().get(CATALOG_CACHE);
            if (!StringUtils.isBlank((CharSequence)catalogStr)) {
                this.getView().getModel().setValue(CATALOG, (Object)Long.parseLong(catalogStr));
            }
            this.unlockCtrls();
            this.getPageCache().remove(ENTRYGRIDMODEL);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setCtrlMustInput();
        String type = (String)this.getModel().getValue(TYPE);
        this.setDisplay(type);
        this.setFiltergridap();
        this.getModel().setDataChanged(false);
    }

    public void afterLoadData(EventObject e) {
        Map map;
        Object isCopy;
        super.afterLoadData(e);
        Object catalog = this.getModel().getValue("catalog_id");
        if (!ObjectUtils.isEmpty((Object)catalog)) {
            this.getPageCache().put(CATALOG_CACHE, catalog.toString());
        }
        if (Objects.equals(isCopy = (map = this.getView().getFormShowParameter().getCustomParams()).get("isCopy"), false)) {
            this.lockCtrls();
        } else {
            this.unlockCtrls();
        }
        String code = (String)this.getModel().getValue(TYPE);
        if (BaseDataTypeEnum.CUSTOM.eqScene((Object)code)) {
            this.setIsPrimaryKeyLock();
            this.setIsPrimaryKeyVisible(true);
        } else {
            this.setIsPrimaryKeyVisible(false);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String operationKy = evt.getItemKey();
        String code = (String)this.getModel().getValue(TYPE);
        if (EDIT.equals(operationKy)) {
            this.edit(code);
        } else if (BAR_CLOSE.equals(operationKy)) {
            this.barClose();
        } else if (ADDCUSTOM.equals(operationKy)) {
            this.addCustom();
        } else if (DELCUSTOM.equals(operationKy)) {
            this.delCustom();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (HYPERLINKAP.equals(key)) {
            this.hyperlinkapClick();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (PROPERTYEDIT.equalsIgnoreCase(e.getActionId()) && e.getReturnData() != null) {
            Map returnData = (Map)e.getReturnData();
            List refProps = (List)returnData.get("RefProps");
            this.resetEntryEntity(this.getSourceNumber(), refProps);
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeBindData(EventObject e) {
        this.createFilterGrid();
        super.beforeBindData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        if (key.equals(VALUESOURCE)) {
            beforeF7SelectEvent.addCustomQFilter(new QFilter("modeltype", "=", (Object)"BaseFormModel"));
        }
    }

    private void setDisplay(String type) {
        if (BaseDataTypeEnum.DATABASE.getCode().equals(type)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ASSISTANTTYPE});
            this.getView().setVisible(Boolean.TRUE, new String[]{VALUESOURCE, CHECKFLEXPANELAP});
            this.getView().getModel().setValue(ASSISTANTTYPE, (Object)"");
        } else if (BaseDataTypeEnum.CUSTOM.getCode().equals(type)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ASSISTANTTYPE, VALUESOURCE, CHECKFLEXPANELAP});
            this.getView().getModel().setValue(VALUESOURCE, (Object)"");
            this.getView().getModel().setValue(ASSISTANTTYPE, (Object)"");
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{PENTRYENTITY});
    }

    private void unlockCtrls() {
        this.getView().setEnable(Boolean.TRUE, new String[]{"number", TYPE, VALUESOURCE, ASSISTANTTYPE});
    }

    private void lockCtrls() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.EDIT)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", TYPE, VALUESOURCE, ASSISTANTTYPE});
        }
    }

    private void basicDataSourceChanged(String newData) {
        String code = (String)this.getModel().getValue(TYPE);
        if (BaseDataTypeEnum.DATABASE.eqScene((Object)code)) {
            String entityName;
            String string = entityName = "".equals(newData) ? null : newData;
            if (entityName != null) {
                try {
                    QueryServiceHelper.exists((String)entityName, null);
                }
                catch (Throwable ex) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u201d%s\u201c\u5185\u5bb9\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ManageObjectPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]), entityName));
                    return;
                }
                this.resetEntryEntity(entityName, this.getDefaultRefProps());
            }
        }
        this.clearFilterAndPre();
        this.setCtrlMustInput();
        this.setCtrlPreview(true);
        this.getModel().setValue(FILTERRULE, null);
        this.getView().updateView();
    }

    private void resetEntryEntity(String entityNumber, List<String> refProps) {
        String entryentityMapStr = this.getPageCache().get(ENTRYENTITY_MAP_CACHE);
        Map entryentityMap = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)entryentityMapStr)) {
            entryentityMap = (Map)SerializationUtils.fromJsonString((String)entryentityMapStr, Map.class);
        }
        String tableName = "";
        DynamicObject value = this.getValue();
        if (value != null) {
            tableName = value.getString("name");
        }
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (entityNumber != null && refProps != null) {
            try {
                QueryServiceHelper.exists((String)entityNumber, null);
            }
            catch (Throwable ex) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u201d%s\u201c\u5185\u5bb9\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ManageObjectPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]), entityNumber));
                return;
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(ZNUMBER, new Object[0]);
            vs.addField(ZNAME, new Object[0]);
            vs.addField(SOURCE, new Object[0]);
            vs.addField(SOURCEFIELD, new Object[0]);
            vs.addField(SOURCENUMBER, new Object[0]);
            vs.addField(CONVERSION, new Object[0]);
            EntityMetadata metadata = new EntityMetadata(entityNumber);
            for (String refProp : refProps) {
                EntityMetadata.RefFieldProp fprop = metadata.getRefFieldProp(refProp);
                if (fprop != null) {
                    Map map;
                    String name = fprop.getName();
                    String displayName = fprop.getDisplayName();
                    String conversion = fprop.getConversion();
                    String zname = name;
                    String zdisplayName = displayName;
                    if (entryentityMap.size() > 0 && (map = (Map)entryentityMap.get(name)) != null && map.size() > 0) {
                        zname = StringUtils.isEmpty((CharSequence)((CharSequence)map.get("name"))) ? name : (String)map.get("name");
                        zdisplayName = StringUtils.isEmpty((CharSequence)((CharSequence)map.get("displayName"))) ? name : (String)map.get("displayName");
                    }
                    vs.addRow(new Object[]{zname, zdisplayName, tableName, displayName + "(" + name + ")", name, conversion});
                    continue;
                }
                logger.info(entityNumber + " not get RefFieldProp" + refProp);
            }
            model.batchCreateNewEntryRow(ENTRYENTITY, vs);
            model.endInit();
            this.getView().updateView(ENTRYENTITY);
        }
    }

    private DynamicObject getValue() {
        DynamicObject value = null;
        String code = (String)this.getModel().getValue(TYPE);
        if (BaseDataTypeEnum.DATABASE.eqScene((Object)code)) {
            value = (DynamicObject)this.getView().getModel().getValue(VALUESOURCE);
        }
        return value;
    }

    private void setCtrlMustInput() {
        String code = (String)this.getModel().getValue(TYPE);
        if (BaseDataTypeEnum.DATABASE.eqScene((Object)code)) {
            this.setMustInput(VALUESOURCE, true);
            this.setMustInput(ASSISTANTTYPE, false);
        } else {
            this.setMustInput(VALUESOURCE, false);
            this.setMustInput(ASSISTANTTYPE, false);
        }
    }

    private void setCtrlPreview(boolean flag) {
        if (flag) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PENTRYENTITY});
            this.getView().setVisible(Boolean.TRUE, new String[]{HYPERLINKAPFLEX});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{PENTRYENTITY});
            this.getView().setVisible(Boolean.FALSE, new String[]{HYPERLINKAPFLEX});
        }
    }

    private void setMustInput(String key, boolean mustInput) {
        FieldEdit edit = (FieldEdit)this.getControl(key);
        edit.setMustInput(mustInput);
    }

    private List<String> getDefaultRefProps() {
        return Arrays.asList(new String[0]);
    }

    private String getSourceNumber() {
        String code = (String)this.getModel().getValue(TYPE);
        if (BaseDataTypeEnum.DATABASE.eqScene((Object)code)) {
            return (String)this.getModel().getValue("valuesource_id");
        }
        return BaseDataTypeEnum.ASSISTANTDATA.eqScene((Object)code) ? "bos_assistantdata_detail" : "";
    }

    private List getSelectValue() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        HashMap entryentityMap = new HashMap();
        List collect = entryEntity.stream().map(field -> {
            String sourceNumber = field.getString(SOURCENUMBER);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", field.getString(ZNUMBER));
            map.put("displayName", field.getString(ZNAME));
            entryentityMap.put(sourceNumber, map);
            return sourceNumber;
        }).collect(Collectors.toList());
        this.getPageCache().remove(ENTRYENTITY_MAP_CACHE);
        this.getPageCache().put(ENTRYENTITY_MAP_CACHE, SerializationUtils.toJsonString(entryentityMap));
        return collect;
    }

    private boolean preSaveEntityCheck(String type) {
        return this.preSaveDatabase(ENTRYENTITY, type);
    }

    private boolean preSaveDatabase(String entryentity, String type) {
        DynamicObject basicData;
        long primarykeyId;
        String primarykeyCache;
        OperationStatus status;
        Long pkId = 0L;
        boolean flag = false;
        DynamicObjectCollection mzs = this.getModel().getEntryEntity(entryentity);
        String numberData = "number";
        String nameData = "name";
        if (ENTRYENTITY.equals(entryentity)) {
            if (CollectionUtils.isEmpty((Collection)mzs)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u5165\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ManageObjectPlugin_8", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return false;
            }
            numberData = ZNUMBER;
            nameData = ZNAME;
        } else if (CENTRYENTITY.equals(entryentity)) {
            if (!BaseDataTypeEnum.DATABASE.getCode().equals(type) && !BaseDataTypeEnum.ASSISTANTDATA.getCode().equals(type) && CollectionUtils.isEmpty((Collection)mzs)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5b57\u6bb5\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ManageObjectPlugin_9", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return false;
            }
            numberData = CNUMBER;
            nameData = CNAME;
        }
        HashSet names = Sets.newHashSetWithExpectedSize((int)mzs.size());
        HashSet numbers = Sets.newHashSetWithExpectedSize((int)mzs.size());
        String code = (String)this.getModel().getValue(TYPE);
        if (mzs.size() > 30 && BaseDataTypeEnum.CUSTOM.eqScene((Object)code)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5b57\u6bb5\u4e0d\u80fd\u5927\u4e8e30,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ManageObjectPlugin_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryentity);
        int i = 0;
        for (DynamicObject mz : mzs) {
            String number = mz.getString(numberData);
            String name = mz.getString(nameData);
            if (ENTRYENTITY.equals(entryentity)) {
                if (!NumberRuleUtils.checkNumberV2((String)number)) {
                    entryGrid.focusCell(i, numberData);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u5165\u5b57\u6bb5\u7f16\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\uff0c\u4e0d\u53ef\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\uff0c\u4ee5\u53ca\u591a\u7ef4\u5e93\u4fdd\u7559\u5b57\u6bb5all\u3001other\u3001none\uff08\u4e0d\u533a\u5206\u5927\u5c0f\u5199\uff0c\u6700\u957f50\u4e2a\u5b57\u7b26\uff09\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ManageObjectPlugin_10", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (!numbers.add(number)) {
                    entryGrid.focusCell(i, numberData);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9009\u5165\u5b57\u6bb5\u7f16\u7801\"%s\"\u4e0d\u80fd\u91cd\u590d\u3002", (String)"ManageObjectPlugin_11", (String)"epm-epbs-formplugin", (Object[])new Object[0]), number));
                    return false;
                }
            } else if (CENTRYENTITY.equals(entryentity)) {
                if (StringUtils.isBlank((CharSequence)number) && StringUtils.isBlank((CharSequence)name)) {
                    entryGrid.focusCell(i, nameData);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5b57\u6bb5\u7f16\u7801\u201d\u3001\u201c\u5b57\u6bb5\u540d\u79f0\u201d\u3002", (String)"ManageObjectPlugin_12", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (StringUtils.isBlank((CharSequence)number)) {
                    entryGrid.focusCell(i, numberData);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5b57\u6bb5\u7f16\u7801\u201d\u3002", (String)"ManageObjectPlugin_13", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (StringUtils.isBlank((CharSequence)name)) {
                    entryGrid.focusCell(i, nameData);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5b57\u6bb5\u540d\u79f0\u201d\u3002", (String)"ManageObjectPlugin_14", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (!NumberRuleUtils.checkNumberV2((String)number)) {
                    entryGrid.focusCell(i, numberData);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5b57\u6bb5\u7f16\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\uff0c\u4e0d\u53ef\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\uff0c\u4ee5\u53ca\u591a\u7ef4\u5e93\u4fdd\u7559\u5b57\u6bb5all\u3001other\u3001none\uff08\u4e0d\u533a\u5206\u5927\u5c0f\u5199\uff0c\u6700\u957f50\u4e2a\u5b57\u7b26\uff09\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ManageObjectPlugin_15", (String)"epm-epbs-formplugin", (Object[])new Object[0]), new Object[0]));
                    return false;
                }
                if (!numbers.add(number)) {
                    entryGrid.focusCell(i, numberData);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5b57\u6bb5\u7f16\u7801\"%s\"\u4e0d\u80fd\u91cd\u590d\u3002", (String)"ManageObjectPlugin_16", (String)"epm-epbs-formplugin", (Object[])new Object[0]), number));
                    return false;
                }
                if (mz.getBoolean(ISPRIMARYKEY)) {
                    flag = true;
                    pkId = mz.getLong("id");
                }
            }
            ++i;
        }
        if (!flag && BaseDataTypeEnum.CUSTOM.eqScene((Object)code)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5b57\u6bb5\u5fc5\u987b\u8bbe\u7f6e\u4e3b\u952e\u3002", (String)"ManageObjectPlugin_17", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (flag && BaseDataTypeEnum.CUSTOM.eqScene((Object)code) && (status = this.getView().getFormShowParameter().getStatus()).equals((Object)OperationStatus.EDIT) && StringUtils.isNotEmpty((CharSequence)(primarykeyCache = this.getPageCache().get(PRIMARYKEY_CACHE))) && (primarykeyId = Long.parseLong(primarykeyCache)) != pkId && (basicData = this.getBasicData(primarykeyId)) != null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5b57\u6bb5\u4e3b\u952e\u5df2\u88ab\u7ef4\u62a4,\u8bf7\u52ff\u91cd\u590d\u7ef4\u62a4\u3002", (String)"ManageObjectPlugin_18", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void createFilterGrid() {
        String entityNumber = this.getSourceNumber();
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            this.filterGridSetFieldColumns(FILTERGRIDAP, entityNumber, true);
        }
    }

    private void filterGridSetFieldColumns(String controlKey, String entityNumber, boolean isAddedBtn) {
        FilterGrid filterGrid = (FilterGrid)this.getControl(controlKey);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        filterGrid.setEntityNumber(entityType.getName());
        String code = (String)this.getModel().getValue(TYPE);
        if ("bos_assistantdata_detail".equals(entityNumber) && BaseDataTypeEnum.ASSISTANTDATA.eqScene((Object)code)) {
            GetFilterFieldsParameter getFilterFieldsParameter = new GetFilterFieldsParameter((IDataEntityType)entityType);
            List filterColumns = EntityTypeUtil.createFilterColumns((GetFilterFieldsParameter)getFilterFieldsParameter);
            List newFilterColumns = filterColumns.stream().filter(c -> !c.get("fieldName").toString().contains("group") && !c.get("fieldName").toString().contains("parent")).collect(Collectors.toList());
            filterGrid.setFilterColumns(newFilterColumns);
        } else {
            GetFilterFieldsParameter getFilterFieldsParameter = new GetFilterFieldsParameter((IDataEntityType)entityType);
            List filterColumns = EntityTypeUtil.createFilterColumns((GetFilterFieldsParameter)getFilterFieldsParameter);
            filterGrid.setFilterColumns(filterColumns);
        }
        if (!isAddedBtn) {
            filterGrid.setBtnStatus();
        }
    }

    private void setFiltergridap() {
        DynamicObject value = this.getValue();
        if (value == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FILTERGRIDAP});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{FILTERGRIDAP});
            String filterjson = (String)this.getModel().getValue(FILTERRULE);
            FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
            String flag = this.getPageCache().get(FLAG_CACHE);
            if (StringUtils.isNotBlank((CharSequence)filterjson) && !"T".equals(flag)) {
                FlexBDValueCondition fc = (FlexBDValueCondition)SerializationUtils.fromJsonString((String)filterjson, FlexBDValueCondition.class);
                filterGrid.SetValue(fc.getFilterCondition());
            }
            this.getPageCache().put(FLAG_CACHE, "T");
        }
    }

    private void preSaveFilterCheck() {
        String condition = SerializationUtils.toJsonString((Object)this.getFlexBDValueCondition());
        this.getModel().setValue(FILTERRULE, (Object)condition);
    }

    private FlexBDValueCondition getFlexBDValueCondition() {
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        FilterBuilder filterBuilder = this.getCommonFilters();
        String filter = filterBuilder.getFilterObject().getFilterResult().getFilterGroup()[0];
        FlexBDValueCondition flexPropertyCon = new FlexBDValueCondition();
        flexPropertyCon.setDescription(new LocaleString(filter));
        flexPropertyCon.setFilterCondition(filterCondition);
        return flexPropertyCon;
    }

    private void basicDataTypeChange(Object newValue) {
        String type = (String)newValue;
        this.clearOldValue(type);
        switch (BaseDataTypeEnum.getEnum((String)type)) {
            case ASSISTANTDATA: {
                this.resetEntryEntity("bos_assistantdata_detail", this.getDefaultRefProps());
                this.setIsPrimaryKeyVisible(false);
                break;
            }
            case CUSTOM: {
                this.setIsPrimaryKeyVisible(true);
                break;
            }
            default: {
                this.setIsPrimaryKeyVisible(false);
            }
        }
        this.setCtrlPreview(true);
        this.setCtrlMustInput();
    }

    private void clearOldValue(String type) {
        this.setDisplay(type);
        this.resetEntryEntity(null, this.getDefaultRefProps());
        this.clearFilterAndPre();
        this.getView().updateView();
    }

    private void clearFilterAndPre() {
        this.getPageCache().remove(ENTRYGRIDMODEL);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        filterGrid.SetValue(new FilterCondition());
    }

    private boolean createDocumentBody(String entityName) {
        QFilter filter;
        int rowCount = 0;
        ManagePreEntryGridControl grid = (ManagePreEntryGridControl)this.getView().getControl(PENTRYENTITY);
        ModelEntryGrid entryGridModel = this.createEntryGridModel(entityName, grid);
        QFilter[] filters = new QFilter[]{};
        if (!StringUtils.isBlank((CharSequence)entryGridModel.getFilterStr()) && (filter = QFilter.fromSerializedString((String)entryGridModel.getFilterStr())) != null) {
            filters = filter.toArray();
        }
        try {
            QueryServiceHelper.exists((String)entityName, null);
        }
        catch (Throwable ex) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u201d%s\u201c\u5185\u5bb9\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ManageObjectPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]), entityName));
            return false;
        }
        DynamicObject totalObject = QueryServiceHelper.queryOne((String)entityName, (String)"count(1) as totalNumber", (QFilter[])filters);
        if (!Objects.isNull(totalObject)) {
            rowCount = totalObject.getInt("totalNumber");
        }
        int pageRow = grid.getPageRow();
        String pagerowCacheStr = this.getPageCache().get(PAGEROW_CACHE);
        if (StringUtils.isBlank((CharSequence)pagerowCacheStr)) {
            this.getPageCache().put(PAGEROW_CACHE, String.valueOf(pageRow));
        } else {
            pageRow = Integer.parseInt(pagerowCacheStr);
        }
        DynamicObject billObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection(PENTRYENTITY);
        rows.clear();
        ManageHelper.createPreEntryGrid((ModelEntryGrid)entryGridModel, (int)0, (int)pageRow, (DynamicObjectCollection)rows);
        billObj.getDataEntityState().setEntryRowCount(PENTRYENTITY, rowCount);
        billObj.getDataEntityState().setEntryPageSize(PENTRYENTITY, pageRow);
        billObj.getDataEntityState().setEntryStartRowIndex(PENTRYENTITY, 0);
        this.getView().updateView();
        return true;
    }

    private ModelEntryGrid createEntryGridModel(String entityName, ManagePreEntryGridControl grid) {
        ModelEntryGrid entryGridModel = new ModelEntryGrid();
        entryGridModel.setEntityName(entityName);
        String selectFields = this.getSelectFields(grid);
        entryGridModel.setSelectFields(selectFields);
        String filters = this.getFilters();
        entryGridModel.setFilterStr(filters);
        entryGridModel.setConversionMap(this.getConversionMapData());
        entryGridModel.setOrderBys("");
        this.getPageCache().remove(ENTRYGRIDMODEL);
        this.getPageCache().put(ENTRYGRIDMODEL, SerializationUtils.toJsonString((Object)entryGridModel));
        return entryGridModel;
    }

    private Map<String, HashMap<String, String>> getConversionMapData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        String entityName = this.getSourceNumber();
        return ManageHelper.getConversionMapData((DynamicObjectCollection)entryEntity, (String)entityName);
    }

    private String getSelectFields(ManagePreEntryGridControl grid) {
        int i;
        StringBuilder selectFields = new StringBuilder();
        List fieldEdits = grid.getFieldEdits();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (entryEntity.size() > fieldEdits.size()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9009\u5165\u5b57\u6bb5\u4e0d\u80fd\u5927\u4e8e\u201c%s\u201d,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ManageObjectPlugin_19", (String)"epm-epbs-formplugin", (Object[])new Object[0]), fieldEdits.size()));
        }
        for (i = 0; i < entryEntity.size(); ++i) {
            DynamicObject field = (DynamicObject)entryEntity.get(i);
            String sourcenumber = field.getString(SOURCENUMBER);
            selectFields.append(sourcenumber);
            if (i < entryEntity.size() - 1) {
                selectFields.append(",");
            }
            grid.setColumnProperty("a" + i, "header", new LocaleString(field.getString(ZNAME)));
            FieldEdit fieldEdit = (FieldEdit)fieldEdits.get(i);
            fieldEdit.setVisible("a" + i, true);
        }
        for (i = entryEntity.size(); i < fieldEdits.size(); ++i) {
            FieldEdit fieldEdit = (FieldEdit)fieldEdits.get(i);
            fieldEdit.setVisible("a" + i, false);
        }
        return selectFields.toString();
    }

    private FilterBuilder getCommonFilters() {
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        String formId = this.getSourceNumber();
        FilterBuilder filterBuilder = ManageHelper.getFilterBuilder((String)formId, (FilterCondition)filterCondition);
        return filterBuilder;
    }

    private String getFilters() {
        FilterBuilder filterBuilder = this.getCommonFilters();
        String filters = filterBuilder.getQFilter() == null ? "" : filterBuilder.getQFilter().toSerializedString();
        return filters;
    }

    private void createFieldAndFilterCache() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        FlexBDValueCondition flexBDValueCondition = this.getFlexBDValueCondition();
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("entryEntity", entryEntity);
        map.put("flexBDValueCondition", flexBDValueCondition);
        this.getPageCache().remove(FIELD_FILTER_CACHE);
        this.getPageCache().put(FIELD_FILTER_CACHE, SerializationUtils.toJsonString((Object)map));
    }

    private void previewtagEvent() {
        String entryentityMapStr = this.getPageCache().get(FIELD_FILTER_CACHE);
        if (StringUtils.isNotEmpty((CharSequence)entryentityMapStr)) {
            DynamicObjectCollection newEntryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            FlexBDValueCondition newFlexBDValueCondition = this.getFlexBDValueCondition();
            HashMap newMap = Maps.newHashMapWithExpectedSize((int)2);
            newMap.put("entryEntity", newEntryEntity);
            newMap.put("flexBDValueCondition", newFlexBDValueCondition);
            if (!ObjectUtils.nullSafeEquals((Object)entryentityMapStr, (Object)SerializationUtils.toJsonString((Object)newMap))) {
                this.setCtrlPreview(true);
            }
        }
    }

    private void hyperlinkapClick() {
        String code = (String)this.getModel().getValue(TYPE);
        DynamicObject value = this.getValue();
        if (value == null) {
            if (BaseDataTypeEnum.DATABASE.eqScene((Object)code)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u503c\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ManageObjectPlugin_20", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f85\u52a9\u503c\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ManageObjectPlugin_21", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection mzs = this.getModel().getEntryEntity(ENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)mzs)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u5165\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ManageObjectPlugin_8", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.createFieldAndFilterCache();
        String entityName = BaseDataTypeEnum.DATABASE.eqScene((Object)code) ? value.getString("id") : "bos_assistantdata_detail";
        boolean flag = this.createDocumentBody(entityName);
        if (flag) {
            this.setCtrlPreview(false);
        }
    }

    private void maintainRelationships(List<Object> ids) {
        if (!ids.isEmpty()) {
            String objectid = ids.get(0).toString();
            Set idsSet = Sets.newHashSetWithExpectedSize((int)16);
            String delCustomCacheStr = this.getPageCache().get(DELCUSTOM_CACHE);
            if (StringUtils.isNotEmpty((CharSequence)delCustomCacheStr)) {
                idsSet = (Set)SerializationUtils.fromJsonString((String)delCustomCacheStr, Set.class);
            }
            if (idsSet != null && idsSet.size() > 0) {
                this.resetData(objectid, idsSet);
            }
            this.doRelationships(objectid);
        }
    }

    private void doRelationships(String objectid) {
        String seletFileds = "centryentity.id,centryentity.seq";
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"epbs_basedataobject", (String)seletFileds, (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(objectid)).toArray(), (String)"centryentity.seq");
        if (dys != null && dys.length > 0) {
            List<Long> filterCollectList;
            List filterCollect = Arrays.stream(dys).collect(Collectors.toList());
            DynamicObjectCollection centryentity = (DynamicObjectCollection)((DynamicObject)filterCollect.get(0)).get(CENTRYENTITY);
            List<Long> collect = centryentity.stream().map(c -> c.getLong("id")).collect(Collectors.toList());
            DynamicObject[] reDys = BusinessDataServiceHelper.load((String)"epbs_basedatarelation", (String)"fieldid,fieldname", (QFilter[])new QFBuilder("fieldid", "in", collect).toArray());
            if (reDys != null && reDys.length > 0) {
                List reCollect = Arrays.stream(reDys).map(c -> c.getLong("fieldid")).collect(Collectors.toList());
                filterCollectList = collect.stream().filter(c -> !reCollect.contains(c)).collect(Collectors.toList());
            } else {
                filterCollectList = collect;
            }
            if (filterCollectList.size() > 0) {
                List filterList;
                List list = ManageHelper.COUNTLIST.stream().collect(Collectors.toList());
                if (reDys != null && reDys.length > 0) {
                    List fieldList = Arrays.stream(reDys).map(c -> c.getString("fieldname")).collect(Collectors.toList());
                    List fieldseqList = fieldList.stream().filter(c -> !StringUtils.isBlank((CharSequence)c)).map(c -> {
                        String[] fields = c.split("field");
                        Integer value = -1;
                        if (fields.length == 2 && ManageHelper.isNumeric((String)fields[1])) {
                            return Integer.parseInt(fields[1]);
                        }
                        return value;
                    }).collect(Collectors.toList());
                    List filterFieldseqList = list.stream().filter(c -> !fieldseqList.contains(c)).collect(Collectors.toList());
                    filterList = filterFieldseqList.subList(0, filterCollectList.size());
                } else {
                    filterList = list.subList(0, collect.size());
                }
                this.saveBasicdatarelation(filterCollectList, filterList);
            }
        }
    }

    private void saveBasicdatarelation(List<Long> filterCollect, List filterList) {
        long[] longs = DBServiceHelper.genLongIds((String)"epbs_basedatarelation", (int)filterCollect.size());
        ArrayList dataSets = Lists.newArrayListWithExpectedSize((int)filterCollect.size());
        for (int i = 0; i < filterCollect.size(); ++i) {
            DynamicObject dataSet = BusinessDataServiceHelper.newDynamicObject((String)"epbs_basedatarelation");
            dataSet.set("id", (Object)longs[i]);
            dataSet.set("fieldid", (Object)filterCollect.get(i));
            dataSet.set("fieldname", (Object)("field" + filterList.get(i)));
            dataSets.add(dataSet);
        }
        SaveServiceHelper.save((DynamicObject[])dataSets.toArray(new DynamicObject[0]));
    }

    private void resetData(String objectId, Set<Long> set) {
        QFilter[] qFilters = new QFBuilder("fieldid", "in", new ArrayList<Long>(set)).toArray();
        DynamicObject[] fieldnamesObject = BusinessDataServiceHelper.load((String)"epbs_basedatarelation", (String)"fieldname", (QFilter[])qFilters);
        if (fieldnamesObject != null && fieldnamesObject.length > 0) {
            StringBuilder builder = new StringBuilder();
            Arrays.stream(fieldnamesObject).forEach(c -> builder.append(c.getString("fieldname")).append(","));
            if (fieldnamesObject.length > 0) {
                DynamicObject[] dataObject;
                String fieldName = builder.toString().substring(0, builder.length() - 1);
                for (DynamicObject dy : dataObject = BusinessDataServiceHelper.load((String)"epbs_basedata", (String)fieldName, (QFilter[])new QFilter[]{new QFilter("objectid", "=", (Object)Long.parseLong(objectId))})) {
                    Arrays.stream(fieldnamesObject).forEach(c -> dy.set(c.getString("fieldname"), null));
                }
                SaveServiceHelper.save((DynamicObject[])dataObject);
            }
        }
        DeleteServiceHelper.delete((String)"epbs_basedatarelation", (QFilter[])qFilters);
    }

    private void setIsPrimaryKeyVisible(boolean flag) {
        IFormView view = this.getView().getControl(CENTRYENTITY).getView();
        view.setVisible(Boolean.valueOf(flag), new String[]{ISPRIMARYKEY});
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(CENTRYENTITY);
        if (!flag && !entryEntity.isEmpty()) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                dynamicObject.set(ISPRIMARYKEY, (Object)false);
            }
            this.getView().updateView(CENTRYENTITY);
        }
    }

    private void changeOtherIsprimarykey(ChangeData changeData) {
        int seq = changeData.getDataEntity().getInt("seq");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(CENTRYENTITY);
        DynamicObject entryEntityData = (DynamicObject)entryEntity.get(seq - 1);
        boolean isprimarykey = entryEntityData.getBoolean(ISPRIMARYKEY);
        if (isprimarykey) {
            if (!entryEntity.isEmpty()) {
                for (int i = 0; i < entryEntity.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                    if (dynamicObject.getInt("seq") != seq) {
                        dynamicObject.set(ISPRIMARYKEY, (Object)false);
                        continue;
                    }
                    dynamicObject.set("mustinput", (Object)true);
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"mustinput"});
                }
                this.getView().updateView(CENTRYENTITY);
            }
        } else {
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                if (dynamicObject.getInt("seq") != seq) continue;
                dynamicObject.set(ISPRIMARYKEY, (Object)false);
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"mustinput"});
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"islocked"});
                break;
            }
            this.getView().updateView(CENTRYENTITY);
        }
    }

    private void setIsPrimaryKeyLock() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.EDIT)) {
            DynamicObject basicData;
            List collect;
            String id = this.getModel().getValue("id").toString();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(CENTRYENTITY);
            if (!entryEntity.isEmpty() && !(collect = entryEntity.stream().filter(c -> c.getBoolean(ISPRIMARYKEY)).collect(Collectors.toList())).isEmpty()) {
                this.getPageCache().put(PRIMARYKEY_CACHE, ((DynamicObject)collect.get(0)).getString("id"));
            }
            if ((basicData = QueryServiceHelper.queryOne((String)"epbs_basedata", (String)"id", (QFilter[])new QFilter("objectid", "=", (Object)Long.parseLong(id)).toArray())) != null) {
                this.getPageCache().put(ISPRIMARYKEY_CACHE, id);
                if (!entryEntity.isEmpty()) {
                    for (int i = 0; i < entryEntity.size(); ++i) {
                        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                        if (dynamicObject.getBoolean(ISPRIMARYKEY)) {
                            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"mustinput"});
                            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"islocked"});
                            dynamicObject.set("islocked", (Object)true);
                        }
                        this.getView().setEnable(Boolean.valueOf(false), i, new String[]{ISPRIMARYKEY});
                    }
                }
            }
        }
    }

    public void edit(String code) {
        Object value;
        if (BaseDataTypeEnum.DATABASE.eqScene((Object)code)) {
            value = this.getModel().getValue(VALUESOURCE);
            if (value == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u503c\u6765\u6e90\u201d\u3002", (String)"ManageObjectPlugin_22", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
        } else {
            value = this.getModel().getValue(ASSISTANTTYPE);
            if (value == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u8f85\u52a9\u503c\u6765\u6e90\u201d\u3002", (String)"ManageObjectPlugin_23", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        String entityNumber = this.getSourceNumber();
        List list = this.getSelectValue();
        if (BaseDataTypeEnum.DATABASE.eqScene((Object)code)) {
            ManageRefPropsPlugin.openF7((AbstractFormPlugin)this, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u663e\u793a\u5b57\u6bb5", (String)"ManageObjectPlugin_24", (String)"epm-epbs-formplugin", (Object[])new Object[0]), entityNumber, list, PROPERTYEDIT);
        } else {
            ManageRefPropsPlugin.openF7((AbstractFormPlugin)this, ResManager.loadKDString((String)"\u8f85\u52a9\u8d44\u6599\u663e\u793a\u5b57\u6bb5", (String)"ManageObjectPlugin_25", (String)"epm-epbs-formplugin", (Object[])new Object[0]), entityNumber, list, PROPERTYEDIT);
        }
    }

    public void delCustom() {
        EntryGrid eg = (EntryGrid)this.getControl(CENTRYENTITY);
        int focusRow = eg.getEntryState().getFocusRow();
        if (focusRow < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"ManageObjectPlugin_26", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(CENTRYENTITY, focusRow);
        boolean isprimarykey = entryRowEntity.getBoolean(ISPRIMARYKEY);
        long id = entryRowEntity.getLong("id");
        if (status.equals((Object)OperationStatus.EDIT) && id != 0L) {
            DynamicObject basicData = this.getBasicData(id);
            if (isprimarykey && basicData != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u952e\u4e0d\u53ef\u5220\u9664\u3002", (String)"ManageObjectPlugin_27", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            if (basicData != null) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u5b57\u6bb5\u4e0b\u5b58\u5728\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\u8fdb\u884c\u5220\u9664\uff1f", (String)"ManageObjectPlugin_28", (String)"epm-epbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACKID_DELETE_CONFIRM, (IFormPlugin)this));
                return;
            }
        }
        int[] selectRows = new int[]{focusRow};
        this.addDelCustomCache(id);
        this.getModel().deleteEntryRows(CENTRYENTITY, selectRows);
    }

    public void addDelCustomCache(Long id) {
        Set<Long> idsSet = Sets.newHashSetWithExpectedSize((int)16);
        String delCustomCacheStr = this.getPageCache().get(DELCUSTOM_CACHE);
        if (StringUtils.isNotEmpty((CharSequence)delCustomCacheStr)) {
            idsSet = (Set)SerializationUtils.fromJsonString((String)delCustomCacheStr, Set.class);
        }
        if (id != 0L) {
            idsSet.add(id);
            this.getPageCache().put(DELCUSTOM_CACHE, SerializationUtils.toJsonString(idsSet));
        }
    }

    public DynamicObject getBasicData(long id) {
        DynamicObject basicData = null;
        QFilter[] qFilters = new QFBuilder("fieldid", "=", (Object)id).toArray();
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epbs_basedatarelation", (String)"fieldname", (QFilter[])qFilters);
        if (dynamicObject != null) {
            String fieldname = dynamicObject.getString("fieldname");
            String objectid = this.getModel().getValue("id").toString();
            qFilters = new QFBuilder("objectid", "=", (Object)Long.parseLong(objectid)).add(new QFilter(fieldname, "is not null", (Object)"")).toArray();
            basicData = QueryServiceHelper.queryOne((String)"epbs_basedata", (String)fieldname, (QFilter[])qFilters);
        }
        return basicData;
    }

    public void addCustom() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(CENTRYENTITY);
        String cacheStr = this.getPageCache().get(ISPRIMARYKEY_CACHE);
        if (StringUtils.isNotEmpty((CharSequence)cacheStr) && !entryEntity.isEmpty()) {
            this.getView().setEnable(Boolean.valueOf(false), entryEntity.size() - 1, new String[]{ISPRIMARYKEY});
        }
    }

    public void barClose() {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection(PENTRYENTITY);
        rows.clear();
        String objectStr = this.getPageCache().get(OBJECT_CLOSE_CACHE);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Object isCopy = map.get("isCopy");
        if (Objects.equals(isCopy, true)) {
            String isSave = this.getPageCache().get(ISSAVE_CACHE);
            if (!"T".equals(isSave)) {
                Object id = this.getModel().getValue("id");
                QFBuilder qb = new QFBuilder("id", "=", id);
                DeleteServiceHelper.delete((String)"epbs_basedataobject", (QFilter[])qb.toArrays());
            } else {
                this.getView().returnDataToParent(this.getModel().getValue("id"));
            }
        } else if (StringUtils.isNotEmpty((CharSequence)objectStr)) {
            this.getView().returnDataToParent(SerializationUtils.fromJsonString((String)objectStr, List.class));
        } else {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (status.equals((Object)OperationStatus.EDIT)) {
                this.getView().returnDataToParent(this.getModel().getValue("id"));
            }
        }
        this.getView().close();
    }

    private void delete() {
        EntryGrid eg = (EntryGrid)this.getControl(CENTRYENTITY);
        int focusRow = eg.getEntryState().getFocusRow();
        if (focusRow >= 0) {
            int[] selectRows = new int[]{focusRow};
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(CENTRYENTITY, focusRow);
            long id = entryRowEntity.getLong("id");
            if (id != 0L) {
                this.addDelCustomCache(id);
            }
            this.getModel().deleteEntryRows(CENTRYENTITY, selectRows);
        }
    }
}

