/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.bd.manage;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;

public class ManageRefPropsPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
TreeNodeCheckListener {
    private static final String F_TARGET_PROPS = "ftargetprops";
    private static final String FIELD_TREE = "fieldtree";
    private static final String CHECK_NODES = "checkNodes";
    private static final String FTNAME = "ftname";
    private static final String FTDISPLAYNAME = "ftdisplayname";
    private static final String BTNOK = "btnok";
    private static final String BTNREMOVE = "btnremove";

    public void initialize() {
        this.addClickListeners(new String[]{BTNOK, BTNREMOVE});
        EntryGrid grid = (EntryGrid)this.getControl(F_TARGET_PROPS);
        grid.addRowClickListener((RowClickEventListener)this);
        TreeView fieldtree = (TreeView)this.getView().getControl(FIELD_TREE);
        fieldtree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setCurrentEntity(entityNumber);
        option.setIncludeChildEntity(false);
        option.setIncludeBDPropPK(true);
        option.setIncludeEntryEntityAsKeyPrefix(true);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        TreeNode root = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)dataEntityType, (PropTreeBuildOption)option);
        if (root.getChildren() != null) {
            ArrayList childrenId = new ArrayList(root.getChildren().size());
            childrenId.addAll(root.getChildren());
            for (TreeNode node : childrenId) {
                node.setParentid(root.getId());
            }
            TreeView tree = (TreeView)this.getView().getControl(FIELD_TREE);
            tree.addNode(root);
            Object value = this.getView().getFormShowParameter().getCustomParams().get("value");
            if (value == null || StringUtils.isBlank(value)) {
                value = new ArrayList();
            }
            List refProps = (List)value;
            ArrayList checkNodeIds = Lists.newArrayListWithExpectedSize((int)refProps.size());
            ArrayList checkNodes = Lists.newArrayListWithExpectedSize((int)refProps.size());
            for (Object nodeId : refProps) {
                if (nodeId == null) continue;
                checkNodeIds.add(nodeId);
                checkNodes.add(root.getTreeNode((String)nodeId, 16));
            }
            tree.checkNodes((List)checkNodes);
            this.getPageCache().put(FIELD_TREE, SerializationUtils.toJsonString((Object)root));
            this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString((Object)checkNodeIds));
            IDataModel model = this.getModel();
            model.deleteEntryData(F_TARGET_PROPS);
            for (String name : refProps) {
                TreeNode child = root.getTreeNode(name, 16);
                if (child == null) continue;
                int rowindex = model.createNewEntryRow(F_TARGET_PROPS);
                model.setValue(FTNAME, (Object)child.getId(), rowindex);
                model.setValue(FTDISPLAYNAME, (Object)child.getText(), rowindex);
            }
            List children = root.getChildren();
            if (children != null) {
                for (TreeNode child : children) {
                    tree.expand(child.getId());
                }
            }
            this.defaultLockNodes(root);
        }
    }

    private void defaultLockNodes(TreeNode root) {
        Object lockValues = this.getView().getFormShowParameter().getCustomParams().get("lockValues");
        if (lockValues == null || StringUtils.isBlank(lockValues)) {
            new ArrayList();
        }
        List<String> lockNodeNumber = this.getDefaultNodeNumbers();
        for (String nodeNumber : lockNodeNumber) {
            TreeNode node = root.getTreeNode(nodeNumber, 16);
            if (node == null) continue;
            node.setDisabled(true);
        }
    }

    private List<String> getDefaultNodeNumbers() {
        Object lockValues = this.getView().getFormShowParameter().getCustomParams().get("lockValues");
        if (lockValues == null || StringUtils.isBlank(lockValues)) {
            lockValues = new ArrayList();
        }
        return (List)lockValues;
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (F_TARGET_PROPS.equals(source.getKey())) {
            this.delete();
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTNREMOVE.equals(key)) {
            this.delete();
        } else if (BTNOK.equals(key)) {
            this.returnData();
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(FIELD_TREE), TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(FIELD_TREE);
        List currChecks = tree.getTreeState().getCheckedNodeIds();
        List checkNodes = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(CHECK_NODES), List.class);
        IDataModel model = this.getModel();
        if (evt.getChecked().booleanValue()) {
            if (checkNodes.isEmpty() || currChecks.removeAll(checkNodes)) {
                for (String id : currChecks) {
                    TreeNode node = root.getTreeNode(id, 16);
                    if (node == null || node.getChildren() != null) continue;
                    int row = model.createNewEntryRow(F_TARGET_PROPS);
                    model.setValue(FTNAME, (Object)node.getId(), row);
                    model.setValue(FTDISPLAYNAME, (Object)node.getText(), row);
                }
            }
        } else if (currChecks.isEmpty() || checkNodes.removeAll(currChecks)) {
            for (int i = 0; i < checkNodes.size(); ++i) {
                TreeNode node = root.getTreeNode((String)checkNodes.get(i), 16);
                if (node == null || node.getChildren() == null) continue;
                checkNodes.remove(i);
            }
            ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
            for (int i = model.getEntryRowCount(F_TARGET_PROPS) - 1; i >= 0; --i) {
                if (!checkNodes.contains(model.getValue(FTNAME, i))) continue;
                list.add(i);
            }
            int[] rows = list.stream().mapToInt(Integer::valueOf).toArray();
            model.deleteEntryRows(F_TARGET_PROPS, rows);
        }
        this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString((Object)tree.getTreeState().getCheckedNodeIds()));
    }

    protected void returnData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(F_TARGET_PROPS);
        List fieldList = entryEntity.stream().map(field -> field.getString(FTNAME)).collect(Collectors.toList());
        if (50 < fieldList.size()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9009\u5165\u5b57\u6bb5\u4e0d\u80fd\u5927\u4e8e\u201c%s\u201d,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ManageRefPropsPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]), 50));
            return;
        }
        HashMap para = new HashMap();
        para.put("RefProps", fieldList);
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private void delete() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(F_TARGET_PROPS);
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows != null && rows.length != 0) {
            List<String> defaultNodeNumbers = this.getDefaultNodeNumbers();
            OptionalInt defaultRowIndex = Arrays.stream(rows).filter(rowx -> defaultNodeNumbers.contains(this.getModel().getValue(FTNAME, rowx))).findAny();
            if (!defaultRowIndex.isPresent()) {
                IDataModel model = this.getModel();
                ArrayList<String> nodeIds = new ArrayList<String>();
                for (int i = 0; i < rows.length; ++i) {
                    int row = rows[i];
                    if (row < 0) continue;
                    nodeIds.add((String)model.getValue(FTNAME, row));
                }
                model.deleteEntryRows(F_TARGET_PROPS, rows);
                TreeView tree = (TreeView)this.getView().getControl(FIELD_TREE);
                tree.uncheckNodes(nodeIds);
                this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString((Object)tree.getTreeState().getCheckedNodeIds()));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79fb\u9664\u7684\u884c", (String)"ManageRefPropsPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
    }

    public static void openF7(AbstractFormPlugin plugin, String caption, String entityNumber, List<String> value, String actionId) {
        if (!StringUtils.isEmpty((CharSequence)entityNumber)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCaption(caption);
            showParameter.setFormId("epbs_basedatapropertyref");
            showParameter.setCustomParam("value", value);
            showParameter.setCustomParam("entityNumber", (Object)entityNumber);
            showParameter.setParentFormId(plugin.getView().getEntityId());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, actionId);
            showParameter.setCloseCallBack(closeCallBack);
            plugin.getView().showForm(showParameter);
        }
    }
}

