/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.bd.model;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.IPCListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.bd.model.ModelF7ParamContext;
import kd.epm.epbs.business.bd.model.ModelListHelper;
import kd.epm.epbs.common.model.IMetaDataEntity;
import kd.epm.epbs.common.util.AppUtils;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.common.util.OperationResultUtil;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class ModelListPlugin
extends AbstractBaseListPlugin
implements ClickListener,
IPCListPlugin,
IMetaDataEntity {
    private static final String APPNUM = "appnums";
    private static final String MODEL_APP_INFO = "model_app_info";
    public static final String CALLBACKID_DEL_CONFIRM = "callbackid_del_confirm";
    private ModelF7ParamContext _ctx;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addSetFilterListener(this::setFilter);
        billList.addPackageDataListener(this::packageData);
    }

    protected ModelF7ParamContext getCtx() {
        if (this._ctx == null) {
            IFormView parentView;
            String st = (String)this.getView().getFormShowParameter().getCustomParam("f7params");
            this._ctx = StringUtils.isNotEmpty((String)st) ? (ModelF7ParamContext)ObjectSerialUtil.deSerializedBytes((String)st) : ((parentView = this.getView().getParentView()) != null ? ModelListHelper.createModelF7Ctx((IFormView)parentView) : new ModelF7ParamContext());
        }
        return this._ctx;
    }

    public void packageData(PackageDataEvent e) {
        String key;
        super.packageData(e);
        if (ColumnDesc.class.isAssignableFrom(e.getSource().getClass()) && "permcontrol".equals(key = ((ColumnDesc)e.getSource()).getKey())) {
            DynamicObject rowData = e.getRowData();
            e.setFormatValue((Object)(this.getCtx().isOnlyManager() ? "1" : (this.getCtx().getLimitedModelIds().contains(rowData.getLong("id")) ? "1" : "2")));
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (!("baradd".equals(key) || "barrefresh".equals(key) || "barclose".equals(key) || selectedRows.size() >= 1)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"ModelListPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        this.refrush();
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "baradd": {
                this.baradd();
                break;
            }
            case "barupdate": {
                this.barupdate();
                break;
            }
            case "bardelete": {
                this.bardelete();
                break;
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public void setListFields(List<ListField> listFields) {
                ListField listField = listFields.stream().filter(e -> Objects.equals(ModelListPlugin.APPNUM, e.getKey())).findFirst().orElseGet(() -> null);
                AppUtils.buildValueMapItems((ListField)listField, (Collection)ModelListPlugin.this.getCtx().getQueryAppTypes());
                super.setListFields(listFields);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"isshowdisabled"});
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (this.getView().getFormShowParameter().getCustomParam("f7params") == null && this.getCtx() != null) {
            e.getQFilters().add(this.getCtx().genQFilter());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.cacheListData();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "typenew": {
                if (ObjectUtils.isEmpty((Object)e.getReturnData())) {
                    return;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ModelListPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                this.refrush();
                break;
            }
            case "modifierclose": {
                if (!ObjectUtils.isEmpty((Object)e.getReturnData())) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ModelListPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                }
                this.refrush();
            }
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = hyperLinkClickEvent.getCurrentRow();
        Object primaryKeyValue = currentRow.getPrimaryKeyValue();
        CloseCallBack close = new CloseCallBack((IFormPlugin)this, "modifierclose");
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId(this.getMetaDataEntity(this.getView(), "epbs_model"));
        param.setCaption(ResManager.loadKDString((String)"\u7f16\u8f91\u4f53\u7cfb", (String)"ModelListPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        param.setPkId(primaryKeyValue);
        param.setStatus(OperationStatus.EDIT);
        param.setCloseCallBack(close);
        this.getView().showForm((FormShowParameter)param);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (MessageBoxResult.Yes == evt.getResult()) {
            switch (evt.getCallBackId()) {
                case "callbackid_del_confirm": {
                    this.actionDeleteResult();
                    break;
                }
            }
        }
    }

    private void cacheListData() {
        HashMap infos = Maps.newHashMap();
        DynamicObjectCollection list = ((BillList)this.getControl("billlistap")).getListModel().getQueryResult().getCollection();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (DynamicObject model : list) {
                infos.put(model.getLong("id"), model.getString(APPNUM));
            }
        }
        this.getPageCache().put(MODEL_APP_INFO, ObjectSerialUtil.toByteSerialized((Object)infos));
    }

    public void refrush() {
        IListView listView = (IListView)this.getView();
        listView.clearSelection();
        listView.refresh();
    }

    public void baradd() {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId(this.getMetaDataEntity(this.getView(), "epbs_model"));
        param.setStatus(OperationStatus.ADDNEW);
        param.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u4f53\u7cfb", (String)"ModelListPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "typenew");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)param);
    }

    public void barupdate() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u4fee\u6539\u3002", (String)"ModelListPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow listSelectedRow = selectedRows.get(0);
        Object pkValue = listSelectedRow.getPrimaryKeyValue();
        CloseCallBack close = new CloseCallBack((IFormPlugin)this, "modifierclose");
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCaption(ResManager.loadKDString((String)"\u7f16\u8f91\u4f53\u7cfb", (String)"ModelListPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        param.setFormId(this.getMetaDataEntity(this.getView(), "epbs_model"));
        param.setPkId(pkValue);
        param.setStatus(OperationStatus.EDIT);
        param.setCloseCallBack(close);
        this.getView().showForm((FormShowParameter)param);
    }

    public void bardelete() {
        BillList billList = (BillList)this.getControl("billlistap");
        Object[] selectedIds = billList.getSelectedRows().getPrimaryKeyValues();
        if (selectedIds == null || selectedIds.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"ModelListPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u201d%s\u201d\u6761\u8bb0\u5f55\uff0c\u5220\u9664\u540c\u65f6\u4f1a\u5220\u9664\u5176\u5305\u542b\u7684\u6240\u6709\u7ef4\u5ea6\u548c\u6240\u6709\u7ef4\u5ea6\u6210\u5458\uff0c\u5220\u9664\u6210\u529f\u540e\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u5220\u9664\uff1f", (String)"ModelListPlugin_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]), selectedIds.length), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACKID_DEL_CONFIRM, (IFormPlugin)this));
    }

    private void actionDeleteResult() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        Object[] ids = billList.getSelectedRows().getPrimaryKeyValues();
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)this.getMetaDataEntity(this.getView(), "epbs_model"), (Object[])ids, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664%s\u6761\u6570\u636e\u3002", (String)"ModelListPlugin_8", (String)"epm-epbs-formplugin", (Object[])new Object[0]), ids.length));
        } else {
            OperationResultUtil.showOperationResult((IFormView)this.getView(), (OperationResult)operationResult);
        }
        this.refrush();
    }
}

