/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.common;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.databind.JavaType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.epm.epbs.business.paramsetting.util.ParamSettingUtils;
import kd.epm.epbs.common.apitest.ApiTestParam;
import kd.epm.epbs.common.apitest.utils.ApiInfoUtils;
import kd.epm.epbs.common.apitest.vo.ClassVO;
import kd.epm.epbs.common.apitest.vo.MethodVO;
import kd.epm.epbs.common.apitest.vo.ParameterVO;
import kd.epm.epbs.common.tree.AbstractTreeBuilder;
import kd.epm.epbs.common.tree.TreeContext;
import kd.epm.epbs.common.tree.TreeSearchHelper;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.JSONUtils;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class ApiTestPlugin
extends AbstractBaseListPlugin
implements TreeNodeClickListener {
    protected static final String TREE_NODE_CACHE = "treenode_cache";
    protected static final String SELECTED_TREE_NODE_CACHE = "selected_treenode_cache";
    private static final String PARAM_ENTITY = "pentryentity";
    private static final String RES_ENTITY = "rentryentity";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (EnvTypeHelper.getCurrentEnvType() == EnvTypeHelper.EnvType.Product) {
            return;
        }
        this.getView().setEnable(Boolean.valueOf(ParamSettingUtils.isDevModel()), new String[]{"bar_test"});
        this.initLeftTree();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"vectorap_up", "vectorap_down", "bar_testrule"});
        TreeView tree = (TreeView)this.getControl("treeviewap");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(event -> new TreeSearchHelper(tree, event.getText()).search());
    }

    protected void initLeftTree() {
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        new AbstractTreeBuilder<TreeContext>(){

            protected TreeNode createTreeNode() {
                Map map = ApiInfoUtils.scanBusinessPackageClassWithApiTestAnnotation();
                TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5206\u7c7b", (String)"ApiTestPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                map.forEach((k, v) -> {
                    TreeNode treeNode = new TreeNode("0", k.name(), k.getBridge().loadKDString());
                    v.forEach(a -> {
                        TreeNode treeNode2 = new TreeNode(treeNode.getId(), a.getName(), a.getDescription(), a);
                        a.getMethods().forEach(m -> treeNode2.addChild(new TreeNode(treeNode2.getId(), m.getFullMethodInfo(), m.getDescription(), m)));
                        treeNode.addChild(treeNode2);
                    });
                    root.addChild(treeNode);
                });
                return root;
            }
        }.setContext(new TreeContext(treeView.getTreeState().getFocusNodeId())).buildTree(treeView).nodeClick();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("vectorap_up".equals(key) || "vectorap_down".equals(key)) {
            Search search = (Search)this.getControl("searchap");
            TreeView treeView = (TreeView)this.getControl("treeviewap");
            TreeSearchHelper builder = new TreeSearchHelper(treeView, search.getSearchKey());
            if ("vectorap_up".equals(key)) {
                builder.setMoveUp();
            }
            builder.search();
        }
        if ("bar_testrule".equals(key)) {
            // empty if block
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "bar_test": {
                long starttime = System.currentTimeMillis();
                Object object = this.executeApi();
                long executeTime = System.currentTimeMillis() - starttime;
                String result = JSONObject.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
                CodeEdit edit = (CodeEdit)this.getView().getControl("jsonresult");
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(RES_ENTITY, 0);
                if (entryRowEntity != null && "void".equals(entryRowEntity.getString("resptype")) && !result.contains("ERROR INFO:")) {
                    edit.setText(String.format("cost:%dms;%s\"SUCCESS\"", executeTime, System.lineSeparator()));
                    return;
                }
                edit.setText(String.format(String.format("cost:%%dms;%s%%s", System.lineSeparator()), executeTime, result));
                break;
            }
            case "bar_refresh": {
                this.refresh();
                break;
            }
        }
    }

    public void refresh() {
        this.initLeftTree();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String focusNodeId = (String)evt.getNodeId();
        TreeNode root = AbstractTreeBuilder.getRootWithCache((TreeView)((TreeView)evt.getSource()));
        if (root != null) {
            TreeNode treeNode = root.getTreeNode(focusNodeId);
            if (treeNode.getData() != null && CollectionUtils.isEmpty((Collection)treeNode.getChildren())) {
                TreeNode parentNode = root.getTreeNode(treeNode.getParentid());
                MethodVO methodVO = (MethodVO)JSONUtils.parseFormMap((Map)((Map)treeNode.getData()), MethodVO.class);
                this.refreshRightPanel((ClassVO)JSONUtils.parseFormMap((Map)((Map)parentNode.getData()), ClassVO.class), methodVO);
                this.getView().setEnable(Boolean.valueOf(methodVO.isCanTest()), new String[]{"bar_test"});
            } else {
                this.getModel().setValue("classname", null);
                this.getModel().setValue("methodname", null);
                this.getModel().setValue("methoddec", null);
                this.getModel().deleteEntryData(PARAM_ENTITY);
                this.getModel().deleteEntryData(RES_ENTITY);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_test"});
                CodeEdit edit = (CodeEdit)this.getView().getControl("paramvalue");
                edit.setText("");
                CodeEdit jsonresult = (CodeEdit)this.getView().getControl("jsonresult");
                jsonresult.setText("");
            }
        }
    }

    protected void refreshRightPanel(ClassVO classVO, MethodVO methodVO) {
        this.getModel().setValue("classname", (Object)classVO.getName());
        this.getModel().setValue("methodname", (Object)methodVO.getName());
        this.getModel().setValue("methoddec", (Object)methodVO.getDescription());
        this.getModel().deleteEntryData(PARAM_ENTITY);
        List parameterNames = methodVO.getParameterNames();
        LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>(parameterNames.size());
        HashSet<Integer> paramExpands = new HashSet<Integer>(parameterNames.size());
        for (ParameterVO parameter : parameterNames) {
            this.createParamRow(parameter, -1, param, paramExpands);
        }
        TreeEntryGrid pentryentity = (TreeEntryGrid)this.getView().getControl(PARAM_ENTITY);
        pentryentity.expand(paramExpands.stream().mapToInt(Integer::intValue).toArray());
        this.getView().updateView(PARAM_ENTITY);
        this.getModel().deleteEntryData(RES_ENTITY);
        ParameterVO returnModel = methodVO.getReturnParameter();
        HashSet<Integer> respExpands = new HashSet<Integer>(16);
        this.createRespRow(returnModel, -1, respExpands);
        TreeEntryGrid rentryentity = (TreeEntryGrid)this.getView().getControl(RES_ENTITY);
        rentryentity.expand(this.getModel().getEntryNextRows(RES_ENTITY, 0, true));
        this.getView().updateView(RES_ENTITY);
        CodeEdit edit = (CodeEdit)this.getView().getControl("paramvalue");
        edit.setText(JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        CodeEdit jsonresult = (CodeEdit)this.getView().getControl("jsonresult");
        jsonresult.setText("");
    }

    private void createParamRow(ParameterVO parameter, int parentRow, Map<String, Object> param, Set<Integer> expands) {
        int row = parentRow == -1 ? this.getModel().createNewEntryRow(PARAM_ENTITY) : this.getModel().insertEntryRow(PARAM_ENTITY, parentRow);
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity(PARAM_ENTITY, row);
        dynamicObject.set("paramname", (Object)parameter.getName());
        dynamicObject.set("paramtype", (Object)parameter.getClassName());
        dynamicObject.set("paramexample", (Object)parameter.getExample());
        dynamicObject.set("paramdec", (Object)parameter.getDescription());
        dynamicObject.set("paramfullname", (Object)parameter.getFullClassName());
        if (parameter.isModel()) {
            expands.add(row);
            List modelFields = parameter.getModelFields();
            LinkedHashMap<String, Object> childParam = new LinkedHashMap<String, Object>(modelFields.size());
            param.put(parameter.getName(), childParam);
            for (ParameterVO parameterVO : modelFields) {
                this.createParamRow(parameterVO, row, childParam, expands);
            }
        } else if ("java.lang.String".equals(parameter.getFullClassName())) {
            param.put(parameter.getName(), "");
        } else {
            param.put(parameter.getName(), null);
        }
    }

    private void createRespRow(ParameterVO returnModel, int parentRow, Set<Integer> expands) {
        if (returnModel == null) {
            return;
        }
        int row = parentRow == -1 ? this.getModel().createNewEntryRow(RES_ENTITY) : this.getModel().insertEntryRow(RES_ENTITY, parentRow);
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity(RES_ENTITY, row);
        dynamicObject.set("respname", (Object)returnModel.getName());
        dynamicObject.set("resptype", (Object)returnModel.getClassName());
        dynamicObject.set("respexample", (Object)returnModel.getExample());
        dynamicObject.set("respdec", (Object)returnModel.getDescription());
        if (returnModel.isModel()) {
            expands.add(row);
            List modelFields = returnModel.getModelFields();
            for (ParameterVO parameterVO : modelFields) {
                this.createRespRow(parameterVO, row, expands);
            }
        }
    }

    private Object executeApi() {
        Object result;
        try {
            String className = (String)this.getModel().getValue("classname");
            String methodName = (String)this.getModel().getValue("methodname");
            CodeEdit edit = (CodeEdit)this.getView().getControl("paramvalue");
            String paramValue = edit.getText();
            JSONObject paramJson = JSONObject.parseObject((String)paramValue);
            DynamicObjectCollection paramCollection = this.getModel().getEntryEntity(PARAM_ENTITY);
            paramCollection.removeIf(e -> !IDUtils.equals((Object)e.getLong("pid"), (Object)0L));
            ArrayList paramClassList = new ArrayList(paramCollection.size());
            ArrayList<String> paramNameList = new ArrayList<String>(paramCollection.size());
            for (DynamicObject dynamicObject : paramCollection) {
                String paramfullname = dynamicObject.getString("paramfullname");
                Class<?> clazz = ApiTestPlugin.getBaseClassByName(paramfullname);
                paramClassList.add(clazz);
                paramNameList.add(dynamicObject.getString("paramname"));
            }
            Class[] parameterTypes = paramClassList.toArray(new Class[0]);
            Object[] params = new Object[paramClassList.size()];
            Class<?> aClass = Class.forName(className);
            Object instance = null;
            try {
                instance = aClass.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            Method method = aClass.getDeclaredMethod(methodName, parameterTypes);
            Parameter[] parameters = method.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                Object realParam;
                Parameter parameter = parameters[i];
                Class<?> clazz = parameter.getType();
                ApiTestParam apiTestParam = parameter.getAnnotation(ApiTestParam.class);
                Type type = parameter.getParameterizedType();
                JavaType javaType = JSONUtils.getMapper().getTypeFactory().constructType(type);
                Object param = paramJson.get(paramNameList.get(i));
                String paramString = String.valueOf(param);
                if (clazz == String.class) {
                    params[i] = paramString;
                    continue;
                }
                if (clazz == Date.class) {
                    String format = apiTestParam != null ? apiTestParam.dateTimeFormat() : "yyyy-MM-dd";
                    SimpleDateFormat sdf = new SimpleDateFormat(format);
                    realParam = sdf.parse(paramString);
                } else {
                    realParam = JSONUtils.parse((String)paramString, (JavaType)javaType);
                }
                params[i] = realParam;
            }
            result = method.invoke(instance, params);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | ParseException e2) {
            return "ERROR INFO:" + e2.getMessage();
        }
        catch (InvocationTargetException e3) {
            Throwable targetException = e3.getTargetException();
            return "ERROR INFO:" + targetException.getMessage();
        }
        return result;
    }

    public static Class<?> getBaseClassByName(String typeName) throws ClassNotFoundException {
        switch (typeName) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
        }
        return Class.forName(typeName);
    }
}

