/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.epm.epbs.business.multilingual.MetadataKsqlBuilder;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.cache.DimTypeCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;

public class KSqlExportPlugin
extends AbstractBaseListPlugin {
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_exportksql": {
                this.exportKsql(false);
                break;
            }
            case "btn_exportallksql": {
                this.exportKsql(true);
                break;
            }
            case "btn_exportmodelksql": {
                this.exportKsql(this.getModelId());
                break;
            }
        }
    }

    private void exportKsql(boolean isAll) {
        QFilter filter = null;
        BillList billlist = (BillList)this.getControl("billlistap");
        if (!isAll) {
            Object[] obj = billlist.getSelectedRows().getPrimaryKeyValues();
            if (obj == null || obj.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u8bb0\u5f55\u3002", (String)"KSqlExportPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            filter = new QFilter("id", "in", (Object)obj);
        }
        String url = new MetadataKsqlBuilder(this.getView().getFormShowParameter().getAppId(), billlist.getEntityId()).setFilter(filter != null ? filter.toArray() : null).genKsqlDownloadUrl();
        this.getView().download(url);
    }

    private void exportKsql(long modelId) {
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
        Set dimensionIds = modelCache.getDimensionMap().keySet();
        String modelKsl = new MetadataKsqlBuilder(modelCache.getModel().getSrcAppNum(), "epbs_model").setFilter(new QFilter("id", "=", (Object)modelId).toArray()).genKsql() + "\n";
        ArrayList<String> list = new ArrayList<String>(50);
        list.addAll(Arrays.asList("epbs_dimension", "epbs_struct_view", "epbs_propertydefined", "epbs_membpropval", "epbs_bizmodel", "epbs_dimmodelref", "epbs_businessdomain", "epbs_relationmodelentity"));
        Map dimTypeMap = DimTypeCacheHelper.get().getDimTypeMap();
        for (Map.Entry dimTypeBeanEntry : dimTypeMap.entrySet()) {
            DimTypeBean dimTypeBean = (DimTypeBean)dimTypeBeanEntry.getValue();
            if (!dimTypeBean.getAppNumber().equals(modelCache.getModel().getSrcAppNum())) continue;
            list.add(dimTypeBean.getMemberTreemodel());
            list.add(dimTypeBean.getBaseMemberModel());
        }
        modelKsl = modelKsl + list.stream().map(e -> {
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            if (e.contains("memberof")) {
                qFilter = new QFilter("dimension", "in", (Object)dimensionIds);
            }
            return new MetadataKsqlBuilder(modelCache.getModel().getSrcAppNum(), modelCache.getMetaDataEntity(e)).setFilter(qFilter.toArray()).genKsql();
        }).collect(Collectors.joining("\n"));
        this.getView().download(new MetadataKsqlBuilder(modelCache.getModel().getSrcAppNum(), "epbs_model").genKsqlDownloadUrl(modelKsl));
    }
}

