/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.dataimport;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.epm.epbs.business.dataimport.FileResourceImportHelper;
import kd.epm.epbs.business.spi.IPluginProviderService;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.form.FormOpener;
import kd.epm.epbs.common.util.GZIPUtils;
import kd.epm.epbs.common.util.ImportUtil;
import kd.epm.epbs.common.util.JSONUtils;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.common.util.OperationMsgUtil;

public class FileResourceImportFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
UploadListener,
IPluginProviderService<Map<String, Object>, Map<String, Object>> {
    private static final Log log = LogFactory.getLog(FileResourceImportFormPlugin.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        try {
            String mainEntityName = this.getMainEntityName();
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)mainEntityName);
            this.getView().setFormTitle(new LocaleString(String.format(ResManager.loadKDString((String)"%s\u5bfc\u5165", (String)"FileResourceImportFormPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]), dataEntityType.getDisplayName().getLocaleValue())));
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    private String getMainEntityName() {
        String mainEntityName = (String)this.getView().getFormShowParameter().getCustomParam("entityName");
        if (mainEntityName == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u5bfc\u5165\u7684\u8d44\u6e90\u7c7b\u578b\u3002", (String)"FileResourceImportFormPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        return mainEntityName;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryEntity;
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("btn_import".equals(operateKey) && (entryEntity = this.getModel().getEntryEntity("main_resources")).isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u89e3\u6790\u540e\u518d\u5bfc\u5165\u3002", (String)"FileResourceImportFormPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("parse".equals(operateKey)) {
            this.parse();
        } else if ("main_res_diff".equals(operateKey) || "ref_res_diff".equals(operateKey)) {
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("data", this.getModel().getValue(operateKey.replace("res_diff", "") + "res_data"));
            FormOpener.showForm((AbstractFormPlugin)this, (String)"epbs_diff_comp", (String)"", params, (String)"");
        } else if ("btn_import".equals(operateKey)) {
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            List allErrorInfo = operationResult.getAllErrorInfo();
            for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                String errorCode = operateErrorInfo.getErrorCode();
                int rowIndex = operateErrorInfo.getRowIndex();
                String entityKey = operateErrorInfo.getEntityKey();
                if ("FAILED".equals(errorCode)) {
                    this.getModel().setValue(entityKey + "state", (Object)errorCode, rowIndex);
                    this.getModel().setValue(entityKey + "res_err", (Object)operateErrorInfo.getMessage(), rowIndex);
                    continue;
                }
                if ("SUCCESS".equals(errorCode)) {
                    this.getModel().setValue(entityKey + "state", (Object)errorCode, rowIndex);
                    this.getModel().setValue(entityKey + "res_err", null, rowIndex);
                    continue;
                }
                this.getModel().setValue(entityKey + "state", (Object)"OMITTED", rowIndex);
            }
            this.setEntryGridColor("main_");
            this.setEntryGridColor("ref_");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5b8c\u6210\uff0c\u5217\u8868\u53ef\u67e5\u770b\u72b6\u6001\u3002", (String)"FileResourceImportFormPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            OperationLogUtil.writeLog((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.IMPORT, (MultiLangEnumBridge)OperationMsgUtil.getSucStatus());
        }
    }

    public void setEntryGridColor(String type) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(type + "resources");
        DynamicObjectCollection mainResources = this.getModel().getEntryEntity(type + "resources");
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(mainResources.size());
        for (int i = 0; i < mainResources.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)mainResources.get(i);
            CellStyle cellStyle = new CellStyle();
            cellStyle.setRow(i);
            cellStyle.setFieldKey(type + "state");
            cellStyles.add(cellStyle);
            String state = dynamicObject.getString(type + "state");
            if (Objects.equals("SUCCESS", state)) {
                cellStyle.setForeColor("#1BA854");
                continue;
            }
            if (Objects.equals("FAILED", state)) {
                cellStyle.setForeColor("#FB2323");
                continue;
            }
            if (!Objects.equals("OMITTED", state)) continue;
            cellStyle.setForeColor("#F08705");
        }
        entryGrid.setCellStyle(cellStyles);
    }

    private void parse() {
        try {
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
            List list = attachmentPanel.getAttachmentData();
            List urls = list.stream().map(o -> (String)o.get("url")).collect(Collectors.toList());
            if (urls.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u5bfc\u5165\u6587\u4ef6\u3002", (String)"FileResourceImportFormPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            List importStringList = ImportUtil.getImportString(urls);
            this.getModel().deleteEntryData("main_resources");
            this.getModel().deleteEntryData("ref_resources");
            ArrayList<Map<String, Object>> mainList = new ArrayList<Map<String, Object>>(10);
            ArrayList<Map<String, Object>> refList = new ArrayList<Map<String, Object>>(10);
            for (String str : importStringList) {
                JSONArray jsonArray = (JSONArray)JSONUtils.parse((String)GZIPUtils.unZipAndBase64((String)str.trim()), JSONArray.class);
                for (Object object : jsonArray) {
                    Map data = (Map)object;
                    Boolean isref = (Boolean)data.get("$isref");
                    if (isref.booleanValue()) {
                        refList.add(data);
                        continue;
                    }
                    mainList.add(data);
                }
            }
            this.initResources(mainList, false);
            this.initResources(refList, true);
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684\u5bfc\u5165\u6587\u4ef6\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"FileResourceImportFormPlugin_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
        this.getView().updateView("main_resources");
        this.getView().updateView("ref_resources");
    }

    private void initResources(List<Map<String, Object>> resources, boolean isref) {
        String type;
        resources = resources.stream().sorted(Comparator.comparing(o -> (String)o.get("$entityname"))).collect(Collectors.toList());
        String string = type = isref ? "ref_" : "main_";
        if (resources.isEmpty()) {
            return;
        }
        int[] rows = this.getModel().batchCreateNewEntryRow(type + "resources", resources.size());
        for (int i = 0; i < resources.size(); ++i) {
            Map<String, Object> data = resources.get(i);
            String jsonString = JSON.toJSONString(data);
            int row = rows[i];
            String entityName = (String)data.get("$entityname");
            if (!isref && !this.getMainEntityName().equals(entityName)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u8d44\u6e90\u4e0d\u6b63\u786e\u3002", (String)"FileResourceImportFormPlugin_8", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
            DynamicObject importObj = (DynamicObject)ObjectSerialUtil.deSerializedToDynaObj((String)entityName, (String)jsonString);
            BasedataEntityType dataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)entityName);
            String nameProperty = dataEntityType.getNameProperty();
            String numberProperty = dataEntityType.getNumberProperty();
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(type + "resources", row);
            Object name = importObj.get(nameProperty);
            if (name instanceof Map) {
                entryRowEntity.set(type + "res_name", ((Map)name).get(Lang.get().toString()));
            } else {
                entryRowEntity.set(type + "res_name", name);
            }
            Object number = importObj.get(numberProperty);
            entryRowEntity.set(type + "res_number", number);
            entryRowEntity.set(type + "res_type", (Object)(dataEntityType.getName() + "(" + dataEntityType.getDisplayName().getLocaleValue() + ")"));
            entryRowEntity.set(type + "res_pk", importObj.getPkValue());
            entryRowEntity.set(type + "res_data", (Object)GZIPUtils.zipAndBase64((String)jsonString));
            String modifyDatePropName = null;
            for (IDataEntityProperty property : importObj.getDataEntityType().getProperties()) {
                if (!(property instanceof ModifyDateProp)) continue;
                modifyDatePropName = property.getName();
                entryRowEntity.set(type + "res_time", importObj.get(modifyDatePropName));
            }
            DynamicObject localDynamicObject = FileResourceImportHelper.getLocalDynamicObject((String)entityName, (String)numberProperty, (Object)number, (DynamicObject)importObj);
            if (localDynamicObject != null) {
                if (modifyDatePropName != null) {
                    entryRowEntity.set(type + "local_time", localDynamicObject.get(modifyDatePropName));
                }
                entryRowEntity.set(type + "local_res_pk", localDynamicObject.getPkValue());
                continue;
            }
            entryRowEntity.set(type + "importing_operation", (Object)"UPDATE");
        }
    }
}

