/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.datasource;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.ds.DataConnectCacheUtil;
import kd.epm.epbs.common.ds.DatasourceModel;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.util.EncryptUtils;
import kd.epm.epbs.common.util.OlapManagerHelper;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.common.util.OperationMsgUtil;

public class DataSourceEditPlugin
extends AbstractBasePlugIn {
    private static final String SERVERADDRESS = "serveraddress";
    private static final String DATACONNECT = "dataconnect";
    private static final String NUMBER = "number";
    private static final String NAME = "name";

    public void initialize() {
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"baritemtest"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("baritemtest".equals(key)) {
            String number = String.valueOf(this.getModel().getDataEntity().get(NUMBER));
            Object name = this.getModel().getDataEntity().get(NAME);
            this.checktest(number, String.valueOf(this.getModel().getValue(DATACONNECT)), String.valueOf(this.getModel().getValue("username")), String.valueOf(this.getModel().getValue("password")));
            if (number != null && name != null) {
                OperationLogUtil.writeLog((String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.VALIDATE, (MultiLangEnumBridge)new MultiLangEnumBridge("%1$s \u9a8c\u8bc1\u6210\u529f", "DataSourceEditPlugin_2", "epm-epbs-formplugin", new Object[]{number}));
            } else {
                OperationLogUtil.writeLog((String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.VALIDATE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u9a8c\u8bc1\u6210\u529f", "DataSourceEditPlugin_3", "epm-epbs-formplugin"));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        boolean isSuccess = afterDoOperationEventArgs.getOperationResult().getValidateResult().isSuccess();
        if ("save".equals(afterDoOperationEventArgs.getOperateKey())) {
            if (isSuccess) {
                DynamicObject[] load;
                List successPkIds = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds();
                DataConnectCacheUtil.clearDataSourceCache((Collection)successPkIds);
                for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"epbs_datasource", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)successPkIds)})) {
                    OperationLogUtil.writeLog((String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.SAVE, (MultiLangEnumBridge)OperationMsgUtil.getSaveSucTipWithNumber((String)dynamicObject.getString(NUMBER)));
                }
                this.getView().close();
            } else {
                OperationLogUtil.writeLog((String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.SAVE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u65b0\u589e\u4fdd\u5b58\u5931\u8d25", "DataSourceEditPlugin_6", "epm-epbs-formplugin"));
            }
        }
    }

    public void beforeBindData(EventObject e) {
        BaseShowParameter base = (BaseShowParameter)this.getView().getFormShowParameter();
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
            this.getModel().setValue("accountnumber", (Object)RequestContext.get().getTenantCode());
            this.getModel().setValue("accountid", (Object)RequestContext.get().getAccountId());
            this.getModel().setDataChanged(false);
        } else {
            boolean exist = this.checkquote(base.getPkId());
            if (exist) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"baritemsave", NUMBER, NAME, "description", SERVERADDRESS, "port", "username", "password"});
                this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String username = (String)this.getModel().getValue("username");
        String password = (String)this.getModel().getValue("password");
        if (status == OperationStatus.EDIT) {
            if (StringUtils.isNotEmpty((String)username)) {
                this.getModel().setValue("username", (Object)EncryptUtils.aesDecrypt((String)username));
            }
            if (StringUtils.isNotEmpty((String)password)) {
                this.getModel().setValue("password", (Object)EncryptUtils.aesDecrypt((String)password));
            }
            this.getModel().setDataChanged(false);
        }
    }

    private void checktest(String number, String connect, String username, String password) {
        String serverAddress = (String)this.getModel().getValue(SERVERADDRESS);
        if (StringUtils.isEmpty((String)connect) || StringUtils.isEmpty((String)username) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)serverAddress)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fc5\u5f55\u9879\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataSourceEditPlugin_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        long id = this.getModel().getDataEntity().getLong("id");
        if (id != 0L) {
            DataConnectCacheUtil.checkDataSource((String)number);
        }
        password = EncryptUtils.aesDecrypt((String)password);
        boolean isonline = OlapManagerHelper.testIsOnline((DatasourceModel)new DatasourceModel(connect, EncryptUtils.aesDecrypt((String)username), password));
        if (isonline) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u6210\u529f\u3002", (String)"DataSourceEditPlugin_8", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u5931\u8d25\u3002", (String)"DataSourceEditPlugin_9", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkquote(Object obj) {
        QFilter qf = new QFilter("datasource", "=", obj);
        return QueryServiceHelper.exists((String)"epbs_model", (QFilter[])qf.toArray());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String serveraddress = String.valueOf(this.getModel().getValue(SERVERADDRESS));
        String port = String.valueOf(this.getModel().getValue("port"));
        if (StringUtils.isNotEmpty((String)serveraddress) && StringUtils.isNotEmpty((String)port)) {
            this.getModel().setValue(DATACONNECT, (Object)("http://" + serveraddress + ":" + port + "/bos-olap-webserver/services/httpolap"));
        }
    }
}

