/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.datasource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.ds.DataConnectCacheUtil;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.common.util.OperationMsgUtil;
import kd.epm.epbs.formplugin.IPermItemCheckListener;

public class DataSourceListPlugin
extends AbstractListPlugin
implements ClickListener,
IPermItemCheckListener {
    private static final String refreshAdd = "refreshadd";
    private static final String CMAPPID = "11H66HLOX4IC";

    public void initialize() {
        super.initialize();
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_add": {
                this.openform(null);
                break;
            }
            case "btn_del": {
                boolean hasPermission = PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)CMAPPID, (String)"epbs_datasource", (String)"4715e1f1000000ac");
                if (!hasPermission) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5220\u9664\u6570\u636e\u6e90\u7684\u64cd\u4f5c\u6743\u9650\u3002", (String)"DataSourceListPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                BillList billlist = (BillList)this.getControl("billlistap");
                Object[] obj = billlist.getSelectedRows().getPrimaryKeyValues();
                if (obj == null || obj.length != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55,\u4e14\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"DataSourceListPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                Collection list = this.getQuote(obj[0]);
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    String tip = String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u88ab%s\u4e2a\u4f53\u7cfb\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff01", (String)"DataSourceListPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]), list.size());
                    this.openUnDelReason(tip, list);
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u5220\u9664\u6b64\u6570\u636e\u6e90\uff1f", (String)"DataSourceListPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("btn_del", (IFormPlugin)this));
                break;
            }
            case "btn_refresh": {
                this.refreshList();
                this.publicDataSourceCache();
                break;
            }
        }
    }

    private void openUnDelReason(String msg, Collection list) {
        String quoteSerial = ObjectSerialUtil.toByteSerialized((Object)list);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ebps_entrygridtip");
        parameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u914d\u7f6e\u5217\u8868\u5220\u9664\u63d0\u793a", (String)"DataSourceListPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("title", (Object)msg);
        parameter.setCustomParam("collection", (Object)quoteSerial);
        this.getView().showForm(parameter);
    }

    private void openform(Object pkId) {
        BaseShowParameter showparameter = new BaseShowParameter();
        showparameter.setStatus(OperationStatus.ADDNEW);
        if (pkId != null) {
            showparameter.setStatus(OperationStatus.EDIT);
            showparameter.setPkId(pkId);
        }
        showparameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u6e90", (String)"DataSourceListPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        showparameter.setFormId("epbs_datasource");
        showparameter.setHasRight(true);
        showparameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack clo = new CloseCallBack((IFormPlugin)this, refreshAdd);
        showparameter.setCloseCallBack(clo);
        this.getView().showForm((FormShowParameter)showparameter);
    }

    private void publicDataSourceCache() {
    }

    private void refreshList() {
        BillList billlist = (BillList)this.getControl("billlistap");
        billlist.refresh();
        billlist.clearSelection();
    }

    private Collection getQuote(Object obj) {
        QFilter qfs = new QFilter("datasource", "=", obj);
        return QueryServiceHelper.query((String)"epbs_model", (String)"id,shownumber,name,srcappnum,appnums", (QFilter[])qfs.toArray());
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (refreshAdd.equals(e.getActionId())) {
            this.refreshList();
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        HashMap<String, ArrayList<Object>> map = null;
        try {
            args.setCancel(true);
            map = this.getlogMessageMap();
            Iterator<Map.Entry<String, ArrayList<Object>>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                ArrayList<Object> value = iterator.next().getValue();
                String number = (String)value.get(0);
                String name = (String)value.get(1);
                OperationLogUtil.writeLog((String)"epbs_datasource", (IOperationTypeInfo)OperationTypeEnum.LOOKUP, (MultiLangEnumBridge)new MultiLangEnumBridge("\u7f16\u7801\uff1a%1$s\uff0c\u67e5\u770b\u6210\u529f", "DataSourceListPlugin_8", "epm-epbs-formplugin", new Object[]{number}));
            }
            BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            ListSelectedRow currentRow = hyperLinkClickEvent.getCurrentRow();
            this.openform(currentRow.getPrimaryKeyValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private HashMap<String, ArrayList<Object>> getlogMessageMap() {
        ArrayList<Object> selectIdList = new ArrayList<Object>();
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection cos = billlistap.getSelectedRows();
        for (ListSelectedRow listSelectedRow : cos) {
            selectIdList.add(listSelectedRow.getPrimaryKeyValue());
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])selectIdList.toArray(), (DynamicObjectType)billlistap.getEntityType());
        HashMap<String, ArrayList<Object>> map = new HashMap<String, ArrayList<Object>>();
        for (DynamicObject dynamicObject : load) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(dynamicObject.getString("number"));
            list.add(dynamicObject.getString("name"));
            map.put(dynamicObject.getPkValue().toString(), list);
        }
        return map;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("btn_del".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            BillList billlist = (BillList)this.getControl("billlistap");
            Object[] obj = billlist.getSelectedRows().getPrimaryKeyValues();
            QFilter qFilter = new QFilter("id", "in", (Object)obj);
            DynamicObject[] billlistaps = BusinessDataServiceHelper.load((String)"epbs_datasource", (String)"number,name", (QFilter[])new QFilter[]{qFilter});
            BusinessDataServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"epbs_datasource"), (Object[])obj);
            DataConnectCacheUtil.clearDataSourceCache(Arrays.asList(obj));
            for (DynamicObject billlistap : billlistaps) {
                String number = billlistap.getString("number");
                OperationLogUtil.writeLog((String)"epbs_datasource", (IOperationTypeInfo)OperationTypeEnum.DELETE, (MultiLangEnumBridge)OperationMsgUtil.getDeleteSucWithNumber((String)number));
            }
            this.refreshList();
        }
    }
}

