/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.grouptree;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.epbs.business.permission.util.AuthSetUtils;
import kd.epm.epbs.common.enums.AuthTypeEnum;
import kd.epm.epbs.common.tree.DynamicObjectTreeNode;
import kd.epm.epbs.common.tree.DynamicTreeContext;
import kd.epm.epbs.common.tree.LeftTreeSearch;
import kd.epm.epbs.common.tree.NoParentDynamicTreeBuilder;
import kd.epm.epbs.common.tree.SimpleDynamicTreeBuilder;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;
import kd.epm.epbs.formplugin.permission.data.f7.DataRoleF7Helper;
import org.apache.commons.lang3.StringUtils;

public class BaseTreeWithGroupListPlugin
extends AbstractBaseListPlugin
implements TreeNodeClickListener,
SearchEnterListener,
LeftTreeSearch,
CellClickListener,
HyperLinkClickListener {
    private static final String TREEVIEWAP = "treeviewap";
    private static final String RIGHT_ENTITY = "treeentryentity";
    private static final String SEARCH_LIST = "searchlist";
    private static final long LEFT_TREE_ROOT_ID = 0L;
    private String GROUP_FIELD;
    private Set<String> QUERY_COLUMNS = null;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search treeSearchUnit = (Search)this.getView().getControl("searchap");
        treeSearchUnit.addEnterListener((SearchEnterListener)this);
        Search searchlist = (Search)this.getView().getControl(SEARCH_LIST);
        searchlist.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{"searchbefore", "searchnext", "left_new", "left_edit", "left_delete", "listbefore", "listnext"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(RIGHT_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void initialize() {
        super.initialize();
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEWAP);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Label label = (Label)this.getControl("labelap");
        label.setText(EntityMetadataCache.getDataEntityType((String)this.getLeftEntity()).getDisplayName().getLocaleValue());
        this.initLeftTree();
    }

    public void search(SearchEnterEvent arg0) {
        Search source = (Search)arg0.getSource();
        String key = source.getKey();
        String text = arg0.getText().trim();
        if (StringUtils.isEmpty((CharSequence)text)) {
            return;
        }
        if (!SEARCH_LIST.equals(key)) {
            TreeView tv = (TreeView)this.getView().getControl(TREEVIEWAP);
            this.leftSearch(tv, text);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_refresh": {
                this.initLeftTree();
                break;
            }
            case "bar_new": {
                BaseShowParameter baseShowParameter = new BaseShowParameter();
                baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                baseShowParameter.setStatus(OperationStatus.ADDNEW);
                baseShowParameter.setFormId(this.getRightEntity());
                baseShowParameter.setHasRight(true);
                baseShowParameter.setBillStatus(BillOperationStatus.AUDIT);
                baseShowParameter.setCustomParam("group", (Object)this.getGroupId());
                baseShowParameter.setCustomParam("parent", (Object)this.getRightSelectId());
                baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bar_new"));
                this.getView().showForm((FormShowParameter)baseShowParameter);
                break;
            }
            case "bar_delete": {
                Long deleteId = this.getRightSelectId();
                if (deleteId == null || deleteId == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"BaseTreeWithGroupListPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!DataRoleF7Helper.checkRoleUsePerm(deleteId, this.getView())) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u5220\u9664\u9009\u4e2d\u884c\uff1f", (String)"BaseTreeWithGroupListPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("bar_delete", (IFormPlugin)this));
                break;
            }
            case "bar_edit": {
                Long editId = this.getRightSelectId();
                if (editId == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u7f16\u8f91\u7684\u6570\u636e\u3002", (String)"BaseTreeWithGroupListPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.rightEdit(editId);
                break;
            }
            case "bar_dimset": {
                AuthSetUtils.openF7((IFormView)this.getView(), (CloseCallBack)new CloseCallBack((IFormPlugin)this, itemKey), (AuthTypeEnum)AuthTypeEnum.DIM);
                break;
            }
            case "bar_bizset": {
                AuthSetUtils.openF7((IFormView)this.getView(), (CloseCallBack)new CloseCallBack((IFormPlugin)this, itemKey), (AuthTypeEnum)AuthTypeEnum.BIZ);
                break;
            }
            case "bar_adminset": {
                AuthSetUtils.openF7((IFormView)this.getView(), (CloseCallBack)new CloseCallBack((IFormPlugin)this, itemKey), (AuthTypeEnum)AuthTypeEnum.ADMIN);
                break;
            }
            case "bar_permclass": {
                break;
            }
        }
    }

    protected void rightEdit(Long editId) {
        BaseShowParameter editShowParameter = new BaseShowParameter();
        editShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        editShowParameter.setStatus(OperationStatus.EDIT);
        editShowParameter.setFormId(this.getRightEntity());
        editShowParameter.setHasRight(true);
        editShowParameter.setBillStatus(BillOperationStatus.AUDIT);
        editShowParameter.setPkId((Object)editId);
        editShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bar_edit"));
        this.getView().showForm((FormShowParameter)editShowParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("bar_delete".equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            String rightEntity = this.getRightEntity();
            Long deleteId = this.getRightSelectId();
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)rightEntity, (String)"longnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)deleteId)});
            QFilter qFilter = new QFilter("longnumber", "like", (Object)(dynamicObject.getString("longnumber") + "!%"));
            qFilter.or(new QFilter("id", "=", (Object)deleteId));
            DeleteServiceHelper.delete((String)rightEntity, (QFilter[])new QFilter[]{qFilter});
            this.initRightTree();
        } else if ("left_delete".equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            QFilter qFilter;
            String leftEntity = this.getLeftEntity();
            Long deleteId = this.getGroupId();
            if (this.leftEntityIsTree()) {
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)leftEntity, (String)"longnumber", (QFilter[])new QFilter("id", "=", (Object)deleteId).toArray());
                qFilter = new QFilter("longnumber", "like", (Object)(dynamicObject.getString("longnumber") + "!%")).or("id", "=", (Object)deleteId);
            } else {
                qFilter = new QFilter("id", "=", (Object)deleteId);
            }
            DeleteServiceHelper.delete((String)leftEntity, (QFilter[])new QFilter[]{qFilter});
            this.initLeftTree();
        }
    }

    protected String getRightEntity() {
        String entity = (String)this.getModel().getValue("right_entity");
        if (StringUtils.isEmpty((CharSequence)entity)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u53f3\u8868\u5b9e\u4f53", (String)"BaseTreeWithGroupListPlugin_8", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        return entity;
    }

    protected String getLeftEntity() {
        String entity = (String)this.getModel().getValue("left_entity");
        if (StringUtils.isEmpty((CharSequence)entity)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u5de6\u6811\u5206\u7ec4\u5b9e\u4f53", (String)"BaseTreeWithGroupListPlugin_9", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        return entity;
    }

    private String getGroupField() {
        if (this.GROUP_FIELD == null) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.getRightEntity());
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            for (IDataEntityProperty property : properties) {
                if (!(property instanceof BasedataProp)) continue;
                String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                if (!StringUtils.equals((CharSequence)this.getLeftEntity(), (CharSequence)baseEntityId)) continue;
                this.GROUP_FIELD = property.getName();
                break;
            }
        }
        if (this.GROUP_FIELD == null) {
            this.GROUP_FIELD = "group";
        }
        return this.GROUP_FIELD;
    }

    private void leftEdit() {
        Long editId = this.getGroupId();
        if (editId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u7f16\u8f91\u7684\u6570\u636e\u3002", (String)"BaseTreeWithGroupListPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (editId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u7f16\u8f91\u3002", (String)"BaseTreeWithGroupListPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter editShowParameter = new BaseShowParameter();
        editShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        editShowParameter.setStatus(OperationStatus.EDIT);
        editShowParameter.setFormId(this.getLeftEntity());
        editShowParameter.setHasRight(true);
        editShowParameter.setPkId((Object)editId);
        editShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "left_edit"));
        this.getView().showForm((FormShowParameter)editShowParameter);
    }

    private void leftNew() {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setStatus(OperationStatus.ADDNEW);
        baseShowParameter.setFormId(this.getLeftEntity());
        baseShowParameter.setHasRight(true);
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "left_new"));
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void leftDelete() {
        Long deleteId = this.getGroupId();
        if (deleteId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"BaseTreeWithGroupListPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (deleteId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BaseTreeWithGroupListPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (QueryServiceHelper.exists((String)"epbs_dataperm_role", (QFilter[])new QFilter("group", "=", (Object)deleteId).toArray())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7ec4\u5df2\u7ed1\u5b9a\u89d2\u8272\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BaseTreeWithGroupListPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u5220\u9664\u9009\u4e2d\u7684\u6570\u636e\uff1f", (String)"BaseTreeWithGroupListPlugin_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("left_delete", (IFormPlugin)this));
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        switch (key = Control2.getKey()) {
            case "searchbefore": 
            case "searchnext": {
                TreeView tv = (TreeView)this.getView().getControl(TREEVIEWAP);
                this.leftSearchNext(tv, key);
                break;
            }
            case "left_edit": {
                this.leftEdit();
                break;
            }
            case "left_new": {
                this.leftNew();
                break;
            }
            case "left_delete": {
                this.leftDelete();
                break;
            }
        }
    }

    private boolean leftEntityIsTree() {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.getLeftEntity());
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            if (!StringUtils.equals((CharSequence)property.getName(), (CharSequence)"parent")) continue;
            return true;
        }
        return false;
    }

    private void initLeftTree() {
        TreeView tv = (TreeView)this.getView().getControl(TREEVIEWAP);
        String focusNodeId = tv.getTreeState().getFocusNodeId();
        DynamicTreeContext context = new DynamicTreeContext(this.getLeftEntity());
        context.setFocusTreeId(focusNodeId);
        if (!this.leftEntityIsTree()) {
            context.setSelectFields("id,name,number");
            new NoParentDynamicTreeBuilder(context).buildTree(tv).nodeClick();
        } else {
            new SimpleDynamicTreeBuilder(context).buildTree(tv).nodeClick();
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.initRightTree();
    }

    protected Long getGroupId() {
        TreeView tv = (TreeView)this.getView().getControl(TREEVIEWAP);
        Map focusNode = tv.getTreeState().getFocusNode();
        if (focusNode == null || StringUtils.equals((CharSequence)"#", (CharSequence)((String)focusNode.get("id")))) {
            return null;
        }
        return Long.parseLong((String)focusNode.get("id"));
    }

    protected Long getRightSelectId() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(RIGHT_ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length < 1) {
            return null;
        }
        return (Long)this.getModel().getEntryRowEntity(RIGHT_ENTITY, selectRows[0]).getPkValue();
    }

    protected void initRightTree() {
        String rightEntity = this.getRightEntity();
        List<FieldEdit> fieldEdits = this.getRightEntityColumns();
        Set<String> queryColumns = this.getRightEntityQueryColumns(rightEntity, fieldEdits);
        queryColumns.add("id");
        queryColumns.add("parent");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)rightEntity, (String)String.join((CharSequence)",", queryColumns), (QFilter[])this.getFilters(), (String)"createtime");
        HashMap<Long, DynamicObjectTreeNode> nodeMap = new HashMap<Long, DynamicObjectTreeNode>(dynamicObjects.size());
        for (Object dynamicObject : dynamicObjects) {
            Map<String, Object> data = this.packageData((DynamicObject)dynamicObject, queryColumns);
            long id = dynamicObject.getLong("id");
            long pid = dynamicObject.getLong("parent");
            nodeMap.put(id, new DynamicObjectTreeNode(Long.valueOf(id), Long.valueOf(pid), data));
        }
        ArrayList<DynamicObjectTreeNode> nodeList = new ArrayList<DynamicObjectTreeNode>(10);
        for (Object dynamicObject : dynamicObjects) {
            Long parentId = dynamicObject.getLong("parent");
            Long id = dynamicObject.getLong("id");
            DynamicObjectTreeNode treeNode = (DynamicObjectTreeNode)nodeMap.get(id);
            DynamicObjectTreeNode parentNode = (DynamicObjectTreeNode)nodeMap.get(parentId);
            if (parentNode != null) {
                parentNode.addChild(treeNode);
                continue;
            }
            nodeList.add(treeNode);
        }
        ArrayList<DynamicObjectTreeNode> listNode = new ArrayList<DynamicObjectTreeNode>(10);
        for (DynamicObjectTreeNode dynamicObjectTreeNode : nodeList) {
            this.listNode(dynamicObjectTreeNode, listNode);
        }
        this.getModel().deleteEntryData(RIGHT_ENTITY);
        HashSet<Integer> paramExpands = new HashSet<Integer>(nodeList.size());
        this.createParamRow(listNode, paramExpands, fieldEdits);
        TreeEntryGrid pentryentity = (TreeEntryGrid)this.getView().getControl(RIGHT_ENTITY);
        pentryentity.expand(paramExpands.stream().mapToInt(Integer::intValue).toArray());
        this.getView().updateView(RIGHT_ENTITY);
    }

    private QFilter[] getFilters() {
        Long groupId = this.getGroupId();
        if (groupId != null) {
            QFilter qFilter;
            QFilter idFilter = groupId == 0L ? new QFilter("1", "=", (Object)1) : new QFilter(this.getGroupField(), "=", (Object)groupId);
            if (this.leftEntityIsTree()) {
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)this.getLeftEntity(), (String)"longnumber", (QFilter[])new QFilter[]{idFilter});
                qFilter = idFilter.or(new QFilter("longnumber", "like", (Object)(dynamicObject.getString("longnumber") + "!%")));
            } else {
                qFilter = idFilter;
            }
            return qFilter.toArray();
        }
        return null;
    }

    private void listNode(DynamicObjectTreeNode node, List<DynamicObjectTreeNode> nodeList) {
        nodeList.add(node);
        List children = node.getChildren();
        for (DynamicObjectTreeNode child : children) {
            this.listNode(child, nodeList);
        }
    }

    protected Map<String, Object> packageData(DynamicObject dynamicObject, Set<String> queryColumns) {
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("id", dynamicObject.get("id"));
        data.put("pid", dynamicObject.get("parent"));
        for (String column : queryColumns) {
            data.put(column, dynamicObject.get(column));
        }
        return data;
    }

    private List<FieldEdit> getRightEntityColumns() {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(RIGHT_ENTITY);
        return treeEntryGrid.getFieldEdits();
    }

    private Set<String> getRightEntityQueryColumns(String rightEntity, List<FieldEdit> fieldEdits) {
        if (this.QUERY_COLUMNS == null) {
            this.QUERY_COLUMNS = new HashSet<String>(fieldEdits.size());
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)rightEntity);
            List properties = dataEntityType.getProperties().stream().map(e -> e.getName()).collect(Collectors.toList());
            for (FieldEdit fieldEdit : fieldEdits) {
                String fieldKey = fieldEdit.getFieldKey();
                if (!properties.contains(fieldKey)) continue;
                this.QUERY_COLUMNS.add(fieldKey);
            }
        }
        return this.QUERY_COLUMNS;
    }

    private void createParamRow(List<DynamicObjectTreeNode> nodeList, Set<Integer> expands, List<FieldEdit> fieldEdits) {
        if (nodeList.isEmpty()) {
            return;
        }
        IDataModel dataModel = this.getModel();
        int[] rows = this.getModel().batchCreateNewEntryRow(RIGHT_ENTITY, nodeList.size());
        for (int i = 0; i < nodeList.size(); ++i) {
            DynamicObjectTreeNode dynamicObjectTreeNode = nodeList.get(i);
            int row = rows[i];
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(RIGHT_ENTITY, row);
            Map rowData = dynamicObjectTreeNode.getData();
            dynamicObject.set("id", rowData.get("id"));
            dynamicObject.set("pid", rowData.get("pid"));
            for (FieldEdit fieldEdit : fieldEdits) {
                String fieldKey = fieldEdit.getFieldKey();
                Object data = rowData.get(fieldKey);
                if (fieldEdit instanceof BasedataEdit) {
                    dataModel.setValue(fieldKey, data);
                    continue;
                }
                dynamicObject.set(fieldKey, data);
            }
            List children = dynamicObjectTreeNode.getChildren();
            if (children.isEmpty()) continue;
            expands.add(row);
            dynamicObject.set("isgroupnode", (Object)true);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "left_new": 
            case "left_edit": 
            case "left_delete": {
                this.initLeftTree();
                break;
            }
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        Object source = cellClickEvent.getSource();
        String fieldKey = cellClickEvent.getFieldKey();
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        Object source = cellClickEvent.getSource();
        String fieldKey = cellClickEvent.getFieldKey();
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        if ("number".equals(fieldName)) {
            Long pkValue = (Long)this.getModel().getEntryRowEntity(RIGHT_ENTITY, rowIndex).getPkValue();
            this.rightEdit(pkValue);
        }
    }
}

