/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.log;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.bean.AppConfigPropBean;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.configuration.enums.IAppConfigProp;
import kd.epm.epbs.common.configuration.factory.ConfigurationContext;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.util.ExportUtil;
import kd.epm.epbs.common.util.ModelUtil;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;

public class FunctionPermLogListPlugin
extends AbstractBaseListPlugin
implements SetFilterListener {
    private static final String BILLLISTAP = "billlistap";
    private static final String TOOLBARAP = "toolbarap";
    private static final String FILTERCONTAINER = "filtercontainerap";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_EXPORT = "btn_export";
    private static final String MODEL = "model";
    private static final String MODELID = "modelid";
    private static final String APPNUMBER = "appnumber";
    private static Long RoleModelId = 17299999999L;

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTERCONTAINER);
        filterContainer.getContext();
        filterContainer.setBillFormId("epbs_functionpermlog");
        filterContainer.addSearchClickListener(this::doRefreshBillList);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addSetFilterListener((SetFilterListener)this);
        billList.addCreateListColumnsListener(this::beforeCreateListColumns);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARAP});
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        for (IListColumn listColumn : args.getListColumns()) {
            if (!"isunionperm".equals(listColumn.getListFieldKey())) continue;
            listColumn.setVisible(this.isCMorRpt() ? 11 : 0);
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection dynamicObjects;
        super.afterCreateNewData(e);
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (modelId == null && !(dynamicObjects = QueryServiceHelper.query((String)"epbs_model", (String)"id", null)).isEmpty()) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
            modelId = dynamicObject.getString("id");
        }
        if (modelId != null) {
            this.getPageCache().put(MODELID, modelId);
            this.getModel().setValue(MODEL, (Object)modelId);
            this.refreshBillList(Long.parseLong(modelId));
        }
        this.showControl();
    }

    public boolean isCMorRpt() {
        long modelId = this.getModelId();
        if (modelId > 0L) {
            AppTypeEnum appType = ModelUtil.getAppType((Long)modelId);
            return AppTypeEnum.RPT == appType || AppTypeEnum.CM == appType;
        }
        return false;
    }

    public void showControl() {
        this.getView().setVisible(Boolean.valueOf(this.isCMorRpt()), new String[]{"btn_queryold"});
    }

    private void doRefreshBillList(SearchClickEvent evt) {
        FilterParameter filterParameter = evt.getFilterParameter();
        List fastQFilters = evt.getFastQFilters();
        List commonFilters = filterParameter.getQFilters();
        String modelId = this.getPageCache().get(MODELID);
        if (modelId != null) {
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            ArrayList<Long> modelIds = new ArrayList<Long>();
            modelIds.add(RoleModelId);
            modelIds.add(Long.parseLong(modelId));
            QFilter qFilter = new QFilter(MODELID, "in", modelIds);
            if (fastQFilters != null && fastQFilters.size() > 0) {
                for (QFilter fastFilter : fastQFilters) {
                    qFilter.and(fastFilter);
                }
            }
            if (commonFilters != null && commonFilters.size() > 0) {
                for (QFilter commonFilter : commonFilters) {
                    qFilter.and(commonFilter);
                }
            }
            billList.clearSelection();
            billList.getFilterParameter().getQFilters().add(qFilter);
            billList.refresh();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String changeModel = e.getProperty().getName();
        if (MODEL.equals(changeModel)) {
            this.getPageCache().put(MODELID, this.getModelId() + "");
            this.showControl();
            this.refreshBillList(this.getModelId());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "btn_refresh": {
                String modelId = this.getPageCache().get(MODELID);
                if (modelId == null) break;
                this.refreshBillList(Long.parseLong(modelId));
                break;
            }
            case "btn_queryold": {
                FormShowParameter formparam = new FormShowParameter();
                formparam.setFormId(ConfigurationContext.INSTANCE.loadProp(AppTypeEnum.CM.getAppNum(), (IAppConfigProp)new AppConfigPropBean("functionpermlog.formid", "bcm_functionperm_log")));
                formparam.setParentPageId(this.getView().getPageId());
                formparam.setHasRight(true);
                formparam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formparam.getCustomParams().put(MODEL, this.getModelId());
                this.getView().showForm(formparam);
                break;
            }
            case "btn_export": {
                MainEntityType dataEntityType;
                String selectsql;
                DynamicObject[] load;
                String modelId1 = this.getPageCache().get(MODELID);
                if (modelId1 == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"FunctionPermLogListPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                ArrayList<Long> modelIds = new ArrayList<Long>();
                modelIds.add(this.getModelId());
                if (this.getModelId() != 0L) {
                    modelIds.add(RoleModelId);
                }
                QFilter filter = new QFilter(MODELID, "in", modelIds);
                filter.and(APPNUMBER, "=", (Object)this.getView().getFormShowParameter().getAppId());
                BillList list = (BillList)this.getControl(BILLLISTAP);
                if (list.getSelectedRows().size() != 0) {
                    ListSelectedRowCollection rows = list.getSelectedRows();
                    ArrayList<Object> ids = new ArrayList<Object>();
                    for (ListSelectedRow row : rows) {
                        ids.add(row.getPrimaryKeyValue());
                    }
                    filter.and("id", "in", ids);
                }
                if ((load = BusinessDataServiceHelper.load((String)"epbs_functionpermlog", (String)(selectsql = (dataEntityType = MetadataServiceHelper.getDataEntityType((String)"epbs_functionpermlog")).getProperties().stream().map(e -> e.getName()).collect(Collectors.joining(","))), (QFilter[])filter.toArray())).length < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u6570\u636e\u5bfc\u51fa\u3002", (String)"FunctionPermLogListPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                try {
                    String url = ExportUtil.export((DynamicObject[])load, (String)AppTypeEnum.EPBS.getAppId(), (String)"epbs_functionpermlog", (String)ResManager.loadKDString((String)"\u4f53\u7cfb\u529f\u80fd\u6743\u9650\u65e5\u5fd7", (String)"FunctionPermLogListPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    if (StringUtils.isNotEmpty((CharSequence)url)) {
                        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
                    }
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
                this.writeLog((IOperationTypeInfo)OperationTypeEnum.EXPORT, new MultiLangEnumBridge("\u4f53\u7cfb\u529f\u80fd\u6743\u9650\u65e5\u5fd7\u5bfc\u51fa\u6210\u529f\u3002", "FunctionPermLogListPlugin_4", "epm-epbs-formplugin"));
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        String modelId = this.getPageCache().get(MODELID);
        if (modelId != null) {
            ArrayList<Long> modelIds = new ArrayList<Long>();
            modelIds.add(RoleModelId);
            modelIds.add(Long.parseLong(modelId));
            QFilter modelFilter = new QFilter(MODELID, "in", modelIds);
            QFilter appFilter = new QFilter(APPNUMBER, "=", (Object)this.getView().getFormShowParameter().getAppId());
            e.getQFilters().add(modelFilter);
            e.getQFilters().add(appFilter);
            e.setOrderBy("modifytime desc");
        }
    }

    private void refreshBillList(Long modelId) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        FilterParameter filterParameter = new FilterParameter();
        ArrayList<Long> modelIds = new ArrayList<Long>();
        if (modelId != -1L) {
            modelIds.add(RoleModelId);
        }
        modelIds.add(modelId);
        QFilter modelFilter = new QFilter(MODELID, "in", modelIds);
        filterParameter.getQFilters().add(modelFilter);
        QFilter appFilter = new QFilter(APPNUMBER, "=", (Object)this.getView().getFormShowParameter().getAppId());
        filterParameter.getQFilters().add(modelFilter);
        filterParameter.getQFilters().add(appFilter);
        filterParameter.setOrderBy("modifytime desc");
        billList.setFilterParameter(filterParameter);
        billList.refresh();
        billList.clearSelection();
        billList.refreshData();
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.validateModelAdmin(e);
    }
}

