/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.log;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.formplugin.log.olap.OlapLogNewPlugin;
import org.apache.commons.lang.RandomStringUtils;

public class OlapLogHelper {
    protected static final Log log = LogFactory.getLog(OlapLogHelper.class);

    public static List<Map<String, String>> cartesianDimMember(Map<String, List<String>> dimMemberMap) {
        String sep = "@@";
        ArrayList list = Lists.newArrayListWithExpectedSize((int)dimMemberMap.size());
        for (Map.Entry<String, List<String>> entry : dimMemberMap.entrySet()) {
            list.add(entry.getValue().stream().map(e -> Joiner.on((String)sep).join(entry.getKey(), e, new Object[0])).collect(Collectors.toList()));
        }
        List<Map<String, String>> dimMemberGroups = Lists.cartesianProduct((List)list).stream().map(e -> e.stream().collect(Collectors.toMap(e1 -> e1.split(sep)[0], e1 -> e1.split(sep)[1]))).collect(Collectors.toList());
        return dimMemberGroups;
    }

    @Deprecated
    public static Long getDefaultDatasetId(Long modelId, String entityId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("number", "=", (Object)"default");
        DynamicObject datasetDoj = QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])qFilter.toArray());
        Long datasetId = null != datasetDoj ? Long.valueOf(datasetDoj.getLong("id")) : null;
        return datasetId;
    }

    public static int getPageSize() {
        int pageSize = ParamSettingServiceHelper.getInt((long)0L, (String)"POlapLogPageSize").intValue();
        return pageSize;
    }

    public static void openChildPage(AbstractFormPlugin plugin, long modelid, Consumer<FormShowParameter> consumer) {
        String formId = "epbs_olap_log_inh";
        String appnum = null;
        appnum = modelid != 0L ? ModelCacheHelper.getModel((long)modelid).getSrcAppNum() : plugin.getView().getFormShowParameter().getAppId();
        if (StringUtils.isEmpty((String)appnum)) {
            appnum = AppTypeEnum.EPBS.getAppNum();
        }
        if (AppTypeEnum.isEbApp((String)appnum)) {
            formId = "eb_olap_log_inh";
        } else if (AppTypeEnum.isCMApp((String)appnum)) {
            formId = "bcm_olap_log_inh";
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setTargetKey("flexpanelap");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        String pageId = formId + RandomStringUtils.randomAlphanumeric((int)10);
        showParameter.setFormId(formId);
        showParameter.setPageId(pageId);
        plugin.getView().getPageCache().put("childPageId", pageId);
        showParameter.setStatus(OperationStatus.ADDNEW);
        plugin.getView().getFormShowParameter().getCustomParams().forEach((k, v) -> showParameter.setCustomParam(k, v));
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)modelid);
        if (formId.equals("epbs_olap_log_inh")) {
            showParameter.addCustPlugin(OlapLogNewPlugin.class.getName());
        }
        showParameter.setSendToClient(true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "closePage"));
        if (consumer != null) {
            consumer.accept(showParameter);
        }
        plugin.getView().showForm(showParameter);
    }
}

