/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.log.olap;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.FeatureOption;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.bd.commontype.CommonTypeHelper;
import kd.epm.epbs.business.bd.model.ModelF7ParamContext;
import kd.epm.epbs.business.bd.model.ModelListHelper;
import kd.epm.epbs.business.log.CommonOlapLogListFunction;
import kd.epm.epbs.business.log.IOlapLogListFunction;
import kd.epm.epbs.business.log.audit.AuditLogBill;
import kd.epm.epbs.business.log.audit.AuditLogQueryParam;
import kd.epm.epbs.business.log.audit.OlapAuditServiceHelper;
import kd.epm.epbs.business.log.olap.OlapOpLogHelper;
import kd.epm.epbs.business.log.olap.OlapTraceResult;
import kd.epm.epbs.business.log.olap.TransactionTraceInfo;
import kd.epm.epbs.business.log.trace.TraceOpLogService;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.bean.Page;
import kd.epm.epbs.common.cache.model.Dimension;
import kd.epm.epbs.common.cache.model.Member;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.util.DateTimeUtils;
import kd.epm.epbs.common.util.EpbsOperationResult;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.JSONUtils;
import kd.epm.epbs.common.util.ModelUtil;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;
import kd.epm.epbs.formplugin.log.OlapLogHelper;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractOlapLogPlugin
extends AbstractBaseListPlugin
implements HyperLinkClickListener {
    private static final int DEFAULT_PAGE = 1;
    protected static final Log log = LogFactory.getLog(AbstractOlapLogPlugin.class);
    public static final String MODEL = "model";
    public static final String START_DATETIME = "startdatetime";
    public static final String END_DATETIME = "enddatetime";
    public static final String TRANSACTIONTYPE = "transactiontype";
    public static final String USERS = "users";
    public static final String DIMENSION_LIST = "dimensionList";
    public static final String OPTYPE_LIST = "opTypeList";
    public static final String CUBENUMBER = "cubeNumber";
    public static final String MEMBER_MAP = "memberMap";
    public static final String BARITEMSHOWLOG = "baritemshowlog";
    public static final String BARITEMREFRESH = "baritemrefresh";
    public static final String BARITEMRESET = "baritemreset";
    private static final String SEL_MEMBER_AP = "selmemberap";
    public static final String all_f7_key_prefix = "f7_";
    private static final String LISTFLEX = "listflex";
    public static final String PAGE_TYPE = "type";
    public static final String PAGE_TYPE_AUDIT = "1";
    public static final String PAGE_TYPE_TRACE = "2";
    public static final String OPTYPE_CATEGORY = "olapoptype";
    public static final String OPTYPE_APPNUM = "olapoptype_appnum";
    private static final String ValidateQueryParam = "ValidateQueryParam";
    private static final String IsRefresh = "IsRefresh";
    private Map<String, String> dim_f7Key;
    public static final String F7_MAPPING_CACHE = "f7_mapping_cache";
    public static final String _ID = "_id";
    private static final String ENTRYENTITY = "entryentity";
    private static final String COL_EVENTID = "eventid";
    private static final String COL_IPFIELD = "ipfield";
    private static final String COL_OPUSER = "opuser";
    private static final String COL_OPTYPE = "transaction";
    private static final String COL_OPTIME = "optime";
    private static final String COL_AMOUNT = "amount";
    private static final String COL_OPTARGET = "optargetinfo";
    private static final String COL_TRACEID = "traceid";
    private static final String COL_TRANSACTIONID = "transactionid";
    private static final String KEY_LAST_TIMEQUERYPARAM = "lastTimeQueryParam";
    public static final String FIRST_VISIT_FLAG = "firstvisitPage";
    private static final List<ThreeTuple<String, MultiLangEnumBridge, Class<?>>> ColumnListAudit = Lists.newArrayList((Object[])new ThreeTuple[]{new ThreeTuple((Object)"eventid", (Object)new MultiLangEnumBridge("\u4e8b\u4ef6ID", "AbstractOlapLogPlugin_1", "epm-epbs-formplugin"), TextEdit.class), new ThreeTuple((Object)"opuser", (Object)new MultiLangEnumBridge("\u7528\u6237", "AbstractOlapLogPlugin_2", "epm-epbs-formplugin"), TextEdit.class), new ThreeTuple((Object)"ipfield", (Object)new MultiLangEnumBridge("IP\u5730\u5740", "AbstractOlapLogPlugin_3", "epm-epbs-formplugin"), TextEdit.class), new ThreeTuple((Object)"transaction", (Object)new MultiLangEnumBridge("\u64cd\u4f5c", "AbstractOlapLogPlugin_4", "epm-epbs-formplugin"), TextEdit.class), new ThreeTuple((Object)"optime", (Object)new MultiLangEnumBridge("\u64cd\u4f5c\u65f6\u95f4", "AbstractOlapLogPlugin_5", "epm-epbs-formplugin"), DateTimeEdit.class), new ThreeTuple((Object)"amount", (Object)new MultiLangEnumBridge("\u91d1\u989d", "AbstractOlapLogPlugin_6", "epm-epbs-formplugin"), TextEdit.class), new ThreeTuple((Object)"dimcomplex", (Object)new MultiLangEnumBridge("\u7ef4\u5ea6\u7ec4\u5408", "AbstractOlapLogPlugin_7", "epm-epbs-formplugin"), Container.class)});
    private static final List<ThreeTuple<String, MultiLangEnumBridge, Class<?>>> ColumnListTrace = Lists.newArrayList((Object[])new ThreeTuple[]{new ThreeTuple((Object)"opuser", (Object)new MultiLangEnumBridge("\u7528\u6237", "AbstractOlapLogPlugin_2", "epm-epbs-formplugin"), TextEdit.class), new ThreeTuple((Object)"transaction", (Object)new MultiLangEnumBridge("\u64cd\u4f5c", "AbstractOlapLogPlugin_4", "epm-epbs-formplugin"), TextEdit.class), new ThreeTuple((Object)"optargetinfo", (Object)new MultiLangEnumBridge("\u64cd\u4f5c\u5bf9\u8c61", "AbstractOlapLogPlugin_8", "epm-epbs-formplugin"), TextEdit.class), new ThreeTuple((Object)"optime", (Object)new MultiLangEnumBridge("\u64cd\u4f5c\u65f6\u95f4", "AbstractOlapLogPlugin_5", "epm-epbs-formplugin"), DateTimeEdit.class), new ThreeTuple((Object)"amount", (Object)new MultiLangEnumBridge("\u503c", "AbstractOlapLogPlugin_9", "epm-epbs-formplugin"), TextEdit.class), new ThreeTuple((Object)"dimcomplex", (Object)new MultiLangEnumBridge("\u7ef4\u5ea6\u7ec4\u5408", "AbstractOlapLogPlugin_7", "epm-epbs-formplugin"), Container.class), new ThreeTuple((Object)"traceid", (Object)new MultiLangEnumBridge("\u64cd\u4f5c\u65e5\u5fd7", "AbstractOlapLogPlugin_10", "epm-epbs-formplugin"), TextEdit.class), new ThreeTuple((Object)"transactionid", (Object)new MultiLangEnumBridge("\u591a\u7ef4\u6307\u4ee4", "AbstractOlapLogPlugin_11", "epm-epbs-formplugin"), TextEdit.class)});
    private FormShowParameter formShowParameter = null;
    private static final Set<String> OlapHyperlinkFields = Sets.newHashSet((Object[])new String[]{"traceid", "transactionid"});

    public void initialize() {
        super.initialize();
        this.beforeBindEntryGrid(ENTRYENTITY);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            MainEntityType entityType = (MainEntityType)e.getOriginalEntityType().clone();
            this.registDimDynamicProps(entityType);
            this.registEntryEntityDynamicProps(entityType);
            e.setNewEntityType(entityType);
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public long getModelId() {
        return IDUtils.toLong((Object)this.getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
    }

    private void putListtips(long total, long size) {
        Label title = (Label)this.getControl("listtips");
        if (total > size) {
            title.setText(ResManager.loadResFormat((String)"\u5171%1\u6761, \u5217\u51fa%2\u6761", (String)"AbstractOlapLogPlugin_12", (String)"epm-epbs-formplugin", (Object[])new Object[]{total, size}));
        } else {
            title.setText(ResManager.loadResFormat((String)"\u5171%1\u6761", (String)"AbstractOlapLogPlugin_13", (String)"epm-epbs-formplugin", (Object[])new Object[]{total}));
        }
    }

    private void registDimDynamicProps(MainEntityType newMainType) {
        for (String key : this.getDimMapping().keySet()) {
            TextProp fieldprop = new TextProp();
            fieldprop.setName(key);
            fieldprop.setDbIgnore(false);
            newMainType.registerSimpleProperty((DynamicSimpleProperty)fieldprop);
        }
    }

    protected void registEntryEntityDynamicProps(MainEntityType newMainType) {
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(ENTRYENTITY);
        List<ThreeTuple<String, MultiLangEnumBridge, Class<?>>> columnList = this.getColumnList();
        List<Dimension> dims = this.getDimensionList();
        for (ThreeTuple<String, MultiLangEnumBridge, Class<?>> field : columnList) {
            String fieldKey = (String)field.item1;
            if (field.item3 == TextEdit.class) {
                entryType.registerSimpleProperty((DynamicSimpleProperty)this.getFieldProp(fieldKey, TextProp.class));
                continue;
            }
            if (field.item3 == DateTimeEdit.class) {
                entryType.registerSimpleProperty((DynamicSimpleProperty)this.getFieldProp(fieldKey, DateTimeProp.class));
                continue;
            }
            if (field.item3 != Container.class || !CollectionUtils.isNotEmpty(dims)) continue;
            for (Dimension dim : dims) {
                String dimNumber = dim.getNumber().toLowerCase(Locale.ROOT);
                entryType.registerSimpleProperty((DynamicSimpleProperty)this.getFieldProp(dimNumber, TextProp.class));
            }
        }
        this.modifyExportFileName(newMainType);
    }

    private void modifyExportFileName(MainEntityType newMainType) {
        String exportFileName = "";
        exportFileName = this.isAuditLog() ? ResManager.loadKDString((String)"\u5ba1\u8ba1\u65e5\u5fd7", (String)"AbstractOlapLogPlugin_14", (String)"epm-epbs-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u591a\u7ef4\u6570\u636e\u53d8\u52a8\u65e5\u5fd7", (String)"AbstractOlapLogPlugin_15", (String)"epm-epbs-formplugin", (Object[])new Object[0]);
        newMainType.getProperty(ENTRYENTITY).getDisplayName().setLocaleValue(exportFileName);
    }

    private <T extends FieldProp> T getFieldProp(String propName, Class<T> clazz) {
        FieldProp prop = null;
        try {
            prop = (FieldProp)clazz.newInstance();
        }
        catch (Exception e) {
            log.error("getFieldProp newInstance error", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        prop.setName(propName);
        prop.setAlias("");
        prop.setDbIgnore(true);
        prop.setDefValue(null);
        prop.setFeatures(FeatureOption.Exportable.getValue());
        return (T)prop;
    }

    private void loadEntityData(boolean isRefresh, Map<String, Object> params) {
        AuditLogQueryParam lastTimeQueryParam;
        String transactiontype;
        this.clearEntity();
        DynamicObjectCollection usersDyn = (DynamicObjectCollection)this.getModel().getValue(USERS);
        Map dimMemberMap = (Map)params.get(MEMBER_MAP);
        List<Dimension> dimensionList = this.getDimensionList();
        Map opTypeMap = (Map)params.get(OPTYPE_LIST);
        IOlapLogListFunction function = this.getCustomFunction();
        AuditLogQueryParam queryParam = new AuditLogQueryParam(Long.valueOf(this.getModelId()), this.getCubeNumber(), (Date)this.getModel().getValue(START_DATETIME), (Date)this.getModel().getValue(END_DATETIME));
        if (CollectionUtils.isNotEmpty((Collection)usersDyn)) {
            queryParam.setUserIds((Long[])usersDyn.stream().map(e -> e.getLong("fbasedataid_id")).toArray(Long[]::new));
        }
        if (StringUtils.isNotEmpty((String)(transactiontype = ((MulBasedataDynamicObjectCollection)this.getModel().getValue(TRANSACTIONTYPE)).stream().map(e -> e.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.joining(","))))) {
            queryParam.setTransactionTag(transactiontype);
        }
        queryParam.setDimMemberMap(dimMemberMap);
        queryParam.setDimensionList(dimensionList);
        queryParam.setFunction(function);
        if (isRefresh && !queryParam.equals((Object)(lastTimeQueryParam = (AuditLogQueryParam)JSONUtils.parse((String)this.getLastTimeQueryParam(), AuditLogQueryParam.class)))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u67e5\u8be2\u6761\u4ef6\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u70b9\u51fb\u663e\u793a\u65e5\u5fd7\u6309\u94ae\u663e\u793a\u6570\u636e\u3002", (String)"AbstractOlapLogPlugin_16", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(KEY_LAST_TIMEQUERYPARAM, JSONUtils.toString((Object)queryParam));
        if (!this.isAuditLog()) {
            if (this.loadEntityDataByOlapData(params, queryParam)) {
                this.showSuccess();
            }
            return;
        }
        if (queryParam.getEndTime() == null) {
            queryParam.setEndTime(new Date());
        }
        Page pageBill = OlapAuditServiceHelper.search((AuditLogQueryParam)queryParam, (Integer)1, (Integer)OlapLogHelper.getPageSize());
        this.putInPage((Page<AuditLogBill>)pageBill, opTypeMap);
        if (StringUtils.isNotEmpty((String)pageBill.getMessage())) {
            this.getView().showTipNotification(pageBill.getMessage());
        } else {
            this.showSuccess();
        }
    }

    public void putInPage(Page<AuditLogBill> pageBill, Map<String, String> operateTypeMap) {
        this.putListtips(pageBill.getTotal(), pageBill.getSize());
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRYENTITY);
        model.getDataEntity(true);
        if (!pageBill.getRecords().isEmpty()) {
            model.beginInit();
            model.batchCreateNewEntryRow(ENTRYENTITY, pageBill.getRecords().size());
            model.endInit();
            DynamicObjectCollection entryRows = model.getEntryEntity(ENTRYENTITY);
            for (int i = 0; i < entryRows.size(); ++i) {
                DynamicObject entity = (DynamicObject)entryRows.get(i);
                AuditLogBill auditLogBill = (AuditLogBill)pageBill.getRecords().get(i);
                entity.set(COL_EVENTID, (Object)auditLogBill.getEventId());
                entity.set(COL_OPUSER, (Object)auditLogBill.getUserDy());
                entity.set(COL_IPFIELD, (Object)auditLogBill.getIp());
                if (auditLogBill.getOperateType() != null) {
                    entity.set(COL_OPTYPE, (Object)this.getOpTypeDesc(operateTypeMap, auditLogBill.getOperateType(), auditLogBill.getTransactionType()));
                }
                entity.set(COL_OPTIME, (Object)auditLogBill.getOperateTime());
                entity.set(COL_AMOUNT, (Object)auditLogBill.getNewValue());
                Map dimMemberToDojMap = auditLogBill.getDimMemberToDojMap();
                for (Map.Entry entry : dimMemberToDojMap.entrySet()) {
                    entity.set((String)entry.getKey(), entry.getValue());
                }
            }
            this.getView().updateView(ENTRYENTITY);
        }
    }

    private Map<String, Object> getQueryParam() {
        if (null != this.getView()) {
            return this.getView().getFormShowParameter().getCustomParams();
        }
        if (null != this.formShowParameter) {
            return this.formShowParameter.getCustomParams();
        }
        return Collections.emptyMap();
    }

    protected FormShowParameter getFormShowParameter() {
        if (this.formShowParameter == null) {
            this.formShowParameter = this.getView().getFormShowParameter();
        }
        return this.formShowParameter;
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        this.formShowParameter = (FormShowParameter)e.getSource();
        e.getItems().add(this.getCustomEntryEntity(ENTRYENTITY));
    }

    private Map<String, Object> getCustomEntryEntity(String entryId) {
        HashMap<String, Object> mapEntry = new HashMap<String, Object>(16);
        EntryAp entryAp = this.createEntryAp(entryId);
        mapEntry.put("id", entryId);
        mapEntry.put("columns", entryAp.createControl().get("columns"));
        return mapEntry;
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String col = arg0.getFieldName();
        if (OlapHyperlinkFields.contains(col)) {
            String value = (String)this.getModel().getValue(col, arg0.getRowIndex());
            FormShowParameter formparam = new FormShowParameter();
            formparam.setFormId(this.getEntityNumberWithOlapLogMsg());
            formparam.setParentPageId(this.getView().getPageId());
            formparam.getOpenStyle().setShowType(ShowType.Modal);
            formparam.setCustomParam(CUBENUMBER, (Object)this.getCubeNumber());
            formparam.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            formparam.setCustomParam(col, (Object)value);
            ThreeTuple column = this.getColumnList().stream().filter(e -> Objects.equals(col, e.item1)).findFirst().orElseGet(() -> null);
            formparam.setCaption(null != column ? ((MultiLangEnumBridge)column.item2).loadKDString() : "");
            this.getView().showForm(formparam);
        }
    }

    protected String getEntityNumberWithOlapLogMsg() {
        return "epbs_olap_log_msg";
    }

    protected abstract String getCubeNumber();

    /*
     * WARNING - void declaration
     */
    private boolean loadEntityDataByOlapData(Map<String, Object> params, AuditLogQueryParam queryParam) {
        Long modelId = queryParam.getModelId();
        Date startTime = queryParam.getStartTime();
        ArrayList userDojs = Lists.newArrayList();
        if (null != queryParam.getUserIds()) {
            Long[] longArray = queryParam.getUserIds();
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long user = longArray[i];
                userDojs.add(user);
            }
        }
        String transactiontype = queryParam.getTransactionTag();
        Map<String, List<String>> dimMemberMap = queryParam.getDimMemberMap().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((Set)e.getValue()).stream().collect(Collectors.toList())));
        List dimensionList = queryParam.getDimensionList();
        Map opTypeMap = (Map)params.get(OPTYPE_LIST);
        Map<String, String> opTargetList = this.getOpTargetList();
        IOlapLogListFunction function = queryParam.getFunction();
        int pageSize = ParamSettingServiceHelper.getInt((long)0L, (String)"POlapLogSize").intValue();
        ArrayList allList = Lists.newArrayList();
        boolean isError = false;
        String nextToken = "";
        List<Map<String, String>> dimMemberGroups = OlapLogHelper.cartesianDimMember(dimMemberMap);
        int groupIndex = 0;
        for (Map<String, String> map : dimMemberGroups) {
            OlapTraceResult res = OlapOpLogHelper.queryTransactionTraceInfo((Long)modelId, (String)queryParam.getCubeNumber(), map, (String)DateTimeUtils.format((Date)startTime), (int)pageSize, (String)nextToken);
            isError = OlapOpLogHelper.queryTraceError((OlapTraceResult)res, (IFormView)this.getView());
            if (isError) break;
            if (CollectionUtils.isNotEmpty((Collection)res.getInfoList())) {
                for (TransactionTraceInfo e2 : res.getInfoList()) {
                    e2.setGroupIndex(groupIndex);
                }
                allList.addAll(res.getInfoList());
            }
            ++groupIndex;
        }
        if (CollectionUtils.isEmpty((Collection)allList)) {
            return true;
        }
        this.getTraceOpLogService().fillTracemsg((List)allList, (List)userDojs, transactiontype);
        if (CollectionUtils.isEmpty((Collection)allList)) {
            return true;
        }
        HashMap dimMemberDynMap = Maps.newHashMapWithExpectedSize((int)dimensionList.size());
        for (Dimension dim : dimensionList) {
            Set memberNums = dimMemberMap.get(dim.getNumber()).stream().map(e -> null != function ? function.dealMemberNumber(dim.getNumber(), e) : e).collect(Collectors.toSet());
            dimMemberDynMap.put(dim.getNumber(), ModelUtil.getDimMemberDyn((Long)modelId, (Dimension)dim, memberNums));
        }
        int n = this.getModel().getEntryRowCount(ENTRYENTITY);
        this.getModel().beginInit();
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, allList.size());
        this.getModel().endInit();
        for (TransactionTraceInfo tti : allList) {
            void var19_25;
            this.getModel().setValue(COL_OPUSER, (Object)tti.getOpLog().getUsername(), (int)var19_25);
            this.getModel().setValue(COL_OPTIME, (Object)tti.getTime(), (int)var19_25);
            this.getModel().setValue(COL_AMOUNT, tti.getValue(), (int)var19_25);
            this.getModel().setValue(COL_OPTYPE, (Object)this.getOpTypeDesc(opTypeMap, tti.getOpLog().getOptype(), null), (int)var19_25);
            String optarget = this.getOpTargetDesc(opTargetList, tti.getOpLog().getOptarget());
            this.getModel().setValue(COL_OPTARGET, (Object)(StringUtils.isNotEmpty((String)optarget) ? Joiner.on((String)":").join((Object)optarget, (Object)(null != tti.getOpLog().getOptargetnum() ? tti.getOpLog().getOptargetnum() : ""), new Object[0]) : ""), (int)var19_25);
            this.getModel().setValue(COL_TRACEID, (Object)(null != tti.getTraceId() ? TraceIdUtil.idToHex((long)tti.getTraceId()) : ""), (int)var19_25);
            this.getModel().setValue(COL_TRANSACTIONID, (Object)tti.getTransactionId(), (int)var19_25);
            for (Map.Entry<String, String> entry : dimMemberGroups.get(tti.getGroupIndex()).entrySet()) {
                String memberNumber = null != function ? function.dealMemberNumber(entry.getKey(), entry.getValue()) : entry.getValue();
                DynamicObject member = (DynamicObject)((Map)dimMemberDynMap.get(entry.getKey())).get(memberNumber);
                this.getModel().setValue(entry.getKey().toLowerCase(Locale.ROOT), (Object)ModelUtil.getMemberInfoStr((String)memberNumber, (DynamicObject)member), (int)var19_25);
            }
            ++var19_25;
        }
        this.getView().updateView(ENTRYENTITY);
        this.putListtips(allList.size(), OlapLogHelper.getPageSize());
        return true;
    }

    protected TraceOpLogService getTraceOpLogService() {
        return TraceOpLogService.getInstance();
    }

    protected String getOpTypeDesc(Map<String, String> opTypeMap, String optype, String formId) {
        return opTypeMap.get(optype);
    }

    private void showSuccess() {
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f\u3002", (String)"AbstractOlapLogPlugin_17", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
    }

    protected Map<String, String> getOpTargetList() {
        return Collections.emptyMap();
    }

    protected String getOpTargetDesc(Map<String, String> opTargetList, String optarget) {
        String optargetDesc = null != opTargetList ? opTargetList.get(optarget) : null;
        return StringUtils.isNotEmpty((String)optargetDesc) ? optargetDesc : optarget;
    }

    private String getLastTimeQueryParam() {
        return this.getPageCache().get(KEY_LAST_TIMEQUERYPARAM);
    }

    protected IOlapLogListFunction getCustomFunction() {
        return new CommonOlapLogListFunction();
    }

    private List<ThreeTuple<String, MultiLangEnumBridge, Class<?>>> getColumnList() {
        return this.isAuditLog() ? ColumnListAudit : ColumnListTrace;
    }

    private void cacheF7MappingKey() {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put(F7_MAPPING_CACHE, this.dim_f7Key == null || this.dim_f7Key.size() == 0 ? null : ObjectSerialUtil.toByteSerialized(this.dim_f7Key));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addBasedataListener(TRANSACTIONTYPE, USERS);
        ((EntryGrid)this.getControl(ENTRYENTITY)).addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ((Container)this.getControl("filterflexcontainer")).setCollapse(false);
        this.initData();
        this.setDefaultValue();
        this.showDimComponents();
        this.setMemberFromParam();
        this.getView().setVisible(Boolean.valueOf(this.isAuditLog()), new String[]{END_DATETIME});
        this.customView();
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("custom_member")) {
            this.getView().addClientCallBack("trace_query", Integer.valueOf(100));
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if ("trace_query".equals(e.getName())) {
            try {
                this.getView().showLoading(ResManager.getLocaleString((String)"\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u5019...", (String)"AbstractOlapLogPlugin_18", (String)"epm-epbs-formplugin"));
                this.loadEntityData(false, true);
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
            }
            finally {
                this.getView().hideLoading();
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.startsWith(all_f7_key_prefix)) {
            Map<String, String> dimMapping = this.getDimMapping();
            String dimNumber = dimMapping.get(key);
            this.openF7(key, dimNumber);
        }
    }

    public List<Long> getMemberIdsFromCache(String f7Key) {
        String ids = this.getPageCache().get(f7Key + _ID);
        if (ids != null) {
            return (List)SerializationUtils.fromJsonString((String)ids, List.class);
        }
        return null;
    }

    public List<String> getMemberNumbersFromCache(String f7Key) {
        String numbers = this.getPageCache().get(f7Key);
        if (numbers != null) {
            return (List)SerializationUtils.fromJsonString((String)numbers, List.class);
        }
        return null;
    }

    protected abstract void openF7(String var1, String var2);

    protected void initData() {
        Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        this.getModel().setValue(MODEL, (Object)modelId);
    }

    protected boolean isCreateDimComponent() {
        Long modelId = this.getModelId();
        return IDUtils.isEmptyLong((Long)modelId) == false;
    }

    private void showDimComponents() {
        if (this.isCreateDimComponent()) {
            FieldsetPanelAp fieldsetpanelap = new FieldsetPanelAp();
            fieldsetpanelap.setKey(SEL_MEMBER_AP);
            fieldsetpanelap.setGrow(0);
            this.addF7Items((ContainerAp<Container>)fieldsetpanelap, this.getDimensionList());
            this.getView().updateControlMetadata(SEL_MEMBER_AP, fieldsetpanelap.createControl());
            this.cacheF7MappingKey();
            this.getView().updateView(SEL_MEMBER_AP);
            this.registDimDynamicProps(this.getModel().getDataEntityType());
            this.getModel().getDataEntity().getLastDirty().set(1, true);
            this.getModel().updateCache();
        }
    }

    public void setMemberFromParam() {
        Object membersObj = this.getView().getFormShowParameter().getCustomParams().get("custom_member");
        List enableFalse = (List)this.getView().getFormShowParameter().getCustomParam("enable_false");
        if (membersObj == null) {
            return;
        }
        if (!(membersObj instanceof Map)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u53c2\u6570\u9519\u8bef\u3002", (String)"AbstractOlapLogPlugin_19", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        Map memberMap = (Map)membersObj;
        Map<String, String> dimMapping = this.getDimMapping();
        dimMapping.forEach((f7key, dimNumber) -> {
            Member member = this.getMemberByNumber((String)dimNumber, (String)memberMap.get(dimNumber));
            if (member != null) {
                this.cacheMemberIds((String)f7key, Collections.singletonList(member.getId()));
                this.cacheMemberNumbers((String)f7key, Collections.singletonList(member.getNumber()));
                this.getModel().setValue(f7key, (Object)member.getName());
                if (null != enableFalse && enableFalse.contains(f7key.replace(all_f7_key_prefix, ""))) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{f7key});
                }
                this.getView().updateView(f7key);
            }
        });
    }

    public void cacheMemberIds(String f7Key, List<Long> ids) {
        this.getPageCache().put(f7Key + _ID, SerializationUtils.toJsonString(ids));
    }

    public void cacheMemberNumbers(String f7Key, List<String> numbers) {
        this.getPageCache().put(f7Key, SerializationUtils.toJsonString(numbers));
    }

    public Map<String, String> getDimMapping() {
        if (MapUtils.isEmpty(this.dim_f7Key)) {
            String f7serial = this.getPageCache().get(F7_MAPPING_CACHE);
            if (f7serial == null) {
                f7serial = (String)this.getView().getFormShowParameter().getCustomParam("f7_mapping_key");
            }
            this.dim_f7Key = new HashMap<String, String>(16);
            if (StringUtils.isNotEmpty((String)f7serial)) {
                this.dim_f7Key = (Map)ObjectSerialUtil.deSerializedBytes((String)f7serial);
            }
        }
        return this.dim_f7Key;
    }

    protected abstract Member getMemberByNumber(String var1, String var2);

    protected abstract Set<String> getSingleDims();

    protected abstract List<Dimension> getDimensionList();

    private void addF7Items(ContainerAp<Container> pageViewPanel, List<Dimension> dimensionList) {
        Set<String> singleDims = this.getSingleDims();
        for (Dimension dimension : dimensionList) {
            EntryFieldAp f7Field = new EntryFieldAp();
            f7Field.setName(new LocaleString(dimension.getName()));
            String dimensionNumber = dimension.getNumber();
            String f7key = all_f7_key_prefix + dimensionNumber.toLowerCase();
            this.dim_f7Key.put(f7key, dimensionNumber);
            f7Field.setKey(f7key);
            f7Field.setLabelDirection("v");
            f7Field.setShowTitle(false);
            TextField basedata = new TextField();
            basedata.setId(f7key);
            basedata.setKey(f7key);
            basedata.setEditStyle(1);
            if (singleDims.contains(dimensionNumber)) {
                basedata.setTextBtnIcon("kdfont kdfont-f");
            }
            if (!this.isAuditLog()) {
                basedata.setMustInput(true);
            }
            f7Field.setShowTitle(true);
            f7Field.setField((Field)basedata);
            f7Field.setFieldTextAlign("center");
            f7Field.setAlignSelf("center");
            f7Field.setTextAlign("left");
            f7Field.setFontSize(12);
            Style style = new Style();
            Margin margin = new Margin();
            margin.setRight("10px");
            margin.setTop("20px");
            margin.setBottom("10px");
            style.setMargin(margin);
            f7Field.setStyle(style);
            this.customStyle(f7Field);
            f7Field.setFireUpdEvt(true);
            pageViewPanel.getItems().add(f7Field);
            this.addClickListeners(new String[]{f7key});
        }
    }

    protected void customStyle(EntryFieldAp f7Field) {
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String propName = event.getProperty().getName();
        if ((TRANSACTIONTYPE.equals(propName) || USERS.equals(propName)) && IDUtils.isEmptyLong((Long)this.getModelId()).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AbstractOlapLogPlugin_20", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        if (TRANSACTIONTYPE.equals(event.getProperty().getName())) {
            event.getCustomQFilters().add(this.getOpTypeQfilter());
            event.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u64cd\u4f5c\u5217\u8868", (String)"AbstractOlapLogPlugin_21", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public ModelF7ParamContext getModelF7Param() {
        ModelF7ParamContext ctx = ModelListHelper.createTempModelF7Ctx((FormShowParameter)this.getView().getFormShowParameter());
        if (this.isAuditLog()) {
            ctx.getQueryAppTypes().remove(AppTypeEnum.EB);
            ctx.getQueryAppTypes().remove(AppTypeEnum.BG);
        }
        ctx.setEntityNumber(this.getView().getEntityId());
        return ctx;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String itemKey;
        switch (itemKey = e.getProperty().getName()) {
            case "model": {
                long modelId = IDUtils.toLong2((Object)e.getChangeSet()[0].getNewValue());
                long modelIdold = IDUtils.toLong2((Object)e.getChangeSet()[0].getOldValue());
                if (modelId == modelIdold) break;
                this.switchPage((Consumer<Map<String, Object>>)((Consumer)m -> m.put("KEY_MODEL_ID", modelId)));
                break;
            }
            case "startdatetime": {
                ((DateTimeEdit)this.getControl(END_DATETIME)).setMinDate((Date)this.getModel().getValue(itemKey));
                break;
            }
            case "enddatetime": {
                ((DateTimeEdit)this.getControl(START_DATETIME)).setMaxDate((Date)this.getModel().getValue(itemKey));
                break;
            }
            default: {
                Object value;
                if (!this.getDimMapping().containsKey(itemKey) || (value = this.getModel().getValue(itemKey)) != null && !StringUtils.isEmpty((String)String.valueOf(value))) break;
                this.clearMemberCache(itemKey);
            }
        }
    }

    protected void switchPage(Consumer<Map<String, Object>> consumer) {
        HashMap map = new HashMap(16);
        EpbsOperationResult res = new EpbsOperationResult();
        res.setData(map);
        consumer.accept(map);
        this.getView().returnDataToParent((Object)res);
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent cbe) {
        super.closedCallBack(cbe);
        String key = cbe.getActionId();
        if (key.startsWith(all_f7_key_prefix)) {
            Object returnData = cbe.getReturnData();
            this.f7ClosedCallBack(key, returnData);
        }
    }

    protected void f7ClosedCallBack(String f7Key, Object returnData) {
        if (ObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        ListSelectedRowCollection selectedRowCollection = (ListSelectedRowCollection)returnData;
        ArrayList<String> names = new ArrayList<String>(selectedRowCollection.size());
        ArrayList<Long> ids = new ArrayList<Long>(selectedRowCollection.size());
        ArrayList<String> numbers = new ArrayList<String>(selectedRowCollection.size());
        for (ListSelectedRow data : selectedRowCollection) {
            ids.add((Long)data.getPrimaryKeyValue());
            numbers.add(data.getNumber());
            names.add(data.getName());
        }
        this.getModel().setValue(f7Key, (Object)String.join((CharSequence)",", names));
        this.cacheMemberNumbers(f7Key, numbers);
        this.cacheMemberIds(f7Key, ids);
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (!Objects.equals("baritemexit", evt.getItemKey()) && IDUtils.isEmptyLong((Long)this.getModelId()).booleanValue()) {
            return;
        }
        super.beforeItemClick(evt);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Long modelId = this.getModelId();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return;
        }
        super.beforeDoOperation(args);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "baritemshowlog": 
            case "baritemrefresh": {
                Optional<String> validateMsg = this.validate();
                if (validateMsg.isPresent()) {
                    this.getView().showTipNotification(validateMsg.get());
                    return;
                }
                this.loadEntityData(!BARITEMSHOWLOG.equals(itemKey), true);
                break;
            }
            case "baritemreset": {
                if (!this.reset()) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u6210\u529f\u3002", (String)"AbstractOlapLogPlugin_22", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                break;
            }
            case "exportentry": {
                Button button = (Button)this.getControl("export");
                button.click();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            return;
        }
        switch (callBackId) {
            case "ValidateQueryParam": {
                this.loadEntityData(Boolean.parseBoolean(this.getPageCache().get(IsRefresh)), false);
                break;
            }
        }
    }

    protected boolean reset() {
        this.setDefaultValue();
        this.getModel().setValue(END_DATETIME, null);
        this.getModel().setValue(USERS, null);
        this.getModel().setValue(TRANSACTIONTYPE, null);
        this.getView().updateView();
        this.clearDimSelect();
        this.clearEntity();
        this.getView().updateView();
        this.getPageCache().remove(KEY_LAST_TIMEQUERYPARAM);
        return true;
    }

    private void clearEntity() {
        int entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        if (entryRowCount > 0) {
            this.getModel().deleteEntryData(ENTRYENTITY);
        }
        Label title = (Label)this.getControl("listtips");
        title.setText(ResManager.loadResFormat((String)"\u5171%1\u6761", (String)"AbstractOlapLogPlugin_13", (String)"epm-epbs-formplugin", (Object[])new Object[]{0}));
    }

    private void clearDimSelect() {
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        Map allEntities = dataEntityType.getAllEntities();
        EntityType epmAuditLogFields = (EntityType)allEntities.get(this.getView().getEntityId());
        Map fieldsMap = epmAuditLogFields.getFields();
        fieldsMap.forEach((key, v) -> {
            if (key.startsWith(all_f7_key_prefix)) {
                this.clearMemberCache((String)key);
                this.getModel().setValue(key, null);
            }
        });
        this.clearEntity();
    }

    public void clearMemberCache(String f7Key) {
        this.getPageCache().remove(f7Key + _ID);
        this.getPageCache().remove(f7Key);
    }

    private void setDefaultValue() {
        LocalDate now = LocalDate.now();
        ZonedDateTime zonedDateTime = now.atStartOfDay().atZone(ZoneId.systemDefault());
        Date startTime = Date.from(zonedDateTime.toInstant());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startTime);
        if (!this.isAuditLog()) {
            calendar.set(6, calendar.get(6) - 3);
        }
        startTime = calendar.getTime();
        String cusStartTime = (String)this.getView().getFormShowParameter().getCustomParam("start_time");
        if (StringUtils.isNotEmpty((String)cusStartTime)) {
            try {
                startTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(cusStartTime);
            }
            catch (ParseException e) {
                log.error("parse startTime error:{}", (Object)cusStartTime);
            }
        }
        this.getModel().setValue(START_DATETIME, (Object)startTime);
        DateTimeEdit dateEdit = (DateTimeEdit)this.getControl(END_DATETIME);
        dateEdit.setMinDate(startTime);
    }

    protected Optional<String> validate() {
        boolean needValidAudit;
        IDataModel model = this.getModel();
        DynamicObject modelValue = (DynamicObject)model.getValue(MODEL);
        if (Objects.isNull(modelValue)) {
            return Optional.of(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AbstractOlapLogPlugin_23", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        Date startTime = (Date)model.getValue(START_DATETIME);
        if (Objects.isNull(startTime)) {
            return Optional.of(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u5f00\u59cb\u65f6\u95f4\u3002", (String)"AbstractOlapLogPlugin_24", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        Date endTime = (Date)model.getValue(END_DATETIME);
        if (endTime == null) {
            endTime = new Date();
        }
        if (startTime.getTime() > new Date().getTime()) {
            return Optional.of(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4\u3002", (String)"AbstractOlapLogPlugin_25", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        if (startTime.getTime() > endTime.getTime()) {
            return Optional.of(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\u3002", (String)"AbstractOlapLogPlugin_26", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        boolean bl = needValidAudit = !Objects.equals(Boolean.FALSE.toString(), this.getView().getFormShowParameter().getCustomParam("need_valid_audit"));
        if (this.isAuditLog() && needValidAudit && !OlapAuditServiceHelper.isOpenAudit((Long)this.getModelId())) {
            return Optional.of(ResManager.loadKDString((String)"\u672a\u5f00\u542f\u5ba1\u8ba1\u65e5\u5fd7\u3002", (String)"AbstractOlapLogPlugin_27", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    private boolean validateQueryParam(Map<String, Object> params, boolean check) {
        if (!this.isAuditLog()) {
            Map<String, Set<String>> dimMemberMap = this.getMemberMap();
            long emptyCount = dimMemberMap.entrySet().stream().filter(e -> CollectionUtils.isEmpty((Collection)((Collection)e.getValue()))).count();
            List<Dimension> dimensionList = this.getDimensionList();
            if (dimMemberMap.size() < dimensionList.size() || emptyCount > 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b8c\u6574\u7ef4\u5ea6\u3002", (String)"AbstractOlapLogPlugin_28", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return false;
            }
            int maxQueryCount = ParamSettingServiceHelper.getInt((long)0L, (String)"POlapLogMaxQueryCount").intValue();
            long groupSize = 1L;
            for (Map.Entry<String, Set<String>> entry : dimMemberMap.entrySet()) {
                groupSize *= (long)entry.getValue().size();
            }
            if (check) {
                String msg;
                if (groupSize > 10000L) {
                    msg = ResManager.loadKDString((String)"\u9009\u62e9\u4e0a\u7ea7\u6210\u5458\u4f1a\u67e5\u8be2\u6240\u6709\u4e0b\u7ea7\u660e\u7ec6\u6210\u5458\u7684\u6570\u636e\uff0c\u4e0d\u652f\u6301\u67e5\u8be2\u7ef4\u5ea6\u6210\u5458\u7ec4\u5408\u4e2a\u6570\u8d85\u8fc710000\uff0c\u8bf7\u7f29\u5c0f\u67e5\u8be2\u6570\u636e\u8303\u56f4\u3002", (String)"AbstractOlapLogPlugin_29", (String)"epm-epbs-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(msg);
                    return false;
                }
                if (groupSize > (long)maxQueryCount) {
                    msg = ResManager.loadKDString((String)"\u9009\u62e9\u6210\u5458\u8303\u56f4\u8f83\u5927\uff0c\u9884\u8ba1\u8017\u65f6\u8f83\u957f\uff0c\u662f\u5426\u786e\u5b9a\u6267\u884c\u8be5\u64cd\u4f5c\uff1f", (String)"AbstractOlapLogPlugin_30", (String)"epm-epbs-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(ValidateQueryParam, (IFormPlugin)this));
                    return false;
                }
            }
        }
        return true;
    }

    public Map<String, Object> getDim() {
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put(MEMBER_MAP, this.getMemberMap());
        data.put(CUBENUMBER, this.getCubeNumber());
        data.put(DIMENSION_LIST, this.getDimensionList());
        return data;
    }

    protected abstract Map<String, Set<String>> getMemberMap();

    private void loadEntityData(boolean isRefresh, boolean check) {
        Map<String, Object> params = this.getDim();
        params.put("KEY_MODEL_ID", this.getModelId());
        List optypeList = ((MulBasedataDynamicObjectCollection)this.getModel().getValue(TRANSACTIONTYPE)).stream().map(e -> e.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toList());
        params.put(TRANSACTIONTYPE, Joiner.on((String)",").join(optypeList));
        params.put(START_DATETIME, this.getModel().getValue(START_DATETIME));
        params.put(END_DATETIME, this.getModel().getValue(END_DATETIME));
        DynamicObjectCollection usersDyn = (DynamicObjectCollection)this.getModel().getValue(USERS);
        params.put(USERS, usersDyn.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toList()));
        params.put(OPTYPE_LIST, this.getOpTypeList());
        if (this.validateQueryParam(params, check)) {
            this.loadEntityData(isRefresh, params);
            if (!isRefresh) {
                OperationLogUtil.writeLog((String)this.getFormShowParameter().getAppId(), (String)this.getFormShowParameter().getParentFormId(), (IOperationTypeInfo)OperationTypeEnum.SHOWLOG, (MultiLangEnumBridge)OperationTypeEnum.SHOWLOG.getName());
            }
        } else {
            this.getPageCache().put(IsRefresh, String.valueOf(isRefresh));
        }
    }

    private void beforeBindEntryGrid(String entryId) {
        EntryAp entryAp = this.createEntryAp(entryId);
        IFormView formView = this.getView();
        EntryGrid entryGrid = (EntryGrid)formView.getControl(entryId);
        List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            fieldEdit.setView(formView);
            entryGrid.getItems().add(fieldEdit);
            if (!(fieldEdit instanceof Container)) continue;
            List listCol = ((Container)fieldEdit).getItems();
            for (Control col : listCol) {
                col.setView(formView);
                entryGrid.getItems().add(col);
            }
        }
    }

    private EntryAp createEntryAp(String entryId) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(entryId + "ap");
        entryAp.setShowSeq(true);
        List<ThreeTuple<String, MultiLangEnumBridge, Class<?>>> columnList = this.getColumnList();
        List<Dimension> dims = this.getDimensionList();
        for (ThreeTuple<String, MultiLangEnumBridge, Class<?>> head : columnList) {
            TextField field;
            String fieldKey = (String)head.item1;
            EntryFieldAp apMat = new EntryFieldAp();
            if (head.item3 == TextEdit.class) {
                field = new TextField();
                field.setKey(fieldKey);
                field.setDefValue(null);
                apMat.setField((Field)field);
                if (OlapHyperlinkFields.contains(fieldKey)) {
                    ((FieldAp)apMat).setHyperlink(true);
                }
            } else if (head.item3 == DateTimeEdit.class) {
                field = new DateTimeField();
                field.setKey(fieldKey);
                field.setDefValue(null);
                apMat.setField((Field)field);
            } else if (head.item3 == Container.class) {
                apMat = new EntryFieldGroupAp();
                if (CollectionUtils.isNotEmpty(dims)) {
                    for (Dimension dim : dims) {
                        String dimNumber = dim.getNumber().toLowerCase(Locale.ROOT);
                        EntryFieldAp ap = new EntryFieldAp();
                        ap.setId(dimNumber);
                        ap.setKey(dimNumber);
                        ap.setName(new LocaleString(dim.getName()));
                        TextField field2 = new TextField();
                        field2.setKey(dimNumber);
                        field2.setDefValue(null);
                        ap.setField((Field)field2);
                        ((EntryFieldGroupAp)apMat).getItems().add(ap);
                    }
                }
            }
            apMat.setId(fieldKey);
            apMat.setKey(fieldKey);
            apMat.setName(new LocaleString(((MultiLangEnumBridge)head.item2).loadKDString()));
            entryAp.getItems().add(apMat);
        }
        return entryAp;
    }

    protected final boolean isAuditLog() {
        String parent = this.getFormShowParameter().getParentFormId();
        if ("epbs_olap_log".equals(parent) || "epbs_olap_log_trace".equals(parent)) {
            return "epbs_olap_log".equals(parent);
        }
        return true;
    }

    private QFilter getOpTypeQfilter() {
        return CommonTypeHelper.getCommonQfilter((String)OPTYPE_CATEGORY, (String)ModelUtil.getAppType((Long)this.getModelId()).getAppNum());
    }

    private Map<String, String> getOpTypeList() {
        DynamicObjectCollection list = CommonTypeHelper.query((QFilter)this.getOpTypeQfilter());
        return list.stream().collect(Collectors.toMap(e -> e.getString("number"), e -> e.getString("name")));
    }

    private void customView() {
        List enableFalse;
        List visibleFalse = (List)this.getView().getFormShowParameter().getCustomParam("visible_false");
        if (null != visibleFalse) {
            this.getView().setVisible(Boolean.valueOf(false), visibleFalse.toArray(new String[0]));
        }
        if (null != (enableFalse = (List)this.getView().getFormShowParameter().getCustomParam("enable_false"))) {
            this.getView().setEnable(Boolean.valueOf(false), enableFalse.toArray(new String[0]));
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String ctrlKey = e.getKey();
        if (ctrlKey.startsWith(all_f7_key_prefix)) {
            TextEdit edit = new TextEdit();
            edit.setKey(ctrlKey);
            edit.setModel(this.getModel());
            edit.setView(this.getView());
            edit.setDraggable(true);
            edit.addClickListener((ClickListener)this);
            e.setControl((Control)edit);
        }
    }
}

