/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.member.f7;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.epm.epbs.formplugin.member.f7.SelectedMember;
import kd.epm.epbs.formplugin.member.f7.face.ISelectedF7Cache;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class F7CommonUtils
implements ISelectedF7Cache {
    public static final Log log = LogFactory.getLog(F7CommonUtils.class);
    private static final HashMap<String, String> replaceArgs = new HashMap();

    public static F7CommonUtils get() {
        return new F7CommonUtils();
    }

    public String getDataType(@NotNull Control control) {
        String controlKey = control.getKey();
        String dataType = "1";
        if ("lefttree".equals(controlKey)) {
            dataType = "1";
        } else if ("treeproperty".equals(controlKey)) {
            dataType = "2";
        }
        return dataType;
    }

    public void clearMemberRange(@NotNull IFormView view, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache) {
        LinkedHashMap<String, SelectedMember> selectData = this.getSelectedIdsFromCache(pageCache);
        this.unClearTreeNode(view, new ArrayList<String>(selectData.keySet()), selectData);
        this.cacheSelectMemberNew(pageCache, null);
        dataModel.deleteEntryData("entryentity");
    }

    public void unClearTreeNode(@NotNull IFormView view, List<String> nodes, Map<String, SelectedMember> selectData) {
        TreeView propView;
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        ArrayList memberIds = Lists.newArrayListWithExpectedSize((int)nodes.size());
        ArrayList propIds = Lists.newArrayListWithExpectedSize((int)nodes.size());
        for (String nodeId : nodes) {
            SelectedMember selectedMember = selectData.get(nodeId);
            if (selectedMember != null) {
                String type = selectedMember.getType();
                if ("2".equals(type)) {
                    propIds.add(nodeId);
                    continue;
                }
                memberIds.add(nodeId);
                continue;
            }
            memberIds.add(nodeId);
            propIds.add(nodeId);
        }
        TreeView treeView = (TreeView)view.getControl("lefttree");
        if (treeView != null && !memberIds.isEmpty()) {
            treeView.uncheckNodes((List)memberIds);
        }
        if ((propView = (TreeView)view.getControl("treeproperty")) != null && !propIds.isEmpty()) {
            propView.uncheckNodes((List)propIds);
        }
    }

    public void showSelectedSize(@NotNull IFormView view, @NotNull IPageCache pageCache, int selectedSize) {
        String cacheAllSize = pageCache.get("CACHE_TREE_ALL");
        int allSize = StringUtils.isNotEmpty((CharSequence)cacheAllSize) ? Integer.parseInt(cacheAllSize) : 0;
        Label labSelected = (Label)view.getControl("selected");
        if (labSelected != null) {
            labSelected.setText(String.format("(%1/%2)", selectedSize, allSize));
        }
    }

    public static QFilter getSearchFilter(String searchText) {
        if (StringUtils.isEmpty((CharSequence)searchText)) {
            return null;
        }
        String _searchText = searchText.trim();
        QFilter searchFilter = F7CommonUtils.getSearchFilter(_searchText = F7CommonUtils.filterIllegality(_searchText), " ", true);
        if (searchFilter == null) {
            searchFilter = F7CommonUtils.getSearchFilter(_searchText, "&", false);
        }
        if (searchFilter == null) {
            searchFilter = new QFilter("number", "like", (Object)("%" + _searchText + "%")).or("name", "like", (Object)("%" + _searchText + "%"));
        }
        return searchFilter;
    }

    private static String filterIllegality(String searchText) {
        if (StringUtils.isEmpty((CharSequence)searchText)) {
            return searchText;
        }
        for (Map.Entry<String, String> entry : replaceArgs.entrySet()) {
            searchText = searchText.replaceAll(entry.getKey(), entry.getValue());
        }
        return searchText;
    }

    private static QFilter getSearchFilter(String searchText, String SEP_MARK, boolean isOr) {
        QFilter searchFilter = null;
        if (searchText.indexOf(SEP_MARK) > 0) {
            String[] tmpStr = searchText.split(SEP_MARK);
            int in = tmpStr.length;
            for (int i = 0; i < in; ++i) {
                String _tmpStr = tmpStr[i].trim();
                QFilter tmpFilter = F7CommonUtils.getSearchFilter(_tmpStr, "&", false);
                if (tmpFilter == null) {
                    tmpFilter = new QFilter("number", "like", (Object)("%" + _tmpStr + "%")).or("name", "like", (Object)("%" + _tmpStr + "%"));
                }
                if (searchFilter == null) {
                    searchFilter = tmpFilter;
                    continue;
                }
                if (isOr) {
                    searchFilter.or(tmpFilter);
                    continue;
                }
                searchFilter.and(tmpFilter);
            }
        }
        return searchFilter;
    }

    static {
        replaceArgs.put("\u3000", " ");
        replaceArgs.put("\uff06", "&");
        replaceArgs.put("%", "");
        replaceArgs.put("(?i) and ", "");
        replaceArgs.put("(?i) or ", "");
    }
}

