/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.member.f7;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.formplugin.member.f7.F7CommonUtils;
import kd.epm.epbs.formplugin.member.f7.SelectedMember;
import kd.epm.epbs.formplugin.member.f7.base.AbstractRangeF7;
import kd.epm.epbs.formplugin.member.f7.face.IMemberF7Parameter;
import kd.epm.epbs.formplugin.member.f7.face.ISelectedF7Cache;
import kd.epm.epbs.formplugin.member.f7.face.ITreeCache;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class MemberRangeF7
extends AbstractRangeF7
implements IMemberF7Parameter,
ITreeCache,
ISelectedF7Cache {
    private AbstractMemberF7Parameter f7Parameter = null;

    protected AbstractMemberF7Parameter getF7Parameter() {
        String version;
        if (this.f7Parameter != null && (version = this.getF7ParamVersion(this.getPageCache())) != null && Long.valueOf(version).compareTo(this.f7Parameter.getVersion()) != 0) {
            this.f7Parameter = null;
        }
        if (this.f7Parameter == null) {
            this.f7Parameter = this.getF7FromCache(this.getPageCache());
            if (this.f7Parameter == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u53c2\u6570\u5f02\u5e38,\u8bf7\u9000\u51fa\u9875\u9762\u540e\u91cd\u8bd5", (String)"MemberRangeF7_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
            this.f7Parameter.check();
            this.f7Parameter.loadData();
        }
        return this.f7Parameter;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.f7Parameter = this.loadF7Parameter(this.getView(), this.getPageCache());
        Label caption = (Label)this.getControl("caption");
        if (caption != null && this.f7Parameter != null) {
            caption.setText(ResManager.loadResFormat((String)ResManager.loadKDString((String)"%1\u7ef4\u5ea6\u6210\u5458", (String)"MemberRangeF7_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]), (String)"MemberListF7_3", (String)"epm-eb-formplugin", (Object[])new Object[]{this.f7Parameter.getDimensionName()}));
        }
    }

    @Override
    protected void initUI(EventObject e) {
        AbstractMemberF7Parameter f7Param = this.getF7Parameter();
        ComboEdit rangeEdit = (ComboEdit)this.getControl("scope");
        rangeEdit.setComboItems(f7Param.getRangeItems());
        this.getView().setVisible(Boolean.valueOf(f7Param.isShowLevel()), new String[]{"level"});
        this.getView().setVisible(Boolean.valueOf(f7Param.isShowExclude()), new String[]{"exclude"});
    }

    @Override
    protected void showUI() {
    }

    @Override
    protected void initData() {
        AbstractMemberF7Parameter f7Param = this.getF7Parameter();
        this.addMember(this.getView(), this.getModel(), this.getPageCache(), "entryentity", f7Param);
    }

    protected void addMember(@NotNull IFormView view, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull String controlKey, @NotNull AbstractMemberF7Parameter f7Param) {
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        AbstractMemberF7Parameter f7Param = this.getF7Parameter();
        boolean isLockRange = f7Param.isLockRangeSelect();
        boolean isShowLevel = f7Param.isShowLevel();
        if ((isLockRange || isShowLevel) && e.getRows() != null) {
            for (RowDataEntity entity : e.getRows()) {
                String scope;
                int rowIndex = entity.getRowIndex();
                DynamicObject selected = entity.getDataEntity();
                if (selected == null) continue;
                boolean lockScope = false;
                boolean lockLevel = false;
                if (isLockRange || "2".equals(selected.get("type"))) {
                    lockScope = true;
                }
                if (isShowLevel && (scope = (String)selected.get("scope")) != null && !"170".equals(scope) && !"180".equals(scope)) {
                    lockLevel = true;
                }
                if (lockScope && lockLevel) {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"scope", "level"});
                    continue;
                }
                if (lockScope) {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"scope"});
                    continue;
                }
                if (!lockLevel) continue;
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"level"});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyKey;
        super.propertyChanged(e);
        switch (propertyKey = e.getProperty().getName()) {
            case "scope": {
                this.propertyChanged_scope(e);
                break;
            }
            case "level": {
                this.propertyChanged_level(e);
                break;
            }
            case "exclude": {
                this.propertyChanged_exclude(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void propertyChanged_scope(PropertyChangedArgs e) {
        ChangeData[] changeDatas = e.getChangeSet();
        if (changeDatas == null || changeDatas.length == 0) {
            return;
        }
        MemberRangeF7 memberRangeF7 = this;
        synchronized (memberRangeF7) {
            LinkedHashMap selectedMembers = this.getSelectedIdsFromCache(this.getPageCache());
            for (ChangeData changeData : changeDatas) {
                DynamicObject member = changeData.getDataEntity();
                SelectedMember memberData = (SelectedMember)selectedMembers.get(member.getString("memberid"));
                if (memberData == null) continue;
                String scopeIndex = (String)changeData.getNewValue();
                memberData.setScope(Integer.parseInt(scopeIndex));
                if (!StringUtils.isNotEmpty((CharSequence)scopeIndex)) continue;
                Integer _rangeLevel = null;
                if ("170".equals(scopeIndex) || "180".equals(scopeIndex)) {
                    this.getView().setEnable(Boolean.TRUE, changeData.getRowIndex(), new String[]{"level"});
                    _rangeLevel = 1;
                } else {
                    this.getView().setEnable(Boolean.FALSE, changeData.getRowIndex(), new String[]{"level"});
                }
                this.getModel().setValue("level", (Object)_rangeLevel, changeData.getRowIndex());
                memberData.setLevel(_rangeLevel != null ? _rangeLevel : 0);
            }
            this.cacheSelectMemberNew(this.getPageCache(), selectedMembers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void propertyChanged_level(PropertyChangedArgs e) {
        ChangeData[] changeDatas = e.getChangeSet();
        if (changeDatas == null || changeDatas.length == 0) {
            return;
        }
        MemberRangeF7 memberRangeF7 = this;
        synchronized (memberRangeF7) {
            LinkedHashMap selectedMembers = this.getSelectedIdsFromCache(this.getPageCache());
            for (ChangeData changeData : changeDatas) {
                DynamicObject member = changeData.getDataEntity();
                SelectedMember memberData = (SelectedMember)selectedMembers.get(member.getString("memberid"));
                if (memberData == null) continue;
                String scopeIndex = (String)changeData.getNewValue();
                memberData.setLevel(Integer.parseInt(scopeIndex));
            }
            this.cacheSelectMemberNew(this.getPageCache(), selectedMembers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void propertyChanged_exclude(PropertyChangedArgs e) {
        ChangeData[] changeDatas = e.getChangeSet();
        if (changeDatas == null || changeDatas.length == 0) {
            return;
        }
        MemberRangeF7 memberRangeF7 = this;
        synchronized (memberRangeF7) {
            LinkedHashMap selectedMembers = this.getSelectedIdsFromCache(this.getPageCache());
            for (ChangeData changeData : changeDatas) {
                DynamicObject member = changeData.getDataEntity();
                SelectedMember memberData = (SelectedMember)selectedMembers.get(member.getString("memberid"));
                if (memberData == null) continue;
                Boolean exclude = (Boolean)changeData.getNewValue();
                memberData.setExclude(exclude);
            }
            this.cacheSelectMemberNew(this.getPageCache(), selectedMembers);
        }
    }

    @Override
    protected void click_moveUp(EventObject evt) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        if (entryGrid != null) {
            int[] rows = entryGrid.getSelectRows();
            if (rows == null || rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u6210\u5458\u3002", (String)"MemberRangeF7_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            } else {
                Arrays.stream(rows).forEach(rowIndex -> {
                    if (rowIndex == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u5904\u4e8e\u7b2c\u4e00\u884c\uff0c\u65e0\u6cd5\u7ee7\u7eed\u4e0a\u79fb", (String)"MemberRangeF7_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                        return;
                    }
                });
                this.getModel().moveEntryRowsUp("entryentity", rows);
            }
        }
    }

    @Override
    protected void click_moveDown(EventObject evt) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        if (entryGrid != null) {
            int[] rows = entryGrid.getSelectRows();
            if (rows == null || rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u6210\u5458\u3002", (String)"MemberRangeF7_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            } else {
                int count = this.getModel().getEntryRowCount("entryentity");
                Arrays.stream(rows).forEach(rowIndex -> {
                    if (rowIndex == count - 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u5904\u4e8e\u6700\u540e\u4e00\u884c\uff0c\u65e0\u6cd5\u7ee7\u7eed\u4e0b\u79fb", (String)"MemberRangeF7_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                        return;
                    }
                });
                this.getModel().moveEntryRowsDown("entryentity", rows);
            }
        }
    }

    protected Set<String> getIds(int[] rows) {
        HashSet<String> unCheckedIds = new HashSet<String>(rows.length);
        for (int row : rows) {
            DynamicObject member = this.getModel().getEntryRowEntity("entryentity", row);
            if (member == null) continue;
            unCheckedIds.add(member.getString("memberid"));
        }
        return unCheckedIds;
    }

    protected void clearSelect(Set<String> unCheckedIds) {
        AbstractMemberF7Parameter f7Param = this.getF7Parameter();
        List selectIds = f7Param.getSelectIds();
        if (selectIds != null) {
            HashSet<String> removes = new HashSet<String>(selectIds.size());
            block0: for (String selectId : selectIds) {
                for (String unCheckedId : unCheckedIds) {
                    if (!selectId.startsWith(unCheckedId + "@")) continue;
                    removes.add(selectId);
                    continue block0;
                }
            }
            if (!removes.isEmpty()) {
                selectIds.removeAll(removes);
                this.cacheF7Parameter(this.getPageCache(), f7Param);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void click_remove(EventObject evt) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        if (entryGrid != null) {
            int[] rows = entryGrid.getSelectRows();
            if (rows == null || rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u6210\u5458\u3002", (String)"MemberRangeF7_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            } else {
                Set<String> unCheckedIds = this.getIds(rows);
                MemberRangeF7 memberRangeF7 = this;
                synchronized (memberRangeF7) {
                    LinkedHashMap selectData = this.getSelectedIdsFromCache(this.getPageCache());
                    F7CommonUtils.get().unClearTreeNode(this.getView(), new ArrayList<String>(unCheckedIds), selectData);
                    this.getModel().deleteEntryRows("entryentity", rows);
                    unCheckedIds.forEach(selectData::remove);
                    this.cacheSelectMemberNew(this.getPageCache(), selectData);
                }
                this.clearSelect(unCheckedIds);
            }
        }
    }

    @Override
    protected void click_clearSelected(EventObject evt) {
        AbstractMemberF7Parameter f7Param = this.getF7Parameter();
        f7Param.setSelectIds(new ArrayList());
        this.cacheF7Parameter(this.getPageCache(), f7Param);
        F7CommonUtils utils = F7CommonUtils.get();
        utils.clearMemberRange(this.getView(), this.getModel(), this.getPageCache());
    }

    @Override
    protected void click_submit(EventObject evt) {
        AbstractMemberF7Parameter f7Param = this.getF7Parameter();
        Map<String, SelectedMember> selectData = this.getSelectedData();
        f7Param.setViewId((Long)this.getModel().getValue("view_id"));
        this.returnSelectedDataNew(this.getView(), f7Param, selectData, this.getDataParams());
    }

    protected Map<String, SelectedMember> getSelectedData() {
        LinkedHashMap cacheSelected = this.getSelectedIdsFromCache(this.getPageCache());
        LinkedHashMap selectDatas = Maps.newLinkedHashMapWithExpectedSize((int)cacheSelected.size());
        DynamicObjectCollection selectedObj = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject selected : selectedObj) {
            String memberId = selected.getString("memberid");
            SelectedMember selectData = (SelectedMember)cacheSelected.get(memberId);
            if (selectData == null) continue;
            selectDatas.put(memberId, selectData);
        }
        return selectDatas;
    }

    protected Map<String, Object> getDataParams() {
        Object parent;
        Object isAddNew;
        Object isFloat;
        HashMap dataParams = Maps.newHashMap();
        IDataEntityProperty property = this.getModel().getProperty("chkfloat");
        if (property != null && (isFloat = this.getModel().getValue("chkfloat")) instanceof Boolean) {
            dataParams.put("chkfloat", isFloat);
        }
        if ((property = this.getModel().getProperty("chkaddnew")) != null && (isAddNew = this.getModel().getValue("chkaddnew")) instanceof Boolean) {
            dataParams.put("chkaddnew", isAddNew);
        }
        if ((property = this.getModel().getProperty("parent")) != null && (parent = this.getModel().getValue("parent")) instanceof DynamicObject) {
            dataParams.put("parent", parent);
        }
        return dataParams;
    }

    @Override
    protected void click_cancel(EventObject evt) {
        this.getView().returnDataToParent(null);
        this.getView().close();
    }

    @Override
    public void search(SearchEnterEvent evt) {
        super.search(evt);
        String searchTxt = evt.getText();
        if (StringUtils.isNotEmpty((CharSequence)searchTxt)) {
            this.searchList(searchTxt, true);
        }
    }

    protected void searchList(@NotNull String searchTxt, boolean isDown) {
        DynamicObjectCollection selMembers = this.getModel().getEntryEntity("entryentity");
        ArrayList<Integer> selectRows = new ArrayList<Integer>();
        if (selMembers != null && !selMembers.isEmpty()) {
            DynamicObject selMember;
            int rowIndex;
            int selRowIndex = -1;
            String _selRowIndex = this.getPageCache().get("CACHE_LIST_ROW_INDEX");
            if (StringUtils.isNotEmpty((CharSequence)_selRowIndex)) {
                try {
                    selRowIndex = Integer.parseInt(_selRowIndex);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (isDown) {
                int in = selMembers.size();
                for (int i = rowIndex = selRowIndex != -1 ? selRowIndex + 1 : 0; i < in; ++i) {
                    selMember = (DynamicObject)selMembers.get(i);
                    if (selMember == null || !this.equalsSearchText(selMember, searchTxt)) continue;
                    this.getPageCache().put("CACHE_LIST_ROW_INDEX", String.valueOf(i));
                    selectRows.add(i);
                    break;
                }
            } else {
                for (int i = rowIndex = selRowIndex != -1 ? selRowIndex - 1 : selMembers.size() - 1; i >= 0; --i) {
                    selMember = (DynamicObject)selMembers.get(i);
                    if (selMember == null || !this.equalsSearchText(selMember, searchTxt)) continue;
                    this.getPageCache().put("CACHE_LIST_ROW_INDEX", String.valueOf(i));
                    selectRows.add(i);
                    break;
                }
            }
        }
        if (selectRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879", (String)"MemberRangeF7_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
        } else {
            EntryGrid entry = (EntryGrid)this.getControl("entryentity");
            if (entry != null) {
                int[] rows = selectRows.stream().mapToInt(x -> x).toArray();
                entry.selectRows(rows, 0);
            }
        }
    }

    private boolean equalsSearchText(@NotNull DynamicObject member, @NotNull String searchTxt) {
        String name = member.getString("name");
        String number = member.getString("number");
        String _searchTxt = searchTxt.toLowerCase();
        return StringUtils.isNotEmpty((CharSequence)name) && name.contains(searchTxt) || StringUtils.isNotEmpty((CharSequence)number) && number.toLowerCase().contains(_searchTxt);
    }

    @Override
    protected void click_searchUp(EventObject evt) {
        Search search = (Search)this.getControl("searchlist");
        if (search != null && StringUtils.isNotEmpty((CharSequence)search.getSearchKey())) {
            this.searchList(search.getSearchKey(), false);
        }
    }

    @Override
    protected void click_searchDown(EventObject evt) {
        Search search = (Search)this.getControl("searchlist");
        if (search != null && StringUtils.isNotEmpty((CharSequence)search.getSearchKey())) {
            this.searchList(search.getSearchKey(), true);
        }
    }

    @Override
    public void entryRowClick(RowClickEvent evt) {
        this.getPageCache().put("CACHE_LIST_ROW_INDEX", String.valueOf(evt.getRow()));
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent event) {
        super.hyperLinkClick(event);
    }
}

