/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.member.f7;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.F7SelectedList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.constant.F7Constant;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.member.f7.tree.BaseTreeBuilder;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.QFBuilder;
import kd.epm.epbs.formplugin.member.f7.F7CommonUtils;
import kd.epm.epbs.formplugin.member.f7.F7Member;
import kd.epm.epbs.formplugin.member.f7.base.AbstractTreeF7;
import kd.epm.epbs.formplugin.member.f7.face.IMemberF7Parameter;
import kd.epm.epbs.formplugin.member.f7.face.ISelectedF7Cache;
import kd.epm.epbs.formplugin.member.f7.face.ITreeCache;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class MemberTreeF7Base
extends AbstractTreeF7
implements IMemberF7Parameter,
ITreeCache,
ISelectedF7Cache {
    public static final String VIEWID = "viewId";
    private AbstractMemberF7Parameter f7Parameter = null;

    protected AbstractMemberF7Parameter getF7Parameter() {
        if (this.f7Parameter == null) {
            this.f7Parameter = this.getF7FromCache(this.getPageCache());
            if (this.f7Parameter == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u53c2\u6570\u5f02\u5e38,\u8bf7\u9000\u51fa\u9875\u9762\u540e\u91cd\u8bd5", (String)"MemberTreeF7Base_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
        }
        return this.f7Parameter;
    }

    @Override
    public void initialize() {
        TreeView treeView;
        super.initialize();
        this.f7Parameter = this.loadF7Parameter(this.getView(), this.getPageCache());
        if (this.f7Parameter != null && this.f7Parameter.isStepLoad() && (treeView = (TreeView)this.getControl("lefttree")) != null) {
            BaseTreeBuilder.registerQueryListener((TreeView)treeView, (TreeNodeQueryListener)this);
        }
    }

    @Override
    protected void init_base() {
        AbstractMemberF7Parameter _f7Param = this.getF7Parameter();
        this.getModel().setValue("cbshowdisable", (Object)_f7Param.isShowDisable());
    }

    @Override
    protected void init_view() {
        AbstractMemberF7Parameter _f7Param = this.getF7Parameter();
        if (IDUtils.isNotNull((Long)_f7Param.getViewId())) {
            this.getModel().setValue("view", (Object)_f7Param.getViewId());
        }
    }

    @Override
    protected void init_leftTree(AbstractMemberF7Parameter f7Param) {
        if (f7Param == null) {
            f7Param = this.getF7Parameter();
        }
        LinkedHashMap selectedIdsFromCache = this.getSelectedIdsFromCache(this.getPageCache());
        Set selectIds = selectedIdsFromCache.keySet().stream().map(Long::parseLong).collect(Collectors.toSet());
        f7Param.getTreeBuilder(f7Param).buildTree((TreeView)this.getControl("lefttree"), this.getPageCache(), selectIds);
    }

    @Override
    protected void initUI() {
        AbstractMemberF7Parameter _f7Param = this.getF7Parameter();
        this.getView().setVisible(Boolean.valueOf(_f7Param.isShowView()), F7Constant.F7_VIEW_SHOW);
        this.getView().setEnable(Boolean.valueOf(_f7Param.isEnableView()), F7Constant.F7_VIEW_SHOW);
    }

    @Override
    protected void beforeF7Select_view(BeforeF7SelectEvent evt) {
    }

    @Override
    protected void propertyChanged_dimension(PropertyChangedArgs evt) {
    }

    @Override
    protected void propertyChanged_view(PropertyChangedArgs evt) {
        if (evt.getChangeSet() == null || evt.getChangeSet().length == 0) {
            return;
        }
        ChangeData changeData = evt.getChangeSet()[0];
        if (changeData.getNewValue() == null && changeData.getOldValue() != null) {
            this.getModel().getDataEntity().set("view", changeData.getOldValue());
            this.getView().updateView("view");
            return;
        }
        AbstractMemberF7Parameter _f7Param = this.getF7Parameter();
        if (evt.getChangeSet()[0].getNewValue() instanceof DynamicObject) {
            DynamicObject _view = (DynamicObject)evt.getChangeSet()[0].getNewValue();
            if (IDUtils.isNull((Long)_f7Param.getViewId()) || !_f7Param.getViewId().equals(_view.getLong("id"))) {
                _f7Param.setViewId(Long.valueOf(_view.getLong("id")));
                this.cacheF7Parameter(this.getPageCache(), _f7Param);
                this.cacheParentView(_f7Param, _f7Param.getViewId());
                if (_f7Param.isClearSelectWhenChangeView() || _f7Param.getFunctionType() == 0) {
                    this.clearSelected();
                }
                this.init_leftTree(_f7Param);
            }
        }
    }

    protected void cacheParentView(AbstractMemberF7Parameter f7Param, Long viewId) {
        if (f7Param == null || IDUtils.isNull((Long)viewId)) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)f7Param.getViewSign())) {
            IPageCache parentCache = this.getParentCache();
            parentCache.put(f7Param.getViewSign() + VIEWID, IDUtils.toString((Object)viewId));
            parentCache.saveChanges();
        }
    }

    protected IPageCache getParentCache() {
        return (IPageCache)this.getView().getParentView().getService(IPageCache.class);
    }

    protected void clearSelected() {
        this.cacheSelectMemberNew(this.getPageCache(), null);
        F7SelectedList selectedList = (F7SelectedList)this.getControl("rightselect");
        if (selectedList != null) {
            selectedList.removeAllItems();
        }
    }

    @Override
    protected void propertyChanged_includeChildren(PropertyChangedArgs evt) {
        this.sendTreeNodeClick();
    }

    @Override
    protected void propertyChanged_showDisable(PropertyChangedArgs evt) {
        AbstractMemberF7Parameter f7Param = this.getF7Parameter();
        Boolean showDisable = (Boolean)this.getModel().getValue("cbshowdisable");
        f7Param.setShowDisable(showDisable.booleanValue());
        this.cacheF7Parameter(this.getPageCache(), f7Param);
        LinkedHashMap selectedIdsFromCache = this.getSelectedIdsFromCache(this.getPageCache());
        Set selectIds = selectedIdsFromCache.keySet().stream().map(Long::parseLong).collect(Collectors.toSet());
        f7Param.getTreeBuilder(f7Param).buildTree((TreeView)this.getControl("lefttree"), this.getPageCache(), selectIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void propertyChanged_comboShowType(PropertyChangedArgs evt) {
        ChangeData[] changeData = evt.getChangeSet();
        if (changeData == null || changeData.length == 0) {
            return;
        }
        AbstractMemberF7Parameter f7Param = this.getF7Parameter();
        f7Param.setShowType((String)changeData[0].getNewValue());
        log.info("begin-showType.");
        try {
            this.showTree(f7Param);
        }
        finally {
            this.cacheF7Parameter(this.getPageCache(), f7Param);
            log.info("end-showType.");
        }
    }

    protected void showTree(@NotNull AbstractMemberF7Parameter f7Param) {
        TreeView view = (TreeView)this.getControl("lefttree");
        f7Param.getTreeBuilder(f7Param).buildTree(view, this.getPageCache());
    }

    @Override
    protected void click_TreeSearchUp(EventObject evt) {
        Search search = (Search)this.getControl("treesearch");
        if (search != null && StringUtils.isNotEmpty((CharSequence)search.getSearchKey())) {
            this.searchTree(search.getSearchKey(), false);
        }
    }

    @Override
    protected void click_TreeSearchDown(EventObject evt) {
        Search search = (Search)this.getControl("treesearch");
        if (search != null && StringUtils.isNotEmpty((CharSequence)search.getSearchKey())) {
            this.searchTree(search.getSearchKey(), true);
        }
    }

    protected void sendTreeNodeClick() {
        TreeView treeView = (TreeView)this.getControl("lefttree");
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        if (focusNodeId == null) {
            return;
        }
        treeView.treeNodeClick(null, focusNodeId);
    }

    @Override
    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        String nodeId = (String)evt.getNodeId();
        if (StringUtils.isNotEmpty((CharSequence)nodeId)) {
            F7Member curr = this.getTreeNodeClickMember(nodeId);
            this.cacheSearchTree(this.getPageCache(), curr);
        }
    }

    protected String getNodeId(String nodeId) {
        return nodeId;
    }

    protected F7Member getTreeNodeClickMember(String nodeId) {
        F7Member curr = null;
        DynamicObject _do = BusinessDataServiceHelper.loadSingleFromCache((Object)IDUtils.toLong((Object)this.getNodeId(nodeId)), (String)this.getF7Parameter().getEntityNumber(), (String)"id, name, number, longnumber");
        if (_do != null) {
            curr = new F7Member(_do.getLong("id"), _do.getString("name"), _do.getString("number"));
            curr.setLongNumber(_do.getString("longnumber"));
        }
        return curr;
    }

    @Override
    protected void treeNode_stepLoad(TreeNodeEvent evt) {
        TreeView treeView = (TreeView)evt.getSource();
        String nodeId = (String)evt.getNodeId();
        try {
            if (nodeId != null) {
                this.treeStepLoad(treeView, nodeId);
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    protected void treeStepLoad(@NotNull TreeView treeView, @NotNull String nodeId) throws Exception {
        if ("lefttree".equals(treeView.getKey())) {
            AbstractMemberF7Parameter _f7Param = this.getF7Parameter();
            _f7Param.getTreeBuilder(_f7Param).stepLoadTree(treeView, Collections.singletonList(nodeId), "CACHE_F7_TREE_MEMBER_NODE_DATA", null, null, this.getPageCache());
        }
    }

    @Override
    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        super.treeNodeCheck(evt);
        String cacheSelected = this.getPageCache().get("CACHE_TREE_SELECTED");
        int selected = StringUtils.isNotEmpty((CharSequence)cacheSelected) ? Integer.parseInt(cacheSelected) : 0;
        selected = evt.getChecked() != false ? selected + 1 : selected - 1;
        this.getPageCache().put("CACHE_TREE_SELECTED", String.valueOf(selected));
        F7CommonUtils.get().showSelectedSize(this.getView(), this.getPageCache(), selected);
    }

    @Override
    protected void searchTree(Search search, String searchText) {
        this.searchTree(searchText, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchTree(String searchText, boolean hasDown) {
        log.info("begin-searchTree");
        AbstractMemberF7Parameter _f7Param = this.getF7Parameter();
        try {
            SearchQuery query = this.getSearchFilter(searchText, hasDown, _f7Param);
            log.info(query.toString());
            F7Member next = this.searchMember(_f7Param, query);
            if (next == null) {
                query.currMember = null;
                query.direction = null;
                next = this.searchMember(_f7Param, query);
            }
            if (next == null && hasDown) {
                query.currMember = null;
                query.direction = null;
                next = this.searchMember(_f7Param, query);
            }
            if (next == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879", (String)"MemberTreeF7Base_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                return;
            }
            this.cacheSearchTree(this.getPageCache(), next);
            log.info(JSON.toJSONString((Object)next));
            String[] parents = next.getLongNumber().split("!");
            ArrayList<String> _parents = new ArrayList<String>(parents.length);
            int in = parents.length - 1;
            for (int i = 0; i < in; ++i) {
                _parents.add(parents[i]);
            }
            ArrayList expandIds = Lists.newArrayListWithExpectedSize((int)_parents.size());
            QFBuilder builder = new QFBuilder();
            builder.add(_f7Param.filters().toList());
            builder.add("number", "in", _parents);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"searchTree", (String)_f7Param.getEntityNumber(), (String)query.fields, (QFilter[])builder.toArray(), (String)"longnumber");){
                if (ds != null) {
                    for (Row row : ds) {
                        expandIds.add(row.getString("id"));
                    }
                }
            }
            TreeView treeView = (TreeView)this.getControl("lefttree");
            _f7Param.getTreeBuilder(_f7Param).stepLoadTree(treeView, (List)expandIds, "CACHE_F7_TREE_MEMBER_NODE_DATA", next.getId().toString(), null, this.getPageCache());
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
        }
        finally {
            log.info("end-searchTree");
        }
    }

    protected F7Member searchMember(@NotNull AbstractMemberF7Parameter f7Param, @NotNull SearchQuery query) {
        F7Member next = null;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(query.filters);
        if (query.direction != null) {
            filters.add(query.direction);
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"searchTree", (String)f7Param.getEntityNumber(), (String)query.fields, (QFilter[])filters.toArray(new QFilter[0]), (String)query.orderBy, (int)1);){
            if (ds != null && ds.hasNext()) {
                Row row = ds.next();
                next = new F7Member(row.getLong("id"), row.getString("name"), row.getString("number"));
                next.setLongNumber(row.getString("longnumber"));
            }
        }
        return next;
    }

    protected SearchQuery getSearchFilter(String searchText, boolean hasDown, AbstractMemberF7Parameter f7Param) {
        Set _permissionIds;
        String fields = "id,name,number,longnumber";
        if (f7Param.isView()) {
            fields = "memberid as id,name,number,longnumber";
        }
        QFBuilder builder = new QFBuilder();
        builder.add(f7Param.filters().toList());
        if (f7Param.isVerifyPermission() && (_permissionIds = f7Param.getPermissionIds()) != null) {
            if (_permissionIds.isEmpty()) {
                builder.add(f7Param.pkField(), "=", (Object)0L);
            } else {
                builder.add(f7Param.pkField(), "in", (Object)_permissionIds);
            }
        }
        builder.add(new QFilter("number", "like", (Object)("%" + searchText + "%")).or("name", "like", (Object)("%" + searchText + "%")));
        if (!f7Param.isShowLeaf()) {
            builder.add("isleaf", "=", (Object)"0");
        }
        QFilter direction = null;
        F7Member _member = this.getSearchTreeByCache(this.getPageCache());
        String _order = "longnumber";
        if (_member != null && StringUtils.isNotEmpty((CharSequence)_member.getLongNumber())) {
            if (hasDown) {
                direction = new QFilter("longnumber", ">", (Object)_member.getLongNumber());
            } else {
                direction = new QFilter("longnumber", "<", (Object)_member.getLongNumber());
                _order = "longnumber desc";
            }
        }
        return new SearchQuery(_member, fields, builder.toList(), direction, _order, searchText, hasDown);
    }

    protected static class SearchQuery {
        public F7Member currMember;
        public String fields;
        public List<QFilter> filters;
        public QFilter direction;
        public String orderBy;
        public String searchText;
        public boolean hasDown;

        public SearchQuery(F7Member currMember, String fields, List<QFilter> filters, QFilter direction, String orderBy, String searchText, boolean hasDown) {
            this.currMember = currMember;
            this.fields = fields;
            this.filters = filters;
            this.direction = direction;
            this.orderBy = orderBy;
            this.searchText = searchText;
            this.hasDown = hasDown;
        }
    }
}

