/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.member.f7;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.member.f7.tree.BaseTreeBuilder;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.QFBuilder;
import kd.epm.epbs.formplugin.member.f7.F7CommonUtils;
import kd.epm.epbs.formplugin.member.f7.MemberTreeF7Base;
import kd.epm.epbs.formplugin.member.f7.SelectedMember;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class MemberTreeRangeF7Base
extends MemberTreeF7Base
implements TabSelectListener {
    @Override
    public void initialize() {
        TreeView propertyTree;
        super.initialize();
        Search search = (Search)this.getControl("propertysearch");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
        this.addClickListeners(new String[]{"propertyup", "propretydown"});
        AbstractMemberF7Parameter _f7Param = this.getF7Parameter();
        TreeView treeView = (TreeView)this.getControl("lefttree");
        if (treeView != null) {
            Map properties = treeView.getCustomProperties();
            properties.put("cpn", Boolean.FALSE);
            this.getView().updateControlMetadata("lefttree", properties);
            if (!_f7Param.isMultiSelect()) {
                treeView.setMulti(_f7Param.isMultiSelect());
            }
        }
        if (_f7Param.isShowCustomProperty() && _f7Param.canShowCustomProperty() && (propertyTree = (TreeView)this.getControl("treeproperty")) != null) {
            Map properties = propertyTree.getCustomProperties();
            properties.put("cpn", Boolean.FALSE);
            this.getView().updateControlMetadata("treeproperty", properties);
            if (!_f7Param.isMultiSelect()) {
                propertyTree.setMulti(_f7Param.isMultiSelect());
                BaseTreeBuilder.registerNodeListener((TreeView)propertyTree, (TreeNodeClickListener)this);
            }
            BaseTreeBuilder.registerNodeCheckListener((TreeView)propertyTree, (TreeNodeCheckListener)this);
            BaseTreeBuilder.registerQueryListener((TreeView)propertyTree, (TreeNodeQueryListener)this);
        }
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    @Override
    protected void initUI() {
        super.initUI();
        AbstractMemberF7Parameter f7Param = this.getF7Parameter();
        if (!f7Param.isShowCustomProperty() || !f7Param.canShowCustomProperty()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"treeproperty", "tabproperty"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"treeproperty", "tabproperty"});
        }
        if (StringUtils.isNotEmpty((CharSequence)f7Param.getShowType())) {
            this.getModel().setValue("showtype", (Object)f7Param.getShowType());
        } else {
            f7Param.setShowType(String.valueOf(this.getModel().getValue("showtype")));
        }
        ComboEdit showScope = (ComboEdit)this.getControl("showscope");
        showScope.setComboItems(f7Param.getRangeItems());
        this.setDefaultValue(f7Param, "showscope");
        if (f7Param.isLockRangeSelect()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"showscope"});
        }
    }

    protected void setDefaultValue(AbstractMemberF7Parameter f7Param, String controlKey) {
        if (f7Param.getDefRangeValue() != null) {
            this.getModel().setValue(controlKey, (Object)f7Param.getDefRangeValue());
        } else {
            this.getModel().setValue(controlKey, (Object)"10");
        }
    }

    @Override
    protected void initData() {
        super.initData();
    }

    @Override
    protected void init_base() {
        super.init_base();
        AbstractMemberF7Parameter _f7Param = this.getF7Parameter();
        this.getModel().setValue("cbshowdisable", (Object)_f7Param.isShowDisable());
    }

    @Override
    protected void init_leftTree(AbstractMemberF7Parameter f7Param) {
        if (f7Param == null) {
            f7Param = this.getF7Parameter();
        }
        super.init_leftTree(f7Param);
        if (f7Param.isShowCustomProperty() && f7Param.canShowCustomProperty()) {
            LinkedHashMap selectedIdsFromCache = this.getSelectedIdsFromCache(this.getPageCache());
            Set selectIds = selectedIdsFromCache.keySet().stream().map(Long::parseLong).collect(Collectors.toSet());
            f7Param.getCustomPropertyTreeBuilder(f7Param).buildTree((TreeView)this.getControl("treeproperty"), this.getPageCache(), selectIds);
        }
    }

    @Override
    protected void propertyChanged_view(PropertyChangedArgs evt) {
        super.propertyChanged_view(evt);
        AbstractMemberF7Parameter f7Parameter = this.getF7Parameter();
        if (f7Parameter.isClearSelectWhenChangeView()) {
            F7CommonUtils utils = F7CommonUtils.get();
            utils.clearMemberRange(this.getView(), this.getModel(), this.getPageCache());
        }
    }

    @Override
    protected void clearSelected() {
        super.clearSelected();
        AbstractMemberF7Parameter f7Param = this.getF7Parameter();
        f7Param.setSelectIds(Collections.EMPTY_MAP);
        this.cacheF7Parameter(this.getPageCache(), f7Param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        super.treeNodeCheck(evt);
        boolean checked = evt.getChecked();
        String nodeId = (String)evt.getNodeId();
        if (nodeId == null) {
            return;
        }
        if (evt.getSource() instanceof TreeView) {
            String type = F7CommonUtils.get().getDataType((Control)((TreeView)evt.getSource()));
            MemberTreeRangeF7Base memberTreeRangeF7Base = this;
            synchronized (memberTreeRangeF7Base) {
                LinkedHashMap selectedMembers = this.getSelectedIdsFromCache(this.getPageCache());
                if (checked) {
                    AbstractMemberF7Parameter f7Param = this.getF7Parameter();
                    if (!f7Param.isMultiSelect() && !selectedMembers.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u591a\u9009\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"MemberTreeRangeF7Base_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]), Integer.valueOf(500));
                        return;
                    }
                    if (!selectedMembers.containsKey(nodeId)) {
                        TreeView treeView = (TreeView)evt.getSource();
                        List nodes = treeView.getTreeState().getCheckedNodes();
                        Map node = null;
                        for (Map _node : nodes) {
                            if (!nodeId.equals(_node.get("id"))) continue;
                            node = _node;
                            break;
                        }
                        if (node != null) {
                            this.selectedNode(node, selectedMembers, type);
                        }
                    }
                } else {
                    this.unSelectedNode(nodeId, selectedMembers);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId;
        super.treeNodeClick(evt);
        AbstractMemberF7Parameter f7Param = this.getF7Parameter();
        if (!f7Param.isMultiSelect() && StringUtils.isNotEmpty((CharSequence)(nodeId = (String)evt.getNodeId()))) {
            String type = F7CommonUtils.get().getDataType((Control)((TreeView)evt.getSource()));
            MemberTreeRangeF7Base memberTreeRangeF7Base = this;
            synchronized (memberTreeRangeF7Base) {
                LinkedHashMap selectedMembers = this.getSelectedIdsFromCache(this.getPageCache());
                selectedMembers.clear();
                HashMap<String, Object> node = new HashMap<String, Object>();
                node.put("id", nodeId);
                node.put("parentid", evt.getParentNodeId());
                this.selectedNode(node, selectedMembers, type);
            }
        }
    }

    private void selectedNode(@NotNull Map<String, Object> node, @NotNull LinkedHashMap<String, SelectedMember> selectedMembers, @NotNull String type) {
        SelectedMember selectedMember = this.getSelectedMember(node, type);
        if (selectedMember != null) {
            this.fillSpecialField(type, selectedMember);
            this.fillBillList(selectedMember);
            this.putSelectedMemberNew(selectedMembers, selectedMember);
            this.cacheSelectMemberNew(this.getPageCache(), selectedMembers);
        }
    }

    protected void fillSpecialField(@NotNull String type, SelectedMember selectedMember) {
        if ("2".equals(type)) {
            selectedMember.setScope(10);
        } else {
            selectedMember.setScope(this.getShowRange());
        }
    }

    protected SelectedMember getSelectedMember(Map<String, Object> node, String type) {
        SelectedMember selectedMember = this.instanceSelectedMember();
        return selectedMember.loadMember(IDUtils.toLong((Object)node.get("id")), type, this.getF7Parameter());
    }

    @NotNull
    protected SelectedMember instanceSelectedMember() {
        return new SelectedMember();
    }

    private int getShowRange() {
        String showScope = (String)this.getModel().getValue("showscope");
        if (showScope != null) {
            return Integer.parseInt(showScope);
        }
        return 10;
    }

    protected void fillBillList(@NotNull SelectedMember selectedMember) {
        AbstractMemberF7Parameter f7Param = this.getF7Parameter();
        if (!f7Param.isMultiSelect()) {
            this.getModel().deleteEntryData("entryentity");
        }
        int rowIndex = this.getModel().createNewEntryRow("entryentity");
        selectedMember.setRowIndex(rowIndex);
        this.getModel().setValue("memberid", (Object)selectedMember.getId(), rowIndex);
        this.getModel().setValue("name", (Object)selectedMember.getName(), rowIndex);
        this.getModel().setValue("number", (Object)selectedMember.getNumber(), rowIndex);
        this.getModel().setValue("scope", (Object)String.valueOf(selectedMember.getScope()), rowIndex);
        this.getModel().setValue("type", (Object)selectedMember.getType(), rowIndex);
        if ("2".equals(selectedMember.getType()) || this.getF7Parameter().isLockRangeSelect()) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"scope"});
        }
        int scope = selectedMember.getScope();
        this.getView().setEnable(Boolean.valueOf(scope == 170 || scope == 180), rowIndex, new String[]{"level"});
    }

    protected void unSelectedNode(@NotNull Object nodeId, @NotNull LinkedHashMap<String, SelectedMember> selectedMembers) {
        DynamicObject parent;
        IDataEntityProperty property;
        Long memberId = IDUtils.toLong((Object)nodeId);
        HashSet rowIndex = Sets.newHashSetWithExpectedSize((int)selectedMembers.size());
        DynamicObjectCollection selMembers = this.getModel().getEntryEntity("entryentity");
        int in = selMembers.size();
        for (int i = 0; i < in; ++i) {
            DynamicObject selMember = (DynamicObject)selMembers.get(i);
            if (selMember.getLong("memberId") != memberId.longValue()) continue;
            rowIndex.add(i);
            selectedMembers.remove(IDUtils.toString((Object)nodeId));
        }
        if (!rowIndex.isEmpty()) {
            int[] _rowIndex = rowIndex.stream().mapToInt(x -> x).toArray();
            this.getModel().deleteEntryRows("entryentity", _rowIndex);
        }
        if ((property = this.getModel().getProperty("parent")) != null && (parent = (DynamicObject)this.getModel().getValue("parent")) != null && parent.getLong("id") == IDUtils.toLong((Object)nodeId).longValue()) {
            this.getModel().setValue("parent", null);
        }
        this.cacheSelectMemberNew(this.getPageCache(), selectedMembers);
    }

    @Override
    protected void treeStepLoad(@NotNull TreeView treeView, @NotNull String nodeId) throws Exception {
        super.treeStepLoad(treeView, nodeId);
        if ("treeproperty".equals(treeView.getKey())) {
            LinkedHashMap selectedMembers = this.getSelectedIdsFromCache(this.getPageCache());
            AbstractMemberF7Parameter _f7Param = this.getF7Parameter();
            _f7Param.getCustomPropertyTreeBuilder(_f7Param).stepLoadTree(treeView, Collections.singletonList(nodeId), "CACHE_TREE_PROPERTY_NODE_DATA", null, IDUtils.toLongs(selectedMembers.keySet()), this.getPageCache());
        }
    }

    @Override
    protected void showTree(@NotNull AbstractMemberF7Parameter f7Param) {
        LinkedHashMap selectedMembers = this.getSelectedIdsFromCache(this.getPageCache());
        Set selectedMemberIds = IDUtils.toLongs(selectedMembers.keySet());
        TreeView view = (TreeView)this.getControl("lefttree");
        f7Param.getTreeBuilder(f7Param).buildTree(view, this.getPageCache(), selectedMemberIds);
        TreeView propTree = (TreeView)this.getControl("treeproperty");
        f7Param.getCustomPropertyTreeBuilder(f7Param).buildTree(propTree, this.getPageCache(), selectedMemberIds);
    }

    @Override
    protected void searchProperty(Search search, String searchText) {
        this.searchProperty(searchText, true);
    }

    @Override
    protected void click_PropertySearchDown(EventObject evt) {
        Search search = (Search)this.getControl("propertysearch");
        if (search != null && StringUtils.isNotEmpty((CharSequence)search.getSearchKey())) {
            this.searchProperty(search.getSearchKey(), true);
        }
    }

    @Override
    protected void click_PropertySearchUp(EventObject evt) {
        Search search = (Search)this.getControl("propertysearch");
        if (search != null && StringUtils.isNotEmpty((CharSequence)search.getSearchKey())) {
            this.searchProperty(search.getSearchKey(), false);
        }
    }

    private void searchProperty(String searchText, boolean hasDown) {
        log.info("begin-searchProperty.");
        AbstractMemberF7Parameter _f7Param = this.getF7Parameter();
        Map currPropertyValue = this.getSearchPropertyByCache(this.getPageCache());
        List<Object> propertyIds = this.queryProperty(_f7Param);
        DynamicObject propValue = this.queryPropertyValue(propertyIds, currPropertyValue, searchText, hasDown);
        if (propValue == null && currPropertyValue != null) {
            propValue = this.queryPropertyValue(propertyIds, null, searchText, hasDown);
        }
        if (propValue != null) {
            String propertyId = propValue.getString("property.id");
            String propValueId = propValue.getString("id");
            this.cacheSearchPropertyTree(this.getPageCache(), propValue);
            TreeView propView = (TreeView)this.getControl("treeproperty");
            if (propView != null) {
                LinkedHashMap selectedMembers = this.getSelectedIdsFromCache(this.getPageCache());
                try {
                    _f7Param.getCustomPropertyTreeBuilder(_f7Param).stepLoadTree(propView, Arrays.asList(propertyId, propValueId), "CACHE_TREE_PROPERTY_NODE_DATA", propValueId, IDUtils.toLongs(selectedMembers.keySet()), this.getPageCache());
                }
                catch (Exception e) {
                    log.error("stepLoadTree-error", (Throwable)e);
                }
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879", (String)"MemberTreeRangeF7Base_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
            this.clearSearchPropertyCache(this.getPageCache());
        }
        log.info("end-searchProperty.");
    }

    private List<Object> queryProperty(AbstractMemberF7Parameter f7Param) {
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)f7Param.getModelId());
        builder.add("dimension", "=", (Object)f7Param.getDimensionId());
        return QueryServiceHelper.queryPrimaryKeys((String)f7Param.getCustomPropertyForm(), (QFilter[])builder.toArray(), (String)"number", (int)100);
    }

    private DynamicObject queryPropertyValue(List<Object> propertyIds, Map<String, Object> currPropertyValue, String searchText, boolean hasDown) {
        if (propertyIds == null || propertyIds.isEmpty()) {
            return null;
        }
        QFBuilder builder = new QFBuilder();
        builder.add("property", "in", propertyIds);
        if (currPropertyValue != null) {
            String propertyNumber = (String)currPropertyValue.get("property.number");
            String propValNumber = (String)currPropertyValue.get("number");
            if (hasDown) {
                builder.add("property.number", ">=", (Object)propertyNumber);
                builder.add("number", ">", (Object)propValNumber);
            } else {
                builder.add("property.number", "<=", (Object)propertyNumber);
                builder.add("number", "<", (Object)propValNumber);
            }
        }
        builder.add(new QFilter("number", "like", (Object)("%" + searchText + "%")).or("name", "like", (Object)("%" + searchText + "%")));
        String order = hasDown ? "property.number,number" : "property.number desc,number desc";
        DynamicObjectCollection values = QueryServiceHelper.query((String)this.getF7Parameter().getCustomPropertyValueForm(), (String)"id,number,name,property.id,property.number", (QFilter[])builder.toArray(), (String)order, (int)1);
        return values == null || values.size() == 0 ? null : (DynamicObject)values.get(0);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if ("tabproperty".equals(tabKey)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"cbshowdisable", "showscope"});
        } else if ("tabmember".equals(tabKey)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"cbshowdisable", "showscope"});
        }
    }
}

