/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.member.f7.face;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.formplugin.member.f7.SelectedMember;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public interface IMemberF7Parameter {
    default public AbstractMemberF7Parameter loadF7Parameter(@NotNull IFormView formView, @NotNull IPageCache pageCache) {
        AbstractMemberF7Parameter f7Parameter = this.getF7FromCache(pageCache);
        if (f7Parameter == null) {
            f7Parameter = this.getF7FromPageParam(formView);
        }
        if (f7Parameter == null) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458f7\u521d\u59cb\u5316\u5931\u8d25\uff08\u53c2\u6570\u4e3a\u7a7a\uff09", (String)"IMemberF7Parameter_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        } else {
            f7Parameter.check();
            f7Parameter.loadData();
            pageCache.put("KEY_MODEL_ID", IDUtils.toString((Object)f7Parameter.getModelId()));
            pageCache.put("dimensionId", IDUtils.toString((Object)f7Parameter.getDimensionId()));
            pageCache.put("dimensionNumber", f7Parameter.getDimensionNumber());
            this.cacheF7Parameter(pageCache, f7Parameter);
        }
        return f7Parameter;
    }

    default public Long getModelIdByCache(@NotNull IPageCache pageCache) {
        String _modelId = pageCache.get("KEY_MODEL_ID");
        if (StringUtils.isNotEmpty((CharSequence)_modelId)) {
            return IDUtils.toLong((Object)_modelId);
        }
        return null;
    }

    default public Long getDimensionIdByCache(@NotNull IPageCache pageCache) {
        String _dimensionId = pageCache.get("dimensionId");
        if (StringUtils.isNotEmpty((CharSequence)_dimensionId)) {
            return IDUtils.toLong((Object)_dimensionId);
        }
        return null;
    }

    default public AbstractMemberF7Parameter getF7FromCache(@NotNull IPageCache pageCache) {
        String _f7Param = pageCache.get("Member_F7_Cache");
        String _f7ParamClassName = pageCache.get("Member_F7_Cache_ClassName");
        if (_f7Param == null || _f7ParamClassName == null) {
            return null;
        }
        try {
            return (AbstractMemberF7Parameter)JSON.parseObject((String)_f7Param, Class.forName(_f7ParamClassName));
        }
        catch (ClassNotFoundException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ""), new Object[0]);
        }
    }

    default public AbstractMemberF7Parameter getF7FromPageParam(@NotNull IFormView formView) {
        Map customParams = formView.getFormShowParameter().getCustomParams();
        String _f7Param = (String)customParams.get("Member_F7_Param");
        String _f7ParamClassName = (String)customParams.get("Member_F7_Param_ClassName");
        try {
            return (AbstractMemberF7Parameter)JSON.parseObject((String)_f7Param, Class.forName(_f7ParamClassName));
        }
        catch (ClassNotFoundException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ""), new Object[0]);
        }
    }

    default public void cacheF7Parameter(@NotNull IPageCache pageCache, @NotNull AbstractMemberF7Parameter f7Parameter) {
        f7Parameter.setVersion(Long.valueOf(DBServiceHelper.genGlobalLongId()));
        pageCache.put("Member_F7_Cache", JSON.toJSONString((Object)f7Parameter));
        pageCache.put("Member_F7_Cache_ClassName", f7Parameter.getClass().getTypeName());
        this.cacheF7ParamVersion(pageCache, f7Parameter.getVersion().toString());
    }

    default public void cacheF7ParamVersion(@NotNull IPageCache pageCache, @NotNull String version) {
        pageCache.put("Member_F7_Cache_Version", version);
    }

    default public String getF7ParamVersion(@NotNull IPageCache pageCache) {
        return pageCache.get("Member_F7_Cache_Version");
    }

    default public void returnSelectedDataNew(@NotNull IFormView view, @NotNull AbstractMemberF7Parameter f7Param, Map<String, SelectedMember> selectData, @NotNull Map<String, Object> dataParams) {
        if (f7Param.isMustSelected() && (selectData == null || selectData.isEmpty())) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"IMemberF7Parameter_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isNewReturn = f7Param.isNewReturn();
        if (!isNewReturn) {
            HashMap<String, List<String>> _selectData = new HashMap<String, List<String>>(16);
            for (Map.Entry<String, SelectedMember> selectedMemberEntry : selectData.entrySet()) {
                SelectedMember selectedMember = selectedMemberEntry.getValue();
                ArrayList<String> data = new ArrayList<String>(10);
                data.add(String.valueOf(selectedMember.getId()));
                data.add(selectedMember.getNumber());
                data.add(selectedMember.getName());
                data.add(String.valueOf(selectedMember.getScope()));
                data.add(selectedMember.getType());
                data.add(selectedMember.getLongNumber());
                data.add(String.valueOf(selectedMember.getLevel()));
                data.add(selectedMember.isExclude() ? "1" : "0");
                _selectData.put(selectedMemberEntry.getKey(), data);
            }
            this.returnSelectedData(view, f7Param, _selectData, dataParams);
        } else {
            this.returnData(view, selectData, f7Param, dataParams);
        }
        view.close();
    }

    default public void returnData(@NotNull IFormView view, Map<String, SelectedMember> selectData, @NotNull AbstractMemberF7Parameter f7Param, Map<String, Object> dataParams) {
        view.returnDataToParent(selectData);
    }

    default public void returnSelectedData(@NotNull IFormView view, @NotNull AbstractMemberF7Parameter f7Param, Map<String, List<String>> selectData, @NotNull Map<String, Object> dataParams) {
        this.returnData(view, selectData, f7Param);
    }

    default public void returnData(@NotNull IFormView view, Map<String, List<String>> selectData, @NotNull AbstractMemberF7Parameter f7Param) {
        view.returnDataToParent(selectData);
    }
}

