/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.member.f7.face;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IPageCache;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.util.GZIPUtils;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.JSONUtils;
import kd.epm.epbs.formplugin.member.f7.SelectedMember;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public interface ISelectedF7Cache {
    default public Map<String, SelectedMember> selectMembersToNew(Map<String, List<String>> selectMembers) {
        HashMap<String, SelectedMember> _selectMembers = new HashMap<String, SelectedMember>(16);
        if (selectMembers != null) {
            for (Map.Entry<String, List<String>> entry : selectMembers.entrySet()) {
                List<String> values = entry.getValue();
                SelectedMember selectedMember = new SelectedMember();
                for (int i = 0; i < values.size(); ++i) {
                    String value = values.get(i);
                    if (i == 0) {
                        selectedMember.setId(Long.parseLong(value));
                        continue;
                    }
                    if (i == 1) {
                        selectedMember.setNumber(value);
                        continue;
                    }
                    if (i == 2) {
                        selectedMember.setName(value);
                        continue;
                    }
                    if (i == 3) {
                        selectedMember.setScope(Integer.parseInt(value));
                        continue;
                    }
                    if (i == 4) {
                        selectedMember.setType(value);
                        continue;
                    }
                    if (i == 5) {
                        selectedMember.setLongNumber(value);
                        continue;
                    }
                    if (i == 6) {
                        selectedMember.setLevel(Integer.parseInt(value));
                        continue;
                    }
                    if (i != 7) continue;
                    selectedMember.setExclude("1".equals(value));
                }
                _selectMembers.put(entry.getKey(), selectedMember);
            }
        }
        return _selectMembers;
    }

    default public void cacheSelectMember(@NotNull IPageCache pageCache, Map<String, List<String>> selectMembers) {
        this.cacheSelectMemberNew(pageCache, this.selectMembersToNew(selectMembers));
    }

    default public void cacheSelectMemberNew(@NotNull IPageCache pageCache, Map<String, SelectedMember> selectMembers) {
        if (selectMembers == null || selectMembers.isEmpty()) {
            pageCache.remove("LIST_MEMBER_CACHE_SELECT");
        } else {
            pageCache.put("LIST_MEMBER_CACHE_SELECT", SerializationUtils.serializeToBase64((Object)GZIPUtils.compress((String)JSON.toJSONString(selectMembers))));
        }
    }

    default public LinkedHashMap<String, SelectedMember> getSelectedIdsFromCache(@NotNull IPageCache pageCache) {
        LinkedHashMap selectMembers;
        String _cacheStr = pageCache.get("LIST_MEMBER_CACHE_SELECT");
        if (StringUtils.isNotEmpty((CharSequence)_cacheStr)) {
            _cacheStr = GZIPUtils.uncompressToString((byte[])((byte[])SerializationUtils.deSerializeFromBase64((String)_cacheStr)));
            selectMembers = (LinkedHashMap)JSONUtils.parse((String)_cacheStr, (TypeReference)this.getSelectMemberType());
        } else {
            selectMembers = new LinkedHashMap(16);
        }
        return selectMembers;
    }

    default public TypeReference getSelectMemberType() {
        return new TypeReference<LinkedHashMap<String, SelectedMember>>(){};
    }

    default public void putSelectedMemberNew(@NotNull Map<String, SelectedMember> selectMembers, Collection<?> objects, @NotNull String memberType) {
        if (objects == null || objects.isEmpty()) {
            return;
        }
        for (Object _object : objects) {
            SelectedMember selectedMember = this.newSelectMember((DynamicObject)_object, memberType);
            selectMembers.put(String.valueOf(selectedMember.getId()), selectedMember);
        }
    }

    default public SelectedMember newSelectMember(DynamicObject member, String memberType) {
        return new SelectedMember().of(member, memberType);
    }

    default public SelectedMember newSelectMember(Long id, String memberType, AbstractMemberF7Parameter f7Parameter) {
        return new SelectedMember().loadMember(id, memberType, f7Parameter);
    }

    default public void putSelectedMember(@NotNull Map<String, List<String>> selectMembers, SelectedMember member) {
        this.putSelectedMemberNew(this.selectMembersToNew(selectMembers), member);
    }

    default public void putSelectedMemberNew(@NotNull Map<String, SelectedMember> selectMembers, SelectedMember member) {
        if (member == null) {
            return;
        }
        String pk = this.getSelectMemberPk(member);
        selectMembers.put(pk, member);
    }

    default public String getSelectMemberPk(SelectedMember member) {
        return IDUtils.toString((Object)member.getId());
    }
}

