/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.model.dimension.DimensionServiceHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.bean.ModelBean;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.model.IMetaDataEntity;
import kd.epm.epbs.common.model.bean.BizModelDimBean;
import kd.epm.epbs.common.model.bean.ViewBean;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.GlobalIdUtil;
import kd.epm.epbs.common.util.NumberRuleUtils;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.common.util.OperationMsgUtil;

public class DimensionFormPlugin
extends AbstractBasePlugIn
implements ClickListener,
IConfirmCallBack,
IMetaDataEntity {
    private static final Log log = LogFactory.getLog(DimensionFormPlugin.class);
    private static final String STEP1 = "tabpageap";
    private static final String STEP2 = "tabpageap1";
    private static final String STEP3 = "tabpageap2";
    private static final String NEXT = "btnnext";
    private static final String PRE = "btnprev";
    private static final String FINISH = "finish";
    public static final String ID_CACHE = "id_cache";
    public static final String CURRENTTAB_CACHE = "currenttab_cache";
    private static final String BILLLISTAP = "billlistap";
    private static final String RADIOGROUPFIELD = "radiogroupfield";
    private static final String BASEBILLLISTAP = "basebilllistap";
    private static final String ADDFLEXPANELAP = "addflexpanelap";
    private static final String BASEFLEXPANELAP = "baseflexpanelap";
    public static final String ID_CACHE_CHANGE = "id_cache_change";

    public void initialize() {
        super.initialize();
        BillList billlistapList = (BillList)this.getView().getControl(BILLLISTAP);
        billlistapList.addSetFilterListener(this::setFilter);
        billlistapList.setOrderBy("desq");
        BillList basebillList = (BillList)this.getView().getControl(BASEBILLLISTAP);
        basebillList.addSetFilterListener(this::setFilter);
        basebillList.addCreateListDataProviderListener(args -> args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection rows = super.getData(arg0, arg1);
                this.getQueryResult().setDataCount(this.getRealCount());
                return rows;
            }
        }));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{RADIOGROUPFIELD, NEXT, PRE});
        Tab tab = (Tab)this.getControl("guidecontent");
        tab.addTabSelectListener(evt -> {
            String key = evt.getTabKey();
            if (key.equals(STEP3)) {
                try {
                    Thread.sleep(1000L);
                    this.getView().close();
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"wizardap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{FINISH, PRE});
        this.getView().setVisible(Boolean.FALSE, new String[]{BASEBILLLISTAP, BASEFLEXPANELAP});
        this.setMustInput(false);
        FieldEdit number = (FieldEdit)this.getControl("baseshortnumber");
        number.setMustInput(false);
        this.refreshBillList(BILLLISTAP);
        this.refreshBillList(BASEBILLLISTAP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void click(EventObject evt) {
        DimensionFormPlugin dimensionFormPlugin = this;
        synchronized (dimensionFormPlugin) {
            String key;
            super.click(evt);
            switch (key = ((Control)evt.getSource()).getKey()) {
                case "btnnext": {
                    boolean flag = this.processNext();
                    if (!flag) break;
                    this.next();
                    break;
                }
                case "btnprev": {
                    this.previous();
                    break;
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (key) {
            case "radiogroupfield": {
                if (newValue.equals(oldValue)) {
                    return;
                }
                if ("1".equals(newValue)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{ADDFLEXPANELAP});
                    this.getView().setVisible(Boolean.TRUE, new String[]{BASEBILLLISTAP, BASEFLEXPANELAP});
                    this.getView().getModel().setValue("baseshortnumber", null);
                    this.setMustInput(false);
                    this.refreshBillList(BASEBILLLISTAP);
                    break;
                }
                this.setMustInput(true);
                this.getView().setVisible(Boolean.TRUE, new String[]{ADDFLEXPANELAP});
                this.getView().setVisible(Boolean.FALSE, new String[]{BASEBILLLISTAP, BASEFLEXPANELAP});
                this.getView().getModel().setValue("dimnumber", null);
                this.getView().getModel().setValue("dimname", null);
                this.getView().getModel().setValue("dimshortnumber", null);
                this.getView().getModel().setValue("description", null);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String idstr = this.getPageCache().get(ID_CACHE);
        if (!StringUtils.isBlank((CharSequence)idstr)) {
            this.getView().returnDataToParent((Object)Long.parseLong(idstr));
        }
    }

    public void setFilter(SetFilterEvent e) {
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
        ModelBean model = modelCache.getModel();
        BillList source = (BillList)e.getSource();
        String key = source.getKey();
        if (BILLLISTAP.equals(key)) {
            e.getQFilters().add(new QFilter("appnumber", "=", (Object)model.getSrcAppNum()).and("status", "=", (Object)"1"));
        } else {
            e.getQFilters().add(new QFilter("enable", "=", (Object)"1"));
        }
        Object dimTypeList = this.getView().getFormShowParameter().getCustomParam("dimTypeList");
        if (dimTypeList != null) {
            String dimensionIdStr = (String)dimTypeList;
            List typeList = (List)SerializationUtils.fromJsonString((String)dimensionIdStr, List.class);
            e.getQFilters().add(new QFilter("type", "in", (Object)typeList));
        }
    }

    private Long getModelId() {
        Object model = this.getView().getFormShowParameter().getCustomParam("model");
        if (model != null) {
            return (Long)model;
        }
        return 0L;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
    }

    private String getCurrentTab() {
        Tab tab = (Tab)this.getView().getControl("guidecontent");
        String currentTabCache = this.getPageCache().get(CURRENTTAB_CACHE);
        String currentTab = tab.getCurrentTab();
        if (!StringUtils.isBlank((CharSequence)currentTabCache) && !currentTab.equals(currentTabCache)) {
            currentTab = currentTabCache;
        }
        return currentTab;
    }

    private void next() {
        Tab tab = (Tab)this.getView().getControl("guidecontent");
        String currentTab = this.getCurrentTab();
        for (int i = 0; i < tab.getItems().size(); ++i) {
            if (currentTab.equals(((Control)tab.getItems().get(tab.getItems().size() - 1)).getKey())) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5411\u5bfc\u5df2\u5b8c\u6210\uff0c\u662f\u5426\u9000\u51fa\u672c\u9875?", (String)"DimensionFormPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("exitGuideCallBack"));
                break;
            }
            Control control = (Control)tab.getItems().get(i);
            if (!control.getKey().equals(currentTab)) continue;
            String key = ((Control)tab.getItems().get(i + 1)).getKey();
            this.getPageCache().put(CURRENTTAB_CACHE, key);
            tab.activeTab(key);
            this.getView().updateView("guidecontent");
            break;
        }
    }

    private void previous() {
        String currentTab;
        FieldEdit number = (FieldEdit)this.getControl("baseshortnumber");
        Tab tab = (Tab)this.getView().getControl("guidecontent");
        switch (currentTab = this.getCurrentTab()) {
            case "tabpageap": {
                break;
            }
            case "tabpageap1": {
                number.setMustInput(false);
                this.setMustInput(false);
                this.getView().setVisible(Boolean.FALSE, new String[]{PRE});
                break;
            }
            case "tabpageap2": {
                break;
            }
        }
        for (int i = 0; i < tab.getItems().size(); ++i) {
            if (currentTab.equals(((Control)tab.getItems().get(0)).getKey())) {
                return;
            }
            Control control = (Control)tab.getItems().get(i);
            if (!control.getKey().equals(currentTab)) continue;
            String key = ((Control)tab.getItems().get(i - 1)).getKey();
            this.getPageCache().put(CURRENTTAB_CACHE, key);
            tab.activeTab(key);
            break;
        }
    }

    private boolean processNext() {
        boolean flag = true;
        this.getView().updateView();
        FieldEdit number = (FieldEdit)this.getControl("baseshortnumber");
        switch (this.getCurrentTab()) {
            case "tabpageap": {
                BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
                Object[] selectedIds = billList.getSelectedRows().getPrimaryKeyValues();
                if (selectedIds == null || selectedIds.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u7c7b\u578b\u3002", (String)"DimensionFormPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    return false;
                }
                number.setMustInput(true);
                this.setMustInput(true);
                this.getView().setVisible(Boolean.TRUE, new String[]{PRE});
                break;
            }
            case "tabpageap1": {
                String addType = (String)this.getModel().getValue(RADIOGROUPFIELD);
                if ("1".equals(addType)) {
                    BillList baseBillList = (BillList)this.getView().getControl(BASEBILLLISTAP);
                    Object[] selectedBaseIds = baseBillList.getSelectedRows().getPrimaryKeyValues();
                    if (selectedBaseIds == null || selectedBaseIds.length == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u57fa\u7840\u8d44\u6599\u3002", (String)"DimensionFormPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                    flag = this.checkBaseData();
                } else {
                    String msg = DimensionServiceHelper.checkAddData((AbstractFormPlugin)this);
                    if (!StringUtils.isBlank((CharSequence)msg)) {
                        flag = false;
                        this.getView().showTipNotification(msg);
                    } else {
                        flag = true;
                    }
                }
                if (!flag) break;
                this.saveData();
                this.getView().setVisible(Boolean.FALSE, new String[]{NEXT});
                this.getView().setVisible(Boolean.TRUE, new String[]{FINISH});
                break;
            }
            case "tabpageap2": {
                break;
            }
        }
        return flag;
    }

    private boolean checkBaseData() {
        String shortnumber = this.getView().getModel().getValue("baseshortnumber").toString();
        Object model = this.getView().getFormShowParameter().getCustomParam("model");
        if (!NumberRuleUtils.checkShortNumber((String)shortnumber)) {
            this.getView().showTipNotification(NumberRuleUtils.getShrotNumberMessage());
            return false;
        }
        BillList billList = (BillList)this.getView().getControl(BASEBILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        DynamicObject sourceobj = BusinessDataServiceHelper.loadSingle((Object)selectedRows.getPrimaryKeyValues()[0], (String)billList.getEntityType().getName(), (String)"id,number");
        if (sourceobj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"DimensionFormPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        Object number = sourceobj.get("number");
        QFilter filter = new QFilter("number", "=", (Object)String.valueOf(number)).and(new QFilter("model", "=", model));
        boolean existRepeatNumber = QueryServiceHelper.exists((String)this.getMetaDataEntity(this.getView(), "epbs_dimension"), (QFilter[])new QFilter[]{filter});
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.ADDNEW) && existRepeatNumber) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201d%s\u201c\u7f16\u7801\u91cd\u590d\u3002", (String)"ManageObjectPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]), number));
            return false;
        }
        filter = new QFilter("shortnumber", "=", (Object)String.valueOf(shortnumber)).and(new QFilter("model", "=", model));
        existRepeatNumber = QueryServiceHelper.exists((String)this.getMetaDataEntity(this.getView(), "epbs_dimension"), (QFilter[])new QFilter[]{filter});
        if (status.equals((Object)OperationStatus.ADDNEW) && existRepeatNumber) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201d%s\u201c\u7b80\u7801\u91cd\u590d\u3002", (String)"DimensionFormPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]), shortnumber));
            return false;
        }
        if (shortnumber.equals(String.valueOf(number))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u548c\u7b80\u7801\u4e0d\u80fd\u4e00\u81f4\u3002", (String)"DimensionFormPlugin_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void refreshBillList(String activebill) {
        BillList activebillList = (BillList)this.getView().getControl(activebill);
        activebillList.getRealCount();
        activebillList.refresh();
        activebillList.clearSelection();
    }

    private void setMustInput(boolean flag) {
        FieldEdit number = (FieldEdit)this.getControl("dimnumber");
        number.setMustInput(flag);
        FieldEdit name = (FieldEdit)this.getControl("dimname");
        name.setMustInput(flag);
        FieldEdit shortnumber = (FieldEdit)this.getControl("dimshortnumber");
        shortnumber.setMustInput(flag);
    }

    private void saveData() {
        BillList billList;
        DynamicObject dimension = BusinessDataServiceHelper.newDynamicObject((String)this.getMetaDataEntity(this.getView(), "epbs_dimension"));
        String addType = (String)this.getModel().getValue(RADIOGROUPFIELD);
        if ("1".equals(addType)) {
            billList = (BillList)this.getView().getControl(BASEBILLLISTAP);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            DynamicObject sourceobj = BusinessDataServiceHelper.loadSingle((Object)selectedRows.getPrimaryKeyValues()[0], (String)billList.getEntityType().getName(), (String)"id,number,name");
            if (sourceobj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"DimensionFormPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            Object number = sourceobj.get("number");
            dimension.set("number", number);
            dimension.set("shortnumber", this.getView().getModel().getValue("baseshortnumber"));
            dimension.set("name", (Object)sourceobj.getLocaleString("name"));
            dimension.set("basedataid", sourceobj.get("id"));
            dimension.set("description", null);
        } else {
            dimension.set("basedataid", null);
            DynamicObject modelobj = this.getModel().getDataEntity();
            String number = modelobj.getString("dimnumber");
            Object name = modelobj.get("dimname");
            String shortnumber = modelobj.getString("dimshortnumber");
            Object description = modelobj.get("description");
            if (name instanceof Map) {
                dimension.set("name", (Object)LocaleString.fromMap((Map)((Map)name)));
            } else {
                dimension.set("name", (Object)name.toString());
            }
            if (description instanceof Map) {
                dimension.set("description", (Object)LocaleString.fromMap((Map)((Map)description)));
            } else {
                dimension.set("description", (Object)description.toString());
            }
            dimension.set("number", (Object)number);
            dimension.set("shortnumber", (Object)shortnumber);
        }
        dimension.set("type", (Object)addType);
        dimension.set("model", this.getView().getFormShowParameter().getCustomParam("model"));
        billList = (BillList)this.getView().getControl(BILLLISTAP);
        Object[] selectedIds = billList.getSelectedRows().getPrimaryKeyValues();
        dimension.set("dtypeid", selectedIds[0]);
        dimension.set("issysdimension", (Object)0);
        Long bizModelId = (Long)this.getView().getFormShowParameter().getCustomParam("bizModelId");
        if (bizModelId != null && bizModelId != 0L) {
            dimension.set("refid", (Object)bizModelId);
            dimension.set("reftype", (Object)2);
        }
        JSONObject jsonObject = DimensionServiceHelper.saveData((DynamicObject)dimension);
        String appNum = ModelCacheHelper.getModel((long)this.getModelId()).getSrcAppNum().toLowerCase(Locale.ENGLISH);
        OperationLogUtil.writeLog((String)appNum, (String)this.getView().getEntityId(), (IOperationTypeInfo)OperationTypeEnum.SAVE, (MultiLangEnumBridge)OperationMsgUtil.getSaveSucTipWithNumber((String)dimension.getString("number")));
        this.getPageCache().put(ID_CACHE, jsonObject.getString("dimId"));
        this.saveDimRefByParamJump(dimension);
    }

    private void saveDimRefByParamJump(DynamicObject dimension) {
        Long bizModelId = (Long)this.getView().getFormShowParameter().getCustomParam("bizModelId");
        if (bizModelId != null && bizModelId != 0L) {
            Long viewId;
            Map dimBeanMap = EpbsModelCacheHelper.get((long)this.getModelId()).getBizModelById(bizModelId.longValue()).getDimMap();
            EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
            DynamicObject dimRef = BusinessDataServiceHelper.newDynamicObject((String)modelCache.getMetaDataEntity("epbs_dimmodelref"));
            long dimRefId = GlobalIdUtil.genGlobalLongId();
            dimRef.set("id", (Object)dimRefId);
            dimRef.set("businessdomain", (Object)0);
            dimRef.set("bizmodel", (Object)bizModelId);
            Long dimensionId = dimension.getLong("id");
            dimRef.set("dimension", (Object)dimensionId);
            dimRef.set("model", (Object)this.getModelId());
            dimRef.set("sourcedim", (Object)0);
            dimRef.set("aggoprttype", (Object)3);
            dimRef.set("createtype", (Object)1);
            dimRef.set("issync", (Object)"0");
            Integer maxDseq = DimensionFormPlugin.findMaxDseq(dimBeanMap);
            if (maxDseq == null) {
                maxDseq = 99;
            }
            dimRef.set("dseq", (Object)(maxDseq + 1));
            DynamicObjectCollection dimviews = dimRef.getDynamicObjectCollection("dimviews");
            dimviews.clear();
            ViewBean defaultView = modelCache.getDefaultView(dimensionId.longValue());
            if (defaultView != null && (viewId = Long.valueOf(defaultView.getId())) != 0L) {
                DynamicObject viewRef = new DynamicObject(dimviews.getDynamicObjectType());
                viewRef.set("view", (Object)viewId);
                dimviews.add((Object)viewRef);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dimRef});
            EpbsModelCacheHelper.invalidateModelKeyById((Long)this.getModelId());
            try {
                if (this.getView().getParentView() != null && this.getView().getParentView().getParentView() != null) {
                    this.getView().getParentView().getParentView().getPageCache().put(ID_CACHE_CHANGE, String.valueOf(bizModelId));
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
    }

    public static Integer findMaxDseq(Map<Long, BizModelDimBean> dimBeanMap) {
        Optional<Integer> maxDseqOptional = dimBeanMap.values().stream().map(BizModelDimBean::getDseq).max(Integer::compareTo);
        return maxDseqOptional.orElse(null);
    }
}

