/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.model.bizmodel.BizModelServiceHelper;
import kd.epm.epbs.business.model.member.MemberDao;
import kd.epm.epbs.business.model.member.MemberDaoFactory;
import kd.epm.epbs.business.olap.OlapServiceHelper;
import kd.epm.epbs.business.permission.model.ModelPermHelper;
import kd.epm.epbs.common.enums.model.DayEnum;
import kd.epm.epbs.common.enums.model.DimTypeEnum;
import kd.epm.epbs.common.enums.model.MonthEnum;
import kd.epm.epbs.common.enums.model.PeriodYearEnum;
import kd.epm.epbs.common.model.bean.BizModelBean;
import kd.epm.epbs.common.model.bean.BizModelDimBean;
import kd.epm.epbs.common.model.bean.DimManagerMemberTree;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.bean.DimensionBean;
import kd.epm.epbs.common.model.bean.ViewBean;
import kd.epm.epbs.common.model.cache.DimTypeCache;
import kd.epm.epbs.common.model.cache.DimTypeCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.tree.AbstractTreeBuilder;
import kd.epm.epbs.common.tree.DynamicObjectTreeNode;
import kd.epm.epbs.common.tree.DynamicTreeContext;
import kd.epm.epbs.common.tree.LeftTreeSearch;
import kd.epm.epbs.common.tree.NoParentDynamicTreeBuilder;
import kd.epm.epbs.common.tree.SimpleDynamicTreeBuilder;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.OperationResultUtil;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;
import kd.epm.epbs.formplugin.model.importplugin.DimMemImportBasePlugin;
import org.elasticsearch.common.Strings;
import org.jetbrains.annotations.NotNull;

public class DimensionManagerListPlugin
extends AbstractBaseListPlugin
implements TreeNodeClickListener,
LeftTreeSearch,
HyperLinkClickListener,
TreeNodeQueryListener {
    protected static final String VIEW_TREE = "viewtree";
    protected static final String DIM_TREE = "dimtree";
    protected static final String MEMBER_TREE = "treeentryentity";
    protected static final String MEMBER_ENTITY = "entryentity";
    boolean iconVisible = false;
    protected static final String IS_SEARCH = "issearch";
    private static final String MEMBERTREE_VIEW = "membertree_view";
    private final String[] MEMBER_FIELDS = new String[]{"number", "longnumber", "shownumber", "name", "level", "enable", "sourcetype", "modifier.name", "modifytime", "aggoprt"};

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{MEMBER_ENTITY});
        TreeView treeView = (TreeView)this.getView().getControl(VIEW_TREE);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView dimTreeView = (TreeView)this.getView().getControl(DIM_TREE);
        dimTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_addviewgp", "btn_addview", "btn_editview", "btn_delview", "btn_adddim", "btn_editdim", "btn_deldim", "searchbefore", "searchnext"});
        this.addItemClickListeners(new String[]{"operationtoor", "toolbarap"});
        Search searchap = (Search)this.getView().getControl("searchap");
        searchap.addEnterListener(evt -> {
            String text = evt.getText().trim();
            TreeView dimTv = (TreeView)this.getView().getControl(DIM_TREE);
            this.getView().getPageCache().put(IS_SEARCH, "1");
            this.leftSearch(dimTv, text);
            this.getView().getPageCache().remove(IS_SEARCH);
        });
        Search searchMember = (Search)this.getView().getControl("searchmember");
        searchMember.addEnterListener(evt -> {
            TreeView treeView = (TreeView)this.getView().getControl(VIEW_TREE);
            Map focusNodeData = AbstractTreeBuilder.getFocusNodeData((TreeView)treeView);
            if (focusNodeData != null && Objects.equals(focusNodeData.get("isgroup"), true)) {
                this.refreshList();
            }
        });
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(MEMBER_TREE);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addCellClickListener((TreeNodeQueryListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String enable;
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"bizmodel"});
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object bizModelId = formShowParameter.getCustomParam("bizModelId");
        if (bizModelId != null) {
            DynamicObject bizModel = BusinessDataServiceHelper.loadSingle((Object)bizModelId, (String)this.getMetaDataEntity(this.getView(), "epbs_bizmodel"), (String)"model");
            this.getModel().setValue("model", bizModel.get("model"));
            this.getModel().setValue("bizmodel", (Object)bizModel);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bizmodel"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_deldim"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"model"});
        } else {
            this.setDefaultModel();
        }
        long modelId = this.getModelId();
        if (!IDUtils.isNull((long)modelId)) {
            Object focusNodeIdObj = this.getView().getFormShowParameter().getCustomParam("focusNodeId");
            String focusNodeId = null;
            if (focusNodeIdObj != null) {
                focusNodeId = String.valueOf(focusNodeIdObj);
            }
            this.initDimTree(focusNodeId);
        }
        if ("1".equals(enable = (String)formShowParameter.getCustomParam("enable"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_adddim", "btn_editdim", "btn_deldim", "btn_addviewgp", "btn_addview", "btn_editview", "btn_delview"});
        }
    }

    protected Long getViewId() {
        TreeView tree = (TreeView)this.getView().getControl(VIEW_TREE);
        String focusNodeId = tree.getTreeState().getFocusNodeId();
        try {
            return Long.parseLong(focusNodeId);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    protected Long getDimensionId() {
        TreeView tree = (TreeView)this.getView().getControl(DIM_TREE);
        String focusNodeId = tree.getTreeState().getFocusNodeId();
        if (focusNodeId == null || "#".equals(focusNodeId)) {
            return 0L;
        }
        return Long.parseLong(focusNodeId);
    }

    private Long getDimensionIdWithCheck() {
        Long dimensionId = this.getDimensionId();
        if (dimensionId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6", (String)"DimensionManagerListPlugin_14", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        return dimensionId;
    }

    protected long getBizModelId() {
        DynamicObject bizModel = (DynamicObject)this.getModel().getValue("bizmodel");
        if (bizModel != null) {
            return bizModel.getLong("id");
        }
        Object bizModel1 = this.getView().getFormShowParameter().getCustomParam("bizModelId");
        if (bizModel1 != null && !Objects.equals(bizModel1, 0L)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u578b\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"DimensionManagerListPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        return 0L;
    }

    private void initViewTree(String focusNodeId) {
        TreeView treeView = (TreeView)this.getView().getControl(VIEW_TREE);
        if (focusNodeId == null || "0".equals(focusNodeId)) {
            focusNodeId = treeView.getTreeState().getFocusNodeId();
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object type = formShowParameter.getCustomParam("type");
        Long dimensionId = this.getDimensionId();
        if (dimensionId != 0L) {
            DimTypeEnum dimTypeEnum;
            Boolean existDimension;
            Object refBizModelId;
            QFilter qFilter = new QFilter("dimension", "=", (Object)dimensionId);
            long bizModelId = this.getBizModelId();
            if (!ObjectUtils.isEmpty((Object)type) && "2".equals(type) && !ObjectUtils.isEmpty((Object)(refBizModelId = formShowParameter.getCustomParam("refBizModelId"))) && bizModelId != 0L) {
                bizModelId = Long.parseLong(refBizModelId.toString());
            }
            if (bizModelId != 0L) {
                qFilter.and(new QFilter("bizmodel", "=", (Object)bizModelId).or("type", "=", (Object)"1"));
            }
            if ((existDimension = this.checkExistDimView()).booleanValue()) {
                BizModelDimBean bizModelDimBean;
                EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
                Long bizModelIdParam = (Long)this.getView().getFormShowParameter().getCustomParam("bizModelId");
                if (bizModelIdParam != null && bizModelIdParam != 0L && (bizModelDimBean = (BizModelDimBean)modelCache.getBizModelById(bizModelIdParam.longValue()).getDimMap().get(this.getDimensionId())) != null) {
                    List viewIds = bizModelDimBean.getViewIds();
                    HashSet groupIdList = Sets.newHashSetWithExpectedSize((int)viewIds.size());
                    HashSet parentIdList = Sets.newHashSetWithExpectedSize((int)viewIds.size());
                    for (Long viewId : viewIds) {
                        Long gbId = modelCache.getViewById(viewId.longValue()).getGroupId();
                        groupIdList.add(gbId);
                        parentIdList.add(gbId);
                    }
                    qFilter.and(new QFilter("parent", "in", (Object)groupIdList).or("id", "in", (Object)parentIdList));
                }
            }
            DynamicTreeContext context = new DynamicTreeContext(this.getMetaDataEntity(this.getView(), "epbs_struct_view"));
            context.setSelectFields("id,number,name,parent,isgroup");
            context.setOrderby("createtime");
            context.setqFilters(qFilter.toArray());
            context.setFocusTreeId(focusNodeId);
            context.setClickFirstChild(true);
            context.setMultiRoot(true);
            AbstractTreeBuilder treeBuilder = new SimpleDynamicTreeBuilder(context).buildTree(treeView);
            if (this.iconVisible && treeBuilder != null && treeBuilder.getRoot() != null) {
                this.SetFolderIcon(treeBuilder.getRoot());
            }
            if (treeBuilder != null) {
                treeBuilder.nodeClick();
            }
            EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
            DimTypeBean dimType = modelCache.getDimTypeByDimensionId(dimensionId.longValue());
            SplitContainer splitc = (SplitContainer)this.getControl("splitcontainer_inside");
            splitc.hidePanel(SplitDirection.left, !dimType.isShowView());
            Object bizModelIdOrBusId = this.getView().getFormShowParameter().getCustomParam("bizModelIdOrBusId");
            if (bizModelIdOrBusId != null) {
                splitc.setSubContainerMinWidth(240);
            }
            if ((dimTypeEnum = DimTypeEnum.getDimType((String)dimType.getType())) != null) {
                this.getView().setVisible(Boolean.valueOf(DimTypeEnum.Period != dimTypeEnum), new String[]{"btn_addviewgp"});
                this.getView().setVisible(Boolean.valueOf(dimTypeEnum.isHasCustomProperty()), new String[]{"propertydefined"});
            }
        } else {
            TreeView viewTree = (TreeView)this.getView().getControl(VIEW_TREE);
            viewTree.deleteAllNodes();
            this.refreshList();
        }
        this.jumpSetAddViewGpVisible(dimensionId);
    }

    private void jumpSetAddViewGpVisible(Long dimensionId) {
        Object bizModelIdOrBusId = this.getView().getFormShowParameter().getCustomParam("bizModelIdOrBusId");
        if (bizModelIdOrBusId != null) {
            Boolean existDimension;
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_addviewgp"});
            EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
            DimTypeBean dimType = modelCache.getDimTypeByDimensionId(dimensionId.longValue());
            DimTypeEnum dimTypeEnum = DimTypeEnum.getDimType((String)dimType.getType());
            if (dimTypeEnum != null) {
                this.getView().setVisible(Boolean.valueOf(DimTypeEnum.Period != dimTypeEnum), new String[]{"btn_addviewgp"});
                this.getView().setVisible(Boolean.valueOf(dimTypeEnum.isHasCustomProperty()), new String[]{"propertydefined"});
            }
            if ((existDimension = this.checkExistDimView()).booleanValue()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_addviewgp"});
            }
        }
    }

    private Boolean checkExistDimView() {
        Boolean existDimension = false;
        Long bizModelIdParam = (Long)this.getView().getFormShowParameter().getCustomParam("bizModelId");
        if (bizModelIdParam != null && bizModelIdParam != 0L) {
            EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
            DimensionBean dimensionBean = modelCache.getDimensionById(this.getDimensionId().longValue());
            BizModelBean bizModelBean = modelCache.getBizModelById(bizModelIdParam.longValue());
            if (bizModelBean != null && dimensionBean != null) {
                existDimension = OlapServiceHelper.isExistDimension((String)bizModelBean.getCube(), (long)this.getModelId(), (String)dimensionBean.getNumber());
            }
        }
        return existDimension;
    }

    private void initDimTree(String focusNodeId) {
        TreeNode focusNode;
        List children;
        Object dimensionId;
        DynamicTreeContext context;
        AbstractTreeBuilder treeBuilder;
        TreeNode root;
        TreeView treeView = (TreeView)this.getView().getControl(DIM_TREE);
        if (focusNodeId == null || "0".equals(focusNodeId)) {
            focusNodeId = treeView.getTreeState().getFocusNodeId();
        }
        if ((root = (treeBuilder = new NoParentDynamicTreeBuilder(context = this.getDimTreeContext(dimensionId = this.getView().getFormShowParameter().getCustomParam("dimensionId"), focusNodeId)).buildTree(treeView)).getRoot()).getId().equals("#") || root.getId().equals("0")) {
            treeView.setRootVisible(false);
            treeView.deleteAllNodes();
            treeView.addNode(root);
        }
        if (root != null && CollectionUtils.isNotEmpty((Collection)(children = root.getChildren()))) {
            for (int i = 0; i < children.size(); ++i) {
                TreeNode treeNode = (TreeNode)children.get(i);
                Map map = (Map)treeNode.getData();
                String shortnumber = map.get("shortnumber").toString();
                String text = treeNode.getText();
                treeNode.setText(text + "(" + shortnumber + ")");
            }
            if (this.iconVisible) {
                this.SetIcon(children);
            }
        }
        if ((focusNode = root.getTreeNode(focusNodeId)) == null) {
            List children2 = root.getChildren();
            focusNode = !CollectionUtils.isEmpty((Collection)children2) ? (TreeNode)children2.get(0) : root;
        }
        treeView.focusNode(focusNode);
        treeView.expand(focusNode.getId());
        treeView.treeNodeClick(focusNode.getParentid(), focusNode.getId());
    }

    private void SetIcon(List<TreeNode> nodes) {
        try {
            HashMap<String, String> dic = new HashMap<String, String>();
            dic.put("InternalCompany", "kdfont kdfont-gongyingshang5");
            dic.put("Entity", "kdfont kdfont-bumen2");
            dic.put("Period", "kdfont kdfont-rili");
            dic.put("Account", "kdfont kdfont-jiliangdanwei");
            dic.put("Currency", "kdfont kdfont-qian15");
            dic.put("Year", "kdfont kdfont-daijiesuan");
            dic.put("Process", "kdfont kdfont-liuliang2");
            dic.put("DataType", "kdfont kdfont-kecheng");
            dic.put("EntityList", "kdfont kdfont-weiduzhitianchong2");
            dic.put("Version", "kdfont kdfont-zhideng2");
            dic.put("Scenario", "kdfont kdfont-kecheng");
            String custom = "kdfont kdfont-zidingyi";
            List ids = nodes.stream().map(x -> Long.parseLong(x.getId())).collect(Collectors.toList());
            DynamicObjectCollection types = QueryServiceHelper.query((String)this.getMetaDataEntity(this.getView(), "epbs_dimension"), (String)"id, dtypeid", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            HashMap dimId2TypeIdMap = new HashMap();
            types.forEach(x -> dimId2TypeIdMap.put(x.getLong("id"), x.getLong("dtypeid")));
            List typeIds = types.stream().map(x -> x.getLong("dtypeid")).collect(Collectors.toList());
            DynamicObjectCollection typeId2Number = QueryServiceHelper.query((String)"epbs_dimtype", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("id", "in", typeIds)});
            HashMap typeId2NumberMap = new HashMap();
            typeId2Number.forEach(x -> typeId2NumberMap.put(x.getLong("id"), x.getString("number")));
            nodes.forEach(item -> {
                String type;
                Long typeId;
                item.setIcon(custom);
                if (!Strings.isNullOrEmpty((String)item.getId()) && dimId2TypeIdMap.containsKey(Long.parseLong(item.getId())) && typeId2NumberMap.containsKey(typeId = (Long)dimId2TypeIdMap.get(Long.parseLong(item.getId()))) && !Strings.isNullOrEmpty((String)(type = (String)typeId2NumberMap.get(typeId)))) {
                    item.setIcon(dic.getOrDefault(type, custom));
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void SetFolderIcon(TreeNode root) {
        if (root == null) {
            return;
        }
        List nodes = root.getChildren();
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        HashMap<String, String> dic = new HashMap<String, String>();
        dic.put("folder", "kdfont kdfont-wenjianjia2");
        dic.put("leaf", "kdfont kdfont-jichuziliao4");
        root.setIcon((String)dic.get("folder"));
        nodes.forEach(item -> {
            if (item.isLeaf() && !"0".equals(item.getParentid())) {
                item.setIcon((String)dic.get("leaf"));
            } else {
                item.setIcon((String)dic.get("folder"));
                List children = item.getChildren();
                if (children != null && !children.isEmpty()) {
                    children.forEach(nc -> nc.setIcon((String)dic.get("leaf")));
                }
            }
        });
    }

    @NotNull
    private DynamicTreeContext getDimTreeContext(Object dimensionId, String focusNodeId) {
        Long bizModelId = (Long)this.getView().getFormShowParameter().getCustomParam("bizModelIdOrBusId");
        if (bizModelId != null && bizModelId != 0L) {
            DynamicTreeContext context = new DynamicTreeContext(this.getMetaDataEntity(this.getView(), "epbs_dimmodelref"));
            context.setSelectFields("dimension.id as id,dimension.number as number,dimension.name as name,dimension.issysdimension as issysdimension,dimension.shortnumber as shortnumber,dimension.name as refname");
            QFilter qFilter = new QFilter("bizmodel.id", "=", (Object)bizModelId);
            context.setOrderby("dseq");
            context.setqFilters(qFilter.toArray());
            context.setFocusTreeId(focusNodeId);
            return context;
        }
        QFilter qFilter = dimensionId != null ? new QFilter("id", "=", dimensionId) : new QFilter("model", "=", (Object)this.getModelId());
        DynamicTreeContext context = new DynamicTreeContext(this.getMetaDataEntity(this.getView(), "epbs_dimension"));
        context.setSelectFields("id,number,name,issysdimension,shortnumber,name as refname");
        context.setOrderby("dseq");
        context.setqFilters(qFilter.toArray());
        context.setFocusTreeId(focusNodeId);
        return context;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        if ("btn_addviewgp".equals(key)) {
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("isGroup", true);
            this.showAddViewForm(params, key, null);
        } else if ("btn_addview".equals(key)) {
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            TreeView treeView = (TreeView)this.getView().getControl(VIEW_TREE);
            Map focusNodeData = AbstractTreeBuilder.getFocusNodeData((TreeView)treeView);
            if (focusNodeData != null) {
                if (Objects.equals(focusNodeData.get("isgroup"), true)) {
                    params.put("parent", this.getViewId());
                } else {
                    EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
                    ViewBean viewBean = modelCache.getViewById(this.getViewId().longValue());
                    if (viewBean != null) {
                        params.put("parent", viewBean.getGroupId());
                    }
                }
            }
            this.showAddViewForm(params, key, null);
        } else if ("btn_editview".equals(key)) {
            this.showAddViewForm(null, key, this.getViewId());
        } else if (key.equals("btn_delview")) {
            Long viewId = this.getViewId();
            if (Objects.equals(viewId, 0L)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"DimensionManagerListPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeView treeView = (TreeView)this.getView().getControl(VIEW_TREE);
            Map focusNodeData = AbstractTreeBuilder.getFocusNodeData((TreeView)treeView);
            if (focusNodeData != null && Objects.equals(focusNodeData.get("isgroup"), true)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("btn_delview", (IFormPlugin)this);
                focusNodeData = treeView.getTreeState().getFocusNode();
                if (focusNodeData != null) {
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664\u201c%s\u201d\u89c6\u56fe\u7ec4\u5417\uff1f", (String)"DimensionManagerListPlugin_15", (String)"epm-epbs-formplugin", (Object[])new Object[0]), focusNodeData.get("text")), "", MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks, (Map)null, String.valueOf(viewId));
                }
            } else {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("btn_delview", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u8be5\u89c6\u56fe\u7684\u540c\u65f6\u4f1a\u5220\u9664\u5176\u5305\u542b\u7684\u6240\u6709\u89c6\u56fe\u6210\u5458\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"DimensionManagerListPlugin_16", (String)"epm-epbs-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks, (Map)null, String.valueOf(viewId));
            }
        } else if ("btn_adddim".equals(key)) {
            Long bizModelId;
            if (this.getModelId() == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DimensionManagerListPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Long> params = new HashMap<String, Long>(16);
            params.put("model", this.getModelId());
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(this.getMetaDataEntity(this.getView(), "epbs_dimension_form"));
            showParameter.setCustomParams(params);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            showParameter.setStatus(OperationStatus.ADDNEW);
            Object bizModelIdOrBusId = this.getView().getFormShowParameter().getCustomParam("bizModelIdOrBusId");
            if (bizModelIdOrBusId != null) {
                DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)this.getMetaDataEntity(this.getView(), "epbs_dimmodelref"), (String)"dimension.dtypeid.type", (QFilter[])new QFilter("bizmodel.id", "=", bizModelIdOrBusId).or("businessdomain.id", "=", bizModelIdOrBusId).toArray());
                ArrayList hasDimType = Lists.newArrayListWithExpectedSize((int)16);
                EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
                DimTypeCache dimTypeCache = DimTypeCacheHelper.get();
                List dimTypeByAppList = dimTypeCache.getDimTypeByApp(modelCache.getModel().getSrcAppNum());
                List allDimType = dimTypeByAppList.stream().map(DimTypeBean::getType).collect(Collectors.toList());
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    hasDimType.add(dynamicObject.getString("dimension.dtypeid.type"));
                }
                allDimType.removeAll(hasDimType);
                allDimType.removeAll(BizModelServiceHelper.excludeDimList);
                allDimType.addAll(BizModelServiceHelper.excludeDimList);
                showParameter.setCustomParam("dimTypeList", (Object)SerializationUtils.toJsonString(allDimType));
            }
            if ((bizModelId = (Long)this.getView().getFormShowParameter().getCustomParam("bizModelId")) != null && bizModelId != 0L) {
                showParameter.setCustomParam("bizModelId", (Object)bizModelId);
            }
            this.getView().showForm(showParameter);
        } else if ("btn_editdim".equals(key)) {
            if (this.getModelId() == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DimensionManagerListPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            Long id = this.getDimensionIdWithCheck();
            String name = "";
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)this.getMetaDataEntity(this.getView(), "epbs_dimension"), (String)"name", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
            if (dynamicObject != null) {
                name = dynamicObject.getString("name");
            }
            BaseShowParameter param = new BaseShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setFormId(this.getMetaDataEntity(this.getView(), "epbs_dimension"));
            param.setPkId((Object)id);
            param.setStatus(OperationStatus.EDIT);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            param.setCaption(String.format(ResManager.loadKDString((String)"%s\u7ef4\u5ea6", (String)"DimensionManagerListPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]), name));
            this.getView().showForm((FormShowParameter)param);
        } else if ("btn_deldim".equals(key)) {
            Long focusNodeId = this.getDimensionId();
            if (Objects.equals(focusNodeId, 0L)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"DimensionManagerListPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeView treeView = (TreeView)this.getView().getControl(DIM_TREE);
            Map focusNodeData = AbstractTreeBuilder.getFocusNodeData((TreeView)treeView);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("btn_deldim", (IFormPlugin)this);
            this.getView().showConfirm(String.format(String.format(ResManager.loadKDString((String)"\u5220\u9664\u7ef4\u5ea6\u201d%s\u201d\u65f6\u4f1a\u5c06\u8be5\u7ef4\u5ea6\u4e0b\u7684\u89c6\u56fe\u7ec4\u3001\u89c6\u56fe\u3001\u6210\u5458\u5168\u90e8\u5220\u9664\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"DimensionManagerListPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]), focusNodeData.get("refname")), new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks, (Map)null, String.valueOf(focusNodeId));
        } else if ("searchbefore".equals(key) || "searchnext".equals(key)) {
            TreeView treeView = (TreeView)this.getView().getControl(DIM_TREE);
            this.leftSearchNext(treeView, key);
        }
    }

    private void deleteView(Long viewId) {
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)this.getMetaDataEntity(this.getView(), "epbs_struct_view"), (Object[])new Object[]{viewId}, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DimensionManagerListPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            this.initViewTree(null);
        } else {
            OperationResultUtil.showOperationResult((IFormView)this.getView(), (OperationResult)operationResult);
        }
    }

    private void deleteDim(Long dimId) {
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)this.getMetaDataEntity(this.getView(), "epbs_dimension"), (Object[])new Object[]{dimId}, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DimensionManagerListPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        } else {
            OperationResultUtil.showOperationResult((IFormView)this.getView(), (OperationResult)operationResult);
        }
        this.initDimTree(null);
    }

    protected DimTypeBean getDimType() {
        Long dimensionId = this.getDimensionIdWithCheck();
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
        return modelCache.getDimTypeByDimensionId(dimensionId.longValue());
    }

    private void deleteMember(Long memberId) {
        DimTypeBean dimType = this.getDimType();
        String memberTreemodel = dimType.getMemberTreemodel();
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)memberTreemodel, (Object[])new Object[]{memberId}, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DimensionManagerListPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            this.refreshList();
        } else {
            OperationResultUtil.showOperationResult((IFormView)this.getView(), (OperationResult)operationResult);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if ("btn_delview".equals(evt.getCallBackId()) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            String viewId = evt.getCustomVaule();
            this.deleteView(Long.parseLong(viewId));
        } else if ("btn_deldim".equals(evt.getCallBackId()) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            String customVaule = evt.getCustomVaule();
            this.deleteDim(Long.parseLong(customVaule));
        } else if ("member_del".equals(evt.getCallBackId()) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            String customVaule = evt.getCustomVaule();
            this.deleteMember(Long.parseLong(customVaule));
        }
    }

    protected void showAddViewForm(Map<String, Object> params, String key, String viewEntity, Object pkId) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId(viewEntity);
        billShowParameter.setCustomParams(params);
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        if (pkId != null) {
            billShowParameter.setPkId((Object)this.getViewId());
            billShowParameter.setStatus(OperationStatus.EDIT);
        } else {
            billShowParameter.setStatus(OperationStatus.ADDNEW);
            billShowParameter.setCustomParam("bizModelId", (Object)this.getBizModelId());
        }
        if (Objects.equals(params.get("isGroup"), true)) {
            billShowParameter.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6\u89c6\u56fe\u7ec4", (String)"DimensionManagerListPlugin_19", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    protected void showAddViewForm(Map<String, Object> params, String key, Object pkId) {
        if (params == null) {
            params = new HashMap<String, Object>(16);
        }
        params.put("model", this.getModelId());
        params.put("dimension", this.getDimensionIdWithCheck());
        DimTypeBean dimType = this.getDimType();
        if (DimTypeEnum.Period.getValue().equals(dimType.getType())) {
            this.showAddViewForm(params, key, this.getMetaDataEntity(this.getView(), "epbs_period_view"), pkId);
        } else {
            this.showAddViewForm(params, key, this.getMetaDataEntity(this.getView(), "epbs_struct_view"), pkId);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        try {
            if ("member_add".equals(itemKey)) {
                this.memberAdd();
            } else if ("member_del".equals(itemKey)) {
                this.memberDel();
            } else if ("member_enable".equals(itemKey) || "member_disable".equals(itemKey)) {
                this.memberEnable(itemKey);
            } else if ("member_move_up".equals(itemKey) || "member_move_down".equals(itemKey)) {
                this.memberMove(itemKey);
            } else if ("propertydefined".equals(itemKey)) {
                this.propertyDefined();
            } else if ("btn_refresh".equals(itemKey)) {
                this.initDimTree(null);
            } else if ("member_import".equals(itemKey)) {
                this.memberImport();
            }
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    protected void memberImport() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(this.getMetaDataEntity(this.getView(), "epbs_import"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("modelId", (Object)this.getModelId());
        showParameter.setCustomParam("dimensionId", (Object)this.getDimensionId());
        showParameter.setCustomParam("viewId", (Object)this.getViewId());
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)this.getMetaDataEntity(this.getView(), "epbs_import"));
        showParameter.setFormConfig(formConfig);
        String pluginClassName = DimMemImportBasePlugin.class.getName();
        if (StringUtils.isNotEmpty((String)pluginClassName)) {
            showParameter.addCustPlugin(pluginClassName);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this.getPlugin(), "member_import");
            showParameter.setCloseCallBack(callBack);
            this.getView().showForm(showParameter);
        }
    }

    protected void propertyDefined() {
        ListShowParameter listShowParameter = new ListShowParameter();
        long modelId = this.getModelId();
        Long dimensionId = this.getDimensionIdWithCheck();
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
        DimensionBean dimensionBean = modelCache.getDimensionById(dimensionId.longValue());
        String metaDataEntity = this.getMetaDataEntity(this.getView(), "epbs_propertydefined");
        listShowParameter.setPageId(this.getView().getPageId() + metaDataEntity + dimensionId);
        listShowParameter.setCustomParam("model", (Object)modelId);
        listShowParameter.setCustomParam("dimension", (Object)dimensionId);
        listShowParameter.setCustomParam("bizModel", (Object)this.getBizModelId());
        listShowParameter.setBillFormId(this.getMetaDataEntity(this.getView(), metaDataEntity));
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u7ef4\u5ea6\u81ea\u5b9a\u4e49\u5c5e\u6027\u5217\u8868", (String)"DimensionManagerListPlugin_17", (String)"epm-epbs-formplugin", (Object[])new Object[0]), dimensionBean.getNameString()));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    protected void memberDel() {
        Long memberId = this.getMemberId();
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("member_del", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u5f53\u524d\u6210\u5458\u53ca\u5176\u6240\u6709\u4e0b\u7ea7\u6210\u5458\uff1f", (String)"DimensionManagerListPlugin_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks, null, String.valueOf(memberId));
    }

    protected void memberMove(String itemKey) {
        Long memberId = this.getMemberId();
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
        String memberTreemodel = modelCache.getMemberTreeModelByDimensionId(this.getDimensionIdWithCheck().longValue());
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)("member_move_up".equals(itemKey) ? "move_up" : "move_down"), (String)memberTreemodel, (Object[])new Object[]{memberId}, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.refreshList();
        } else {
            OperationResultUtil.showOperationResult((IFormView)this.getView(), (OperationResult)operationResult);
        }
    }

    protected void memberEnable(String itemKey) {
        Long memberId = this.getMemberId();
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
        String memberTreeModel = modelCache.getMemberTreeModelByDimensionId(this.getDimensionIdWithCheck().longValue());
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)("member_enable".equals(itemKey) ? "enable" : "disable"), (String)memberTreeModel, (Object[])new Object[]{memberId}, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            if ("member_enable".equals(itemKey)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"DimensionManagerListPlugin_8", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"DimensionManagerListPlugin_9", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
            this.refreshList();
        } else {
            OperationResultUtil.showOperationResult((IFormView)this.getView(), (OperationResult)operationResult);
        }
    }

    protected void memberAdd() {
        TreeView treeView = (TreeView)this.getView().getControl(VIEW_TREE);
        Map focusNodeData = AbstractTreeBuilder.getFocusNodeData((TreeView)treeView);
        if (focusNodeData == null || Objects.equals(focusNodeData.get("isgroup"), true)) {
            return;
        }
        Long memberId = this.getMemberId();
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
        DimTypeBean dimTypeBean = modelCache.getDimTypeByDimensionId(this.getDimensionIdWithCheck().longValue());
        String memberTreeFrom = dimTypeBean.getMemberTreeFrom();
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"addnew", (String)dimTypeBean.getMemberTreemodel(), (Object[])new Object[]{memberId}, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            FormShowParameter formShowParameter;
            HashMap<String, Long> params = new HashMap<String, Long>(16);
            if (DimTypeEnum.Year.getValue().equals(dimTypeBean.getType())) {
                formShowParameter = new FormShowParameter();
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            } else {
                formShowParameter = new BillShowParameter();
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            }
            params.put("modelId", this.getModelId());
            params.put("dimensionId", this.getDimensionId());
            params.put("viewId", this.getViewId());
            params.put("parent", memberId);
            params.put("bizModelId", this.getBizModelId());
            formShowParameter.setFormId(memberTreeFrom);
            formShowParameter.setCustomParams(params);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "member_add"));
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            this.getView().showForm(formShowParameter);
        } else {
            OperationResultUtil.showOperationResult((IFormView)this.getView(), (OperationResult)operationResult);
        }
    }

    private Long getMemberId() {
        TreeEntryGrid entryentity = (TreeEntryGrid)this.getView().getControl(MEMBER_TREE);
        int[] selectRows = entryentity.getSelectRows();
        if (selectRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u6210\u5458\u3002", (String)"DimensionManagerListPlugin_18", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(MEMBER_TREE, selectRows[0]);
        return entryRowEntity.getLong("id");
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        TreeView tree = (TreeView)evt.getSource();
        if (DIM_TREE.equals(tree.getKey())) {
            this.initViewTree(null);
        } else {
            this.refreshList();
        }
    }

    private void refreshList() {
        TreeView treeView = (TreeView)this.getView().getControl(VIEW_TREE);
        Long viewId = this.getViewId();
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
        Map focusNodeData = AbstractTreeBuilder.getFocusNodeData((TreeView)treeView);
        if (focusNodeData != null && Objects.equals(focusNodeData.get("isgroup"), true)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"viewmemberlistap"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"viewgpmemberlistap"});
            Long dimensionId = this.getDimensionIdWithCheck();
            DimensionBean dimension = modelCache.getDimensionById(dimensionId.longValue());
            String memberTreemodel = modelCache.getMemberTreeModelByDimensionId(dimensionId.longValue());
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setFormId(this.getMetaDataEntity(this.getView(), "epbs_viewgp_memberlist"));
            listShowParameter.setBillFormId(memberTreemodel);
            listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            listShowParameter.getOpenStyle().setTargetKey("viewgpmemberlistap");
            listShowParameter.setCustomParam("viewGpId", (Object)viewId);
            listShowParameter.setCustomParam("model", (Object)this.getModelId());
            listShowParameter.setCustomParam("dimensionId", (Object)dimension.getId());
            listShowParameter.setCustomParam("bizModelId", (Object)this.getBizModelId());
            listShowParameter.setCustomParam("dimName", (Object)dimension.getNameString());
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"viewgpmemberlistap"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"viewmemberlistap"});
            ViewBean viewBean = modelCache.getViewById(viewId.longValue());
            this.getView().setVisible(Boolean.valueOf(viewBean != null && viewBean.getPeriodTypeEnum() == null), new String[]{"member_import"});
            this.initMemberTree(viewId);
        }
    }

    private void initMemberTree(Long viewId) {
        DynamicObject entryRowEntity;
        TreeEntryGrid treeEntity = (TreeEntryGrid)this.getView().getControl(MEMBER_TREE);
        int[] selectRows = treeEntity.getSelectRows();
        Long selectId = null;
        if (String.valueOf(viewId).equals(this.getView().getPageCache().get(MEMBERTREE_VIEW)) && selectRows.length > 0 && (entryRowEntity = this.getModel().getEntryRowEntity(MEMBER_TREE, selectRows[0])) != null) {
            selectId = entryRowEntity.getLong("id");
        }
        if (viewId == 0L) {
            return;
        }
        this.getView().getPageCache().put(MEMBERTREE_VIEW, String.valueOf(viewId));
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
        long dimensionId = this.getDimensionIdWithCheck();
        DimensionBean dimension = modelCache.getDimensionById(dimensionId);
        DimTypeBean dimTypeBean = modelCache.getDimTypeById(dimension.getDimTypeId());
        this.getView().setVisible(Boolean.valueOf(DimTypeEnum.Period.getValue().equals(dimTypeBean.getType())), new String[]{"startdate", "enddate"});
        Label control = (Label)this.getControl("membername");
        control.setText(String.format(ResManager.loadKDString((String)"%s\u7ef4\u5ea6\u6210\u5458", (String)"DimensionManagerListPlugin_10", (String)"epm-epbs-formplugin", (Object[])new Object[0]), dimension.getNameString()));
        QFilter qFilter = new QFilter("view", "=", (Object)viewId);
        QFilter qFilter1 = new QFilter("level", "<=", (Object)2);
        List expandNodes = (List)treeEntity.getExpandNodes();
        if (expandNodes != null) {
            List expandIds = expandNodes.stream().map(o -> o == null ? 0L : Long.parseLong(o)).collect(Collectors.toList());
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)dimTypeBean.getMemberTreemodel(), (String)"id,parent", (QFilter[])new QFilter("id", "in", expandIds).toArray());
            Map<Long, Long> map = dynamicObjects.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o.getLong("parent"), (key1, key2) -> key2));
            boolean remove = true;
            while (remove) {
                remove = false;
                Iterator iterator = expandIds.iterator();
                while (iterator.hasNext()) {
                    Long next = (Long)iterator.next();
                    if (map.get(next) != null && (map.get(next) == 0L || expandIds.contains(map.get(next)))) continue;
                    iterator.remove();
                    remove = true;
                }
            }
            qFilter1.or("parent", "in", expandIds);
        }
        this.getModel().deleteEntryData(MEMBER_TREE);
        this.initMemberTree(dimTypeBean, qFilter.and(qFilter1), 0, selectId);
    }

    private void initMemberTree(DimTypeBean dimTypeBean, QFilter qFilter, int rowKey, Long selectId) {
        DynamicObjectCollection dataList;
        MemberDao memberDao = MemberDaoFactory.getMemberDao((DimTypeBean)dimTypeBean);
        String select = "id,aggoprt,number,shownumber,longnumber,name,enable,level,member.sourcetype as sourcetype,parent,modifier.name,modifytime,dseq,isleaf";
        if (DimTypeEnum.Period.getValue().equals(dimTypeBean.getType())) {
            select = select + ",member.startyear as startyear,member.startmonth as startmonth,member.startday as startday,member.endyear as endyear,member.endmonth as endmonth,member.endday as endday";
        }
        if (!(dataList = memberDao.getData(qFilter, select, 0, 10000, "dseq")).isEmpty()) {
            Integer selectRow;
            Set expands;
            HashMap<Long, DynamicObjectTreeNode> nodeMap = new HashMap<Long, DynamicObjectTreeNode>(dataList.size());
            for (Object dynamicObject : dataList) {
                long id = dynamicObject.getLong("id");
                long pid = dynamicObject.getLong("parent");
                nodeMap.put(id, new DynamicObjectTreeNode(Long.valueOf(id), Long.valueOf(pid), (DynamicObject)dynamicObject));
            }
            ArrayList<DynamicObjectTreeNode> nodeList = new ArrayList<DynamicObjectTreeNode>(10);
            for (DynamicObject dynamicObject : dataList) {
                Long id = dynamicObject.getLong("id");
                Long parentId = dynamicObject.getLong("parent");
                DynamicObjectTreeNode treeNode = (DynamicObjectTreeNode)nodeMap.get(id);
                DynamicObjectTreeNode parentNode = (DynamicObjectTreeNode)nodeMap.get(parentId);
                if (parentNode != null) {
                    parentNode.addChild(treeNode);
                    continue;
                }
                nodeList.add(treeNode);
            }
            ArrayList<DynamicObjectTreeNode> listNode = new ArrayList<DynamicObjectTreeNode>(10);
            for (DynamicObjectTreeNode dynamicObjectTreeNode : nodeList) {
                this.listNode(dynamicObjectTreeNode, listNode);
            }
            TreeEntryGrid treeEntity = (TreeEntryGrid)this.getView().getControl(MEMBER_TREE);
            List expandNodes = (List)treeEntity.getExpandNodes();
            DimManagerMemberTree dimManagerMemberTree = this.createMemberRow(listNode, expandNodes, dimTypeBean, selectId);
            int[] rows = dimManagerMemberTree.getRows();
            if (rows != null && rows.length > 0) {
                this.getView().updateView(MEMBER_TREE);
                treeEntity.collapseOne(rows);
            }
            if ((expands = dimManagerMemberTree.getExpands()) != null) {
                treeEntity.expandOne(expands.stream().mapToInt(Integer::intValue).toArray());
            }
            if ((selectRow = dimManagerMemberTree.getSelectRow()) == null) {
                selectRow = rowKey;
            }
            if (!"1".equals(this.getView().getPageCache().get(IS_SEARCH))) {
                treeEntity.selectRows(selectRow.intValue());
            }
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        Control control = (Control)treeNodeEvent.getSource();
        String key = control.getKey();
        if (key.equals(MEMBER_TREE)) {
            int rowKey = treeNodeEvent.getRowKey();
            if (rowKey <= 0) {
                return;
            }
            String nodeId = (String)treeNodeEvent.getNodeId();
            DimTypeBean dimTypeBean = this.getDimType();
            QFilter qFilter = new QFilter("parent", "=", (Object)Long.parseLong(nodeId));
            this.initMemberTree(dimTypeBean, qFilter, rowKey, null);
        }
    }

    private void listNode(DynamicObjectTreeNode node, List<DynamicObjectTreeNode> nodeList) {
        nodeList.add(node);
        List children = node.getChildren();
        for (DynamicObjectTreeNode child : children) {
            this.listNode(child, nodeList);
        }
    }

    private DimManagerMemberTree createMemberRow(List<DynamicObjectTreeNode> nodeList, List<String> expandNodes, DimTypeBean dimTypeBean, Long selectId) {
        DimManagerMemberTree dimManagerMemberTree = new DimManagerMemberTree();
        if (nodeList.isEmpty()) {
            return dimManagerMemberTree;
        }
        int[] rows = this.getModel().batchCreateNewEntryRow(MEMBER_TREE, nodeList.size());
        dimManagerMemberTree.setRows(rows);
        for (int i = 0; i < nodeList.size(); ++i) {
            DynamicObjectTreeNode dynamicObjectTreeNode = nodeList.get(i);
            int row = rows[i];
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(MEMBER_TREE, row);
            DynamicObject rowData = dynamicObjectTreeNode.getDynamicObject();
            long id = rowData.getLong("id");
            if (Objects.equals(id, selectId)) {
                dimManagerMemberTree.setSelectRow(Integer.valueOf(row));
            }
            dynamicObject.set("id", (Object)id);
            dynamicObject.set("pid", rowData.get("parent"));
            for (String memberField : this.MEMBER_FIELDS) {
                dynamicObject.set(memberField.replace("member.", "").replace(".", "") + "_tree", rowData.get(memberField));
            }
            if (DimTypeEnum.Period.getValue().equals(dimTypeBean.getType())) {
                PeriodYearEnum startYear = PeriodYearEnum.get((String)rowData.getString("startyear"));
                PeriodYearEnum endYear = PeriodYearEnum.get((String)rowData.getString("endyear"));
                MonthEnum startMonth = MonthEnum.get((String)rowData.getString("startmonth"));
                MonthEnum endMonth = MonthEnum.get((String)rowData.getString("endmonth"));
                DayEnum startDay = DayEnum.get((String)rowData.getString("startday"));
                DayEnum endDay = DayEnum.get((String)rowData.getString("endday"));
                dynamicObject.set("startdate", (Object)String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s", (String)"DimensionManagerListPlugin_11", (String)"epm-epbs-formplugin", (Object[])new Object[0]), startYear.getName().getLocaleString(), startMonth.getBridge().getLocaleString(), startDay.getBridge().loadKDString()));
                dynamicObject.set("enddate", (Object)String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s", (String)"DimensionManagerListPlugin_11", (String)"epm-epbs-formplugin", (Object[])new Object[0]), endYear.getName().getLocaleString(), endMonth.getBridge().getLocaleString(), endDay.getBridge().loadKDString()));
            }
            List children = dynamicObjectTreeNode.getChildren();
            if (expandNodes != null && expandNodes.contains(String.valueOf(id))) {
                dimManagerMemberTree.addExpands(Integer.valueOf(row));
            } else if (!children.isEmpty() && rowData.getInt("level") == 1) {
                dimManagerMemberTree.addExpands(Integer.valueOf(row));
            }
            dynamicObject.set("isgroupnode", (Object)(!rowData.getBoolean("isleaf") ? 1 : 0));
        }
        return dimManagerMemberTree;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        try {
            if ("btn_addviewgp".equals(actionId) || "btn_addview".equals(actionId) || "btn_editview".equals(actionId)) {
                Object returnData = closedCallBackEvent.getReturnData();
                if (returnData instanceof Long) {
                    this.initViewTree(String.valueOf(returnData));
                } else {
                    this.initViewTree(null);
                }
            } else if ("member_add".equals(actionId) || "member_edit".equals(actionId) || "member_import".equals(actionId) || "member_enable".equals(actionId) || "member_disable".equals(actionId)) {
                this.refreshList();
            } else if ("btn_adddim".equals(actionId) || "btn_editdim".equals(actionId) || "btn_deldim".equals(actionId)) {
                Object returnData;
                if ("btn_editdim".equals(actionId) && !ObjectUtils.isEmpty((Object)closedCallBackEvent.getReturnData())) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DimensionManagerListPlugin_12", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                }
                if ((returnData = closedCallBackEvent.getReturnData()) instanceof Long) {
                    this.initDimTree(String.valueOf(returnData));
                } else {
                    this.initDimTree(null);
                }
            }
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyKey = e.getProperty().getName();
        if ("model".equals(propertyKey)) {
            this.propertyChanged_model(e);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if ("number_tree".equals(fieldName)) {
            EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)this.getModelId());
            String appPkId = AppMetadataCache.getAppInfo((String)this.getView().getFormShowParameter().getAppId()).getId();
            boolean permission = ModelPermHelper.checkPermission((long)this.getModelId(), (String)appPkId, (String)modelCache.getMetaDataEntity("epbs_dimension_manager"), (String)"49Y+E201HT1O");
            if (!permission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u7ef4\u5ea6\u7ba1\u7406\u201d\u7684\u201c\u7ef4\u5ea6\u6210\u5458\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DimensionManagerListPlugin_13", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(MEMBER_TREE, rowIndex);
            String memberTreemodel = modelCache.getMemberTreeModelByDimensionId(this.getDimensionIdWithCheck().longValue());
            Object id = entryRowEntity.get("id");
            HashMap<String, Long> params = new HashMap<String, Long>(16);
            params.put("bizModelId", this.getBizModelId());
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setPkId(id);
            billShowParameter.setPageId(this.getView().getPageId() + memberTreemodel + "_" + id);
            billShowParameter.setFormId(memberTreemodel);
            billShowParameter.setCustomParams(params);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "member_edit"));
            billShowParameter.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    protected void propertyChanged_model(PropertyChangedArgs e) {
        DynamicObject newModel = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (newModel == null) {
            return;
        }
        TreeView tree = (TreeView)this.getView().getControl(DIM_TREE);
        tree.deleteAllNodes();
        TreeView viewTree = (TreeView)this.getView().getControl(VIEW_TREE);
        viewTree.deleteAllNodes();
        this.refreshList();
        this.initDimTree(null);
    }

    protected void setIconVisible(boolean visible) {
        this.iconVisible = visible;
    }
}

