/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.model;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.epbs.common.enums.model.ViewScopeEnum;
import kd.epm.epbs.common.model.IMetaDataEntity;
import kd.epm.epbs.common.util.IDUtils;

public class DimensionViewFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
IMetaDataEntity {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit parent = (BasedataEdit)this.getControl("parent");
        parent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter.getStatus() == OperationStatus.ADDNEW) {
            Object isGroup = formShowParameter.getCustomParam("isGroup");
            if (Objects.equals(isGroup, true)) {
                this.getModel().setValue("isgroup", (Object)true);
                Object bizModelId = this.getView().getFormShowParameter().getCustomParam("bizModelId");
                if (bizModelId != null && !Objects.equals(bizModelId, 0)) {
                    this.getModel().setValue("bizmodel", bizModelId);
                    this.getModel().setValue("type", (Object)ViewScopeEnum.PRIVATE.getValue());
                }
            } else {
                Object parent = formShowParameter.getCustomParam("parent");
                if (parent != null) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)parent, (String)this.getMetaDataEntity(this.getView(), "epbs_struct_view"));
                    this.getModel().setValue("parent", (Object)dynamicObject);
                    this.getModel().setValue("bizmodel", dynamicObject.get("bizmodel"));
                    this.getModel().setValue("type", (Object)dynamicObject.getString("type"));
                }
            }
            this.getModel().setValue("dimension", formShowParameter.getCustomParam("dimension"));
            this.getModel().setValue("model", formShowParameter.getCustomParam("model"));
        }
        this.getModel().setDataChanged(false);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject parent;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("parent".equals(name) && (parent = (DynamicObject)changeData.getNewValue()) != null) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)parent.getPkValue(), (String)this.getMetaDataEntity(this.getView(), "epbs_struct_view"));
            this.getModel().setValue("bizmodel", dynamicObject.get("bizmodel"));
            this.getModel().setValue("type", (Object)dynamicObject.getString("type"));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if ("parent".equals(fieldKey)) {
            QFilter qFilter = new QFilter("dimension", "=", this.getModel().getValue("dimension_id"));
            Long bizModelId = (Long)this.getModel().getValue("bizmodel_id");
            if (IDUtils.isNotNull((Long)bizModelId)) {
                qFilter.and("type", "=", (Object)"1").or("bizmodel", "=", (Object)bizModelId);
            }
            beforeF7SelectEvent.addCustomQFilter(qFilter);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        Long id = (Long)this.getModel().getValue("id");
        if (IDUtils.isNotNull((Long)id)) {
            this.getView().returnDataToParent(this.getModel().getValue("id"));
        }
    }
}

